/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeatMapData
implements Iterator<NextValue> {
    private Map<CoordPair, Map<String, double[]>> sendRecv = new TreeMap<CoordPair, Map<String, double[]>>();
    private int size = 0;
    private Map<String, double[]> maxs = new TreeMap<String, double[]>();
    private Map<String, double[]> mins = new TreeMap<String, double[]>();
    private Set<String> paths = new TreeSet<String>();
    private static final int COUNT = 0;
    private static final int MAX = 1;
    private static final int MIN = 2;
    private static final int MEAN = 3;
    private static final int STDDEV = 4;
    private static final int VOLUME = 5;
    private Iterator<Map.Entry<CoordPair, Map<String, double[]>>> mapIterator = null;

    public HeatMapData(int n) {
        this.size = n;
    }

    public void put(int n, int n2, String string, double[] dArray) {
        CoordPair coordPair = new CoordPair(n, n2);
        Map<String, double[]> map = this.sendRecv.get(coordPair);
        if (map == null) {
            map = new TreeMap<String, double[]>();
            this.sendRecv.put(coordPair, map);
        }
        map.put(string, dArray);
        this.paths.add(string);
    }

    public double[] get(int n, int n2, String string) {
        CoordPair coordPair = new CoordPair(n, n2);
        Map<String, double[]> map = this.sendRecv.get(coordPair);
        if (map != null) {
            return map.get(string);
        }
        return null;
    }

    public double get(int n, int n2, String string, int n3) {
        double[] dArray = this.get(n, n2, string);
        if (dArray != null) {
            return dArray[n3];
        }
        return 0.0;
    }

    @Override
    public boolean hasNext() {
        if (this.mapIterator == null) {
            this.mapIterator = this.sendRecv.entrySet().iterator();
        }
        return this.mapIterator.hasNext();
    }

    @Override
    public NextValue next() {
        if (!this.mapIterator.hasNext()) {
            return null;
        }
        Map.Entry<CoordPair, Map<String, double[]>> entry = this.mapIterator.next();
        NextValue nextValue = new NextValue();
        nextValue.sender = entry.getKey().sender;
        nextValue.data = entry.getValue();
        nextValue.receiver = entry.getKey().receiver;
        return nextValue;
    }

    @Override
    public void remove() {
    }

    public static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static void main(String[] stringArray) {
        int n;
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        double[] dArray2 = new double[]{6.0, 5.0, 4.0, 3.0, 2.0, 1.0};
        int n2 = 20;
        HeatMapData heatMapData = new HeatMapData(n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < i % 10 + 1; ++j) {
                heatMapData.put(i, (i + 1) % n2, "test" + j, dArray2);
                heatMapData.put(i, (i + n2 - 1) % n2, "test" + j, dArray);
            }
        }
        while (heatMapData.hasNext()) {
            NextValue nextValue = heatMapData.next();
            System.out.println(nextValue.sender + ", " + nextValue.receiver);
            for (String string : nextValue.data.keySet()) {
                double[] dArray3 = nextValue.data.get(string);
                System.out.print("\t" + string + ": ");
                for (int i = 0; i < 6; ++i) {
                    System.out.print(dArray3[i] + " ");
                }
                System.out.println();
            }
        }
        double[] dArray4 = heatMapData.get(14, 13, "test1");
        System.out.print("14, 13\n\ttest1: ");
        for (n = 0; n < 6; ++n) {
            System.out.print(dArray4[n] + " ");
        }
        System.out.println();
        dArray4 = heatMapData.get(14, 15, "test1");
        System.out.print("14, 15\n\ttest1: ");
        for (n = 0; n < 6; ++n) {
            System.out.print(dArray4[n] + " ");
        }
        System.out.println();
    }

    public void massageData() {
        while (this.hasNext()) {
            NextValue nextValue = this.next();
            for (String string : nextValue.data.keySet()) {
                double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                if (nextValue.data.containsKey(string)) {
                    dArray = nextValue.data.get(string);
                } else {
                    nextValue.data.put(string, dArray);
                }
                double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                if (this.maxs.keySet().contains(string)) {
                    dArray2 = this.maxs.get(string);
                }
                double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                if (this.mins.keySet().contains(string)) {
                    dArray3 = this.mins.get(string);
                }
                dArray[3] = dArray[0] > 0.0 ? dArray[5] / dArray[0] : 0.0;
                dArray[4] = dArray[0] > 0.0 ? Math.sqrt(Math.abs(dArray[4] / dArray[0] - dArray[3] * dArray[3])) : 0.0;
                dArray2[0] = Math.max(dArray2[0], dArray[0]);
                dArray2[1] = Math.max(dArray2[1], dArray[1]);
                dArray2[2] = Math.max(dArray2[2], dArray[2]);
                dArray2[3] = Math.max(dArray2[3], dArray[3]);
                dArray2[4] = Math.max(dArray2[4], dArray[4]);
                dArray2[5] = Math.max(dArray2[5], dArray[5]);
                if (dArray[0] > 0.0) {
                    dArray3[0] = dArray3[0] == 0.0 ? dArray[0] : Math.min(dArray3[0], dArray[0]);
                    dArray3[1] = dArray3[1] == 0.0 ? dArray[1] : Math.min(dArray3[1], dArray[1]);
                    dArray3[2] = dArray3[2] == 0.0 ? dArray[2] : Math.min(dArray3[2], dArray[2]);
                    dArray3[3] = dArray3[3] == 0.0 ? dArray[3] : Math.min(dArray3[3], dArray[3]);
                    dArray3[4] = dArray3[4] == 0.0 ? dArray[4] : Math.min(dArray3[4], dArray[4]);
                    dArray3[5] = dArray3[5] == 0.0 ? dArray[5] : Math.min(dArray3[5], dArray[5]);
                }
                this.maxs.put(string, dArray2);
                this.mins.put(string, dArray3);
            }
        }
    }

    public void reset() {
        this.mapIterator = this.sendRecv.entrySet().iterator();
    }

    public int getSize() {
        return this.size;
    }

    public Map<String, double[]> getMaxs() {
        return this.maxs;
    }

    public Map<String, double[]> getMins() {
        return this.mins;
    }

    public Set<String> getPaths() {
        return this.paths;
    }

    public double getMin(String string, int n) {
        return this.mins.get(string)[n];
    }

    public double getMax(String string, int n) {
        return this.maxs.get(string)[n];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CoordPair
    implements Comparable<CoordPair> {
        public final int sender;
        public final int receiver;
        public final int hashCode;

        public CoordPair(int n, int n2) {
            this.sender = n;
            this.receiver = n2;
            this.hashCode = (n << 16) + n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CoordPair)) {
                return false;
            }
            if (((CoordPair)object).sender != this.sender) {
                return false;
            }
            return ((CoordPair)object).receiver == this.receiver;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public int compareTo(CoordPair coordPair) {
            return HeatMapData.compare(this.hashCode(), coordPair.hashCode());
        }
    }

    public class NextValue {
        public int sender;
        public int receiver;
        public Map<String, double[]> data;

        public double getValue(String string, int n) {
            double[] dArray = this.data.get(string);
            if (dArray == null) {
                return 0.0;
            }
            return dArray[n];
        }
    }
}

