/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import edu.uoregon.tau.vis.Axes;
import edu.uoregon.tau.vis.ColorScale;
import edu.uoregon.tau.vis.ScatterPlot;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TopoPlot
extends ScatterPlot {
    private float xSize = 15.0f;
    private float ySize = 15.0f;
    private float zSize = 15.0f;
    private float sphereSize = 0.4f;
    private int sphereDetail = 8;
    private boolean visible = true;
    private boolean normalized = true;
    private float[][] values;
    private ColorScale colorScale;
    private Axes axes;
    private int displayList;
    private boolean dirty = true;
    private int selectedRow = 5;
    private int selectedCol = 5;
    private int minVis = 0;
    private int maxVis = 100;
    boolean isTopo = false;
    private float[] minValueArr = new float[0];
    private float[] maxValueArr = new float[0];
    private float minShown;
    private float maxShown;
    float[][] origValues = null;
    private int[] topoVis = null;
    private float statMin = Float.MAX_VALUE;
    private float statMax = Float.MIN_VALUE;
    private int statCount = 0;
    private float statAcc = 0.0f;

    public void setMinMax(float[] fArray, float[] fArray2) {
        this.minValueArr = fArray;
        this.maxValueArr = fArray2;
    }

    public float getMinShown() {
        return this.minShown;
    }

    public float getMaxShown() {
        return this.maxShown;
    }

    public void setIsTopo(boolean bl) {
        this.isTopo = bl;
    }

    public void setVisRange(int n, int n2) {
        this.minVis = n;
        this.maxVis = n2;
    }

    @Override
    public void setSize(float f, float f2, float f3) {
        this.xSize = f;
        this.ySize = f2;
        this.zSize = f3;
        if (this.axes != null) {
            this.axes.setSize(f, f2, f3);
        }
        if (this.values != null) {
            this.processValues();
        }
        this.dirty = true;
    }

    @Override
    public void setValues(float[][] fArray) {
        this.values = fArray;
        if (this.isTopo) {
            this.origValues = new float[fArray.length][];
            for (int i = 0; i < fArray.length; ++i) {
                this.origValues[i] = (float[])fArray[i].clone();
            }
        } else {
            this.origValues = null;
        }
        this.processValues();
        this.isTopo = false;
        this.dirty = true;
    }

    @Override
    public float getSphereSize() {
        return this.sphereSize;
    }

    @Override
    public void setSphereSize(float f) {
        this.sphereSize = f;
        this.dirty = true;
    }

    @Override
    public Axes getAxes() {
        return this.axes;
    }

    @Override
    public void setAxes(Axes axes) {
        this.axes = axes;
        axes.setSize(this.xSize, this.ySize, this.zSize);
    }

    public void setTopoVis(int[] nArray) {
        this.topoVis = nArray;
    }

    @Override
    public int getSphereDetail() {
        return this.sphereDetail;
    }

    @Override
    public void setSphereDetail(int n) {
        this.sphereDetail = n;
        this.dirty = true;
    }

    @Override
    public ColorScale getColorScale() {
        return this.colorScale;
    }

    @Override
    public void setColorScale(ColorScale colorScale) {
        if (this.colorScale != null) {
            this.colorScale.deleteObserver(this);
        }
        this.colorScale = colorScale;
        if (colorScale != null) {
            colorScale.addObserver(this);
        }
    }

    @Override
    public float getWidth() {
        return this.xSize;
    }

    @Override
    public float getDepth() {
        return this.ySize;
    }

    @Override
    public float getHeight() {
        return this.zSize;
    }

    @Override
    public String getName() {
        return "ScatterPlot";
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public JPanel getControlPanel(final VisRenderer visRenderer) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        final JSlider jSlider = new JSlider(0, 20, (int)(this.sphereSize * 10.0f));
        final JSlider jSlider2 = new JSlider(2, 30, this.sphereDetail);
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    TopoPlot.this.setSphereSize((float)jSlider.getValue() / 10.0f);
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        jSlider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    TopoPlot.this.setSphereDetail(jSlider2.getValue());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        VisTools.addCompItem(jPanel, new JLabel("Point size"), gridBagConstraints, 0, 0, 1, 1);
        VisTools.addCompItem(jPanel, jSlider, gridBagConstraints, 1, 0, 1, 1);
        VisTools.addCompItem(jPanel, new JLabel("Point detail"), gridBagConstraints, 0, 1, 1, 1);
        VisTools.addCompItem(jPanel, jSlider2, gridBagConstraints, 1, 1, 1, 1);
        return jPanel;
    }

    @Override
    public void render(VisRenderer visRenderer) {
        GLAutoDrawable gLAutoDrawable = visRenderer.getGLAutoDrawable();
        if (this.axes != null) {
            this.axes.render(visRenderer);
        }
        if (!this.visible) {
            return;
        }
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (this.dirty || this.displayList == 0) {
            this.displayList = gL2.glGenLists(1);
            gL2.glNewList(this.displayList, 4864);
            this.privateRender(gLAutoDrawable);
            gL2.glEndList();
            this.dirty = false;
        }
        gL2.glCallList(this.displayList);
    }

    private void processValues() {
        float[] fArray = new float[]{this.xSize, this.ySize, this.zSize, 1.0f};
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < 4; ++i) {
            float f3 = this.maxValueArr[i];
            float f4 = this.minValueArr[i];
            boolean bl = false;
            boolean bl2 = false;
            f = 0.0f;
            f2 = 0.0f;
            if (this.isTopo && i == 3) {
                float f5;
                if (this.minVis > 0) {
                    bl = true;
                    f5 = f3 - f4;
                    f = f4 + f5 * ((float)this.minVis / 100.0f);
                } else {
                    f = f4;
                }
                if (this.maxVis < 100) {
                    bl2 = true;
                    f5 = f3 - f4;
                    f2 = f4 + f5 * ((float)this.maxVis / 100.0f);
                } else {
                    f2 = f3;
                }
            }
            for (int j = 0; j < this.values.length; ++j) {
                if (f3 - f4 == 0.0f) {
                    this.values[j][i] = 0.0f;
                    continue;
                }
                if (bl && this.values[j][i] < f) {
                    if (!(bl2 && this.values[j][i] < f2 && f > f2)) {
                        this.values[j][i] = Float.NaN;
                        continue;
                    }
                } else if (!(!bl2 || !(this.values[j][i] > f2) || bl && this.values[j][i] > f && f > f2)) {
                    this.values[j][i] = Float.NaN;
                    continue;
                }
                this.values[j][i] = this.normalized ? (this.values[j][i] - f4) / (f3 - f4) * fArray[i] : this.values[j][i] / f3 * fArray[i];
            }
        }
        this.minShown = f;
        this.maxShown = f2;
    }

    public float getStatMean() {
        if (this.statCount > 0) {
            return this.statAcc / (float)this.statCount;
        }
        return Float.NaN;
    }

    public float getStatMax() {
        return this.statMax;
    }

    public float getStatMin() {
        return this.statMin;
    }

    private void resetTopoVals() {
        this.statMin = Float.MAX_VALUE;
        this.statMax = Float.MIN_VALUE;
        this.statCount = 0;
        this.statAcc = 0.0f;
    }

    private boolean showCoord(int n) {
        boolean bl = this.checkCoord(n);
        if (bl && this.origValues != null) {
            ++this.statCount;
            this.statAcc += this.origValues[n][3];
            this.statMin = Math.min(this.origValues[n][3], this.statMin);
            this.statMax = Math.max(this.origValues[n][3], this.statMax);
        }
        return bl;
    }

    private boolean checkCoord(int n) {
        if (Float.compare(this.values[n][3], Float.NaN) == 0) {
            return false;
        }
        if (this.topoVis == null || this.origValues == null) {
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.topoVis[i] == -1 || !((float)this.topoVis[i] < this.origValues[n][i]) && !((float)this.topoVis[i] >= this.origValues[n][i] + 1.0f)) continue;
            return false;
        }
        return true;
    }

    private void privateRender(GLAutoDrawable gLAutoDrawable) {
        if (this.values == null) {
            return;
        }
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        GLU gLU = GLU.createGLU((GL)gLAutoDrawable.getGL());
        gL2.glShadeModel(7425);
        gL2.glColor3f(1.0f, 0.0f, 0.0f);
        this.resetTopoVals();
        if (this.sphereSize < 0.1f || this.sphereDetail < 3) {
            gL2.glDisable(2896);
            float f = 2.5f;
            if (this.sphereSize >= 0.1f) {
                f = this.sphereSize * 30.0f;
            }
            gL2.glPointSize(f);
            gL2.glBegin(0);
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.showCoord(i)) continue;
                if (this.colorScale != null) {
                    Color color = this.colorScale.getColor(this.values[i][3]);
                    gL2.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                }
                gL2.glVertex3f(this.values[i][0], this.values[i][1], this.values[i][2]);
            }
            gL2.glEnd();
        } else {
            gL2.glEnable(2896);
            gL2.glEnable(2929);
            gL2.glFrontFace(2305);
            GLUquadric gLUquadric = gLU.gluNewQuadric();
            gL2.glEnable(2884);
            gLU.gluQuadricDrawStyle(gLUquadric, 100012);
            gLU.gluQuadricOrientation(gLUquadric, 100020);
            gLU.gluQuadricNormals(gLUquadric, 100000);
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.showCoord(i)) continue;
                gL2.glPushMatrix();
                gL2.glTranslatef(this.values[i][0], this.values[i][1], this.values[i][2]);
                if (this.colorScale != null) {
                    Color color = this.colorScale.getColor(this.values[i][3]);
                    gL2.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                }
                gLU.gluSphere(gLUquadric, (double)this.sphereSize, this.sphereDetail, this.sphereDetail);
                gL2.glPopMatrix();
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof ColorScale) {
            this.dirty = true;
        }
    }

    @Override
    public int getSelectedRow() {
        return this.selectedRow;
    }

    @Override
    public void setSelectedRow(int n) {
        this.selectedRow = n;
    }

    @Override
    public int getSelectedCol() {
        return this.selectedCol;
    }

    @Override
    public void setSelectedCol(int n) {
        this.selectedCol = n;
    }

    @Override
    public boolean getNormalized() {
        return this.normalized;
    }

    @Override
    public void setNormalized(boolean bl) {
        this.normalized = bl;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public void resetCanvas() {
        this.dirty = true;
        this.displayList = 0;
        if (this.axes != null) {
            this.axes.resetCanvas();
        }
    }
}

