/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.CallPathTextWindowPanel;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.SearchPanel;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.ScrollBarController;
import edu.uoregon.tau.paraprof.interfaces.SearchableOwner;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallPathTextWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
SearchableOwner,
ScrollBarController,
KeyListener,
ParaProfWindow,
UnitListener {
    private static final long serialVersionUID = -8482671835939047124L;
    private ParaProfTrial ppTrial = null;
    private DataSorter dataSorter = null;
    private JMenu optionsMenu = null;
    private JMenu unitsSubMenu = null;
    private boolean sortByName;
    private JCheckBoxMenuItem descendingOrder = null;
    private JCheckBoxMenuItem collapsedView = null;
    private JCheckBoxMenuItem showMetaData = null;
    private JCheckBoxMenuItem showFindPanelBox;
    private JScrollPane sp;
    private CallPathTextWindowPanel panel;
    private List<PPFunctionProfile> list;
    private SearchPanel searchPanel;
    private int units = ParaProf.preferences.getUnits();
    private Thread thread;

    public CallPathTextWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        paraProfTrial.addObserver(this);
        this.dataSorter = new DataSorter(paraProfTrial);
        this.thread = thread;
        this.setSize(ParaProfUtils.checkSize(new Dimension(800, 600)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.addKeyListener(this);
        if (thread.getNodeID() == -1 || thread.getNodeID() == -6) {
            this.setTitle("TAU: ParaProf: Mean Call Path Data - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -3 || thread.getNodeID() == -7) {
            this.setTitle("TAU: ParaProf: Standard Deviation Call Path Data - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle("TAU: ParaProf: Call Path Data n,c,t, " + thread.getNodeID() + "," + thread.getContextID() + "," + thread.getThreadID() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        ParaProfUtils.setFrameIcon(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CallPathTextWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.getHelpWindow().isVisible()) {
            this.help(false);
        }
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel = new CallPathTextWindowPanel(paraProfTrial, this.thread, this);
        this.setupMenus();
        this.sp = new JScrollPane(this.panel);
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        this.sortLocalData();
        ParaProf.incrementNumWindows();
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.addKeyListener(this);
        JMenu jMenu = null;
        this.optionsMenu = new JMenu("Options");
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.showFindPanelBox = new JCheckBoxMenuItem("Show Find Panel", false);
        this.showFindPanelBox.addActionListener(this);
        this.optionsMenu.add(this.showFindPanelBox);
        this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.showMetaData.addActionListener(this);
        this.optionsMenu.add(this.showMetaData);
        this.optionsMenu.add(new JSeparator());
        this.collapsedView = new JCheckBoxMenuItem("Collapsible View", false);
        this.collapsedView.addActionListener(this);
        this.optionsMenu.add(this.collapsedView);
        this.unitsSubMenu = ParaProfUtils.createUnitsMenu(this, this.units, true);
        this.optionsMenu.add(this.unitsSubMenu);
        jMenu = new JMenu("Sort By");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Name", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive per Call", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive per Call", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        this.descendingOrder = new JCheckBoxMenuItem("Descending Order", true);
        this.descendingOrder.addActionListener(this);
        this.optionsMenu.add(this.descendingOrder);
        this.optionsMenu.addMenuListener(this);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Name")) {
                    this.sortByName = true;
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Descending Order")) {
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Exclusive")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.EXCLUSIVE);
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Inclusive")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.INCLUSIVE);
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Number of Calls")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.NUMCALLS);
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Number of Child Calls")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.NUMSUBR);
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Inclusive per Call")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.INCLUSIVE_PER_CALL);
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Exclusive per Call")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.EXCLUSIVE_PER_CALL);
                    this.sortLocalData();
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Collapsible View")) {
                    this.panel.resetAllDrawObjects();
                    this.panel.repaint();
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                } else if (string.equals("Show Find Panel")) {
                    if (this.showFindPanelBox.isSelected()) {
                        this.showSearchPanel(true);
                    } else {
                        this.showSearchPanel(false);
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.ppTrial.isTimeMetric()) {
                this.unitsSubMenu.setEnabled(true);
            } else {
                this.unitsSubMenu.setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.setHeader();
            this.sortLocalData();
            this.panel.resetAllDrawObjects();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    @Override
    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("Call path text window.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("This window displays call path relationships in two ways:");
        ParaProf.getHelpWindow().writeText("1- If this window has been invoked from the \"windows\" menu of");
        ParaProf.getHelpWindow().writeText("ParaProf, the information displayed is all call path relations found.");
        ParaProf.getHelpWindow().writeText("That is, all the parent/child relationships.");
        ParaProf.getHelpWindow().writeText("Thus, in this case, given the parallel nature of ParaProf, this information");
        ParaProf.getHelpWindow().writeText("might not be valid for a particular thread. It is however useful to observe");
        ParaProf.getHelpWindow().writeText("all the realtionships that exist in the data.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("2- If this window has been invoked from the popup menu to the left of a thread bar");
        ParaProf.getHelpWindow().writeText("in the main ParaProf window, the information dispayed will be specific to this thread,");
        ParaProf.getHelpWindow().writeText("and will thus contain both parent/child relations and the data relating to those");
        ParaProf.getHelpWindow().writeText("relationships.");
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    private void sortLocalData() {
        if (this.sortByName) {
            this.dataSorter.setSortType(SortType.NAME);
        } else {
            this.dataSorter.setSortType(SortType.VALUE);
        }
        this.dataSorter.setDescendingOrder(this.descendingOrder.isSelected());
        this.dataSorter.setSelectedMetric(this.ppTrial.getDefaultMetric());
        this.setHeader();
        this.list = this.dataSorter.getFunctionProfiles(this.thread);
    }

    public List<PPFunctionProfile> getData() {
        return this.list;
    }

    public ListIterator<PPFunctionProfile> getDataIterator() {
        return this.list.listIterator();
    }

    public int units() {
        if (this.ppTrial.isTimeMetric()) {
            return this.units;
        }
        return 0;
    }

    public boolean showCollapsedView() {
        return this.collapsedView.isSelected();
    }

    public Dimension getViewportSize() {
        return this.sp.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.sp.getViewport().getViewRect();
    }

    @Override
    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.addKeyListener(this);
            jTextArea.setFont(ParaProf.preferencesWindow.getFont());
            jTextArea.append(this.getHeaderString());
            jTextArea.setMargin(new Insets(3, 3, 3, 3));
            this.sp.setColumnHeaderView(jTextArea);
        } else {
            this.sp.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        return "Metric Name: " + this.dataSorter.getSelectedMetric().getName() + "\n" + "Sorted By: " + this.dataSorter.getValueType() + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.dataSorter.isTimeMetric(), (boolean)this.dataSorter.isDerivedMetric(), (String)this.dataSorter.getSelectedMetric().getName()) + "\n";
    }

    @Override
    public void closeThisWindow() {
        this.setVisible(false);
        this.ppTrial.deleteObserver(this);
        ParaProf.decrementNumWindows();
        this.dispose();
    }

    @Override
    public void showSearchPanel(boolean bl) {
        if (bl) {
            if (this.searchPanel == null) {
                this.searchPanel = new SearchPanel(this, this.panel.getSearcher());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.weightx = 0.1;
                gridBagConstraints.weighty = 0.01;
                this.addCompItem(this.searchPanel, gridBagConstraints, 0, 3, 2, 1);
                this.searchPanel.setFocus();
            }
        } else {
            this.getContentPane().remove(this.searchPanel);
            this.searchPanel = null;
        }
        this.showFindPanelBox.setSelected(bl);
        this.validate();
    }

    @Override
    public void setHorizontalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.sp.getHorizontalScrollBar();
        jScrollBar.setValue(n);
    }

    @Override
    public Dimension getThisViewportSize() {
        return this.getViewportSize();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 70) {
            this.showSearchPanel(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void setUnits(int n) {
        this.units = n;
        this.setHeader();
        this.panel.repaint();
    }

    public JScrollPane getScrollPane() {
        return this.sp;
    }

    @Override
    public JFrame getFrame() {
        return this;
    }
}

