/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.AlphanumComparator;
import edu.uoregon.tau.paraprof.FunctionOrdering;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSorter
implements Comparator<FunctionProfile> {
    private ParaProfTrial ppTrial = null;
    private Metric selectedMetric;
    private Metric sortMetric;
    private ValueType valueType;
    private SortType sortType;
    private ValueType sortValueType;
    private UserEventValueType userEventValueType = UserEventValueType.NUMSAMPLES;
    private boolean descendingOrder;
    private boolean sortByVisible = true;
    private Function phase;
    private static SortType defaultSortType = SortType.MEAN_VALUE;
    private static ValueType defaultValueType = ValueType.EXCLUSIVE;
    private static boolean defaultSortOrder = true;
    private boolean selectedSnapshotOverride = false;
    private int selectedSnapshot = -1;
    private static AlphanumComparator anComparator = new AlphanumComparator();

    public DataSorter(ParaProfTrial paraProfTrial) {
        this.ppTrial = paraProfTrial;
        this.selectedMetric = paraProfTrial.getDefaultMetric();
        this.sortMetric = paraProfTrial.getDefaultMetric();
        this.sortType = defaultSortType;
        this.valueType = defaultValueType;
        this.sortValueType = defaultValueType;
        this.descendingOrder = defaultSortOrder;
    }

    public boolean isTimeMetric() {
        return this.selectedMetric.isTimeMetric();
    }

    public boolean isDerivedMetric() {
        return this.selectedMetric.getDerivedMetric();
    }

    public List<PPUserEventProfile> getUserEventProfiles(Thread thread) {
        UserEventProfile userEventProfile = null;
        ArrayList<PPUserEventProfile> arrayList = new ArrayList<PPUserEventProfile>();
        Iterator iterator = thread.getUserEventProfiles();
        while (iterator.hasNext()) {
            userEventProfile = (UserEventProfile)iterator.next();
            if (userEventProfile == null) continue;
            PPUserEventProfile pPUserEventProfile = new PPUserEventProfile(this, thread, userEventProfile);
            arrayList.add(pPUserEventProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private List<PPFunctionProfile> createFunctionProfileList(Thread thread, boolean bl) {
        ArrayList<PPFunctionProfile> arrayList = null;
        List list = thread.getFunctionProfiles();
        arrayList = new ArrayList<PPFunctionProfile>();
        for (int i = 0; i < list.size(); ++i) {
            PPFunctionProfile pPFunctionProfile;
            FunctionProfile functionProfile = (FunctionProfile)list.get(i);
            if (functionProfile == null) continue;
            if (bl) {
                if (!functionProfile.getFunction().isPhaseMember(this.phase)) continue;
                pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
                arrayList.add(pPFunctionProfile);
                continue;
            }
            if (!this.ppTrial.displayFunction(functionProfile.getFunction()) || !functionProfile.getFunction().isPhaseMember(this.phase)) continue;
            pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
            arrayList.add(pPFunctionProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<PPFunctionProfile> getCallPathFunctionProfiles(Thread thread) {
        return this.createFunctionProfileList(thread, true);
    }

    public List<PPFunctionProfile> getFunctionProfiles(Thread thread) {
        return this.createFunctionProfileList(thread, false);
    }

    public List<FunctionProfile> getBasicFunctionProfiles(Thread thread) {
        ArrayList<FunctionProfile> arrayList = null;
        List list = thread.getFunctionProfiles();
        arrayList = new ArrayList<FunctionProfile>();
        for (int i = 0; i < list.size(); ++i) {
            FunctionProfile functionProfile = (FunctionProfile)list.get(i);
            if (functionProfile == null || !this.ppTrial.displayFunction(functionProfile.getFunction())) continue;
            arrayList.add(functionProfile);
        }
        Collections.sort(arrayList, this);
        return arrayList;
    }

    public List<PPThread> getAllFunctionProfiles() {
        PPFunctionProfile pPFunctionProfile;
        long l = System.currentTimeMillis();
        ArrayList<PPThread> arrayList = new ArrayList<PPThread>();
        PPThread pPThread = null;
        Thread thread2 = this.ppTrial.getDataSource().getStdDevData();
        PPThread pPThread2 = new PPThread(thread2, this.ppTrial);
        for (Object object : thread2.getFunctionProfiles()) {
            if (object == null || !this.ppTrial.displayFunction(object.getFunction()) || !object.getFunction().isPhaseMember(this.phase)) continue;
            pPFunctionProfile = new PPFunctionProfile(this, thread2, (FunctionProfile)object);
            pPThread2.addFunction(pPFunctionProfile);
        }
        Collections.sort(pPThread2.getFunctionList());
        arrayList.add(pPThread2);
        thread2 = this.ppTrial.getDataSource().getMeanData();
        pPThread2 = new PPThread(thread2, this.ppTrial);
        for (Object object : thread2.getFunctionProfiles()) {
            if (object == null || !this.ppTrial.displayFunction(object.getFunction()) || !object.getFunction().isPhaseMember(this.phase)) continue;
            pPFunctionProfile = new PPFunctionProfile(this, thread2, (FunctionProfile)object);
            pPThread2.addFunction(pPFunctionProfile);
        }
        Collections.sort(pPThread2.getFunctionList());
        arrayList.add(pPThread2);
        pPThread = pPThread2;
        for (Thread thread2 : this.ppTrial.getDataSource().getAllThreads()) {
            Object object;
            pPThread2 = new PPThread(thread2, this.ppTrial);
            object = pPThread.getFunctionListIterator();
            while (object.hasNext()) {
                pPFunctionProfile = (PPFunctionProfile)object.next();
                FunctionProfile functionProfile = thread2.getFunctionProfile(pPFunctionProfile.getFunction());
                if (functionProfile == null) continue;
                pPThread2.addFunction(new PPFunctionProfile(this, thread2, functionProfile));
            }
            if (pPThread2.getFunctionList().size() <= 0) continue;
            arrayList.add(pPThread2);
        }
        l = System.currentTimeMillis() - l;
        return arrayList;
    }

    private void addThread(List<List<FunctionProfile>> list, List<FunctionProfile> list2, Thread thread) {
        ArrayList<FunctionProfile> arrayList = new ArrayList<FunctionProfile>();
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            FunctionProfile functionProfile = list2.get(i);
            FunctionProfile functionProfile2 = thread.getFunctionProfile(functionProfile.getFunction());
            if (functionProfile2 == null) continue;
            arrayList.add(functionProfile2);
        }
        if (arrayList.size() > 0) {
            list.add(arrayList);
        }
    }

    public List<List<FunctionProfile>> getAllFunctionProfilesMinimal() {
        long l = System.currentTimeMillis();
        ArrayList<List<FunctionProfile>> arrayList = new ArrayList<List<FunctionProfile>>();
        ArrayList<FunctionProfile> arrayList2 = new ArrayList<FunctionProfile>();
        List list = this.ppTrial.getDataSource().getMeanData().getFunctionProfiles();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            FunctionProfile functionProfile = (FunctionProfile)list.get(i);
            if (functionProfile == null || !this.ppTrial.displayFunction(functionProfile.getFunction()) || !functionProfile.getFunction().isPhaseMember(this.phase)) continue;
            arrayList2.add(functionProfile);
        }
        Collections.sort(arrayList2, this);
        this.addThread(arrayList, arrayList2, this.ppTrial.getDataSource().getStdDevData());
        arrayList.add(arrayList2);
        for (Thread thread : this.ppTrial.getDataSource().getAllThreads()) {
            this.addThread(arrayList, arrayList2, thread);
        }
        l = System.currentTimeMillis() - l;
        return arrayList;
    }

    public FunctionOrdering getOrdering() {
        long l = System.currentTimeMillis();
        ArrayList<FunctionProfile> arrayList = new ArrayList<FunctionProfile>();
        List list = this.ppTrial.getDataSource().getMeanData().getFunctionProfiles();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            FunctionProfile functionProfile = (FunctionProfile)list.get(i);
            if (functionProfile == null || !this.ppTrial.displayFunction(functionProfile.getFunction()) || !functionProfile.getFunction().isPhaseMember(this.phase)) continue;
            arrayList.add(functionProfile);
        }
        Collections.sort(arrayList, this);
        Function[] functionArray = new Function[arrayList.size()];
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            functionArray[n] = ((FunctionProfile)arrayList.get(n)).getFunction();
        }
        FunctionOrdering functionOrdering = new FunctionOrdering(this);
        functionOrdering.setFunctions(functionArray);
        l = System.currentTimeMillis() - l;
        return functionOrdering;
    }

    boolean filterThread(Thread thread, int[] nArray) {
        if (thread == null) {
            return false;
        }
        if (nArray == null) {
            return true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (thread.getThreadID() != nArray[i]) continue;
            return false;
        }
        return true;
    }

    public List<Thread> getThreads(int[] nArray) {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Thread thread2 = null;
        thread2 = this.ppTrial.getDataSource().getStdDevData();
        if (thread2 != null && this.filterThread(thread2, nArray)) {
            arrayList.add(thread2);
        }
        if ((thread2 = this.ppTrial.getDataSource().getMeanData()) != null && this.filterThread(thread2, nArray)) {
            arrayList.add(thread2);
        }
        if ((thread2 = this.ppTrial.getDataSource().getTotalData()) != null && this.filterThread(thread2, nArray)) {
            arrayList.add(thread2);
        }
        if ((thread2 = this.ppTrial.getDataSource().getMaxData()) != null && this.filterThread(thread2, nArray)) {
            arrayList.add(thread2);
        }
        if ((thread2 = this.ppTrial.getDataSource().getMinData()) != null && this.filterThread(thread2, nArray)) {
            arrayList.add(thread2);
        }
        for (Thread thread2 : this.ppTrial.getDataSource().getAllThreads()) {
            if (!this.filterThread(thread2, nArray)) continue;
            arrayList.add(thread2);
        }
        return arrayList;
    }

    public List<Thread> getThreads() {
        return this.getThreads(null);
    }

    public List<PPFunctionProfile> getFunctionData(Function function, boolean bl, boolean bl2) {
        PPFunctionProfile pPFunctionProfile;
        FunctionProfile functionProfile;
        Thread thread2;
        ArrayList<PPFunctionProfile> arrayList = new ArrayList<PPFunctionProfile>();
        if (bl) {
            thread2 = this.ppTrial.getDataSource().getMeanData();
            functionProfile = thread2.getFunctionProfile(function);
            if (functionProfile != null) {
                pPFunctionProfile = new PPFunctionProfile(this, thread2, functionProfile);
                arrayList.add(pPFunctionProfile);
            }
            if ((thread2 = this.ppTrial.getDataSource().getMinData()) != null) {
                functionProfile = thread2.getFunctionProfile(function);
                pPFunctionProfile = new PPFunctionProfile(this, thread2, functionProfile);
                arrayList.add(pPFunctionProfile);
            }
            if ((thread2 = this.ppTrial.getDataSource().getMaxData()) != null) {
                functionProfile = thread2.getFunctionProfile(function);
                pPFunctionProfile = new PPFunctionProfile(this, thread2, functionProfile);
                arrayList.add(pPFunctionProfile);
            }
        }
        if (bl2 && (functionProfile = (thread2 = this.ppTrial.getDataSource().getStdDevData()).getFunctionProfile(function)) != null) {
            pPFunctionProfile = new PPFunctionProfile(this, thread2, functionProfile);
            arrayList.add(pPFunctionProfile);
        }
        for (Thread thread2 : this.ppTrial.getDataSource().getAllThreads()) {
            pPFunctionProfile = thread2.getFunctionProfile(function);
            if (pPFunctionProfile == null) continue;
            PPFunctionProfile pPFunctionProfile2 = new PPFunctionProfile(this, thread2, (FunctionProfile)pPFunctionProfile);
            arrayList.add(pPFunctionProfile2);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<PPFunctionProfile> getFunctionAcrossPhases(Function function, Thread thread) {
        ArrayList<PPFunctionProfile> arrayList = new ArrayList<PPFunctionProfile>();
        String string = function.getName();
        if (function.isCallPathFunction()) {
            string = string.substring(string.indexOf("=>") + 2).trim();
        }
        Iterator iterator = thread.getFunctionProfileIterator();
        while (iterator.hasNext()) {
            FunctionProfile functionProfile = (FunctionProfile)iterator.next();
            if (functionProfile == null || !functionProfile.isCallPathFunction()) continue;
            String string2 = functionProfile.getName();
            if (string.compareTo(string2 = string2.substring(string2.indexOf("=>") + 2).trim()) != 0) continue;
            PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
            arrayList.add(pPFunctionProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<PPUserEventProfile> getUserEventData(UserEvent userEvent) {
        PPUserEventProfile pPUserEventProfile;
        ArrayList<PPUserEventProfile> arrayList = new ArrayList<PPUserEventProfile>();
        Thread thread2 = this.ppTrial.getDataSource().getMeanData();
        UserEventProfile userEventProfile = thread2.getUserEventProfile(userEvent);
        if (userEventProfile != null) {
            pPUserEventProfile = new PPUserEventProfile(this, thread2, userEventProfile);
            arrayList.add(pPUserEventProfile);
        }
        if ((userEventProfile = (thread2 = this.ppTrial.getDataSource().getStdDevData()).getUserEventProfile(userEvent)) != null) {
            pPUserEventProfile = new PPUserEventProfile(this, thread2, userEventProfile);
            arrayList.add(pPUserEventProfile);
        }
        for (Thread thread2 : this.ppTrial.getDataSource().getAllThreads()) {
            userEventProfile = thread2.getUserEventProfile(userEvent);
            if (userEventProfile == null) continue;
            pPUserEventProfile = new PPUserEventProfile(this, thread2, userEventProfile);
            arrayList.add(pPUserEventProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public int compare(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        FunctionProfile functionProfile3 = functionProfile;
        FunctionProfile functionProfile4 = functionProfile2;
        if (this.descendingOrder) {
            return -this.performComparison(functionProfile3, functionProfile4);
        }
        return this.performComparison(functionProfile3, functionProfile4);
    }

    private int performComparison(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        ValueType valueType = this.getSortValueType();
        if (this.sortType == SortType.NAME) {
            return anComparator.compare(DataSorter.getDisplayName(functionProfile2), DataSorter.getDisplayName(functionProfile));
        }
        if (this.sortType == SortType.NCT) {
            return DataSorter.compareNCT(functionProfile, functionProfile2);
        }
        if (this.sortType == SortType.MEAN_VALUE) {
            return DataSorter.compareToHelper(valueType.getValue(functionProfile.getFunction().getMeanProfile(), this.getSortMetric(), this.getSelectedSnapshot()), valueType.getValue(functionProfile2.getFunction().getMeanProfile(), this.getSortMetric(), this.getSelectedSnapshot()), functionProfile.getFunction().getMeanProfile(), functionProfile2.getFunction().getMeanProfile());
        }
        if (this.sortType == SortType.VALUE) {
            return DataSorter.compareToHelper(valueType.getValue(functionProfile, this.getSortMetric(), this.getSelectedSnapshot()), valueType.getValue(functionProfile2, this.getSortMetric(), this.getSelectedSnapshot()));
        }
        throw new ParaProfException("Unexpected sort type: " + this.sortType);
    }

    public static String getDisplayName(FunctionProfile functionProfile) {
        if (ParaProf.preferences.getReversedCallPaths()) {
            return functionProfile.getFunction().getReversedName();
        }
        return functionProfile.getFunction().getName();
    }

    private static int compareNCT(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        Thread thread = functionProfile.getThread();
        Thread thread2 = functionProfile2.getThread();
        if (thread.getNodeID() != thread2.getNodeID()) {
            return thread.getNodeID() - thread2.getNodeID();
        }
        if (thread.getContextID() != thread2.getContextID()) {
            return thread.getContextID() - thread2.getContextID();
        }
        return thread.getThreadID() - thread2.getThreadID();
    }

    private static int compareToHelper(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return 0;
        }
        return 1;
    }

    private static int compareToHelper(double d, double d2, FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return functionProfile.getFunction().compareTo(functionProfile2.getFunction());
        }
        return 1;
    }

    public Function getPhase() {
        return this.phase;
    }

    public ParaProfTrial getPpTrial() {
        return this.ppTrial;
    }

    public void setPpTrial(ParaProfTrial paraProfTrial) {
        this.ppTrial = paraProfTrial;
    }

    public Metric getSortMetric() {
        if (this.getSortByVisible()) {
            return this.selectedMetric;
        }
        return this.sortMetric;
    }

    public void setSortMetric(Metric metric) {
        this.sortMetric = metric;
    }

    public ValueType getSortValueType() {
        if (this.getSortByVisible()) {
            return this.valueType;
        }
        return this.sortValueType;
    }

    public void setSortValueType(ValueType valueType) {
        this.sortValueType = valueType;
    }

    public boolean getSortByVisible() {
        return this.sortByVisible;
    }

    public void setSortByVisible(boolean bl) {
        this.sortByVisible = bl;
    }

    public void setSelectedMetric(Metric metric) {
        this.selectedMetric = metric;
    }

    public double getValue(FunctionProfile functionProfile) {
        return this.getValueType().getValue(functionProfile, this.selectedMetric, this.getSelectedSnapshot());
    }

    public double getValue(FunctionProfile functionProfile, int n) {
        return this.getValueType().getValue(functionProfile, this.selectedMetric, n);
    }

    public Metric getSelectedMetric() {
        return this.selectedMetric;
    }

    public void setDescendingOrder(boolean bl) {
        this.descendingOrder = bl;
    }

    public boolean getDescendingOrder() {
        return this.descendingOrder;
    }

    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setPhase(Function function) {
        this.phase = function;
    }

    public UserEventValueType getUserEventValueType() {
        return this.userEventValueType;
    }

    public void setUserEventValueType(UserEventValueType userEventValueType) {
        this.userEventValueType = userEventValueType;
    }

    public static void setDefaultSortType(SortType sortType) {
        defaultSortType = sortType;
    }

    public static void setDefaultValueType(ValueType valueType) {
        defaultValueType = valueType;
    }

    public static void setDefaultSortOrder(boolean bl) {
        defaultSortOrder = bl;
    }

    public int getSelectedSnapshot() {
        if (this.selectedSnapshotOverride) {
            return this.selectedSnapshot;
        }
        return this.ppTrial.getSelectedSnapshot();
    }

    public boolean getSelectedSnapshotOverride() {
        return this.selectedSnapshotOverride;
    }

    public void setSelectedSnapshotOverride(boolean bl) {
        this.selectedSnapshotOverride = bl;
    }

    public void setSelectedSnapshot(int n) {
        this.selectedSnapshot = n;
    }
}

