/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPUserEventProfile
implements Comparable<PPUserEventProfile> {
    private UserEventProfile userEventProfile;
    private DataSorter dataSorter;
    private UserEvent userEvent;
    private boolean highlighted = false;
    private Thread thread;

    public PPUserEventProfile(DataSorter dataSorter, Thread thread, UserEventProfile userEventProfile) {
        this.thread = thread;
        this.dataSorter = dataSorter;
        this.userEventProfile = userEventProfile;
        this.userEvent = userEventProfile.getUserEvent();
    }

    public int getNodeID() {
        return this.thread.getNodeID();
    }

    public int getContextID() {
        return this.thread.getContextID();
    }

    public int getThreadID() {
        return this.thread.getThreadID();
    }

    public UserEvent getUserEvent() {
        return this.userEvent;
    }

    public String getUserEventDisplayName() {
        return ParaProfUtils.getUserEventDisplayName(this.userEvent);
    }

    public String getUserEventName() {
        return this.userEvent.getName();
    }

    public Color getColor() {
        return this.userEvent.getColor();
    }

    public UserEventProfile getUserEventProfile() {
        return this.userEventProfile;
    }

    public double getNumSamples() {
        return this.userEventProfile.getNumSamples(this.dataSorter.getSelectedSnapshot());
    }

    public double getMinValue() {
        return this.userEventProfile.getMinValue(this.dataSorter.getSelectedSnapshot());
    }

    public double getMaxValue() {
        return this.userEventProfile.getMaxValue(this.dataSorter.getSelectedSnapshot());
    }

    public double getMeanValue() {
        return this.userEventProfile.getMeanValue(this.dataSorter.getSelectedSnapshot());
    }

    public double getStdDev() {
        return this.userEventProfile.getStdDev(this.dataSorter.getSelectedSnapshot());
    }

    public String getUserEventStatString(int n, boolean bl) {
        int n2;
        int n3 = 108;
        int n4 = 0;
        char[] cArray = new char[n3];
        PPUserEventProfile.insertSpaces(cArray, 0, 108);
        String string = this.getUserEventDisplayName();
        String string2 = string.startsWith("Memory Utilization (heap, in KB)") || string.contains("/s)") || !bl || !this.getUserEvent().isShowTotal() ? "-" : UtilFncs.getOutputString((int)0, (double)(this.getNumSamples() * this.getMeanValue()), (int)n, (boolean)false);
        char[] cArray2 = string2.toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        n4 = 18;
        string2 = UtilFncs.getOutputString((int)0, (double)this.getNumSamples(), (int)n, (boolean)false);
        cArray2 = string2.toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        n4 = 36;
        string2 = UtilFncs.getOutputString((int)0, (double)this.getMaxValue(), (int)n, (boolean)false);
        cArray2 = string2.toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        n4 = 54;
        string2 = UtilFncs.getOutputString((int)0, (double)this.getMinValue(), (int)n, (boolean)false);
        cArray2 = string2.toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        n4 = 72;
        string2 = UtilFncs.getOutputString((int)0, (double)this.getMeanValue(), (int)n, (boolean)false);
        cArray2 = string2.toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        n4 = 90;
        string2 = UtilFncs.getOutputString((int)0, (double)this.getStdDev(), (int)n, (boolean)false);
        cArray2 = string2.toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        return new String(cArray);
    }

    private static int insertSpaces(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[n] = 32;
            ++n;
        }
        return n;
    }

    private int checkDescending(int n) {
        if (this.dataSorter.getDescendingOrder()) {
            return -n;
        }
        return n;
    }

    @Override
    public int compareTo(PPUserEventProfile pPUserEventProfile) {
        UserEventValueType userEventValueType = this.dataSorter.getUserEventValueType();
        PPUserEventProfile pPUserEventProfile2 = pPUserEventProfile;
        if (this.dataSorter.getSortType() == SortType.NAME) {
            return this.checkDescending(pPUserEventProfile2.getUserEventName().compareTo(this.getUserEventName()));
        }
        if (this.dataSorter.getSortType() == SortType.NCT) {
            if (pPUserEventProfile2.getNodeID() != this.getNodeID()) {
                return this.checkDescending(this.getNodeID() - pPUserEventProfile2.getNodeID());
            }
            if (pPUserEventProfile2.getContextID() != this.getContextID()) {
                return this.checkDescending(this.getContextID() - pPUserEventProfile2.getContextID());
            }
            return this.checkDescending(this.getThreadID() - pPUserEventProfile2.getThreadID());
        }
        if (this.dataSorter.getSortType() == SortType.VALUE || this.dataSorter.getSortType() == SortType.MEAN_VALUE) {
            if (userEventValueType.toString().equals("Total") && !this.dataSorter.getDescendingOrder()) {
                return this.compareTotalHelper(userEventValueType.getValue(this.getUserEventProfile()), userEventValueType.getValue(pPUserEventProfile2.getUserEventProfile()));
            }
            return this.checkDescending(this.compareToHelper(userEventValueType.getValue(this.getUserEventProfile()), userEventValueType.getValue(pPUserEventProfile2.getUserEventProfile())));
        }
        throw new ParaProfException("Unexpected sort type: " + this.dataSorter.getSortType());
    }

    private int compareToHelper(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return 0;
        }
        return 1;
    }

    private int compareTotalHelper(double d, double d2) {
        if (d == -1.0 && d2 == -1.0) {
            return 0;
        }
        if (d == -1.0) {
            return 1;
        }
        if (d2 == -1.0) {
            return -1;
        }
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return 0;
        }
        return 1;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public Thread getThread() {
        return this.thread;
    }
}

