/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.GlobalDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTreeNodeUserObject;
import edu.uoregon.tau.paraprof.ParaProfView;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.SnapshotControlWindow;
import edu.uoregon.tau.paraprof.script.ParaProfScript;
import edu.uoregon.tau.paraprof.script.ParaProfTrialScript;
import edu.uoregon.tau.paraprof.util.FileMonitor;
import edu.uoregon.tau.paraprof.util.FileMonitorListener;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.FileList;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UserEvent;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParaProfTrial
extends Observable
implements ParaProfTreeNodeUserObject {
    private Function highlightedFunction = null;
    private Group highlightedGroup = null;
    private UserEvent highlightedUserEvent = null;
    private DatabaseAPI dbAPI;
    private ParaProfExperiment experiment = null;
    private ParaProfView view = null;
    private DefaultMutableTreeNode defaultMutableTreeNode = null;
    private TreePath treePath = null;
    private boolean dBTrial = false;
    private boolean upload = false;
    private boolean loading = false;
    private GlobalDataWindow fullDataWindow = null;
    private ColorChooser clrChooser = ParaProf.colorChooser;
    private PreferencesWindow preferencesWindow = ParaProf.preferencesWindow;
    private String path = null;
    private String pathReverse = null;
    private Metric defaultMetric = null;
    private int selectedSnapshot = -1;
    private Group selectedGroup;
    private Group groupInclude;
    private Group groupExclude;
    private Trial trial;
    private boolean[] functionMask;
    private boolean monitored;
    private List<Observer> obs = new ArrayList<Observer>();
    private FileMonitorListener fileMonitorListener;
    private SnapshotControlWindow snapshotControlWindow;
    private static final String TAU_APPLICATION_NAME = "TAU_APPLICATION_NAME";

    public ParaProfTrial() {
        this.trial = new Trial();
        this.trial.setID(-1);
        this.trial.setExperimentID(-1);
        this.trial.setApplicationID(-1);
        this.trial.setName("");
    }

    public ParaProfTrial(Trial trial) {
        this.trial = new Trial(trial);
        this.assignDefaultMetric();
    }

    public Iterator<Function> getFunctions() {
        return this.getDataSource().getFunctionIterator();
    }

    public Thread getMeanThread() {
        return this.getDataSource().getMeanData();
    }

    public Trial getTrial() {
        return this.trial;
    }

    public int getApplicationID() {
        return this.trial.getApplicationID();
    }

    public int getExperimentID() {
        return this.trial.getExperimentID();
    }

    public int getID() {
        return this.trial.getID();
    }

    public void setApplicationID(int n) {
        this.trial.setApplicationID(n);
    }

    public void setExperimentID(int n) {
        this.trial.setExperimentID(n);
    }

    public void setID(int n) {
        this.trial.setID(n);
    }

    public void rename(String string) {
        DatabaseAPI databaseAPI;
        if (this.dBTrial && (databaseAPI = this.getDatabaseAPI()) != null) {
            this.trial.rename(databaseAPI.getDb(), string);
        }
        this.trial.setName(string);
    }

    public String getName() {
        return this.trial.getName();
    }

    public DataSource getDataSource() {
        return this.trial.getDataSource();
    }

    public void setExperiment(ParaProfExperiment paraProfExperiment) {
        this.experiment = paraProfExperiment;
    }

    public void setView(ParaProfView paraProfView) {
        this.view = paraProfView;
    }

    public ParaProfView getView() {
        return this.view;
    }

    public ParaProfExperiment getExperiment() {
        return this.experiment;
    }

    public void setDMTN(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.defaultMutableTreeNode = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDMTN() {
        return this.defaultMutableTreeNode;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public void setDBTrial(boolean bl) {
        this.dBTrial = bl;
    }

    public boolean dBTrial() {
        return this.dBTrial;
    }

    public void setUpload(boolean bl) {
        this.upload = bl;
    }

    public boolean upload() {
        return this.upload;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public boolean loading() {
        return this.loading;
    }

    public String getIDString() {
        if (this.experiment != null) {
            return this.experiment.getIDString() + ":" + this.trial.getID();
        }
        if (this.view != null) {
            return this.view.getIDString() + ":" + this.trial.getID();
        }
        return ":" + this.trial.getID();
    }

    public ColorChooser getColorChooser() {
        return this.clrChooser;
    }

    public PreferencesWindow getPreferencesWindow() {
        return this.preferencesWindow;
    }

    public String getTrialIdentifier(boolean bl) {
        if (this.path != null) {
            if (bl) {
                return this.pathReverse;
            }
            return this.path;
        }
        return "Application " + this.trial.getApplicationID() + ", Experiment " + this.trial.getExperimentID() + ", Trial " + this.trial.getID() + ".";
    }

    public void setPaths(String string) {
        this.path = string;
        this.pathReverse = FileList.getPathReverse((String)string);
    }

    public String getPath() {
        return this.path;
    }

    public String getPathReverse() {
        return this.pathReverse;
    }

    public String toString() {
        if (this.loading()) {
            return this.trial.getName() + " (Loading...)";
        }
        return this.trial.getName();
    }

    @Override
    public void clearDefaultMutableTreeNode() {
        this.setDMTN(null);
    }

    public GlobalDataWindow getFullDataWindow() {
        return this.fullDataWindow;
    }

    public void showMainWindow() {
        if (this.fullDataWindow == null) {
            this.showSnapshotController();
        }
        this.fullDataWindow = new GlobalDataWindow(this, this.trial.getDataSource().getTopLevelPhase());
        this.fullDataWindow.setVisible(true);
    }

    public void showSnapshotController() {
        if (this.getDataSource().getWellBehavedSnapshots()) {
            this.snapshotControlWindow = new SnapshotControlWindow(this);
            this.snapshotControlWindow.setVisible(true);
        }
    }

    public void setDefaultMetric(Metric metric) {
        this.defaultMetric = metric;
    }

    public Metric getDefaultMetric() {
        return this.defaultMetric;
    }

    public boolean isTimeMetric() {
        return this.defaultMetric.isTimeMetric();
    }

    public boolean isDerivedMetric() {
        return this.defaultMetric.getDerivedMetric();
    }

    public List<Metric> getMetrics() {
        if (this.trial == null) {
            return null;
        }
        if (this.trial.getDataSource() == null) {
            return null;
        }
        return this.trial.getDataSource().getMetrics();
    }

    public int getMetricID(String string) {
        Metric metric = this.getDataSource().getMetric(string);
        if (metric == null) {
            return -1;
        }
        return metric.getID();
    }

    public int getNumberOfMetrics() {
        return this.trial.getDataSource().getNumberOfMetrics();
    }

    public ParaProfMetric getMetric(int n) {
        return (ParaProfMetric)this.trial.getDataSource().getMetric(n);
    }

    public Metric getRegularMetric(int n) {
        return this.trial.getDataSource().getMetric(n);
    }

    public String getMetricName(int n) {
        return this.trial.getDataSource().getMetricName(n);
    }

    public ParaProfMetric addMetric() {
        ParaProfMetric paraProfMetric = new ParaProfMetric();
        this.trial.getDataSource().addMetric((Metric)paraProfMetric);
        return paraProfMetric;
    }

    public boolean groupNamesPresent() {
        return this.trial.getDataSource().getGroupNamesPresent();
    }

    public boolean userEventsPresent() {
        return this.trial.getDataSource().getUserEventsPresent();
    }

    public boolean callPathDataPresent() {
        return this.trial.getDataSource().getCallPathDataPresent();
    }

    public int[] getMaxNCTNumbers() {
        return this.trial.getDataSource().getMaxNCTNumbers();
    }

    public void setMeanData(int n) {
        boolean bl = this.trial.getDataSource().isDerivedProvided();
        this.trial.getDataSource().setDerivedProvided(false);
        this.trial.getDataSource().generateStatistics(n, n);
        this.trial.getDataSource().setDerivedProvided(bl);
    }

    public List<Function> getDisplayedFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        Iterator iterator = this.getDataSource().getFunctionIterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (!this.displayFunction(function)) continue;
            arrayList.add(function);
        }
        return arrayList;
    }

    public boolean displayFunction(Function function) {
        if (this.functionMask == null) {
            return true;
        }
        return this.functionMask[function.getID()];
    }

    public void showGroup(Group group) {
        Iterator iterator = this.getDataSource().getFunctionIterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (!function.isGroupMember(group)) continue;
            this.functionMask[function.getID()] = true;
        }
        this.groupInclude = null;
        this.groupExclude = null;
        this.updateRegisteredObjects("dataEvent");
    }

    public void hideGroup(Group group) {
        Iterator iterator = this.getDataSource().getFunctionIterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (!function.isGroupMember(group)) continue;
            this.functionMask[function.getID()] = false;
        }
        this.groupInclude = null;
        this.groupExclude = null;
        this.updateRegisteredObjects("dataEvent");
    }

    public void showGroupOnly(Group group) {
        Iterator iterator = this.getDataSource().getFunctionIterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (function.isGroupMember(group)) {
                this.functionMask[function.getID()] = true;
                continue;
            }
            this.functionMask[function.getID()] = false;
        }
        this.groupInclude = group;
        this.groupExclude = null;
        this.updateRegisteredObjects("dataEvent");
    }

    public void showAllExcept(Group group) {
        Iterator iterator = this.getDataSource().getFunctionIterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (function.isGroupMember(group)) {
                this.functionMask[function.getID()] = false;
                continue;
            }
            this.functionMask[function.getID()] = true;
        }
        this.groupInclude = null;
        this.groupExclude = group;
        this.updateRegisteredObjects("dataEvent");
    }

    public void setFunctionMask(boolean[] blArray) {
        this.functionMask = blArray;
        this.groupInclude = null;
        this.groupExclude = null;
        this.updateRegisteredObjects("dataEvent");
    }

    public void showFunction(Function function) {
        this.functionMask[function.getID()] = true;
        this.updateRegisteredObjects("dataEvent");
    }

    public void hideFunction(Function function) {
        this.functionMask[function.getID()] = false;
        this.updateRegisteredObjects("dataEvent");
    }

    public void hideMatching(String string, boolean bl, boolean bl2) {
        this.maskMatching(string, false, bl, bl2);
    }

    public void showMatching(String string, boolean bl, boolean bl2) {
        this.maskMatching(string, true, bl, bl2);
    }

    public void maskMatching(String string, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            string = string.toUpperCase();
        }
        if (bl3) {
            bl = !bl;
            for (int i = 0; i < this.functionMask.length; ++i) {
                this.functionMask[i] = !bl;
            }
        }
        Iterator iterator = this.getDataSource().getFunctionIterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            String string2 = function.getName();
            if (bl2) {
                string2 = string2.toUpperCase();
            }
            if (string2.indexOf(string) == -1) continue;
            this.functionMask[function.getID()] = bl;
        }
        this.updateRegisteredObjects("dataEvent");
    }

    public void setSelectedGroup(Group group) {
        this.selectedGroup = group;
    }

    public void closeTrialWindows() {
        this.updateRegisteredObjects("subWindowCloseEvent");
    }

    public Group getSelectedGroup() {
        return this.selectedGroup;
    }

    private void assignDefaultMetric() {
        if (this.getMetrics() != null && this.getMetrics().size() > 0) {
            this.setDefaultMetric(this.getMetrics().get(0));
        }
        if (this.getMetrics() == null) {
            return;
        }
        for (Metric metric : this.getMetrics()) {
            if (!metric.isTimeMetric()) continue;
            this.setDefaultMetric(metric);
            break;
        }
        for (Metric metric : this.getMetrics()) {
            if (!metric.getName().equalsIgnoreCase("time")) continue;
            this.setDefaultMetric(metric);
            break;
        }
    }

    public void finishLoad() {
        int n;
        this.trial.setMetaData(this.trial.getDataSource().getMetaData());
        this.trial.setUncommonMetaData(this.trial.getDataSource().getUncommonMetaData());
        int n2 = this.trial.getDataSource().getNumberOfMetrics();
        Vector<ParaProfMetric> vector = new Vector<ParaProfMetric>();
        for (n = 0; n < n2; ++n) {
            ParaProfMetric paraProfMetric = new ParaProfMetric();
            paraProfMetric.setName(this.trial.getDataSource().getMetricName(n));
            paraProfMetric.setID(n);
            paraProfMetric.setDbMetricID(this.trial.getDataSource().getMetric(n).getDbMetricID());
            paraProfMetric.setPpTrial(this);
            vector.add(paraProfMetric);
        }
        this.trial.getDataSource().setMetrics(vector);
        this.assignDefaultMetric();
        this.functionMask = new boolean[this.getDataSource().getNumFunctions()];
        for (n = 0; n < this.functionMask.length; ++n) {
            this.functionMask[n] = true;
        }
        this.clrChooser.setColors(this, -1);
        this.setLoading(false);
        Group group = this.getGroup("TAU_CALLPATH_DERIVED");
        if (group != null) {
            this.showAllExcept(group);
        }
        for (int i = 0; i < ParaProf.scripts.size(); ++i) {
            ParaProfScript paraProfScript = ParaProf.scripts.get(i);
            if (!(paraProfScript instanceof ParaProfTrialScript)) continue;
            try {
                ((ParaProfTrialScript)paraProfScript).trialLoaded(this);
                continue;
            }
            catch (Exception exception) {
                new ParaProfErrorDialog("Exception while executing script: ", exception);
            }
        }
    }

    public DatabaseAPI getDatabaseAPI() {
        return this.dbAPI;
    }

    public void setDatabaseAPI(DatabaseAPI databaseAPI) {
        this.dbAPI = databaseAPI;
    }

    public void setHighlightedFunction(Function function) {
        this.highlightedFunction = function;
        this.updateRegisteredObjects("colorEvent");
    }

    public Function getHighlightedFunction() {
        return this.highlightedFunction;
    }

    public void toggleHighlightedFunction(Function function) {
        this.highlightedFunction = this.highlightedFunction == function ? null : function;
        this.updateRegisteredObjects("colorEvent");
    }

    public void setHighlightedGroup(Group group) {
        this.highlightedGroup = group;
        this.updateRegisteredObjects("colorEvent");
    }

    public Group getHighlightedGroup() {
        return this.highlightedGroup;
    }

    public void toggleHighlightedGroup(Group group) {
        this.highlightedGroup = this.highlightedGroup == group ? null : group;
        this.updateRegisteredObjects("colorEvent");
    }

    public void setHighlightedUserEvent(UserEvent userEvent) {
        this.highlightedUserEvent = userEvent;
        this.updateRegisteredObjects("colorEvent");
    }

    public UserEvent getHighlightedUserEvent() {
        return this.highlightedUserEvent;
    }

    public void toggleHighlightedUserEvent(UserEvent userEvent) {
        this.highlightedUserEvent = this.highlightedUserEvent == userEvent ? null : userEvent;
        this.updateRegisteredObjects("colorEvent");
    }

    public boolean getMonitored() {
        return this.monitored;
    }

    public void setMonitored(boolean bl) {
        this.monitored = bl;
        if (bl) {
            FileMonitor fileMonitor = new FileMonitor(1000L);
            List list = this.trial.getDataSource().getFiles();
            for (File file : list) {
                fileMonitor.addFile(file);
            }
            this.fileMonitorListener = new FileMonitorListener(){

                public void fileChanged(File file) {
                    try {
                        while (ParaProfTrial.this.loading) {
                            java.lang.Thread.sleep(1000L);
                        }
                        EventQueue.invokeAndWait(new Runnable(){

                            public void run() {
                                try {
                                    if (ParaProfTrial.this.getDataSource().reloadData()) {
                                        ParaProfTrial.this.clrChooser.setColors(ParaProfTrial.this, -1);
                                        ParaProfTrial.this.updateRegisteredObjects("dataEvent");
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            fileMonitor.addListener(this.fileMonitorListener);
        }
    }

    public Function getFunction(String string) {
        return this.getDataSource().getFunction(string);
    }

    public Thread getThread(int n, int n2, int n3) {
        return this.getDataSource().getThread(n, n2, n3);
    }

    public void updateRegisteredObjects(String string) {
        this.setChanged();
        this.notifyObservers(string);
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
        this.obs.add(observer);
    }

    @Override
    public void deleteObserver(Observer observer) {
        super.deleteObserver(observer);
        this.obs.remove(observer);
    }

    public List<Observer> getObservers() {
        return this.obs;
    }

    public Group getGroup(String string) {
        return this.getDataSource().getGroup(string);
    }

    public Group getGroupInclude() {
        return this.groupInclude;
    }

    public Group getGroupExclude() {
        return this.groupExclude;
    }

    public int getSelectedSnapshot() {
        return this.selectedSnapshot;
    }

    public void setSelectedSnapshot(int n) {
        this.selectedSnapshot = n;
        this.updateRegisteredObjects("dataEvent");
    }

    public Database getDatabase() {
        if (this.experiment != null) {
            return this.experiment.getDatabase();
        }
        if (this.view != null) {
            return this.view.getDatabase();
        }
        return null;
    }

    public List<Thread> getThreads() {
        return this.getDataSource().getAllThreads();
    }

    public List<String> getThreadNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Thread thread : this.getDataSource().getAllThreads()) {
            MetaDataMap metaDataMap = thread.getMetaData();
            String string = "";
            if (ParaProf.preferences.getAppNameLabels() == 1 && metaDataMap.containsKey(TAU_APPLICATION_NAME)) {
                string = ":" + metaDataMap.get(TAU_APPLICATION_NAME);
            }
            if (this.getDataSource().getExecutionType() == 1) {
                arrayList.add(Integer.toString(thread.getNodeID()) + string);
                continue;
            }
            if (this.getDataSource().getExecutionType() == 3) {
                arrayList.add(thread.getNodeID() + ":" + thread.getThreadID() + string);
                continue;
            }
            arrayList.add(thread.getNodeID() + ":" + thread.getContextID() + ":" + thread.getThreadID() + string);
        }
        return arrayList;
    }

    public void deleteMetric(Metric metric) {
        this.trial.getDataSource().getMetrics().remove(metric);
        if (metric == this.defaultMetric) {
            this.assignDefaultMetric();
        }
    }

    public Metric[] getMetricArray() {
        int n = 0;
        for (Metric metric : this.getMetrics()) {
            if (metric == null) continue;
            ++n;
        }
        Metric[] metricArray = new Metric[n];
        int n2 = 0;
        for (Metric metric : this.getMetrics()) {
            if (metric == null) continue;
            metricArray[n2++] = metric;
        }
        return metricArray;
    }

    public Vector<String> getTopologyArray() {
        Object object;
        Set set = this.getDataSource().getMetaData().keySet();
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = ((MetaDataMap.MetaDataKey)object2.next()).name;
            if (!((String)object).contains(" isTorus") && !((String)object).contains(" Period") && !((String)object).contains(" Dimension")) continue;
            vector.add(((String)object).split(" ")[0]);
            bl = true;
        }
        if (!bl) {
            Object object3;
            Iterator iterator;
            object2 = this.getDataSource().getThread(0, 0, 0);
            if (object2 == null) {
                object = this.getDataSource().getThreads();
                iterator = object.iterator();
                if (!iterator.hasNext()) {
                    return vector;
                }
                object3 = (Thread)iterator.next();
                object2 = object3;
                int n = object3.getMetaData().keySet().size();
                while (iterator.hasNext()) {
                    object3 = (Thread)iterator.next();
                    int n2 = object3.getMetaData().keySet().size();
                    if (n2 > n) {
                        object2 = object3;
                        break;
                    }
                    if (n2 >= n) continue;
                    break;
                }
            }
            if (object2 == null) {
                return vector;
            }
            boolean bl2 = false;
            set = object2.getMetaData().keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                object3 = ((MetaDataMap.MetaDataKey)iterator.next()).name;
                if (((String)object3).startsWith("Cray") && ((String)object3).contains("Nodename")) {
                    vector.add(((String)object3).split(" ")[0]);
                    bl = true;
                }
                if (bl2 || !((String)object3).startsWith("CRAY_PMI")) continue;
                vector.add("CRAY_PMI");
                bl = true;
                bl2 = true;
            }
        }
        return vector;
    }
}

