/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.ExternalTool;
import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.common.VectorExport;
import edu.uoregon.tau.paraprof.CallGraphWindow;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.CommunicationMatrixWindow;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ExternalController;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.FunctionSelectorDialog;
import edu.uoregon.tau.paraprof.GlobalDataWindow;
import edu.uoregon.tau.paraprof.GroupChangerWindow;
import edu.uoregon.tau.paraprof.HistogramWindow;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfFileFilter;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.PreCompHistogramWindow;
import edu.uoregon.tau.paraprof.SelectiveFileGenerator;
import edu.uoregon.tau.paraprof.SnapshotBreakdownWindow;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.paraprof.ThreeDeeCommMatrixWindow;
import edu.uoregon.tau.paraprof.ThreeDeeImageProvider;
import edu.uoregon.tau.paraprof.ThreeDeeWindow;
import edu.uoregon.tau.paraprof.UserEventWindow;
import edu.uoregon.tau.paraprof.barchart.BarChart;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.SortListener;
import edu.uoregon.tau.paraprof.interfaces.ToolBarListener;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import edu.uoregon.tau.paraprof.script.ParaProfFunctionScript;
import edu.uoregon.tau.paraprof.script.ParaProfScript;
import edu.uoregon.tau.paraprof.script.ParaProfTrialScript;
import edu.uoregon.tau.paraprof.sourceview.SourceViewer;
import edu.uoregon.tau.paraprof.treetable.ContextEventWindow;
import edu.uoregon.tau.paraprof.treetable.TreeTableWindow;
import edu.uoregon.tau.paraprof.util.MapViewer;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceExport;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.PhaseConvertedDataSource;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.SourceRegion;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.vis.HeatMapWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;

public class ParaProfUtils {
    static boolean verbose;
    static boolean verboseSet;
    private static final String TAU_APPLICATION_NAME = "TAU_APPLICATION_NAME";

    private ParaProfUtils() {
    }

    public static FunctionBarChartWindow createFunctionBarChartWindow(ParaProfTrial paraProfTrial, Function function, Component component) {
        return new FunctionBarChartWindow(paraProfTrial, function, component);
    }

    public static FunctionBarChartWindow createFunctionBarChartWindow(ParaProfTrial paraProfTrial, edu.uoregon.tau.perfdmf.Thread thread, Function function, Component component) {
        return new FunctionBarChartWindow(paraProfTrial, thread, function, component);
    }

    public static LedgerWindow createLedgerWindow(ParaProfTrial paraProfTrial, int n) {
        return new LedgerWindow(paraProfTrial, n, null);
    }

    public static LedgerWindow createLedgerWindow(ParaProfTrial paraProfTrial, int n, Component component) {
        return new LedgerWindow(paraProfTrial, n, component);
    }

    private static void checkVerbose() {
        if (!verboseSet) {
            if (System.getProperty("paraprof.verbose") != null) {
                verbose = true;
            }
            verboseSet = true;
        }
    }

    public static void verr(String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            System.err.println(string);
        }
    }

    public static void vout(String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            System.out.println(string);
        }
    }

    public static void vout(Object object, String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            String string2 = object.getClass().getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.out.println(string2 + ": " + string);
        }
    }

    public static void verr(Object object, String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            String string2 = object.getClass().getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.println(string2 + ": " + string);
        }
    }

    public static void helperAddRadioMenuItem(String string, String string2, boolean bl, ButtonGroup buttonGroup, JMenu jMenu, ActionListener actionListener) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, bl);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand(string2);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
    }

    public static void print(Printable printable) {
        PageFormat pageFormat;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat2 = printerJob.defaultPage();
        if (pageFormat2 != (pageFormat = printerJob.pageDialog(pageFormat2))) {
            printerJob.setPrintable(printable, pageFormat);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    ParaProfUtils.handleException(printerException);
                }
            }
        }
    }

    public static JMenu createHelpMenu(final JFrame jFrame, final ParaProfWindow paraProfWindow) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    if (object instanceof JMenuItem) {
                        String string = actionEvent.getActionCommand();
                        if (string.equals("About ParaProf")) {
                            ImageIcon imageIcon = Utility.getImageIconResource((String)"tau-medium.png");
                            JOptionPane.showMessageDialog(jFrame, ParaProf.getInfoString(), "About ParaProf", 1, imageIcon);
                        } else if (string.equals("Show Help Window")) {
                            paraProfWindow.help(true);
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("Show Help Window");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("About ParaProf");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenu createFileMenu(final ParaProfWindow paraProfWindow, final Printable printable, final Object object) {
        JMenuItem jMenuItem;
        if (printable == null) {
            throw new ParaProfException("File menu created with null panel!");
        }
        ActionListener actionListener = new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Print")) {
                        ParaProfUtils.print(printable);
                        return;
                    } else if (string.equals("Preferences...")) {
                        ParaProf.preferencesWindow.showPreferencesWindow(paraProfWindow instanceof JFrame ? (JFrame)((Object)paraProfWindow) : null);
                        return;
                    } else if (string.equals("Save as Bitmap Image")) {
                        if (object instanceof ImageExport) {
                            ParaProfImageOutput.saveImage((ImageExport)object);
                            return;
                        } else {
                            if (!(object instanceof ThreeDeeImageProvider)) throw new ParaProfException("Don't know how to \"Save Image\" for " + object.getClass());
                            ParaProfImageOutput.save3dImage((ThreeDeeImageProvider)object);
                        }
                        return;
                    } else if (string.equals("Save as Vector Graphics")) {
                        if (object instanceof HeatMapWindow) {
                            JOptionPane.showMessageDialog(paraProfWindow.getFrame(), "Can't save heat map as vector graphics");
                            return;
                        } else if (object instanceof ThreeDeeImageProvider) {
                            JOptionPane.showMessageDialog(paraProfWindow.getFrame(), "Can't save 3D visualization as vector graphics");
                            return;
                        } else if (object instanceof SourceViewer) {
                            JOptionPane.showMessageDialog(paraProfWindow.getFrame(), "Can't save Source Viewer as vector graphics");
                            return;
                        } else {
                            if (!(object instanceof ImageExport)) throw new ParaProfException("Don't know how to \"Save as Vector Graphics\" for " + object.getClass());
                            VectorExport.promptForVectorExport((ImageExport)((ImageExport)object), (String)"ParaProf");
                        }
                        return;
                    } else if (string.equals("Close This Window")) {
                        paraProfWindow.closeThisWindow();
                        return;
                    } else if (string.equals("Exit ParaProf!")) {
                        ParaProf.exitParaProf(0);
                        return;
                    } else if (string.equals("Export Profile")) {
                        GlobalDataWindow globalDataWindow = (GlobalDataWindow)paraProfWindow;
                        ParaProfUtils.exportTrial(globalDataWindow.getPpTrial(), globalDataWindow);
                        return;
                    } else if (string.equals("Convert to Phase Profile")) {
                        GlobalDataWindow globalDataWindow = (GlobalDataWindow)paraProfWindow;
                        ParaProfUtils.phaseConvertTrial(globalDataWindow.getPpTrial(), globalDataWindow);
                        return;
                    } else {
                        if (!string.equals("Create Selective Instrumentation File")) return;
                        GlobalDataWindow globalDataWindow = (GlobalDataWindow)paraProfWindow;
                        SelectiveFileGenerator.showWindow(globalDataWindow.getPpTrial(), globalDataWindow);
                    }
                    return;
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("File");
        if (paraProfWindow instanceof GlobalDataWindow) {
            jMenuItem = new JMenuItem("Export Profile");
            jMenuItem.addActionListener(actionListener);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Convert to Phase Profile");
            jMenuItem.addActionListener(actionListener);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Create Selective Instrumentation File");
            jMenuItem.addActionListener(actionListener);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Add Mean to Comparison Window");
            jMenuItem.addActionListener(actionListener);
            jMenu.add(jMenuItem);
            jMenu.add(new JSeparator());
        }
        jMenuItem = new JMenu("Save ...");
        ((JMenu)jMenuItem).getPopupMenu().setLightWeightPopupEnabled(false);
        JMenuItem jMenuItem2 = new JMenuItem("Save as Bitmap Image");
        jMenuItem2.addActionListener(actionListener);
        ((JMenu)jMenuItem).add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Save as Vector Graphics");
        jMenuItem2.addActionListener(actionListener);
        ((JMenu)jMenuItem).add(jMenuItem2);
        jMenu.add(jMenuItem);
        jMenuItem2 = new JMenuItem("Preferences...");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Print");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Close This Window");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Exit ParaProf!");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    private static JMenuItem createMenuItem(String string, ActionListener actionListener, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setEnabled(bl);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static JMenu createScriptMenu(final ParaProfTrial paraProfTrial, JFrame jFrame) {
        final JMenu jMenu = new JMenu("PyScript");
        jMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                jMenu.removeAll();
                JMenuItem jMenuItem = new JMenuItem("Reload scripts");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ParaProf.loadScripts();
                    }
                });
                jMenu.add(jMenuItem);
                for (int i = 0; i < ParaProf.scripts.size(); ++i) {
                    final ParaProfScript paraProfScript = ParaProf.scripts.get(i);
                    if (!(paraProfScript instanceof ParaProfTrialScript)) continue;
                    JMenuItem jMenuItem2 = new JMenuItem("[Script] " + paraProfScript.getName());
                    jMenuItem2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                ((ParaProfTrialScript)paraProfScript).run(paraProfTrial);
                            }
                            catch (Exception exception) {
                                new ParaProfErrorDialog("Exception while executing script:", exception);
                            }
                        }
                    });
                    jMenu.add(jMenuItem2);
                }
            }
        });
        return jMenu;
    }

    public static void showCommMatrix(ParaProfTrial paraProfTrial, JFrame jFrame) {
        JFrame jFrame2 = CommunicationMatrixWindow.createCommunicationMatrixWindow(paraProfTrial, jFrame);
        if (jFrame2 != null) {
            jFrame2.setVisible(true);
        }
    }

    public static void show3dCommMatrix(ParaProfTrial paraProfTrial, JFrame jFrame) {
        ThreeDeeCommMatrixWindow threeDeeCommMatrixWindow = null;
        try {
            threeDeeCommMatrixWindow = ThreeDeeCommMatrixWindow.createCommunicationMatrixWindow(paraProfTrial, jFrame);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ParaProfUtils.printLibjoglError(jFrame, noClassDefFoundError);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            ParaProfUtils.printLibjoglError(jFrame, unsatisfiedLinkError);
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            JOptionPane.showMessageDialog(jFrame, "Unsupported class version.  Are you sure you're using Java 1.4 or above?");
        }
        catch (Exception exception) {
            new ParaProfErrorDialog("Unable to initialize OpenGL: ", exception);
        }
        if (threeDeeCommMatrixWindow != null) {
            threeDeeCommMatrixWindow.setVisible(true);
        }
    }

    public static void show3dVisualization(ParaProfTrial paraProfTrial, JFrame jFrame) {
        if ("1.4".equals("1.3")) {
            JOptionPane.showMessageDialog(jFrame, "3D Visualization requires Java 1.4 or above\nPlease make sure Java 1.4 is in your path, then reconfigure TAU and re-run ParaProf");
            return;
        }
        ThreeDeeWindow threeDeeWindow = null;
        try {
            threeDeeWindow = ThreeDeeWindow.createThreeDeeWindow(paraProfTrial, jFrame);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ParaProfUtils.printLibjoglError(jFrame, noClassDefFoundError);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            ParaProfUtils.printLibjoglError(jFrame, unsatisfiedLinkError);
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            JOptionPane.showMessageDialog(jFrame, "Unsupported class version.  Are you sure you're using Java 1.4 or above?");
        }
        catch (Exception exception) {
            new ParaProfErrorDialog("Unable to initialize OpenGL: ", exception);
        }
        if (threeDeeWindow != null) {
            threeDeeWindow.setVisible(true);
        }
    }

    private static void printLibjoglError(JFrame jFrame, Error error) {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = "";
        if (string.indexOf("mac") >= 0) {
            string2 = "You are on a 64 bit Mac and thus need to install 32 bit compatable Java 6, available here:\n http://tau.uoregon.edu/java.dmg\n\n";
        }
        String string3 = "Unable to load jogl library.  Possible reasons:\n" + string2 + "libjogl.so is not in your LD_LIBRARY_PATH.\n" + "Jogl is not built for this platform.\nOpenGL is not installed\n\n" + "Jogl is available at jogl.dev.java.net\n\n" + "Message : " + error.getMessage();
        JTextArea jTextArea = new JTextArea(string3);
        JOptionPane.showMessageDialog(jFrame, jTextArea);
    }

    public static JMenu createWindowsMenu(final ParaProfTrial paraProfTrial, final JFrame jFrame) {
        JMenuItem jMenuItem;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("ParaProf Manager")) {
                        ParaProf.paraProfManagerWindow.setVisible(true);
                    } else if (string.equals("Function Legend")) {
                        new LedgerWindow(paraProfTrial, 0, jFrame).setVisible(true);
                    } else if (string.equals("Group Changer")) {
                        GroupChangerWindow groupChangerWindow = GroupChangerWindow.createGroupChangerWindow(paraProfTrial, jFrame);
                        groupChangerWindow.setVisible(true);
                    } else if (string.equals("Group Legend")) {
                        new LedgerWindow(paraProfTrial, 1, jFrame).setVisible(true);
                    } else if (string.equals("User Event Legend")) {
                        new LedgerWindow(paraProfTrial, 2, jFrame).setVisible(true);
                    } else if (string.equals("Phase Legend")) {
                        new LedgerWindow(paraProfTrial, 3, jFrame).setVisible(true);
                    } else if (string.equals("Snapshot Controller")) {
                        paraProfTrial.showSnapshotController();
                    } else if (string.equals("Communication Matrix")) {
                        ParaProfUtils.showCommMatrix(paraProfTrial, jFrame);
                    } else if (string.equals("3D Communication Matrix")) {
                        ParaProfUtils.show3dCommMatrix(paraProfTrial, jFrame);
                    } else if (string.equals("3D Visualization")) {
                        ParaProfUtils.show3dVisualization(paraProfTrial, jFrame);
                    } else if (string.equals("Close All Sub-Windows")) {
                        paraProfTrial.updateRegisteredObjects("subWindowCloseEvent");
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("Windows");
        JMenuItem jMenuItem2 = new JMenuItem("ParaProf Manager");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        jMenu.add(new JSeparator());
        jMenuItem2 = new JMenuItem("3D Visualization");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("3D Communication Matrix");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Communication Matrix");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        if (paraProfTrial.getDataSource().getWellBehavedSnapshots()) {
            jMenuItem2 = new JMenuItem("Snapshot Controller");
            jMenuItem2.addActionListener(actionListener);
            jMenu.add(jMenuItem2);
        }
        jMenu.add(new JSeparator());
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(jFrame, true, paraProfTrial.getDataSource().getFunctionIterator(), null, false, false);
                if (functionSelectorDialog.choose()) {
                    Function function = (Function)functionSelectorDialog.getSelectedObject();
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Bar Chart")) {
                        FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(paraProfTrial, function, jFrame);
                        functionBarChartWindow.setVisible(true);
                    } else if (string.equals("Histogram")) {
                        HistogramWindow histogramWindow = new HistogramWindow(paraProfTrial, function, jFrame);
                        histogramWindow.setVisible(true);
                    }
                }
            }
        };
        JMenu jMenu2 = new JMenu("Function");
        jMenu2.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenu2.add(ParaProfUtils.createMenuItem("Bar Chart", actionListener2, true));
        jMenu2.add(ParaProfUtils.createMenuItem("Histogram", actionListener2, true));
        jMenu.add(jMenu2);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                ArrayList<edu.uoregon.tau.perfdmf.Thread> arrayList = new ArrayList<edu.uoregon.tau.perfdmf.Thread>(paraProfTrial.getDataSource().getAllThreads());
                if (paraProfTrial.getDataSource().getAllThreads().size() > 1 && !string.equals("User Event Statistics")) {
                    arrayList.add(0, paraProfTrial.getDataSource().getStdDevData());
                    arrayList.add(1, paraProfTrial.getDataSource().getMeanData());
                }
                FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(jFrame, true, arrayList.iterator(), null, false, false);
                functionSelectorDialog.setTitle("Select a Thread");
                if (functionSelectorDialog.choose()) {
                    edu.uoregon.tau.perfdmf.Thread thread = (edu.uoregon.tau.perfdmf.Thread)functionSelectorDialog.getSelectedObject();
                    if (string.equals("Bar Chart")) {
                        FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(paraProfTrial, thread, null, jFrame);
                        functionBarChartWindow.setVisible(true);
                    } else if (string.equals("Statistics Text")) {
                        new StatWindow(paraProfTrial, thread, false, null, jFrame).setVisible(true);
                    } else if (string.equals("Statistics Table")) {
                        new TreeTableWindow(paraProfTrial, thread, jFrame).setVisible(true);
                    } else if (string.equals("Call Graph")) {
                        new CallGraphWindow(paraProfTrial, thread, jFrame).setVisible(true);
                    } else if (string.equals("Call Path Relations")) {
                        new CallPathTextWindow(paraProfTrial, thread, jFrame).setVisible(true);
                    } else if (string.equals("Context Event Window")) {
                        new ContextEventWindow(paraProfTrial, thread, jFrame).setVisible(true);
                    } else if (string.equals("User Event Bar Chart")) {
                        new UserEventWindow(paraProfTrial, thread, (Component)jFrame).setVisible(true);
                    } else if (string.equals("User Event Statistics")) {
                        new StatWindow(paraProfTrial, thread, true, null, jFrame).setVisible(true);
                    }
                }
            }
        };
        JMenu jMenu3 = new JMenu("Thread");
        jMenu3.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenu3.add(ParaProfUtils.createMenuItem("Bar Chart", actionListener3, true));
        jMenu3.add(ParaProfUtils.createMenuItem("Statistics Text", actionListener3, true));
        jMenu3.add(ParaProfUtils.createMenuItem("Statistics Table", actionListener3, true));
        jMenu3.add(ParaProfUtils.createMenuItem("Call Graph", actionListener3, paraProfTrial.callPathDataPresent()));
        jMenu3.add(ParaProfUtils.createMenuItem("Call Path Relations", actionListener3, paraProfTrial.callPathDataPresent()));
        jMenu3.add(ParaProfUtils.createMenuItem("Context Event Window", actionListener3, paraProfTrial.userEventsPresent()));
        jMenu3.add(ParaProfUtils.createMenuItem("User Event Bar Chart", actionListener3, paraProfTrial.userEventsPresent()));
        jMenu3.add(ParaProfUtils.createMenuItem("User Event Statistics", actionListener3, paraProfTrial.userEventsPresent()));
        jMenu.add(jMenu3);
        jMenu.add(new JSeparator());
        jMenuItem2 = new JMenuItem("Function Legend");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        final JMenuItem jMenuItem3 = new JMenuItem("Group Legend");
        jMenuItem3.addActionListener(actionListener);
        jMenu.add(jMenuItem3);
        final JMenuItem jMenuItem4 = new JMenuItem("User Event Legend");
        jMenuItem4.addActionListener(actionListener);
        jMenu.add(jMenuItem4);
        if (paraProfTrial.getDataSource().getPhasesPresent()) {
            jMenuItem = new JMenuItem("Phase Legend");
            jMenuItem.addActionListener(actionListener);
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Group Changer");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        jMenuItem2 = new JMenuItem("Close All Sub-Windows");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        MenuListener menuListener = new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                try {
                    jMenuItem3.setEnabled(paraProfTrial.groupNamesPresent());
                    jMenuItem4.setEnabled(paraProfTrial.userEventsPresent());
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }
        };
        jMenu.addMenuListener(menuListener);
        return jMenu;
    }

    public static void scaleForPrint(Graphics graphics, PageFormat pageFormat, int n, int n2) {
        double d = pageFormat.getImageableWidth();
        double d2 = pageFormat.getImageableHeight();
        double d3 = d / (double)n;
        double d4 = d2 / (double)n2;
        double d5 = Math.min(d3, d4);
        double d6 = 0.0;
        double d7 = 0.0;
        if (d3 > d5) {
            d6 = 0.5 * (d3 - d5) * (double)n;
        } else {
            d7 = 0.5 * (d4 - d5) * (double)n2;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.translate(d6, d7);
        graphics2D.scale(d5, d5);
    }

    private static SourceRegion getBacktraceSourceLink(String string) {
        SourceRegion sourceRegion = new SourceRegion();
        int n = string.indexOf(91, 1);
        if (n == -1) {
            return null;
        }
        if (n == 1) {
            n = string.indexOf(91, n + 1);
        }
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(93, n + 1);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(n + 1, n2);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length != 2) {
            return null;
        }
        if (stringArray[0].equals("(unknown)")) {
            return null;
        }
        sourceRegion.setFilename(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        sourceRegion.setStartLine(n3);
        sourceRegion.setEndLine(n3);
        return sourceRegion;
    }

    public static JPopupMenu createMetadataClickPopUp(String string, Component component) {
        final SourceRegion sourceRegion = ParaProfUtils.getBacktraceSourceLink(string);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Show Source Code")) {
                        if (ParaProf.controlMode) {
                            ExternalController.outputCommand("sourcecode " + sourceRegion);
                        } else {
                            ParaProf.getDirectoryManager().showSourceCode(sourceRegion);
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (sourceRegion == null) {
            return null;
        }
        JMenuItem jMenuItem = new JMenuItem("Show Source Code");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public static JMenuItem createContextSourcePopUp(String string) {
        final SourceRegion sourceRegion = Function.getSourceLink((String)string);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Show Source Code")) {
                        if (ParaProf.controlMode) {
                            ExternalController.outputCommand("sourcecode " + sourceRegion);
                        } else {
                            ParaProf.getDirectoryManager().showSourceCode(sourceRegion);
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenuItem jMenuItem = null;
        if (sourceRegion != null && sourceRegion.getFilename() != null) {
            jMenuItem = new JMenuItem("Show Source Code");
            jMenuItem.addActionListener(actionListener);
        }
        return jMenuItem;
    }

    public static JPopupMenu createFunctionClickPopUp(final ParaProfTrial paraProfTrial, final Function function, final edu.uoregon.tau.perfdmf.Thread thread, final Component component) {
        ParaProfScript paraProfScript;
        int n;
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Show Function Bar Chart")) {
                        FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(paraProfTrial, function, component);
                        functionBarChartWindow.setVisible(true);
                    } else if (string.equals("Show Function Data over Phases")) {
                        FunctionBarChartWindow functionBarChartWindow = FunctionBarChartWindow.CreateFunctionsOverPhaseDisplay(paraProfTrial, function, thread, component);
                        functionBarChartWindow.setVisible(true);
                    } else if (string.equals("Show Function Histogram")) {
                        String string2 = paraProfTrial.getDataSource().getMetaData().get("TAU Internal Profile Attribute");
                        if (string2 != null && string2.equals("collate_dump_dagstuhl")) {
                            PreCompHistogramWindow preCompHistogramWindow = PreCompHistogramWindow.createHistogramWindow(paraProfTrial, function, thread, component);
                            preCompHistogramWindow.setVisible(true);
                        } else {
                            HistogramWindow histogramWindow = new HistogramWindow(paraProfTrial, function, component);
                            histogramWindow.setVisible(true);
                        }
                    } else if (string.equals("Assign Function Color")) {
                        ParaProf.colorMap.assignColor(component, function);
                    } else if (string.equals("Rename")) {
                        String string3 = (String)JOptionPane.showInputDialog(component, "Rename event:", "Rename event", -1, null, null, function.toString());
                        if (string3 != null) {
                            paraProfTrial.getDataSource().renameFunction(function, string3);
                            paraProfTrial.updateRegisteredObjects("dataEvent");
                        }
                    } else if (string.equals("Reset to Default Color")) {
                        ParaProf.colorMap.removeColor(function);
                        ParaProf.colorMap.reassignColors();
                    } else if (string.equals("Open Profile for this Phase")) {
                        GlobalDataWindow globalDataWindow = new GlobalDataWindow(paraProfTrial, function.getActualPhase());
                        globalDataWindow.setVisible(true);
                        ParaProf.incrementNumWindows();
                    } else if (string.equals("Show Source Code")) {
                        if (ParaProf.controlMode) {
                            ExternalController.outputCommand("sourcecode " + function.getSourceLink());
                        } else if (ParaProf.insideEclipse) {
                            ParaProf.eclipseHandler.openSourceLocation(paraProfTrial, function);
                        } else {
                            ParaProf.getDirectoryManager().showSourceCode(function.getSourceLink());
                        }
                    } else if (string.equals("Launch External Tool for this Function & Metric")) {
                        Object object;
                        String string4 = "TIME";
                        if (component instanceof BarChart) {
                            object = (BarChart)component;
                            string4 = ((BarChart)object).getBarChartModel().getDataSorter().getSelectedMetric().getName();
                        }
                        object = ExternalTool.findMatchingTools((String)paraProfTrial.getTrial().getMetaData().get("File Type Name"), (String)paraProfTrial.getTrial().getName());
                        ExternalTool.CommandParameters commandParameters = new ExternalTool.CommandParameters();
                        commandParameters.function = function.getName();
                        commandParameters.metric = string4;
                        commandParameters.nodeID = thread.getNodeID();
                        commandParameters.threadID = thread.getThreadID();
                        MetaDataMap metaDataMap = new MetaDataMap();
                        metaDataMap.putAll(thread.getMetaData());
                        metaDataMap.putAll(paraProfTrial.getDataSource().getMetaData());
                        commandParameters.metadata = metaDataMap;
                        ExternalTool.launch((List)object, (ExternalTool.CommandParameters)commandParameters, (Component)component);
                    } else if (string.equals("Show In Statistics Table")) {
                        TreeTableWindow treeTableWindow = new TreeTableWindow(paraProfTrial, thread, component);
                        treeTableWindow.select(function);
                        treeTableWindow.setVisible(true);
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (function.getSourceLink().getFilename() != null) {
            jMenuItem2 = new JMenuItem("Show Source Code");
            jMenuItem2.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem2);
        }
        if (function.isPhase()) {
            jMenuItem2 = new JMenuItem("Open Profile for this Phase");
            jMenuItem2.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem2);
        }
        jMenuItem2 = new JMenuItem("Show In Statistics Table");
        jMenuItem2.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Show Function Histogram");
        jMenuItem3.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Show Function Bar Chart");
        jMenuItem4.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem4);
        if (paraProfTrial.getDataSource().getPhasesPresent()) {
            jMenuItem = new JMenuItem("Show Function Data over Phases");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Assign Function Color");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reset to Default Color");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        if (!function.isGroupMember("TAU_CALLPATH")) {
            jMenuItem = new JMenuItem("Rename");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
        }
        if (thread.getNodeID() >= 0 && ExternalTool.matchingToolExists((String)paraProfTrial.getTrial().getMetaData().get("File Type Name"), (String)paraProfTrial.getTrial().getName())) {
            JMenuItem jMenuItem5 = new JMenuItem("Launch External Tool for this Function & Metric");
            jMenuItem5.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem5);
        }
        int n2 = 0;
        for (n = 0; n < ParaProf.scripts.size(); ++n) {
            paraProfScript = ParaProf.scripts.get(n);
            if (!(paraProfScript instanceof ParaProfFunctionScript)) continue;
            ++n2;
        }
        if (n2 > 1) {
            jPopupMenu.add(new JSeparator());
        }
        for (n = 0; n < ParaProf.scripts.size(); ++n) {
            paraProfScript = ParaProf.scripts.get(n);
            if (!(paraProfScript instanceof ParaProfFunctionScript)) continue;
            JMenuItem jMenuItem6 = new JMenuItem("[Script] " + paraProfScript.getName());
            jMenuItem6.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ((ParaProfFunctionScript)paraProfScript).runFunction(paraProfTrial, function);
                    }
                    catch (Exception exception) {
                        new ParaProfErrorDialog("Exception while executing script: ", exception);
                    }
                }
            });
            jPopupMenu.add(jMenuItem6);
        }
        return jPopupMenu;
    }

    public static JMenuItem createStatisticsMenuItem(String string, final ParaProfTrial paraProfTrial, final Function function, final edu.uoregon.tau.perfdmf.Thread thread, final boolean bl, final Component component) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatWindow statWindow = new StatWindow(paraProfTrial, thread, bl, function, component);
                statWindow.setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createStatisticsTableMenuItem(String string, final ParaProfTrial paraProfTrial, Function function, final edu.uoregon.tau.perfdmf.Thread thread, final Component component) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeTableWindow treeTableWindow = new TreeTableWindow(paraProfTrial, thread, component);
                treeTableWindow.setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createCallGraphMenuItem(String string, final ParaProfTrial paraProfTrial, final edu.uoregon.tau.perfdmf.Thread thread, final Component component) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow callGraphWindow = new CallGraphWindow(paraProfTrial, thread, component);
                callGraphWindow.setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createCallPathThreadRelationMenuItem(String string, final ParaProfTrial paraProfTrial, final edu.uoregon.tau.perfdmf.Thread thread, final Component component) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallPathTextWindow callPathTextWindow = new CallPathTextWindow(paraProfTrial, thread, component);
                callPathTextWindow.setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createThreadDataMenuItem(String string, final ParaProfTrial paraProfTrial, final Function function, final edu.uoregon.tau.perfdmf.Thread thread, final Component component) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(paraProfTrial, thread, function, component);
                functionBarChartWindow.setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createComparisonMenuItem(String string, final ParaProfTrial paraProfTrial, final edu.uoregon.tau.perfdmf.Thread thread, final Component component) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ParaProf.theComparisonWindow == null) {
                    ParaProf.theComparisonWindow = FunctionBarChartWindow.CreateComparisonWindow(paraProfTrial, thread, component);
                } else {
                    ParaProf.theComparisonWindow.addThread(paraProfTrial, thread);
                }
                ParaProf.theComparisonWindow.setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createSnapShotMenuItem(String string, final ParaProfTrial paraProfTrial, final edu.uoregon.tau.perfdmf.Thread thread, final Component component) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotBreakdownWindow snapshotBreakdownWindow = new SnapshotBreakdownWindow(paraProfTrial, thread, component);
                snapshotBreakdownWindow.setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createThreadMetaDataMenuItem(String string, final ParaProfTrial paraProfTrial, final edu.uoregon.tau.perfdmf.Thread thread, Component component) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaDataMap metaDataMap = new MetaDataMap();
                metaDataMap.putAll(thread.getMetaData());
                metaDataMap.putAll(paraProfTrial.getDataSource().getMetaData());
                MapViewer mapViewer = new MapViewer("Metadata for " + thread, metaDataMap, ParaProf.preferences.getFont());
                mapViewer.setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createUserEventBarChartMenuItem(String string, final ParaProfTrial paraProfTrial, final edu.uoregon.tau.perfdmf.Thread thread, final Component component) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserEventWindow userEventWindow = new UserEventWindow(paraProfTrial, thread, component);
                userEventWindow.setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createContextEventMenuItem(String string, final ParaProfTrial paraProfTrial, final edu.uoregon.tau.perfdmf.Thread thread, final Component component) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            component.setCursor(Cursor.getPredefinedCursor(3));
                            ContextEventWindow contextEventWindow = new ContextEventWindow(paraProfTrial, thread, component);
                            contextEventWindow.setVisible(true);
                        }
                        finally {
                            component.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                };
                new Thread(runnable).start();
            }
        });
        return jMenuItem;
    }

    public static void handleUserEventClick(ParaProfTrial paraProfTrial, UserEvent userEvent, JComponent jComponent, MouseEvent mouseEvent) {
        ParaProfUtils.handleUserEventClick(paraProfTrial, userEvent, null, jComponent, mouseEvent);
    }

    public static void handleUserEventClick(final ParaProfTrial paraProfTrial, final UserEvent userEvent, final edu.uoregon.tau.perfdmf.Thread thread, final JComponent jComponent, MouseEvent mouseEvent) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JMenuItem) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Show User Event Bar Chart")) {
                        UserEventWindow userEventWindow = new UserEventWindow(paraProfTrial, userEvent, (Component)jComponent);
                        userEventWindow.setVisible(true);
                    } else if (string.equals("Change User Event Color")) {
                        Color color = userEvent.getColor();
                        if ((color = JColorChooser.showDialog(jComponent, "Please select a new color", color)) != null) {
                            userEvent.setSpecificColor(color);
                            userEvent.setColorFlag(true);
                            paraProfTrial.updateRegisteredObjects("colorEvent");
                        }
                    } else if (string.equals("Reset to Generic Color")) {
                        userEvent.setColorFlag(false);
                        paraProfTrial.updateRegisteredObjects("colorEvent");
                    } else if (string.equals("Show/Hide Total")) {
                        userEvent.setShowTotal(!userEvent.isShowTotal());
                        paraProfTrial.updateRegisteredObjects("colorEvent");
                    } else if (string.equals("Show In Context Event Window") && thread != null) {
                        ContextEventWindow contextEventWindow = new ContextEventWindow(paraProfTrial, thread, jComponent);
                        UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent);
                        contextEventWindow.selectEvent(userEventProfile);
                        contextEventWindow.setVisible(true);
                    }
                }
            }
        };
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Show In Context Event Window");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show User Event Bar Chart");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Change User Event Color");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reset to Generic Color");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show/Hide Total");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = ParaProfUtils.createContextSourcePopUp(userEvent.getName());
        if (jMenuItem != null) {
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
    }

    public static void handleThreadClick(ParaProfTrial paraProfTrial, Function function, edu.uoregon.tau.perfdmf.Thread thread, JComponent jComponent, MouseEvent mouseEvent) {
        String string = thread.getNodeID() == -1 || thread.getNodeID() == -6 ? "Mean" : (thread.getNodeID() == -2 ? "Total" : (thread.getNodeID() == -3 || thread.getNodeID() == -7 ? "Standard Deviation" : "Thread"));
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(ParaProfUtils.createThreadDataMenuItem("Show " + string + " Bar Chart", paraProfTrial, function, thread, jComponent));
        jPopupMenu.add(ParaProfUtils.createStatisticsMenuItem("Show " + string + " Statistics Text Window", paraProfTrial, function, thread, false, jComponent));
        jPopupMenu.add(ParaProfUtils.createStatisticsTableMenuItem("Show " + string + " Statistics Table", paraProfTrial, function, thread, jComponent));
        jPopupMenu.add(ParaProfUtils.createCallGraphMenuItem("Show " + string + " Call Graph", paraProfTrial, thread, jComponent));
        jPopupMenu.add(ParaProfUtils.createCallPathThreadRelationMenuItem("Show " + string + " Call Path Relations", paraProfTrial, thread, jComponent));
        if (paraProfTrial.userEventsPresent()) {
            jPopupMenu.add(ParaProfUtils.createUserEventBarChartMenuItem("Show User Event Bar Chart", paraProfTrial, thread, jComponent));
            jPopupMenu.add(ParaProfUtils.createStatisticsMenuItem("Show User Event Statistics Window", paraProfTrial, null, thread, true, jComponent));
            jPopupMenu.add(ParaProfUtils.createContextEventMenuItem("Show Context Event Window", paraProfTrial, thread, jComponent));
        }
        if (thread.getNumSnapshots() > 1) {
            jPopupMenu.add(ParaProfUtils.createSnapShotMenuItem("Show Snapshots for " + string, paraProfTrial, thread, jComponent));
        }
        if (thread.getMetaData() != null) {
            jPopupMenu.add(ParaProfUtils.createThreadMetaDataMenuItem("Show Metadata for " + string, paraProfTrial, thread, jComponent));
        }
        jPopupMenu.add(ParaProfUtils.createComparisonMenuItem("Add " + string + " to Comparison Window", paraProfTrial, thread, jComponent));
        jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
    }

    public static void handleSnapshotClick(ParaProfTrial paraProfTrial, edu.uoregon.tau.perfdmf.Thread thread, Snapshot snapshot, JComponent jComponent, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Hide this snapshot (" + snapshot + ")");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show all snapshots");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
    }

    public static int[] computeClipping(Rectangle rectangle, Rectangle rectangle2, boolean bl, boolean bl2, int n, int n2, int n3) {
        int n4;
        int n5;
        if (!bl2) {
            int n6 = 0;
            int n7 = 0;
            if (bl) {
                n6 = (int)rectangle.getY();
                n7 = (int)((double)n6 + rectangle.getHeight());
            } else {
                n6 = (int)rectangle2.getY();
                n7 = (int)((double)n6 + rectangle2.getHeight());
            }
            n5 = (n6 - n3) / n2 - 1;
            n4 = (n7 - n3) / n2 + 1;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n5 > n - 1) {
                n5 = n - 1;
            }
            if (n4 > n - 1) {
                n4 = n - 1;
            }
            if (bl) {
                n3 += n5 * n2;
            }
        } else {
            n5 = 0;
            n4 = n - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        int[] nArray = new int[]{n5, n4, n3};
        return nArray;
    }

    public static JMenu createUnitsMenu(final UnitListener unitListener, int n, boolean bl) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Microseconds")) {
                        unitListener.setUnits(0);
                    } else if (string.equals("Milliseconds")) {
                        unitListener.setUnits(1);
                    } else if (string.equals("Seconds")) {
                        unitListener.setUnits(2);
                    } else if (string.equals("hr:min:sec")) {
                        unitListener.setUnits(3);
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("Select Units...");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Microseconds", n == 0);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Milliseconds", n == 1);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Seconds", n == 2);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("hr:min:sec", n == 3);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        return jMenu;
    }

    public static void phaseConvertTrial(ParaProfTrial paraProfTrial, JFrame jFrame) {
        if (!paraProfTrial.getDataSource().getCallPathDataPresent()) {
            JOptionPane.showMessageDialog(jFrame, "Can't phase convert non-callpath profiles");
            return;
        }
        FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(jFrame, true, paraProfTrial.getDataSource().getFunctionIterator(), null, false, true);
        functionSelectorDialog.setTitle("Choose Phases");
        if (functionSelectorDialog.choose()) {
            Object object2;
            List<Object> list = functionSelectorDialog.getSelectedObjects();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object2 : list) {
                arrayList.add(object2.getName());
            }
            PhaseConvertedDataSource phaseConvertedDataSource = new PhaseConvertedDataSource(paraProfTrial.getDataSource(), arrayList);
            object2 = ParaProf.applicationManager.addApplication();
            object2.setName("New Application");
            ParaProfExperiment paraProfExperiment = ((ParaProfApplication)object2).addExperiment();
            paraProfExperiment.setName("New Experiment");
            ParaProf.paraProfManagerWindow.expandApplicationType(0, object2.getID(), (ParaProfApplication)object2);
            ParaProf.paraProfManagerWindow.expandApplication(0, (ParaProfApplication)object2, paraProfExperiment);
            final ParaProfTrial paraProfTrial2 = new ParaProfTrial();
            paraProfTrial2.getTrial().setDataSource((DataSource)phaseConvertedDataSource);
            paraProfTrial2.setExperiment(paraProfExperiment);
            paraProfTrial2.setApplicationID(paraProfExperiment.getApplicationID());
            paraProfTrial2.setExperimentID(paraProfExperiment.getID());
            paraProfTrial2.getTrial().setName("Phase Converted from " + paraProfTrial.getName());
            paraProfExperiment.addTrial(paraProfTrial2);
            paraProfTrial2.finishLoad();
            ParaProf.paraProfManagerWindow.populateTrialMetrics(paraProfTrial2);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    paraProfTrial2.showMainWindow();
                }
            });
        }
    }

    public static void exportTrial(ParaProfTrial paraProfTrial, Component component) {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Export Trial");
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        for (n = 0; n < fileFilterArray.length; ++n) {
            jFileChooser.removeChoosableFileFilter(fileFilterArray[n]);
        }
        jFileChooser.addChoosableFileFilter(new ParaProfFileFilter(ParaProfFileFilter.TXT));
        jFileChooser.addChoosableFileFilter(new ParaProfFileFilter(ParaProfFileFilter.PPK));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        n = jFileChooser.showSaveDialog(component);
        if (n != 0) {
            return;
        }
        try {
            int n2;
            File file = jFileChooser.getSelectedFile();
            String string = file.getCanonicalPath();
            String string2 = ParaProfFileFilter.getExtension(file);
            if (string2 == null) {
                FileFilter fileFilter = jFileChooser.getFileFilter();
                if (fileFilter instanceof ParaProfFileFilter) {
                    ParaProfFileFilter paraProfFileFilter = (ParaProfFileFilter)fileFilter;
                    string = string + "." + paraProfFileFilter.getExtension();
                }
                file = new File(string);
            }
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(component, file + " already exists\nOverwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                return;
            }
            string2 = ParaProfFileFilter.getExtension(file).toLowerCase();
            if (string2.compareTo("txt") == 0) {
                DataSourceExport.writeDelimited((DataSource)paraProfTrial.getDataSource(), (File)file);
            } else {
                DataSourceExport.writePacked((DataSource)paraProfTrial.getDataSource(), (File)file);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public static boolean rightClick(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) != 0;
    }

    private static String removeSource(String string) {
        if (!ParaProf.preferences.getShowSourceLocation()) {
            if (string.startsWith("Loop:")) {
                return string;
            }
            while (string.indexOf("[{") != -1) {
                int n = string.indexOf("[{");
                int n2 = string.indexOf("}]");
                string = string.substring(0, n) + string.substring(n2 + 2);
            }
        }
        return string;
    }

    public static String removeSourceLocation(String string) {
        if (string.startsWith("Loop:")) {
            return string;
        }
        while (string.indexOf("[{") != -1) {
            int n = string.indexOf("[{");
            int n2 = string.indexOf("}]");
            string = string.substring(0, n) + string.substring(n2 + 2);
        }
        return string;
    }

    public static String removeThrottledTag(String string) {
        int n = string.indexOf("  [THROTTLED]");
        if (n >= 0) {
            string = string.substring(0, n);
        } else {
            n = string.indexOf(" [THROTTLED]");
            if (n >= 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public static String getDisplayName(Function function) {
        if (ParaProf.preferences.getReversedCallPaths()) {
            return ParaProfUtils.removeSource(function.getReversedName());
        }
        return ParaProfUtils.removeSource(function.getName());
    }

    public static String getUserEventDisplayName(UserEvent userEvent) {
        return ParaProfUtils.removeSource(userEvent.getName());
    }

    public static String getLeafDisplayName(Function function) {
        String string = function.getName();
        int n = string.lastIndexOf("=>");
        if (n != -1) {
            string = string.substring(n + 2).trim();
        }
        return ParaProfUtils.removeSource(string);
    }

    public static String getReversedLeafDisplayName(Function function) {
        String string = function.getReversedName();
        int n = string.lastIndexOf("<=");
        if (n != -1) {
            string = string.substring(n + 2).trim();
        }
        return ParaProfUtils.removeSource(string);
    }

    public static String getThreadLabel(edu.uoregon.tau.perfdmf.Thread thread) {
        MetaDataMap metaDataMap = thread.getMetaData();
        String string = "";
        if (ParaProf.preferences.getAppNameLabels() == 1 && metaDataMap.containsKey(TAU_APPLICATION_NAME)) {
            string = metaDataMap.get(TAU_APPLICATION_NAME) + ": ";
        }
        if (thread.getNodeID() == -1 || thread.getNodeID() == -6) {
            return "Mean";
        }
        if (thread.getNodeID() == -2) {
            return "Total";
        }
        if (thread.getNodeID() == -3 || thread.getNodeID() == -7) {
            return "Std. Dev.";
        }
        if (thread.getNodeID() == -4) {
            return "Min";
        }
        if (thread.getNodeID() == -5) {
            return "Max";
        }
        if (ParaProf.preferences.getAutoLabels()) {
            DataSource dataSource = thread.getDataSource();
            if (!dataSource.getHasContexts() && !dataSource.getHasThreads()) {
                return string + "node " + thread.getNodeID();
            }
            if (!dataSource.getHasContexts()) {
                return string + "node " + thread.getNodeID() + ", thread " + thread.getThreadID();
            }
        }
        return string + "n,c,t " + thread.getNodeID() + "," + thread.getContextID() + "," + thread.getThreadID();
    }

    public static void logException(Exception exception) {
        try {
            String string = ParaProf.paraProfHomeDirectory + "/ParaProf.errors";
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("ParaProf Build (" + ParaProf.getVersionString() + ") encountered the following error on (" + new Date() + ") : ");
            exception.printStackTrace(printStream);
            printStream.println("");
            printStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public static void handleException(Exception exception) {
        ParaProfUtils.logException(exception);
        new ParaProfErrorDialog(null, exception);
    }

    public static Dimension checkSize(Dimension dimension) {
        if (!ParaProf.demoMode) {
            return dimension;
        }
        int n = dimension.width;
        int n2 = dimension.height;
        n = Math.min(n, 640);
        n2 = Math.min(n2, 480);
        return new Dimension(n, n2);
    }

    public static NumberFormat createNumberFormatter(final int n, final boolean bl) {
        return new NumberFormat(){
            private static final long serialVersionUID = 3533959839796773891L;

            public Number parse(String string, ParsePosition parsePosition) {
                return null;
            }

            public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                return stringBuffer.append(UtilFncs.getOutputString((int)n, (double)d, (int)5, (boolean)bl));
            }

            public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                return stringBuffer.append(UtilFncs.getOutputString((int)n, (double)l, (int)5, (boolean)bl));
            }
        };
    }

    public static void setFrameIcon(Frame frame) {
        URL uRL = Utility.getResource((String)"tau16x16.gif");
        if (uRL != null) {
            frame.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
    }

    public static void createMetricToolbarItems(JToolBar jToolBar, ParaProfTrial paraProfTrial, final DataSorter dataSorter, final ToolBarListener toolBarListener) {
        final JComboBox<Metric> jComboBox = new JComboBox<Metric>(paraProfTrial.getMetricArray());
        final JComboBox<ValueType> jComboBox2 = new JComboBox<ValueType>(ValueType.VALUES);
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        jComboBox2.setMaximumSize(jComboBox2.getPreferredSize());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataSorter.setSelectedMetric((Metric)jComboBox.getSelectedItem());
                dataSorter.setValueType((ValueType)jComboBox2.getSelectedItem());
                toolBarListener.toolBarUsed();
            }
        };
        jComboBox.addActionListener(actionListener);
        jComboBox2.addActionListener(actionListener);
        jToolBar.add(jComboBox);
        jToolBar.add(jComboBox2);
    }

    private static Component createMetricMenu(ParaProfTrial paraProfTrial, final ValueType valueType, boolean bl, ButtonGroup buttonGroup, final boolean bl2, final DataSorter dataSorter, final SortListener sortListener, final ActionListener actionListener) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (paraProfTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(valueType.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (bl2) {
                        dataSorter.setSortByVisible(false);
                        dataSorter.setSortType(SortType.VALUE);
                        dataSorter.setSortValueType(valueType);
                    } else {
                        dataSorter.setValueType(valueType);
                    }
                    if (sortListener != null) {
                        sortListener.resort();
                    } else {
                        actionListener.actionPerformed(null);
                    }
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(valueType.toString() + "...");
        jMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        for (Metric metric : paraProfTrial.getMetrics()) {
            if (metric == null) continue;
            int n = metric.getID();
            jRadioButtonMenuItem = n == dataSorter.getSelectedMetric().getID() && bl ? new JRadioButtonMenuItem(metric.getName(), true) : new JRadioButtonMenuItem(metric.getName());
            final Metric metric2 = metric;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (bl2) {
                        dataSorter.setSortByVisible(false);
                        dataSorter.setSortType(SortType.VALUE);
                        dataSorter.setSortMetric(metric2);
                        dataSorter.setSortValueType(valueType);
                    } else {
                        dataSorter.setSelectedMetric(metric2);
                        dataSorter.setValueType(valueType);
                    }
                    if (sortListener != null) {
                        sortListener.resort();
                    } else {
                        actionListener.actionPerformed(null);
                    }
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    public static JMenu createMetricSelectionMenu(ParaProfTrial paraProfTrial, String string, boolean bl, boolean bl2, DataSorter dataSorter, SortListener sortListener, boolean bl3) {
        ActionListener actionListener = null;
        actionListener = bl ? new SortAction(dataSorter, sortListener) : new MetricAction(dataSorter, sortListener);
        return ParaProfUtils.createMetricSelectionMenu(paraProfTrial, string, bl, bl2, dataSorter, sortListener, actionListener, bl3);
    }

    public static JMenu createMetricSelectionMenu(ParaProfTrial paraProfTrial, String string, boolean bl, boolean bl2, DataSorter dataSorter, SortListener sortListener, ActionListener actionListener, boolean bl3) {
        JRadioButtonMenuItem jRadioButtonMenuItem;
        JMenu jMenu = new JMenu(string);
        ButtonGroup buttonGroup = new ButtonGroup();
        if (bl) {
            if (bl3) {
                jRadioButtonMenuItem = new JRadioButtonMenuItem("Same as Visible Metric", dataSorter.getSortByVisible());
                jRadioButtonMenuItem.addActionListener(actionListener);
                buttonGroup.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem);
            }
            if (bl2) {
                jRadioButtonMenuItem = new JRadioButtonMenuItem("Sort By N,C,T", dataSorter.getSortType() == SortType.NCT);
                jRadioButtonMenuItem.addActionListener(actionListener);
                buttonGroup.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem);
            } else {
                jRadioButtonMenuItem = new JRadioButtonMenuItem("Name", dataSorter.getSortType() == SortType.NAME);
                jRadioButtonMenuItem.addActionListener(actionListener);
                buttonGroup.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem);
            }
        }
        jMenu.add(ParaProfUtils.createMetricMenu(paraProfTrial, ValueType.EXCLUSIVE, dataSorter.getValueType() == ValueType.EXCLUSIVE || dataSorter.getValueType() == ValueType.EXCLUSIVE_PERCENT, buttonGroup, bl, dataSorter, sortListener, actionListener));
        jMenu.add(ParaProfUtils.createMetricMenu(paraProfTrial, ValueType.INCLUSIVE, dataSorter.getValueType() == ValueType.INCLUSIVE || dataSorter.getValueType() == ValueType.INCLUSIVE_PERCENT, buttonGroup, bl, dataSorter, sortListener, actionListener));
        jMenu.add(ParaProfUtils.createMetricMenu(paraProfTrial, ValueType.EXCLUSIVE_PER_CALL, dataSorter.getValueType() == ValueType.EXCLUSIVE_PER_CALL, buttonGroup, bl, dataSorter, sortListener, actionListener));
        jMenu.add(ParaProfUtils.createMetricMenu(paraProfTrial, ValueType.INCLUSIVE_PER_CALL, dataSorter.getValueType() == ValueType.INCLUSIVE_PER_CALL, buttonGroup, bl, dataSorter, sortListener, actionListener));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", dataSorter.getValueType() == ValueType.NUMCALLS);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", dataSorter.getValueType() == ValueType.NUMSUBR);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        return jMenu;
    }

    class HistogramAction
    implements ActionListener {
        HistogramAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    static class MetricAction
    implements ActionListener {
        DataSorter dataSorter;
        SortListener sortListener;

        MetricAction(DataSorter dataSorter, SortListener sortListener) {
            this.dataSorter = dataSorter;
            this.sortListener = sortListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Number of Calls")) {
                this.dataSorter.setValueType(ValueType.NUMCALLS);
            } else if (string.equals("Number of Child Calls")) {
                this.dataSorter.setValueType(ValueType.NUMSUBR);
            }
            this.sortListener.resort();
        }
    }

    static class SortAction
    implements ActionListener {
        DataSorter dataSorter;
        SortListener sortListener;

        SortAction(DataSorter dataSorter, SortListener sortListener) {
            this.dataSorter = dataSorter;
            this.sortListener = sortListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Same as Visible Metric")) {
                this.dataSorter.setSortType(SortType.VALUE);
                this.dataSorter.setSortByVisible(true);
            } else if (string.equals("Sort By N,C,T")) {
                this.dataSorter.setSortType(SortType.NCT);
            } else if (string.equals("Name")) {
                this.dataSorter.setSortType(SortType.NAME);
            } else if (string.equals("Number of Calls")) {
                this.dataSorter.setSortByVisible(false);
                this.dataSorter.setSortType(SortType.VALUE);
                this.dataSorter.setSortValueType(ValueType.NUMCALLS);
            } else if (string.equals("Number of Child Calls")) {
                this.dataSorter.setSortByVisible(false);
                this.dataSorter.setSortType(SortType.VALUE);
                this.dataSorter.setSortValueType(ValueType.NUMSUBR);
            }
            this.sortListener.resort();
        }
    }
}

