/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.paraprof.barchart.BarChartPanel;
import edu.uoregon.tau.paraprof.barchart.ThreadSnapshotBarChartModel;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.Thread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SnapshotThreadWindow
extends JFrame
implements ActionListener,
Observer,
ChangeListener,
ParaProfWindow {
    private static final long serialVersionUID = -4212196607612676127L;
    private ParaProfTrial ppTrial;
    private BarChartPanel panel;
    private AbstractBarChartModel model;
    private DataSorter dataSorter;
    private static int defaultWidth = 750;
    private static int defaultHeight = 410;
    private JMenu optionsMenu;
    private JCheckBoxMenuItem nameCheckBox = new JCheckBoxMenuItem("Sort By Name", false);
    private JCheckBoxMenuItem normalizeCheckBox = new JCheckBoxMenuItem("Normalize Bars", true);
    private JCheckBoxMenuItem orderByMeanCheckBox = new JCheckBoxMenuItem("Order By Mean", true);
    private JCheckBoxMenuItem orderCheckBox = new JCheckBoxMenuItem("Descending Order", true);
    private JCheckBoxMenuItem stackBarsCheckBox = new JCheckBoxMenuItem("Stack Bars Together", true);
    private JCheckBoxMenuItem metaDataCheckBox;

    public SnapshotThreadWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        PPThread pPThread = new PPThread(thread, paraProfTrial);
        this.setTitle("TAU: ParaProf: Snapshots for " + pPThread.getFullName() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.dataSorter = new DataSorter(paraProfTrial);
        this.model = new ThreadSnapshotBarChartModel(this, this.dataSorter, paraProfTrial, thread);
        this.panel = new BarChartPanel(this.model);
        this.panel.getBarChart().setLeftJustified(true);
        this.panel.getBarChart().setAutoResize(true);
        this.panel.getVerticalScrollBar().setUnitIncrement(35);
        this.setSize(ParaProfUtils.checkSize(new Dimension(defaultWidth, defaultHeight)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.getContentPane().add(this.panel);
        this.setupMenus();
        ParaProfUtils.setFrameIcon(this);
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this.optionsMenu = new JMenu("Options");
        this.metaDataCheckBox = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.metaDataCheckBox.addActionListener(this);
        this.optionsMenu.add(this.metaDataCheckBox);
        this.optionsMenu.add(new JSeparator());
        this.nameCheckBox.addActionListener(this);
        this.optionsMenu.add(this.nameCheckBox);
        this.normalizeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotThreadWindow.this.setNormalized(SnapshotThreadWindow.this.normalizeCheckBox.isSelected());
            }
        });
        this.optionsMenu.add(this.normalizeCheckBox);
        this.orderByMeanCheckBox.addActionListener(this);
        this.optionsMenu.add(this.orderByMeanCheckBox);
        this.orderCheckBox.addActionListener(this);
        this.optionsMenu.add(this.orderCheckBox);
        this.stackBarsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotThreadWindow.this.setStackBars(SnapshotThreadWindow.this.stackBarsCheckBox.isSelected());
            }
        });
        this.optionsMenu.add(this.stackBarsCheckBox);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        if (ParaProf.scripts.size() > 0) {
            jMenuBar.add(ParaProfUtils.createScriptMenu(this.ppTrial, this));
        }
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void update(Observable observable, Object object) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void closeThisWindow() {
    }

    public void help(boolean bl) {
    }

    public boolean getNormalized() {
        return this.normalizeCheckBox.isSelected();
    }

    public void setNormalized(boolean bl) {
        this.normalizeCheckBox.setSelected(bl);
        this.panel.getBarChart().setNormalized(this.normalizeCheckBox.isSelected());
        this.panel.repaint();
    }

    public void setStackBars(boolean bl) {
        this.stackBarsCheckBox.setSelected(bl);
        if (bl) {
            this.normalizeCheckBox.setEnabled(true);
            this.orderByMeanCheckBox.setEnabled(true);
            this.panel.getBarChart().setNormalized(this.getNormalized());
            this.panel.getBarChart().setStacked(true);
        } else {
            this.normalizeCheckBox.setSelected(false);
            this.normalizeCheckBox.setEnabled(false);
            this.orderByMeanCheckBox.setSelected(true);
            this.orderByMeanCheckBox.setEnabled(false);
            this.panel.getBarChart().setNormalized(this.getNormalized());
            this.panel.getBarChart().setStacked(false);
        }
        this.panel.repaint();
    }

    public JFrame getFrame() {
        return this;
    }
}

