/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.DataSorterWrapper;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.paraprof.barchart.LegendModel;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonBarChartModel
extends AbstractBarChartModel {
    private List<ParaProfTrial> ppTrials = new ArrayList<ParaProfTrial>();
    private List<Thread> threads = new ArrayList<Thread>();
    private Map<String, RowBlob> rowMap = new HashMap<String, RowBlob>();
    private List<RowBlob> rows = new ArrayList<RowBlob>();
    private DataSorter dataSorter;
    private FunctionBarChartWindow window;
    private LegendModel legendModel;

    public ComparisonBarChartModel(FunctionBarChartWindow functionBarChartWindow, ParaProfTrial paraProfTrial, Thread thread, DataSorter dataSorter) {
        this.window = functionBarChartWindow;
        this.dataSorter = dataSorter;
        this.addThread(paraProfTrial, thread);
    }

    public LegendModel getLegendModel() {
        if (this.legendModel == null) {
            this.legendModel = new LegendModel(){

                public int getNumElements() {
                    return ComparisonBarChartModel.this.ppTrials.size();
                }

                public String getLabel(int n) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)ComparisonBarChartModel.this.ppTrials.get(n);
                    Thread thread = (Thread)ComparisonBarChartModel.this.threads.get(n);
                    return paraProfTrial.getName() + " - " + ParaProfUtils.getThreadLabel(thread);
                }

                public Color getColor(int n) {
                    return ComparisonBarChartModel.this.getValueColor(0, n);
                }
            };
        }
        return this.legendModel;
    }

    public void addThread(ParaProfTrial paraProfTrial, Thread thread) {
        this.ppTrials.add(paraProfTrial);
        this.threads.add(thread);
    }

    @Override
    public void reloadData() {
        Thread thread;
        this.rows.clear();
        this.rowMap.clear();
        if (this.threads.get(0).getDataSource().isDerivedProvided()) {
            for (int i = 0; i < this.threads.size(); ++i) {
                thread = this.threads.get(i);
                if (thread.getThreadID() == -1 || thread.getThreadID() == -6) {
                    this.threads.set(i, thread.getDataSource().getMeanData());
                    continue;
                }
                if (thread.getThreadID() != -3 && thread.getThreadID() != -7) continue;
                this.threads.set(i, thread.getDataSource().getStdDevData());
            }
        }
        ParaProfTrial paraProfTrial = this.ppTrials.get(0);
        thread = this.threads.get(0);
        this.dataSorter.setPpTrial(paraProfTrial);
        DataSorterWrapper dataSorterWrapper = new DataSorterWrapper(this.dataSorter, paraProfTrial);
        List<PPFunctionProfile> list = dataSorterWrapper.getFunctionProfiles(thread);
        for (PPFunctionProfile object2 : list) {
            RowBlob i = new RowBlob(object2.getDisplayName());
            this.rows.add(i);
            i.add(object2);
            this.rowMap.put(object2.getDisplayName(), i);
        }
        String string = this.dataSorter.getSelectedMetric().getName();
        String string2 = this.dataSorter.getSortMetric().getName();
        for (int i = 1; i < this.ppTrials.size(); ++i) {
            ParaProfTrial paraProfTrial2 = this.ppTrials.get(i);
            Thread thread2 = this.threads.get(i);
            Iterator<Metric> iterator = paraProfTrial2.getMetrics().iterator();
            boolean bl = false;
            boolean bl2 = false;
            if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR) {
                bl = true;
            }
            if (this.dataSorter.getSortValueType() == ValueType.NUMCALLS || this.dataSorter.getSortValueType() == ValueType.NUMSUBR) {
                bl2 = true;
            }
            while (iterator.hasNext()) {
                String string3 = iterator.next().getName();
                if (string3.equals(string)) {
                    bl = true;
                }
                if (!string3.equals(string2)) continue;
                bl2 = true;
            }
            if (!bl || !bl2) {
                JOptionPane.showMessageDialog(this.window, "Warning: Selected metric not available for all trials");
                bl = false;
                bl2 = false;
                continue;
            }
            dataSorterWrapper = new DataSorterWrapper(this.dataSorter, paraProfTrial2);
            list = dataSorterWrapper.getFunctionProfiles(thread2);
            for (PPFunctionProfile pPFunctionProfile : list) {
                if (!paraProfTrial2.displayFunction(pPFunctionProfile.getFunction())) continue;
                RowBlob rowBlob = this.rowMap.get(pPFunctionProfile.getDisplayName());
                if (rowBlob != null) {
                    rowBlob.add(i, pPFunctionProfile);
                    continue;
                }
                rowBlob = new RowBlob(pPFunctionProfile.getDisplayName());
                this.rows.add(rowBlob);
                this.rowMap.put(pPFunctionProfile.getDisplayName(), rowBlob);
                rowBlob.add(i, pPFunctionProfile);
            }
        }
        Collections.sort(this.rows);
        this.fireModelChanged();
    }

    @Override
    public int getNumRows() {
        return this.rows.size();
    }

    @Override
    public int getSubSize() {
        return this.ppTrials.size();
    }

    public String getLabel(int n) {
        return null;
    }

    @Override
    public double getValue(int n, int n2) {
        RowBlob rowBlob = this.rows.get(n);
        PPFunctionProfile pPFunctionProfile = rowBlob.get(n2);
        if (pPFunctionProfile == null) {
            return -1.0;
        }
        return pPFunctionProfile.getValue();
    }

    @Override
    public String getValueLabel(int n, int n2) {
        double d = this.getValue(n, n2);
        if (this.window.getDataSorter().getValueType() == ValueType.EXCLUSIVE_PERCENT || this.window.getDataSorter().getValueType() == ValueType.INCLUSIVE_PERCENT) {
            return UtilFncs.getOutputString((int)0, (double)d, (int)6, (boolean)this.dataSorter.getSelectedMetric().isTimeDenominator()) + "%";
        }
        String string = "";
        if (this.getValue(n, 0) > 0.0 && n2 != 0) {
            double d2 = d / this.getValue(n, 0) * 100.0;
            string = " (" + UtilFncs.getOutputString((int)0, (double)d2, (int)2, (boolean)this.dataSorter.getSelectedMetric().isTimeDenominator()) + "%)";
        }
        return UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)ParaProf.defaultNumberPrecision, (boolean)this.dataSorter.getSelectedMetric().isTimeDenominator()) + string;
    }

    @Override
    public String getRowLabel(int n) {
        RowBlob rowBlob = this.rows.get(n);
        return rowBlob.getFunctionName();
    }

    @Override
    public Color getValueColor(int n, int n2) {
        Vector<Color> vector = ParaProf.colorChooser.getColors();
        return (Color)vector.get(n2 % vector.size());
    }

    @Override
    public Color getValueHighlightColor(int n, int n2) {
        return null;
    }

    @Override
    public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
    }

    @Override
    public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
        if (ParaProfUtils.rightClick(mouseEvent)) {
            RowBlob rowBlob = this.rows.get(n);
            for (PPFunctionProfile pPFunctionProfile : rowBlob) {
                if (pPFunctionProfile == null) continue;
                JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(pPFunctionProfile.getPPTrial(), pPFunctionProfile.getFunction(), pPFunctionProfile.getThread(), jComponent);
                jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
        }
    }

    @Override
    public String getValueToolTipText(int n, int n2) {
        return null;
    }

    @Override
    public String getRowLabelToolTipText(int n) {
        return null;
    }

    @Override
    public String getOtherToolTopText(int n) {
        return null;
    }

    public static void main(String[] stringArray) {
        ParaProf.initialize();
        File[] fileArray = new File[]{new File("/home/amorris/data/packed/lu.C.512.ppk")};
        ParaProfTrial paraProfTrial = ComparisonBarChartModel.loadTrial(fileArray, 7);
        fileArray[0] = new File("/home/amorris/data/packed/lu.A.128.ppk");
        ParaProfTrial paraProfTrial2 = ComparisonBarChartModel.loadTrial(fileArray, 7);
        FunctionBarChartWindow functionBarChartWindow = FunctionBarChartWindow.CreateComparisonWindow(paraProfTrial, paraProfTrial.getDataSource().getMeanData(), null);
        functionBarChartWindow.addThread(paraProfTrial, paraProfTrial.getDataSource().getThread(0, 0, 0));
        functionBarChartWindow.addThread(paraProfTrial, paraProfTrial.getDataSource().getThread(1, 0, 0));
        functionBarChartWindow.addThread(paraProfTrial2, paraProfTrial2.getDataSource().getMeanData());
        functionBarChartWindow.setVisible(true);
    }

    public static ParaProfTrial loadTrial(File[] fileArray, int n) {
        ParaProfApplication paraProfApplication = ParaProf.applicationManager.addApplication();
        paraProfApplication.setName("New Application");
        ParaProfExperiment paraProfExperiment = paraProfApplication.addExperiment();
        ParaProf.paraProfManagerWindow.addTrial(paraProfApplication, paraProfExperiment, fileArray, n, false, false);
        Vector<ParaProfTrial> vector = paraProfExperiment.getTrials();
        ParaProfTrial paraProfTrial = vector.get(0);
        while (paraProfTrial.loading()) {
            ComparisonBarChartModel.sleep(500);
        }
        return paraProfTrial;
    }

    private static void sleep(int n) {
        try {
            java.lang.Thread.sleep(n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while sleeping");
        }
    }

    public List<Thread> getThreads() {
        return this.threads;
    }

    public List<ParaProfTrial> getPpTrials() {
        return this.ppTrials;
    }

    public void setThreads(List<Thread> list) {
        this.threads = list;
    }

    @Override
    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowBlob
    extends ArrayList<PPFunctionProfile>
    implements Comparable<RowBlob> {
        private static final long serialVersionUID = 8555913184400646137L;
        String functionName;

        public RowBlob(String string) {
            this.functionName = string;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public void add(int n, PPFunctionProfile pPFunctionProfile) {
            while (n >= this.size()) {
                this.add(null);
            }
            super.set(n, pPFunctionProfile);
        }

        @Override
        public PPFunctionProfile get(int n) {
            if (n >= this.size()) {
                return null;
            }
            return (PPFunctionProfile)super.get(n);
        }

        private double getSortMax() {
            double d = 0.0;
            for (int i = 0; i < ComparisonBarChartModel.this.ppTrials.size(); ++i) {
                PPFunctionProfile pPFunctionProfile = this.get(i);
                if (pPFunctionProfile == null) continue;
                d = Math.max(d, pPFunctionProfile.getSortValue());
            }
            return d;
        }

        private int privateCompare(RowBlob rowBlob) {
            if (ComparisonBarChartModel.this.dataSorter.getSortType() == SortType.NAME) {
                return this.functionName.compareTo(rowBlob.getFunctionName());
            }
            return (int)(rowBlob.getSortMax() - this.getSortMax());
        }

        @Override
        public int compareTo(RowBlob rowBlob) {
            if (ComparisonBarChartModel.this.dataSorter.getDescendingOrder()) {
                return this.privateCompare(rowBlob);
            }
            return -this.privateCompare(rowBlob);
        }
    }
}

