/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.enums;

import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;

public abstract class ValueType {
    private final String name;
    private final String classname;
    public static final ValueType EXCLUSIVE = new ValueType("Exclusive", "ValueType.EXCLUSIVE"){

        public double getValue(FunctionProfile functionProfile, int n, int n2) {
            if (functionProfile.getFunction().isPhase() && functionProfile.getFunction().isCallPathFunction()) {
                return functionProfile.getInclusive(n2, n);
            }
            return functionProfile.getExclusive(n2, n);
        }

        public String getSuffix(int n, Metric metric) {
            if (!metric.isTimeMetric()) {
                if (metric.getName().toLowerCase().contains("energy") && !metric.getName().contains("/")) {
                    return " Joules";
                }
                return " counts";
            }
            return ValueType.timeUnits(n);
        }

        public int getUnits(int n, Metric metric) {
            if (metric.isTimeMetric()) {
                return n;
            }
            return 0;
        }
    };
    public static final ValueType EXCLUSIVE_PERCENT = new ValueType("Exclusive percent", "ValueType.EXCLUSIVE_PERCENT"){

        public double getValue(FunctionProfile functionProfile, int n, int n2) {
            if (functionProfile.getFunction().isPhase() && functionProfile.getFunction().isCallPathFunction()) {
                return functionProfile.getInclusivePercent(n2, n);
            }
            return functionProfile.getExclusivePercent(n2, n);
        }

        public String getSuffix(int n, Metric metric) {
            return " %";
        }

        public int getUnits(int n, Metric metric) {
            return 0;
        }
    };
    public static final ValueType INCLUSIVE = new ValueType("Inclusive", "ValueType.INCLUSIVE"){

        public double getValue(FunctionProfile functionProfile, int n, int n2) {
            return functionProfile.getInclusive(n2, n);
        }

        public String getSuffix(int n, Metric metric) {
            if (!metric.isTimeMetric()) {
                return " counts";
            }
            return ValueType.timeUnits(n);
        }

        public int getUnits(int n, Metric metric) {
            if (metric.isTimeMetric()) {
                return n;
            }
            return 0;
        }
    };
    public static final ValueType INCLUSIVE_PERCENT = new ValueType("Inclusive percent", "ValueType.INCLUSIVE_PERCENT"){

        public double getValue(FunctionProfile functionProfile, int n, int n2) {
            return functionProfile.getInclusivePercent(n2, n);
        }

        public String getSuffix(int n, Metric metric) {
            return " %";
        }

        public int getUnits(int n, Metric metric) {
            return 0;
        }
    };
    public static final ValueType NUMCALLS = new ValueType("Number of Calls", "ValueType.NUMCALLS"){

        public double getValue(FunctionProfile functionProfile, int n, int n2) {
            return functionProfile.getNumCalls(n2);
        }

        public String getSuffix(int n, Metric metric) {
            return " calls";
        }

        public int getUnits(int n, Metric metric) {
            return 0;
        }
    };
    public static final ValueType NUMSUBR = new ValueType("Number of Child Calls", "ValueType.NUMSUBR"){

        public double getValue(FunctionProfile functionProfile, int n, int n2) {
            return functionProfile.getNumSubr(n2);
        }

        public String getSuffix(int n, Metric metric) {
            return " calls";
        }

        public int getUnits(int n, Metric metric) {
            return 0;
        }
    };
    public static final ValueType INCLUSIVE_PER_CALL = new ValueType("Inclusive per Call", "ValueType.INCLUSIVE_PER_CALL"){

        public double getValue(FunctionProfile functionProfile, int n, int n2) {
            return functionProfile.getInclusivePerCall(n2, n);
        }

        public String getSuffix(int n, Metric metric) {
            if (!metric.isTimeMetric()) {
                return " counts per call";
            }
            return ValueType.timeUnits(n) + " per call";
        }

        public int getUnits(int n, Metric metric) {
            if (metric.isTimeMetric()) {
                return n;
            }
            return 0;
        }
    };
    public static final ValueType EXCLUSIVE_PER_CALL = new ValueType("Exclusive per Call", "ValueType.EXCLUSIVE_PER_CALL"){

        public double getValue(FunctionProfile functionProfile, int n, int n2) {
            return functionProfile.getExclusivePerCall(n2, n);
        }

        public String getSuffix(int n, Metric metric) {
            if (!metric.isTimeMetric()) {
                return " counts per call";
            }
            return ValueType.timeUnits(n) + " per call";
        }

        public int getUnits(int n, Metric metric) {
            if (metric.isTimeMetric()) {
                return n;
            }
            return 0;
        }
    };
    public static ValueType[] VALUES = new ValueType[]{EXCLUSIVE, INCLUSIVE, EXCLUSIVE_PERCENT, INCLUSIVE_PERCENT, NUMCALLS, NUMSUBR, INCLUSIVE_PER_CALL, EXCLUSIVE_PER_CALL};

    public abstract double getValue(FunctionProfile var1, int var2, int var3);

    public double getValue(FunctionProfile functionProfile, Metric metric, int n) {
        int n2 = 0;
        if (metric != null) {
            n2 = metric.getID();
        }
        return this.getValue(functionProfile, n2, n);
    }

    public double getValue(FunctionProfile functionProfile, int n) {
        return this.getValue(functionProfile, n, -1);
    }

    public abstract String getSuffix(int var1, Metric var2);

    public abstract int getUnits(int var1, Metric var2);

    private ValueType(String string, String string2) {
        this.name = string;
        this.classname = string2;
    }

    public String toString() {
        return this.name;
    }

    public String getClassName() {
        return this.classname;
    }

    private static String timeUnits(int n) {
        String string;
        switch (n) {
            case 0: {
                string = " microseconds";
                break;
            }
            case 1: {
                string = " milliseconds";
                break;
            }
            case 2: {
                string = " seconds";
                break;
            }
            case 3: {
                string = " hh:mm:ss";
                break;
            }
            default: {
                throw new ParaProfException("Unexpected unit type: " + n);
            }
        }
        return string;
    }

    public static boolean isTimeUnits(ValueType valueType) {
        return valueType == EXCLUSIVE || valueType == INCLUSIVE || valueType == INCLUSIVE_PER_CALL || valueType == EXCLUSIVE_PER_CALL;
    }
}

