/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.util;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.util.CheckBoxList;
import edu.uoregon.tau.perfdmf.Snapshot;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFilter
extends Observable {
    private Object[] objects;
    private boolean[] filter;
    private int numShown;
    private int numHidden;
    private JFrame frame;

    public ObjectFilter(List<Snapshot> list) {
        this.objects = list.toArray();
        this.filter = new boolean[this.objects.length];
        this.showAll();
    }

    public List<Object> getFilteredObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.objects.length; ++i) {
            if (!this.filter[i]) continue;
            arrayList.add(this.objects[i]);
        }
        return arrayList;
    }

    public void hide(Object object) {
        for (int i = 0; i < this.objects.length; ++i) {
            if (!object.equals(this.objects[i])) continue;
            this.filter[i] = false;
            --this.numShown;
            ++this.numHidden;
        }
    }

    public void show(Object object) {
        for (int i = 0; i < this.objects.length; ++i) {
            if (!object.equals(this.objects[i])) continue;
            this.filter[i] = true;
            ++this.numShown;
            --this.numHidden;
        }
    }

    public void showAll() {
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i] = true;
        }
        this.numShown = this.filter.length;
        this.numHidden = 0;
    }

    public void closeWindow() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    public void showFrame(String string) {
        if (this.frame == null) {
            this.frame = new JFrame();
            Object[] objectArray = new JCheckBox[this.objects.length];
            for (int i = 0; i < this.objects.length; ++i) {
                objectArray[i] = new JCheckBox(this.objects[i].toString());
                ((AbstractButton)objectArray[i]).setSelected(this.filter[i]);
            }
            CheckBoxList checkBoxList = new CheckBoxList(objectArray);
            JScrollPane jScrollPane = new JScrollPane(checkBoxList);
            this.frame.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            JButton jButton = new JButton("Apply");
            jButton.addActionListener(new ActionListener((JCheckBox[])objectArray){
                final /* synthetic */ JCheckBox[] val$boxes;
                {
                    this.val$boxes = jCheckBoxArray;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < ObjectFilter.this.objects.length; ++i) {
                        ((ObjectFilter)ObjectFilter.this).filter[i] = this.val$boxes[i].isSelected();
                    }
                    ObjectFilter.this.setChanged();
                    ObjectFilter.this.notifyObservers();
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ObjectFilter.this.frame.setVisible(false);
                    ObjectFilter.this.frame.dispose();
                    ObjectFilter.this.frame = null;
                }
            });
            Utility.addCompItem((JFrame)this.frame, (Component)jScrollPane, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)2, (int)1);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 14;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            Utility.addCompItem((JFrame)this.frame, (Component)jButton, (GridBagConstraints)gridBagConstraints, (int)0, (int)1, (int)1, (int)1);
            Utility.addCompItem((JFrame)this.frame, (Component)jButton2, (GridBagConstraints)gridBagConstraints, (int)1, (int)1, (int)1, (int)1);
            this.frame.pack();
            this.frame.setSize(new Dimension(300, 800));
            ParaProfUtils.setFrameIcon(this.frame);
        }
        this.frame.setTitle(string);
        this.frame.setVisible(true);
    }
}

