/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering.weka;

import edu.uoregon.tau.perfexplorer.clustering.LinearRegressionInterface;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.functions.LinearRegression;
import weka.core.Instances;
import weka.core.SelectedTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaLinearRegression
implements LinearRegressionInterface {
    private LinearRegression regress = new LinearRegression();
    private Instances instances;

    public WekaLinearRegression() {
        this.regress.setEliminateColinearAttributes(false);
        this.regress.setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
    }

    @Override
    public void findCoefficients() {
        try {
            this.regress.buildClassifier(this.instances);
        }
        catch (Exception exception) {
            System.err.println("Error performing linear regression");
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    @Override
    public List<Double> getCoefficients() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double[] dArray = this.regress.coefficients();
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(new Double(dArray[i]));
        }
        return arrayList;
    }

    @Override
    public void setInputData(RawDataInterface rawDataInterface) {
        this.instances = (Instances)rawDataInterface.getData();
        this.instances.setClassIndex(this.instances.numAttributes() - 1);
    }
}

