/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceDifferenceType;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = 7845440472736625443L;
    private PerformanceDifferenceType differenceType = PerformanceDifferenceType.SAME;
    private double performanceRatio = 1.0;

    public DifferenceOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public DifferenceOperation(Trial trial) {
        super(trial);
    }

    public DifferenceOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        PerformanceResult performanceResult = (PerformanceResult)this.inputs.get(0);
        PerformanceResult performanceResult2 = (PerformanceResult)this.inputs.get(1);
        DefaultResult defaultResult = new DefaultResult((PerformanceResult)this.inputs.get(0), false);
        Set<Integer> set = performanceResult.getThreads();
        set.addAll(performanceResult2.getThreads());
        Set<String> set2 = performanceResult.getEvents();
        set2.addAll(performanceResult2.getEvents());
        Set<String> set3 = performanceResult.getMetrics();
        set3.addAll(performanceResult2.getMetrics());
        for (Integer object2 : set) {
            for (String string : set2) {
                for (String string2 : set3) {
                    defaultResult.putExclusive(object2, string, string2, performanceResult.getExclusive(object2, string, string2) - performanceResult2.getExclusive(object2, string, string2));
                    defaultResult.putInclusive(object2, string, string2, performanceResult.getInclusive(object2, string, string2) - performanceResult2.getInclusive(object2, string, string2));
                }
                defaultResult.putCalls(object2, string, performanceResult.getCalls(object2, string) - performanceResult2.getCalls(object2, string));
                defaultResult.putSubroutines(object2, string, performanceResult.getSubroutines(object2, string) - performanceResult2.getSubroutines(object2, string));
            }
        }
        Integer n = 0;
        String string = performanceResult.getMainEvent();
        String string3 = performanceResult.getTimeMetric();
        this.performanceRatio = performanceResult2.getInclusive(n, string, string3) / performanceResult.getInclusive(n, string, string3);
        if (performanceResult2.getInclusive(n, string, string3) > performanceResult.getInclusive(n, string, string3)) {
            this.differenceType = PerformanceDifferenceType.SLOWER;
        } else if (performanceResult2.getInclusive(n, string, string3) < performanceResult.getInclusive(n, string, string3)) {
            this.differenceType = PerformanceDifferenceType.FASTER;
        }
        this.outputs.add(defaultResult);
        return this.outputs;
    }

    public PerformanceDifferenceType getDifferenceType() {
        return this.differenceType;
    }

    public PerformanceResult getBaseline() {
        return (PerformanceResult)this.inputs.get(0);
    }

    public PerformanceResult getComparison() {
        return (PerformanceResult)this.inputs.get(1);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.differenceType == PerformanceDifferenceType.SAME) {
            stringBuilder.append("The comparison trial (");
            stringBuilder.append(((Object)this.getComparison()).toString());
            stringBuilder.append(") and the baseline trial (");
            stringBuilder.append(((Object)this.getBaseline()).toString());
            stringBuilder.append(") have the same execution time.");
        } else {
            stringBuilder.append("The comparison trial (");
            stringBuilder.append(((Object)this.getComparison()).toString());
            stringBuilder.append(") is relatively " + this.differenceType.toString() + " than the baseline trial (");
            stringBuilder.append(((Object)this.getBaseline()).toString());
            stringBuilder.append(").");
        }
        return stringBuilder.toString();
    }

    public double getPerformanceRatio() {
        return this.performanceRatio;
    }

    public void setPerformanceRatio(double d) {
        this.performanceRatio = d;
    }
}

