/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.common.VectorExport;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChart;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.server.TauNamespaceContext;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawMetadataGraph
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -5587605162968129610L;
    protected String title = "My Chart";
    protected String yAxisLabel = "Threads in cluster";
    protected String xAxisLabel = "Cluster Number";
    protected String metadataField = "cluster-membership";
    protected PerfExplorerChart chartWindow = null;
    protected ArrayList<Double> metadatavalues = new ArrayList();

    public DrawMetadataGraph(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public DrawMetadataGraph(Trial trial) {
        super(trial);
    }

    public DrawMetadataGraph(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (PerformanceResult performanceResult : this.inputs) {
            Double d2;
            this.metadatavalues = this.getclusterData(performanceResult.getTrial());
            int n = 0;
            for (Double d2 : this.metadatavalues) {
                defaultCategoryDataset.addValue((Number)d2, (Comparable)((Object)"Threads"), (Comparable)((Object)(n + "")));
                ++n;
            }
            JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D((String)this.title, (String)this.xAxisLabel, (String)this.yAxisLabel, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
            Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
            d2 = (CategoryPlot)jFreeChart.getPlot();
            CategoryItemRenderer categoryItemRenderer = d2.getRenderer();
            PerfExplorerChart.customizeColors(categoryItemRenderer);
            jFreeChart.removeLegend();
            this.chartWindow = new PerfExplorerChart(jFreeChart, "General Chart");
        }
        return null;
    }

    private ArrayList<Double> getclusterData(Trial trial) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(trial.getField("XML_METADATA"));
            InputSource inputSource = new InputSource(stringReader);
            Document document = documentBuilder.parse(inputSource);
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(new TauNamespaceContext());
            NodeList nodeList = (NodeList)xPath.evaluate("/metadata/ProfileAttributes", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node;
                    Node node2 = nodeList2.item(j);
                    Node node3 = node2.getFirstChild();
                    while (node3.getFirstChild() == null || node3.getFirstChild().getNodeValue() == null) {
                        node3 = node3.getNextSibling();
                    }
                    for (node = node3.getNextSibling(); node != null && (node.getFirstChild() == null || node.getFirstChild().getNodeValue() == null); node = node.getNextSibling()) {
                    }
                    if (node == null) continue;
                    String string = node.getFirstChild().getNodeValue();
                    String string2 = node3.getFirstChild().getNodeValue();
                    if (string == null || string2 == null || string2.equals("pid") || string2.toLowerCase().contains("time")) continue;
                    try {
                        Double d = Double.parseDouble(string);
                        this.metadatavalues.add(d);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return this.metadatavalues;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            return this.metadatavalues;
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setXAxisLabel(String string) {
        this.xAxisLabel = string;
    }

    public void setYAxisLabel(String string) {
        this.yAxisLabel = string;
    }

    public void setMetadataField(String string) {
        this.metadataField = string;
    }

    public void drawChartToFile(String string) {
        try {
            VectorExport.export((ImageExport)this.chartWindow, (File)new File(string), (boolean)true, (String)"PerfExplorer", (boolean)true, (boolean)true);
        }
        catch (Exception exception) {
            System.err.println("Could not write graph to file:");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

