/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogarithmicOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -8739506883974331396L;
    private double base = 2.0;

    public LogarithmicOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public LogarithmicOperation(Trial trial) {
        super(trial);
    }

    public LogarithmicOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        ArrayList<PerformanceResult> arrayList = new ArrayList<PerformanceResult>();
        for (PerformanceResult performanceResult : this.inputs) {
            DefaultResult defaultResult = new DefaultResult(performanceResult, false);
            arrayList.add(defaultResult);
            for (Integer n : performanceResult.getThreads()) {
                for (String string : performanceResult.getEvents()) {
                    for (String string2 : performanceResult.getMetrics()) {
                        defaultResult.putExclusive(n, string, string2, Math.log(performanceResult.getExclusive(n, string, string2)) / Math.log(this.base));
                        defaultResult.putInclusive(n, string, string2, Math.log(performanceResult.getInclusive(n, string, string2)) / Math.log(this.base));
                    }
                    defaultResult.putCalls(n, string, performanceResult.getCalls(n, string));
                    defaultResult.putSubroutines(n, string, performanceResult.getSubroutines(n, string));
                }
            }
        }
        return arrayList;
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double d) {
        this.base = d;
    }
}

