/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import edu.uoregon.tau.perfexplorer.glue.AbstractResult;
import edu.uoregon.tau.perfexplorer.glue.Utilities;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrialResult
extends AbstractResult {
    private static final long serialVersionUID = -7164598771800856462L;
    private boolean callPath = true;

    public TrialResult() {
    }

    public TrialResult(TrialResult trialResult) {
        super(trialResult);
    }

    public TrialResult(Trial trial) {
        this.trialID = trial.getID();
        this.trial = trial;
        this.name = this.trial.getName();
        this.buildTrialResult(trial, null, null, null);
    }

    public TrialResult(Trial trial, List<String> list, List<String> list2, List<String> list3, boolean bl) {
        this.trialID = trial.getID();
        this.trial = trial;
        this.callPath = bl;
        this.name = this.trial.getName();
        this.buildTrialResult(trial, list, list2, list3);
    }

    private void buildTrialResult(Trial trial, List<String> list, List<String> list2, List<String> list3) {
        DB dB = PerfExplorerServer.getServer().getDB();
        if (dB.getSchemaVersion() > 0) {
            this.buildTrialResultFromTAUdb(trial, list, list2, list3);
            return;
        }
        StringBuilder stringBuilder = null;
        PreparedStatement preparedStatement = null;
        try {
            int n;
            int n2 = Integer.parseInt(trial.getField("threads_per_context"));
            int n3 = Integer.parseInt(trial.getField("contexts_per_node")) * n2;
            stringBuilder = new StringBuilder();
            stringBuilder.append("select e.name, ");
            stringBuilder.append("m.name, ");
            stringBuilder.append("(p.node * " + n3 + ") + ");
            stringBuilder.append("(p.context * " + n2 + ") + ");
            stringBuilder.append("p.thread as thread, ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuilder.append("p.excl, ");
            } else {
                stringBuilder.append("p.exclusive, ");
            }
            stringBuilder.append("p.inclusive, ");
            if (dB.getDBType().compareTo("derby") == 0) {
                stringBuilder.append("p.num_calls, ");
            } else {
                stringBuilder.append("p.call, ");
            }
            stringBuilder.append("p.subroutines, e.id ");
            stringBuilder.append("from interval_event e ");
            stringBuilder.append("left outer join interval_location_profile p ");
            stringBuilder.append("on e.id = p.interval_event ");
            stringBuilder.append("left outer join metric m on m.trial = e.trial ");
            stringBuilder.append("and m.id = p.metric ");
            stringBuilder.append("where e.trial = ? ");
            if (list != null) {
                stringBuilder.append(" and m.name in (");
                n = 0;
                for (String object2 : list) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("'" + object2 + "'");
                    ++n;
                }
                stringBuilder.append(") ");
            }
            if (list2 != null) {
                stringBuilder.append(" and e.name in (");
                n = 0;
                for (String string : list2) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("'" + string + "'");
                    ++n;
                }
                stringBuilder.append(") ");
            }
            if (list3 != null) {
                stringBuilder.append(" and thread in (");
                n = 0;
                for (String string : list3) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string);
                    ++n;
                }
                stringBuilder.append(") ");
            }
            if (!this.callPath) {
                stringBuilder.append(" and (e.group_name is null or e.group_name not like '%TAU_CALLPATH%') ");
            }
            stringBuilder.append(" order by 3,2,1 ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, trial.getID());
            long l = System.currentTimeMillis();
            ResultSet resultSet = preparedStatement.executeQuery();
            long l2 = System.currentTimeMillis() - l;
            float f = (float)l2 / 1000.0f;
            System.out.println("Time to query interval data: " + f + " seconds");
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                Integer n4 = resultSet.getInt(3);
                this.putExclusive(n4, string, resultSet.getString(2), resultSet.getDouble(4));
                this.putInclusive(n4, string, resultSet.getString(2), resultSet.getDouble(5));
                this.putCalls(n4, string, resultSet.getDouble(6));
                this.putSubroutines(n4, string, resultSet.getDouble(7));
                Integer n5 = resultSet.getInt(8);
                this.eventMap.put(n5, string);
            }
            resultSet.close();
            preparedStatement.close();
            stringBuilder = new StringBuilder();
            stringBuilder.append("select a.name, ");
            stringBuilder.append("(p.node * " + n3 + ") + ");
            stringBuilder.append("(p.context * " + n2 + ") + ");
            stringBuilder.append("p.thread as thread, ");
            stringBuilder.append("p.sample_count, ");
            stringBuilder.append("p.maximum_value, ");
            stringBuilder.append("p.minimum_value, ");
            stringBuilder.append("p.mean_value, ");
            stringBuilder.append("p.standard_deviation ");
            stringBuilder.append("from atomic_event a ");
            stringBuilder.append("left outer join atomic_location_profile p ");
            stringBuilder.append("on a.id = p.atomic_event ");
            stringBuilder.append("where a.trial = ? ");
            stringBuilder.append(" order by 2,1 ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, trial.getID());
            l = System.currentTimeMillis();
            ResultSet resultSet2 = preparedStatement.executeQuery();
            l2 = System.currentTimeMillis() - l;
            f = (float)l2 / 1000.0f;
            System.out.println("Time to query counter data: " + f + " seconds");
            while (resultSet2.next()) {
                this.putUsereventNumevents(resultSet2.getInt(2), resultSet2.getString(1), resultSet2.getDouble(3));
                this.putUsereventMax(resultSet2.getInt(2), resultSet2.getString(1), resultSet2.getDouble(4));
                this.putUsereventMin(resultSet2.getInt(2), resultSet2.getString(1), resultSet2.getDouble(5));
                this.putUsereventMean(resultSet2.getInt(2), resultSet2.getString(1), resultSet2.getDouble(6));
                this.putUsereventSumsqr(resultSet2.getInt(2), resultSet2.getString(1), resultSet2.getDouble(7));
            }
            resultSet2.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            if (preparedStatement != null) {
                System.err.println(preparedStatement);
            }
            System.err.println(stringBuilder);
        }
    }

    private void buildTrialResultFromTAUdb(Trial trial, List<String> list, List<String> list2, List<String> list3) {
        DB dB = PerfExplorerServer.getServer().getDB();
        StringBuilder stringBuilder = null;
        PreparedStatement preparedStatement = null;
        try {
            int n;
            stringBuilder = new StringBuilder();
            if (!this.callPath) {
                stringBuilder.append(" select t.name, m.name, h.thread_index, tv.exclusive_value, ");
                stringBuilder.append(" tv.inclusive_value, tcd.calls, tcd.subroutines, cp.id from timer t ");
                stringBuilder.append(" left outer join timer_callpath cp on t.trial = " + trial.getID());
                stringBuilder.append(" and cp.timer = t.id ");
                stringBuilder.append(" left outer join timer_call_data tcd on tcd.timer_callpath = cp.id ");
                stringBuilder.append(" left outer join timer_value tv on tv.timer_call_data = tcd.id ");
                stringBuilder.append(" left outer join metric m on m.trial = " + trial.getID() + " and tv.metric = m.id ");
                stringBuilder.append(" left outer join thread h on h.trial = " + trial.getID() + " and tcd.thread = h.id ");
            } else {
                stringBuilder.append(" with recursive cp (id, parent, timer, name) as (  ");
                stringBuilder.append(" SELECT tc.id, tc.parent, tc.timer, timer.name  ");
                stringBuilder.append(" FROM  timer_callpath tc inner join timer on tc.timer = timer.id ");
                stringBuilder.append(" where timer.trial = " + trial.getID() + " and tc.parent is null ");
                stringBuilder.append(" UNION ALL ");
                stringBuilder.append(" SELECT d.id, d.parent, d.timer, ");
                if (dB.getDBType().compareTo("h2") == 0) {
                    stringBuilder.append("concat (cp.name, ' => ', dt.name) ");
                } else {
                    stringBuilder.append("cp.name || ' => ' || dt.name ");
                }
                stringBuilder.append(" FROM timer_callpath AS d JOIN cp ON (d.parent = cp.id) ");
                stringBuilder.append(" join timer dt on d.timer = dt.id where dt.trial = " + trial.getID() + " ) ");
                stringBuilder.append(" select cp.name, m.name, h.thread_index, tv.exclusive_value, ");
                stringBuilder.append(" tv.inclusive_value, tcd.calls, tcd.subroutines, cp.id from cp ");
                stringBuilder.append(" left outer join timer_call_data tcd on tcd.timer_callpath = cp.id ");
                stringBuilder.append(" left outer join timer_value tv on tv.timer_call_data = tcd.id ");
                stringBuilder.append(" left outer join metric m on m.trial = " + trial.getID() + " and tv.metric = m.id ");
                stringBuilder.append(" left outer join thread h on h.trial = " + trial.getID() + " and tcd.thread = h.id ");
            }
            stringBuilder.append("where m.trial = " + trial.getID());
            if (list != null) {
                stringBuilder.append(" and m.name in (");
                n = 0;
                for (String object2 : list) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("'" + object2 + "'");
                    ++n;
                }
                stringBuilder.append(") ");
            }
            if (list2 != null) {
                stringBuilder.append(" and t.name in (");
                n = 0;
                for (String string : list2) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("'" + string + "'");
                    ++n;
                }
                stringBuilder.append(") ");
            }
            if (list3 != null) {
                stringBuilder.append(" and h.thread_index in (");
                n = 0;
                for (String string : list3) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string);
                    ++n;
                }
                stringBuilder.append(") ");
            } else {
                stringBuilder.append(" and h.thread_index > -1 ");
            }
            stringBuilder.append(" order by 3,2,1 ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            long l = System.currentTimeMillis();
            ResultSet resultSet = preparedStatement.executeQuery();
            long l2 = System.currentTimeMillis() - l;
            float f = (float)l2 / 1000.0f;
            System.out.println("Time to query interval data: " + f + " seconds");
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                Integer n2 = resultSet.getInt(3);
                this.putExclusive(n2, string, resultSet.getString(2), resultSet.getDouble(4));
                this.putInclusive(n2, string, resultSet.getString(2), resultSet.getDouble(5));
                this.putCalls(n2, string, resultSet.getDouble(6));
                this.putSubroutines(n2, string, resultSet.getDouble(7));
                Integer n3 = resultSet.getInt(8);
                this.eventMap.put(n3, string);
            }
            resultSet.close();
            preparedStatement.close();
            stringBuilder = new StringBuilder();
            int n4 = Integer.parseInt(trial.getField("threads_per_context"));
            int n5 = Integer.parseInt(trial.getField("contexts_per_node")) * n4;
            stringBuilder.append("select c.name, ");
            stringBuilder.append("h.thread_index as thread, ");
            stringBuilder.append("cv.sample_count, ");
            stringBuilder.append("cv.maximum_value, ");
            stringBuilder.append("cv.minimum_value, ");
            stringBuilder.append("cv.mean_value, ");
            stringBuilder.append("cv.standard_deviation ");
            stringBuilder.append("from counter c ");
            stringBuilder.append("left outer join counter_value cv ");
            stringBuilder.append("on c.id = cv.counter and c.trial = " + trial.getID());
            stringBuilder.append(" left outer join thread h ");
            stringBuilder.append("on h.id = cv.thread and h.trial = " + trial.getID());
            stringBuilder.append(" where c.trial = " + trial.getID());
            if (list3 != null) {
                stringBuilder.append(" and h.thread_index in (");
                int n6 = 0;
                for (String string : list3) {
                    if (n6 > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string);
                }
                stringBuilder.append(") ");
            } else {
                stringBuilder.append(" and h.thread_index > -1 ");
            }
            stringBuilder.append(" order by 2,1 ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            l = System.currentTimeMillis();
            ResultSet resultSet2 = preparedStatement.executeQuery();
            l2 = System.currentTimeMillis() - l;
            f = (float)l2 / 1000.0f;
            System.out.println("Time to query counter data: " + f + " seconds");
            while (resultSet2.next()) {
                this.putUsereventNumevents(resultSet2.getInt(2), resultSet2.getString(1), resultSet2.getDouble(3));
                this.putUsereventMax(resultSet2.getInt(2), resultSet2.getString(1), resultSet2.getDouble(4));
                this.putUsereventMin(resultSet2.getInt(2), resultSet2.getString(1), resultSet2.getDouble(5));
                this.putUsereventMean(resultSet2.getInt(2), resultSet2.getString(1), resultSet2.getDouble(6));
                this.putUsereventSumsqr(resultSet2.getInt(2), resultSet2.getString(1), resultSet2.getDouble(7));
            }
            resultSet2.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            if (preparedStatement != null) {
                System.err.println(preparedStatement);
            }
            System.err.println(stringBuilder);
        }
    }

    @Override
    public String toString() {
        return this.trial.getName();
    }

    public String getEventGroupName(String string) {
        String string2 = null;
        List<RMISortableIntervalEvent> list = Utilities.getEventsForTrial(this.trial, 0);
        for (RMISortableIntervalEvent rMISortableIntervalEvent : list) {
            if (!rMISortableIntervalEvent.getFunction().getName().equals(string)) continue;
            string2 = rMISortableIntervalEvent.getFunction().getGroupString();
        }
        return string2;
    }
}

