/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex$complex___coerce___exposer;
import org.python.core.PyComplex$complex___div___exposer;
import org.python.core.PyComplex$complex___eq___exposer;
import org.python.core.PyComplex$complex___float___exposer;
import org.python.core.PyComplex$complex___floordiv___exposer;
import org.python.core.PyComplex$complex___gt___exposer;
import org.python.core.PyComplex$complex___hash___exposer;
import org.python.core.PyComplex$complex___int___exposer;
import org.python.core.PyComplex$complex___le___exposer;
import org.python.core.PyComplex$complex___long___exposer;
import org.python.core.PyComplex$complex___mod___exposer;
import org.python.core.PyComplex$complex___ne___exposer;
import org.python.core.PyComplex$complex___neg___exposer;
import org.python.core.PyComplex$complex___pow___exposer;
import org.python.core.PyComplex$complex___radd___exposer;
import org.python.core.PyComplex$complex___rdiv___exposer;
import org.python.core.PyComplex$complex___rdivmod___exposer;
import org.python.core.PyComplex$complex___rpow___exposer;
import org.python.core.PyComplex$complex___sub___exposer;
import org.python.core.PyComplex$complex___truediv___exposer;
import org.python.core.PyComplex$complex_conjugate_exposer;
import org.python.core.PyComplex$imag_descriptor;
import org.python.core.PyComplex$real_descriptor;
import org.python.core.PyComplexDerived;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="complex")
public class PyComplex
extends PyObject {
    public static final PyType TYPE;
    public double real;
    public double imag;
    static PyComplex J;

    @ExposedNew
    public static PyObject complex_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        PyComplex pyComplex;
        PyComplex pye;
        PyComplex complexReal;
        PyObject imag;
        PyObject real;
        block19: {
            ArgParser ap = new ArgParser("complex", args, keywords, "real", "imag");
            real = ap.getPyObject(0, Py.Zero);
            imag = ap.getPyObject(1, null);
            if (real.getType() == TYPE && new_.for_type == subtype && imag == null) {
                return real;
            }
            if (real instanceof PyString) {
                if (imag != null) {
                    throw Py.TypeError("complex() can't take second arg if first is a string");
                }
                return real.__complex__();
            }
            if (imag != null && imag instanceof PyString) {
                throw Py.TypeError("complex() second arg can't be a string");
            }
            try {
                real = real.__complex__();
            }
            catch (PyException pye2) {
                if (pye2.match(Py.AttributeError)) break block19;
                throw pye2;
            }
        }
        PyFloat pyFloat = null;
        if (real instanceof PyComplex) {
            complexReal = (PyComplex)real;
        } else {
            try {
                pyFloat = real.__float__();
            }
            catch (PyException toFloat) {
                if (toFloat.match(Py.AttributeError)) {
                    throw Py.TypeError("complex() argument must be a string or a number");
                }
                throw toFloat;
            }
            complexReal = new PyComplex(pyFloat.getValue());
        }
        if (imag == null) {
            pye = new PyComplex(0.0);
        } else if (imag instanceof PyComplex) {
            pye = (PyComplex)imag;
        } else {
            PyFloat complexImag = null;
            try {
                complexImag = imag.__float__();
            }
            catch (PyException toFloat) {
                if (toFloat.match(Py.AttributeError)) {
                    throw Py.TypeError("complex() argument must be a string or a number");
                }
                throw toFloat;
            }
            pyComplex = new PyComplex(complexImag.getValue());
        }
        complexReal.real -= pyComplex.imag;
        complexReal.imag += pyComplex.real;
        if (new_.for_type != subtype) {
            complexReal = new PyComplexDerived(subtype, complexReal.real, complexReal.imag);
        }
        return complexReal;
    }

    public PyComplex(PyType subtype, double r, double i) {
        super(subtype);
        this.real = r;
        this.imag = i;
    }

    public PyComplex(double r, double i) {
        this(TYPE, r, i);
    }

    public PyComplex(double r) {
        this(r, 0.0);
    }

    public final PyFloat getReal() {
        return Py.newFloat(this.real);
    }

    public final PyFloat getImag() {
        return Py.newFloat(this.imag);
    }

    public static String toString(double value) {
        if (value == Math.floor(value) && value <= 9.223372036854776E18 && value >= -9.223372036854776E18) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }

    public String toString() {
        return this.complex_toString();
    }

    final String complex_toString() {
        if (this.real == 0.0) {
            return PyComplex.toString(this.imag) + "j";
        }
        if (this.imag >= 0.0) {
            return "(" + PyComplex.toString(this.real) + "+" + PyComplex.toString(this.imag) + "j)";
        }
        return "(" + PyComplex.toString(this.real) + "-" + PyComplex.toString(-this.imag) + "j)";
    }

    public int hashCode() {
        return this.complex___hash__();
    }

    final int complex___hash__() {
        if (this.imag == 0.0) {
            return new PyFloat(this.real).hashCode();
        }
        long v = Double.doubleToLongBits(this.real) ^ Double.doubleToLongBits(this.imag);
        return (int)v ^ (int)(v >> 32);
    }

    public boolean __nonzero__() {
        return this.complex___nonzero__();
    }

    final boolean complex___nonzero__() {
        return this.real != 0.0 || this.imag != 0.0;
    }

    public int __cmp__(PyObject other) {
        if (!this.canCoerce(other)) {
            return -2;
        }
        PyComplex c = this.coerce(other);
        double oreal = c.real;
        double oimag = c.imag;
        if (this.real == oreal && this.imag == oimag) {
            return 0;
        }
        if (this.real != oreal) {
            return this.real < oreal ? -1 : 1;
        }
        return this.imag < oimag ? -1 : 1;
    }

    public PyObject __eq__(PyObject other) {
        return this.complex___eq__(other);
    }

    final PyObject complex___eq__(PyObject other) {
        if (!this.canCoerce(other)) {
            return null;
        }
        PyComplex c = this.coerce(other);
        return Py.newBoolean(this.real == c.real && this.imag == c.imag);
    }

    public PyObject __ne__(PyObject other) {
        return this.complex___ne__(other);
    }

    final PyObject complex___ne__(PyObject other) {
        if (!this.canCoerce(other)) {
            return null;
        }
        PyComplex c = this.coerce(other);
        return Py.newBoolean(this.real != c.real || this.imag != c.imag);
    }

    private PyObject unsupported_comparison(PyObject other) {
        if (!this.canCoerce(other)) {
            return null;
        }
        throw Py.TypeError("cannot compare complex numbers using <, <=, >, >=");
    }

    public PyObject __ge__(PyObject other) {
        return this.complex___ge__(other);
    }

    final PyObject complex___ge__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    public PyObject __gt__(PyObject other) {
        return this.complex___gt__(other);
    }

    final PyObject complex___gt__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    public PyObject __le__(PyObject other) {
        return this.complex___le__(other);
    }

    final PyObject complex___le__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    public PyObject __lt__(PyObject other) {
        return this.complex___lt__(other);
    }

    final PyObject complex___lt__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    public Object __coerce_ex__(PyObject other) {
        return this.complex___coerce_ex__(other);
    }

    final PyObject complex___coerce__(PyObject other) {
        return this.adaptToCoerceTuple(this.complex___coerce_ex__(other));
    }

    final PyObject complex___coerce_ex__(PyObject other) {
        if (other instanceof PyComplex) {
            return other;
        }
        if (other instanceof PyFloat) {
            return new PyComplex(((PyFloat)other).getValue(), 0.0);
        }
        if (other instanceof PyInteger) {
            return new PyComplex(((PyInteger)other).getValue(), 0.0);
        }
        if (other instanceof PyLong) {
            return new PyComplex(((PyLong)other).doubleValue(), 0.0);
        }
        return Py.None;
    }

    private final boolean canCoerce(PyObject other) {
        return other instanceof PyComplex || other instanceof PyFloat || other instanceof PyInteger || other instanceof PyLong;
    }

    private final PyComplex coerce(PyObject other) {
        if (other instanceof PyComplex) {
            return (PyComplex)other;
        }
        if (other instanceof PyFloat) {
            return new PyComplex(((PyFloat)other).getValue(), 0.0);
        }
        if (other instanceof PyInteger) {
            return new PyComplex(((PyInteger)other).getValue(), 0.0);
        }
        if (other instanceof PyLong) {
            return new PyComplex(((PyLong)other).doubleValue(), 0.0);
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject right) {
        return this.complex___add__(right);
    }

    final PyObject complex___add__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        PyComplex c = this.coerce(right);
        return new PyComplex(this.real + c.real, this.imag + c.imag);
    }

    public PyObject __radd__(PyObject left) {
        return this.complex___radd__(left);
    }

    final PyObject complex___radd__(PyObject left) {
        return this.__add__(left);
    }

    private static final PyObject _sub(PyComplex o1, PyComplex o2) {
        return new PyComplex(o1.real - o2.real, o1.imag - o2.imag);
    }

    public PyObject __sub__(PyObject right) {
        return this.complex___sub__(right);
    }

    final PyObject complex___sub__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._sub(this, this.coerce(right));
    }

    public PyObject __rsub__(PyObject left) {
        return this.complex___rsub__(left);
    }

    final PyObject complex___rsub__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._sub(this.coerce(left), this);
    }

    private static final PyObject _mul(PyComplex o1, PyComplex o2) {
        return new PyComplex(o1.real * o2.real - o1.imag * o2.imag, o1.real * o2.imag + o1.imag * o2.real);
    }

    public PyObject __mul__(PyObject right) {
        return this.complex___mul__(right);
    }

    final PyObject complex___mul__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._mul(this, this.coerce(right));
    }

    public PyObject __rmul__(PyObject left) {
        return this.complex___rmul__(left);
    }

    final PyObject complex___rmul__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._mul(this.coerce(left), this);
    }

    private static final PyObject _div(PyComplex a, PyComplex b) {
        double abs_bimag;
        double abs_breal = b.real < 0.0 ? -b.real : b.real;
        double d = abs_bimag = b.imag < 0.0 ? -b.imag : b.imag;
        if (abs_breal >= abs_bimag) {
            if (abs_breal == 0.0) {
                throw Py.ZeroDivisionError("complex division");
            }
            double ratio = b.imag / b.real;
            double denom = b.real + b.imag * ratio;
            return new PyComplex((a.real + a.imag * ratio) / denom, (a.imag - a.real * ratio) / denom);
        }
        double ratio = b.real / b.imag;
        double denom = b.real * ratio + b.imag;
        return new PyComplex((a.real * ratio + a.imag) / denom, (a.imag * ratio - a.real) / denom);
    }

    public PyObject __div__(PyObject right) {
        return this.complex___div__(right);
    }

    final PyObject complex___div__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic complex division");
        }
        return PyComplex._div(this, this.coerce(right));
    }

    public PyObject __rdiv__(PyObject left) {
        return this.complex___rdiv__(left);
    }

    final PyObject complex___rdiv__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic complex division");
        }
        return PyComplex._div(this.coerce(left), this);
    }

    public PyObject __floordiv__(PyObject right) {
        return this.complex___floordiv__(right);
    }

    final PyObject complex___floordiv__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(right)).__finditem__(0);
    }

    public PyObject __rfloordiv__(PyObject left) {
        return this.complex___rfloordiv__(left);
    }

    final PyObject complex___rfloordiv__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(left), this).__finditem__(0);
    }

    public PyObject __truediv__(PyObject right) {
        return this.complex___truediv__(right);
    }

    final PyObject complex___truediv__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._div(this, this.coerce(right));
    }

    public PyObject __rtruediv__(PyObject left) {
        return this.complex___rtruediv__(left);
    }

    final PyObject complex___rtruediv__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._div(this.coerce(left), this);
    }

    public PyObject __mod__(PyObject right) {
        return this.complex___mod__(right);
    }

    final PyObject complex___mod__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._mod(this, this.coerce(right));
    }

    public PyObject __rmod__(PyObject left) {
        return this.complex___rmod__(left);
    }

    final PyObject complex___rmod__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._mod(this.coerce(left), this);
    }

    private static PyObject _mod(PyComplex value, PyComplex right) {
        Py.warning(Py.DeprecationWarning, "complex divmod(), // and % are deprecated");
        PyComplex z = (PyComplex)PyComplex._div(value, right);
        z.real = Math.floor(z.real);
        z.imag = 0.0;
        return value.__sub__(z.__mul__(right));
    }

    public PyObject __divmod__(PyObject right) {
        return this.complex___divmod__(right);
    }

    final PyObject complex___divmod__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(right));
    }

    public PyObject __rdivmod__(PyObject left) {
        return this.complex___rdivmod__(left);
    }

    final PyObject complex___rdivmod__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(left), this);
    }

    private static PyObject _divmod(PyComplex value, PyComplex right) {
        Py.warning(Py.DeprecationWarning, "complex divmod(), // and % are deprecated");
        PyComplex z = (PyComplex)PyComplex._div(value, right);
        z.real = Math.floor(z.real);
        z.imag = 0.0;
        return new PyTuple(z, value.__sub__(z.__mul__(right)));
    }

    private static PyObject ipow(PyComplex value, int iexp) {
        int pow = iexp;
        if (pow < 0) {
            pow = -pow;
        }
        double xr = value.real;
        double xi = value.imag;
        double zr = 1.0;
        double zi = 0.0;
        while (pow > 0) {
            double tmp;
            if ((pow & 1) != 0) {
                tmp = zr * xr - zi * xi;
                zi = zi * xr + zr * xi;
                zr = tmp;
            }
            if ((pow >>= 1) == 0) break;
            tmp = xr * xr - xi * xi;
            xi = xr * xi * 2.0;
            xr = tmp;
        }
        PyComplex ret = new PyComplex(zr, zi);
        if (iexp < 0) {
            return new PyComplex(1.0, 0.0).__div__(ret);
        }
        return ret;
    }

    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.complex___pow__(right, modulo);
    }

    final PyObject complex___pow__(PyObject right, PyObject modulo) {
        if (modulo != null) {
            throw Py.ValueError("complex modulo");
        }
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._pow(this, this.coerce(right));
    }

    public PyObject __rpow__(PyObject left) {
        return this.complex___rpow__(left);
    }

    final PyObject complex___rpow__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._pow(this.coerce(left), this);
    }

    public static PyObject _pow(PyComplex value, PyComplex right) {
        double xr = value.real;
        double xi = value.imag;
        double yr = right.real;
        double yi = right.imag;
        if (yr == 0.0 && yi == 0.0) {
            return new PyComplex(1.0, 0.0);
        }
        if (xr == 0.0 && xi == 0.0 && (yi != 0.0 || yr < 0.0)) {
            throw Py.ZeroDivisionError("0.0 to a negative or complex power");
        }
        int iexp = (int)yr;
        if (yi == 0.0 && yr == (double)iexp && iexp >= -128 && iexp <= 128) {
            return PyComplex.ipow(value, iexp);
        }
        double abs = Math.hypot(xr, xi);
        double len = Math.pow(abs, yr);
        double at = Math.atan2(xi, xr);
        double phase = at * yr;
        if (yi != 0.0) {
            len /= Math.exp(at * yi);
            phase += yi * Math.log(abs);
        }
        return new PyComplex(len * Math.cos(phase), len * Math.sin(phase));
    }

    public PyObject __neg__() {
        return this.complex___neg__();
    }

    final PyObject complex___neg__() {
        return new PyComplex(-this.real, -this.imag);
    }

    public PyObject __pos__() {
        return this.complex___pos__();
    }

    final PyObject complex___pos__() {
        if (this.getType() == TYPE) {
            return this;
        }
        return new PyComplex(this.real, this.imag);
    }

    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    public PyObject __abs__() {
        return this.complex___abs__();
    }

    final PyObject complex___abs__() {
        return new PyFloat(Math.hypot(this.real, this.imag));
    }

    public PyObject __int__() {
        return this.complex___int__();
    }

    final PyInteger complex___int__() {
        throw Py.TypeError("can't convert complex to int; use e.g. int(abs(z))");
    }

    public PyObject __long__() {
        return this.complex___long__();
    }

    final PyObject complex___long__() {
        throw Py.TypeError("can't convert complex to long; use e.g. long(abs(z))");
    }

    public PyFloat __float__() {
        return this.complex___float__();
    }

    final PyFloat complex___float__() {
        throw Py.TypeError("can't convert complex to float; use e.g. abs(z)");
    }

    public PyComplex __complex__() {
        return new PyComplex(this.real, this.imag);
    }

    public PyComplex conjugate() {
        return this.complex_conjugate();
    }

    final PyComplex complex_conjugate() {
        return new PyComplex(this.real, -this.imag);
    }

    final PyTuple complex___getnewargs__() {
        return new PyTuple(new PyComplex(this.real, this.imag));
    }

    public PyTuple __getnewargs__() {
        return this.complex___getnewargs__();
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    static {
        PyType.addBuilder(PyComplex.class, new PyComplex$PyExposer());
        TYPE = PyType.fromClass(PyComplex.class);
        J = new PyComplex(0.0, 1.0);
    }

    public class PyComplex$complex_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex_toString_exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyComplex$complex_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            String string = ((PyComplex)this.self).complex_toString();
            return string == null ? Py.None : Py.newString(string);
        }
    }

    public class PyComplex$complex___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___nonzero___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__nonzero__() <==> x != 0";
        }

        public PyComplex$complex___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__nonzero__() <==> x != 0";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyComplex)this.self).complex___nonzero__());
        }
    }

    public class PyComplex$complex___ge___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___ge___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__ge__(y) <==> x>=y";
        }

        public PyComplex$complex___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__ge__(y) <==> x>=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___ge___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___ge__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___lt___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___lt___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__lt__(y) <==> x<y";
        }

        public PyComplex$complex___lt___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__lt__(y) <==> x<y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___lt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___lt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___add___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___add___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__add__(y) <==> x+y";
        }

        public PyComplex$complex___add___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__add__(y) <==> x+y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___add___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___add__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rsub___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rsub___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__rsub__(y) <==> y-x";
        }

        public PyComplex$complex___rsub___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rsub__(y) <==> y-x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___rsub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rsub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___mul___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__mul__(y) <==> x*y";
        }

        public PyComplex$complex___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__mul__(y) <==> x*y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rmul___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rmul___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__rmul__(y) <==> y*x";
        }

        public PyComplex$complex___rmul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rmul__(y) <==> y*x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___rmul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rmul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rfloordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rfloordiv___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__rfloordiv__(y) <==> y//x";
        }

        public PyComplex$complex___rfloordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rfloordiv__(y) <==> y//x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___rfloordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rfloordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rtruediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rtruediv___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__rtruediv__(y) <==> y/x";
        }

        public PyComplex$complex___rtruediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rtruediv__(y) <==> y/x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___rtruediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rtruediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rmod___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__rmod__(y) <==> y%x";
        }

        public PyComplex$complex___rmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rmod__(y) <==> y%x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___rmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___divmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___divmod___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__divmod__(y) <==> divmod(x, y)";
        }

        public PyComplex$complex___divmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__divmod__(y) <==> divmod(x, y)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___divmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___divmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___pos___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___pos___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__pos__() <==> +x";
        }

        public PyComplex$complex___pos___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__pos__() <==> +x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___pos___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___pos__();
        }
    }

    public class PyComplex$complex___abs___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___abs___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__abs__() <==> abs(x)";
        }

        public PyComplex$complex___abs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__abs__() <==> abs(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___abs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___abs__();
        }
    }

    public class PyComplex$complex___getnewargs___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___getnewargs___exposer(String string) {
            super(string, 1, 1);
            this.doc = "";
        }

        public PyComplex$complex___getnewargs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___getnewargs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___getnewargs__();
        }
    }

    public class PyComplex$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyComplex.complex_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyComplex$PyExposer
    extends BaseTypeBuilder {
        public PyComplex$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyComplex$complex_toString_exposer("__repr__"), new PyComplex$complex_toString_exposer("__str__"), new PyComplex$complex___hash___exposer("__hash__"), new PyComplex$complex___nonzero___exposer("__nonzero__"), new PyComplex$complex___eq___exposer("__eq__"), new PyComplex$complex___ne___exposer("__ne__"), new PyComplex$complex___ge___exposer("__ge__"), new PyComplex$complex___gt___exposer("__gt__"), new PyComplex$complex___le___exposer("__le__"), new PyComplex$complex___lt___exposer("__lt__"), new PyComplex$complex___coerce___exposer("__coerce__"), new PyComplex$complex___add___exposer("__add__"), new PyComplex$complex___radd___exposer("__radd__"), new PyComplex$complex___sub___exposer("__sub__"), new PyComplex$complex___rsub___exposer("__rsub__"), new PyComplex$complex___mul___exposer("__mul__"), new PyComplex$complex___rmul___exposer("__rmul__"), new PyComplex$complex___div___exposer("__div__"), new PyComplex$complex___rdiv___exposer("__rdiv__"), new PyComplex$complex___floordiv___exposer("__floordiv__"), new PyComplex$complex___rfloordiv___exposer("__rfloordiv__"), new PyComplex$complex___truediv___exposer("__truediv__"), new PyComplex$complex___rtruediv___exposer("__rtruediv__"), new PyComplex$complex___mod___exposer("__mod__"), new PyComplex$complex___rmod___exposer("__rmod__"), new PyComplex$complex___divmod___exposer("__divmod__"), new PyComplex$complex___rdivmod___exposer("__rdivmod__"), new PyComplex$complex___pow___exposer("__pow__"), new PyComplex$complex___rpow___exposer("__rpow__"), new PyComplex$complex___neg___exposer("__neg__"), new PyComplex$complex___pos___exposer("__pos__"), new PyComplex$complex___abs___exposer("__abs__"), new PyComplex$complex___int___exposer("__int__"), new PyComplex$complex___long___exposer("__long__"), new PyComplex$complex___float___exposer("__float__"), new PyComplex$complex_conjugate_exposer("conjugate"), new PyComplex$complex___getnewargs___exposer("__getnewargs__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyComplex$imag_descriptor(), new PyComplex$real_descriptor()};
            super("complex", PyComplex.class, Object.class, true, pyBuiltinMethodArray, pyDataDescrArray, new PyComplex$exposed___new__());
        }
    }
}

