/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import scalasca.cubex.cube.Cartesian;
import scalasca.cubex.cube.Cnode;
import scalasca.cubex.cube.Cube;
import scalasca.cubex.cube.Location;
import scalasca.cubex.cube.LocationGroup;
import scalasca.cubex.cube.LocationGroupType;
import scalasca.cubex.cube.LocationType;
import scalasca.cubex.cube.datalayout.data.value.CubeTauAtomicMetric;
import scalasca.cubex.cube.datalayout.data.value.ValueType;
import scalasca.cubex.cube.errors.BadCubeReportLayoutException;
import scalasca.cubex.cube.errors.BadSyntaxException;
import scalasca.cubex.cube.errors.NotEnumeratedCnodeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeDataSource
extends DataSource {
    private File file;
    private Cube cube = null;
    private Group defaultGroup;
    private Group callpathGroup;
    private Metric calls = new Metric();
    private boolean calls_are_in_cube = false;
    private Map<Cnode, Function> cube2tau_cnodes = new HashMap<Cnode, Function>();
    private Map<Location, Thread> cube2tau_threads = new HashMap<Location, Thread>();
    private Map<scalasca.cubex.cube.Metric, Metric> cube2tau_metrics = new HashMap<scalasca.cubex.cube.Metric, Metric>();
    private Map<Function, Function> parentMap = new HashMap<Function, Function>();
    private Map<Function, Function> flatMap = new HashMap<Function, Function>();
    private double progress_value = 0.0;
    private String progress_message = "";

    public CubeDataSource(File file) {
        this.file = file;
        this.calls.setName("Number of calls");
        this.defaultGroup = this.addGroup("CUBE_DEFAULT");
        this.callpathGroup = this.addGroup("CUBE_CALLPATH");
    }

    public static FileFilter getFilesFilter() {
        return Cube.getCubeFilesFilter();
    }

    @Override
    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        try {
            Comparable<Function> comparable;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            long l = System.currentTimeMillis();
            this.progress_message = "Start loading...";
            this.cube = new Cube();
            this.progress_message = "Cube object created...";
            this.cube.openCubeReport(this.file.getPath());
            this.progress_message = "Construct TAU dimensions out of CUBE dimensions...";
            this.progress_value = 0.3;
            ArrayList arrayList = this.cube.get_metv();
            ArrayList arrayList2 = this.cube.get_root_metv();
            ArrayList arrayList3 = this.cube.get_cnodev();
            ArrayList arrayList4 = this.cube.get_root_cnodev();
            ArrayList arrayList5 = this.cube.get_location_groupv();
            ArrayList arrayList6 = this.cube.get_locationv();
            ArrayList arrayList7 = this.cube.get_cartv();
            ArrayList<scalasca.cubex.cube.Metric> arrayList8 = new ArrayList<scalasca.cubex.cube.Metric>();
            ArrayList<scalasca.cubex.cube.Metric> arrayList9 = new ArrayList<scalasca.cubex.cube.Metric>();
            this.progress_message = "Construct TAU metrics out of CUBE metrics...";
            this.progress_value = 0.32;
            for (Object object5 : arrayList2) {
                this.addMetrics(arrayList8, arrayList9, (scalasca.cubex.cube.Metric)object5, "");
            }
            this.progress_message = "Construct TAU functions out of CUBE calltree...";
            this.progress_value = 0.34;
            for (Object object5 : arrayList4) {
                this.addCnodes((Cnode)object5, "");
            }
            this.progress_message = "Construct TAU threads out of CUBE system tree...";
            this.progress_value = 0.36;
            for (Object object5 : arrayList5) {
                this.addProcess((LocationGroup)object5);
            }
            this.progress_message = "Construct TAU topologies out of CUBE topologies...";
            this.progress_value = 0.4;
            int n = 1;
            for (Cartesian cartesian : arrayList7) {
                if (cartesian.get_ndim() != 3 && JOptionPane.showConfirmDialog(null, new String("Topology " + n + "( " + cartesian.get_name() + ") has different number of coordinates (" + cartesian.get_ndim() + ") than 3. \n Visualization of this topology will fail. \n Add to TAU profile anyway?"), "Not supported topologies are detected", 0) == 1) continue;
                String string = "Topo" + n;
                this.getMetaData().put(string + " Name", cartesian.get_name());
                this.getMetaData().put(string + " Size", this.createDimString(cartesian.get_dimv()));
                this.getMetaData().put(string + " isTorus", this.createPeriodicityString(cartesian.get_periodv()));
                for (scalasca.cubex.cube.Metric metric : arrayList6) {
                    this.addThreadCoordinates(string, cartesian, (Location)metric);
                }
                ++n;
            }
            this.progress_message = "Cube object filled with data...";
            this.progress_value = 0.55;
            double d = 0.4 / (double)(this.calls_are_in_cube ? arrayList.size() : arrayList.size() + 1);
            int n2 = 0;
            for (scalasca.cubex.cube.Metric metric : arrayList9) {
                this.progress_message = "Load data from CUBE to TAU for metric: " + metric.getDisplayName() + " ( " + ++n2 + "/" + arrayList9.size() + ")";
                for (Location location : arrayList3) {
                    for (Location location2 : arrayList6) {
                        double d2 = this.cube.get_sev(metric, (Cnode)location, location2);
                        object4 = this.cube2tau_threads.get(location2);
                        if (object4 == null) continue;
                        object3 = this.cube2tau_cnodes.get(location);
                        object2 = ((Thread)object4).getFunctionProfile((Function)object3);
                        object = this.cube2tau_metrics.get(metric);
                        if (object2 == null) {
                            object2 = new FunctionProfile((Function)object3, this.getNumberOfMetrics());
                            ((Thread)object4).addFunctionProfile((FunctionProfile)object2);
                        }
                        this.addValueToProfile((Metric)object, (FunctionProfile)object2, (Function)object3, (Thread)object4, d2 * (double)(metric.getUOM().equalsIgnoreCase("sec") ? 1000000 : 1));
                    }
                }
                this.progress_value += d;
            }
            if (!this.calls_are_in_cube) {
                this.progress_message = "Create visits for TAU (becuse Cube is missing the metric \"Visits\")";
                for (scalasca.cubex.cube.Metric metric : arrayList3) {
                    for (Location location : arrayList6) {
                        double d3 = 1.0;
                        Thread thread = this.cube2tau_threads.get(location);
                        if (thread == null) continue;
                        comparable = this.cube2tau_cnodes.get(metric);
                        object4 = thread.getFunctionProfile((Function)comparable);
                        if (object4 == null) {
                            object4 = new FunctionProfile((Function)comparable, this.getNumberOfMetrics());
                            thread.addFunctionProfile((FunctionProfile)object4);
                        }
                        this.addValueToProfile(this.calls, (FunctionProfile)object4, (Function)comparable, thread, d3);
                    }
                }
                this.progress_value += d;
            }
            n2 = 0;
            for (scalasca.cubex.cube.Metric metric : arrayList8) {
                this.progress_message = "Load context events " + metric.getDisplayName() + " from CUBE to TAU :  ( " + ++n2 + "/" + arrayList8.size() + ")";
                for (Location location : arrayList3) {
                    for (Location location2 : arrayList6) {
                        CubeTauAtomicMetric cubeTauAtomicMetric = (CubeTauAtomicMetric)this.cube.get_sev_adv(metric, (Cnode)location, location2);
                        if (cubeTauAtomicMetric.getN() == 0.0) continue;
                        comparable = this.cube2tau_threads.get(location2);
                        object4 = this.cube2tau_cnodes.get(location);
                        object3 = metric.getDisplayName() + " : " + ((Function)object4).toString();
                        object2 = this.addUserEvent((String)object3);
                        object = ((Thread)comparable).getUserEventProfile((UserEvent)object2);
                        if (object != null) continue;
                        object = new UserEventProfile((UserEvent)object2);
                        ((Thread)comparable).addUserEventProfile((UserEventProfile)object);
                        ((UserEventProfile)object).setNumSamples(cubeTauAtomicMetric.getN());
                        ((UserEventProfile)object).setMaxValue(cubeTauAtomicMetric.getMax());
                        ((UserEventProfile)object).setMinValue(cubeTauAtomicMetric.getMin());
                        ((UserEventProfile)object).setMeanValue(cubeTauAtomicMetric.getAvg());
                        ((UserEventProfile)object).setSumSquared(cubeTauAtomicMetric.getSum2());
                        ((UserEventProfile)object).updateMax();
                    }
                }
                this.progress_value += d;
            }
            this.progress_message = "Postprocessing...(releade memory)";
            this.cube = null;
            arrayList = null;
            arrayList2 = null;
            arrayList3 = null;
            arrayList4 = null;
            arrayList5 = null;
            arrayList6 = null;
            arrayList7 = null;
            this.cube2tau_cnodes = null;
            this.cube2tau_metrics = null;
            this.cube2tau_threads = null;
            this.parentMap = null;
            this.flatMap = null;
            arrayList8 = null;
            arrayList9 = null;
            System.gc();
            this.progress_message = "Postprocessing...(set group names)";
            this.setGroupNamesPresent(true);
            this.progress_message = "Generate derived data...";
            this.progress_value = 0.95;
            this.generateDerivedData();
            this.progress_value = 1.0;
            this.progress_message = "Generate derived data...done";
            l = System.currentTimeMillis() - l;
        }
        catch (BadSyntaxException badSyntaxException) {
            throw new DataSourceException((Exception)((Object)badSyntaxException));
        }
        catch (NotEnumeratedCnodeException notEnumeratedCnodeException) {
            throw new DataSourceException((Exception)((Object)notEnumeratedCnodeException));
        }
        catch (BadCubeReportLayoutException badCubeReportLayoutException) {
            throw new DataSourceException((Exception)((Object)badCubeReportLayoutException));
        }
    }

    void addValueToProfile(Metric metric, FunctionProfile functionProfile, Function function, Thread thread, double d) {
        if (metric == this.calls) {
            functionProfile.setNumCalls(d);
        } else {
            functionProfile.setExclusive(metric.getID(), d);
        }
        if (function.isCallPathFunction()) {
            FunctionProfile functionProfile2 = this.getFlatFunctionProfile(thread, function);
            if (metric == this.calls) {
                functionProfile2.setNumCalls(functionProfile2.getNumCalls() + d);
            } else {
                functionProfile2.setExclusive(metric.getID(), d + functionProfile2.getExclusive(metric.getID()));
            }
        }
        if (metric == this.calls) {
            this.addCallsToParent(thread, functionProfile, d);
        } else {
            this.addToInclusive(metric, thread, functionProfile, d);
        }
    }

    private FunctionProfile getFlatFunctionProfile(Thread thread, Function function) {
        Object object;
        if (!function.isCallPathFunction()) {
            return null;
        }
        Function function2 = this.flatMap.get(function);
        if (function2 == null) {
            object = function.getName().substring(function.getName().lastIndexOf("=>") + 2).trim();
            function2 = this.addFunction((String)object);
            function2.addGroup(this.defaultGroup);
            this.flatMap.put(function, function2);
        }
        if ((object = thread.getFunctionProfile(function2)) == null) {
            object = new FunctionProfile(function2, this.getNumberOfMetrics());
            thread.addFunctionProfile((FunctionProfile)object);
        }
        return object;
    }

    private FunctionProfile getParent(Thread thread, Function function) {
        Object object;
        if (!function.isCallPathFunction()) {
            return null;
        }
        Function function2 = this.parentMap.get(function);
        if (function2 == null) {
            object = function.getName();
            String string = ((String)object).substring(0, ((String)object).lastIndexOf("=>"));
            function2 = this.getFunction(string);
            this.parentMap.put(function, function2);
        }
        object = thread.getFunctionProfile(function2);
        return object;
    }

    private void addToInclusive(Metric metric, Thread thread, FunctionProfile functionProfile, double d) {
        FunctionProfile functionProfile2;
        functionProfile.setInclusive(metric.getID(), d + functionProfile.getInclusive(metric.getID()));
        FunctionProfile functionProfile3 = this.getFlatFunctionProfile(thread, functionProfile.getFunction());
        if (functionProfile3 != null) {
            functionProfile3.setInclusive(metric.getID(), d + functionProfile3.getInclusive(metric.getID()));
        }
        if ((functionProfile2 = this.getParent(thread, functionProfile.getFunction())) != null) {
            this.addToInclusive(metric, thread, functionProfile2, d);
        }
    }

    private void addCallsToParent(Thread thread, FunctionProfile functionProfile, double d) {
        FunctionProfile functionProfile2 = this.getParent(thread, functionProfile.getFunction());
        if (functionProfile2 != null) {
            functionProfile2.setNumSubr(functionProfile2.getNumSubr() + d);
            FunctionProfile functionProfile3 = this.getFlatFunctionProfile(thread, functionProfile2.getFunction());
            if (functionProfile3 != null) {
                functionProfile3.setNumSubr(functionProfile3.getNumSubr() + d);
            }
        }
    }

    @Override
    public int getProgress() {
        if (this.cube == null) {
            return 0;
        }
        if (this.cube.isLoading()) {
            return (int)(this.cube.getProgress() * 30.0);
        }
        return (int)(this.progress_value * 100.0);
    }

    public String getProgressMessage() {
        if (this.cube == null) {
            return "";
        }
        if (this.cube.isLoading()) {
            return this.cube.getProgressMessage();
        }
        return this.progress_message;
    }

    @Override
    public void cancelLoad() {
    }

    private void addMetrics(ArrayList<scalasca.cubex.cube.Metric> arrayList, ArrayList<scalasca.cubex.cube.Metric> arrayList2, scalasca.cubex.cube.Metric metric, String string) {
        String string2;
        String string3 = string2 = string + metric.getDisplayName();
        String string4 = string2.toUpperCase();
        if (metric.getDType().equalsIgnoreCase(ValueType.TAU_ATOMIC_METRIC.toString())) {
            arrayList.add(metric);
        } else {
            arrayList2.add(metric);
            if (string4.indexOf("TIME") != -1 && metric.getUOM().toUpperCase().equals("OCC")) {
                string3 = string3 + "_count";
            }
            if (metric.getUniqName().equalsIgnoreCase("visits")) {
                this.cube2tau_metrics.put(metric, this.calls);
                this.calls_are_in_cube = true;
            } else {
                Metric object = this.addMetric(string3);
                this.cube2tau_metrics.put(metric, object);
            }
        }
        if (metric.getNumberOfChildren() != 0) {
            string2 = string2 + " => ";
        }
        for (Object object : metric.getAllChildren().toArray()) {
            this.addMetrics(arrayList, arrayList2, (scalasca.cubex.cube.Metric)object, string2);
        }
    }

    private void addCnodes(Cnode cnode, String string) {
        Object object2;
        String string2 = string + cnode.getRegion().getName();
        for (Object object2 : cnode.get_str_parameters().keySet()) {
            string2 = string2 + " < " + (String)object2 + " > = < " + cnode.get_str_parameter((String)object2) + " > ";
        }
        for (Object object2 : cnode.get_num_parameters().keySet()) {
            string2 = string2 + " < " + (String)object2 + " > = < " + cnode.get_num_parameter((String)object2) + " > ";
        }
        String string3 = string2;
        object2 = this.addFunction(string3);
        this.cube2tau_cnodes.put(cnode, (Function)object2);
        if (string.equals("")) {
            ((Function)object2).addGroup(this.defaultGroup);
        } else {
            ((Function)object2).addGroup(this.callpathGroup);
        }
        if (cnode.getNumberOfChildren() != 0) {
            string2 = string2 + " => ";
        }
        for (Object object3 : cnode.getAllChildren().toArray()) {
            this.addCnodes((Cnode)object3, string2);
        }
    }

    private void addProcess(LocationGroup locationGroup) {
        if (locationGroup.getType() != LocationGroupType.PROCESS) {
            return;
        }
        Node node = this.addNode((int)locationGroup.getRank());
        Context context = node.addContext(0);
        int n = 0;
        for (Object object : locationGroup.getAllChildren().toArray()) {
            this.addThread((Location)object, context, n);
            ++n;
        }
    }

    private void addThread(Location location, Context context, int n) {
        if (location.getType() != LocationType.CPU_THREAD) {
            return;
        }
        Thread thread = context.addThread(n, this.getNumberOfMetrics());
        for (Map.Entry entry : location.get_attrs().entrySet()) {
            thread.getMetaData().put((String)entry.getKey(), (String)entry.getValue());
        }
        this.cube2tau_threads.put(location, thread);
    }

    private String createDimString(ArrayList<Integer> arrayList) {
        String string = "(";
        int n = 0;
        for (Integer n2 : arrayList) {
            string = string + n2;
            if (n < arrayList.size() - 1) {
                string = string + ",";
            }
            ++n;
        }
        string = string + ")";
        return string;
    }

    private String createPeriodicityString(ArrayList<Boolean> arrayList) {
        String string = "(";
        int n = 0;
        for (Boolean bl : arrayList) {
            string = string + (bl == true ? "1" : "0");
            if (n < arrayList.size() - 1) {
                string = string + ",";
            }
            ++n;
        }
        string = string + ")";
        return string;
    }

    private String createCoordinatesString(ArrayList<Integer> arrayList) {
        String string = "(";
        int n = 0;
        for (Integer n2 : arrayList) {
            string = string + n2;
            if (n < arrayList.size() - 1) {
                string = string + ",";
            }
            ++n;
        }
        string = string + ")";
        return string;
    }

    private void addThreadCoordinates(String string, Cartesian cartesian, Location location) {
        ArrayList arrayList = cartesian.get_coordv(location);
        Thread thread = this.cube2tau_threads.get(location);
        if (thread == null) {
            return;
        }
        if (arrayList.size() == 0) {
            thread.getMetaData().put(string + " Coords", "()");
        } else {
            thread.getMetaData().put(string + " Coords", this.createCoordinatesString(arrayList));
        }
    }
}

