/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class DarshanDataSource
extends DataSource {
    private int linenumber = 0;
    private boolean inData = false;
    private int nprocs = 1;
    private File[] files;

    public static void main(String[] stringArray) {
        String string = "/home/wspear/Code/darshan-2.2.4/darshan-util/darshan.log";
        File[] fileArray = new File[]{new File(string)};
        DarshanDataSource darshanDataSource = new DarshanDataSource(fileArray);
        try {
            darshanDataSource.load();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public DarshanDataSource(File[] fileArray) {
        this.files = fileArray;
    }

    public DarshanDataSource(File file) {
        if (this.files == null) {
            this.files = new File[1];
        }
        this.files[0] = file;
    }

    public void cancelLoad() {
    }

    public int getProgress() {
        return 0;
    }

    public void load() throws FileNotFoundException, IOException {
        long l = System.currentTimeMillis();
        Object var3_2 = null;
        Object var4_3 = null;
        String string = null;
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            this.addMetric("Time");
            this.linenumber = 0;
            while ((string = bufferedReader.readLine()) != null) {
                int n = (string = string.trim()).length();
                if (n == 0) continue;
                if (string.startsWith("#")) {
                    this.processComment(string);
                } else if (string.startsWith("t")) {
                    this.processTotal(string);
                } else if (this.inData) {
                    this.processCounter(string);
                }
                ++this.linenumber;
            }
        }
        this.generateDerivedData();
        l = System.currentTimeMillis() - l;
        System.out.println("Done processing data!");
        System.out.println("Time to process (in milliseconds): " + l);
    }

    private void processComment(String string) {
        if (string.startsWith("#<rank>")) {
            this.inData = true;
        }
    }

    private void processTotal(String string) {
    }

    private void processCounter(String string) {
        Integer n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Darshan Data Source Could Not Process: " + string);
            return;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        Double d = Double.parseDouble(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        if (this.nprocs == 1 && n == -1) {
            n = 0;
        }
        MetaDataMap metaDataMap = null;
        Node node = null;
        Context context = null;
        Thread thread = null;
        if (n == -1) {
            metaDataMap = this.getMetaData();
        } else {
            node = this.addNode(n);
            context = node.addContext(0);
            thread = context.addThread(0);
            metaDataMap = this.getThread(n, 0, 0).getMetaData();
        }
        metaDataMap.put("Darshan Filename", string2);
        metaDataMap.put("Darshan Mountpoint : " + string2, string4);
        metaDataMap.put("Darshan FS Type : " + string4, string4);
        if (string3.endsWith("_TIMESTAMP")) {
            metaDataMap.put("Darshan " + string3 + " : " + string2, d.toString());
        }
        if (string3.endsWith("_DEVICE")) {
            metaDataMap.put("Darshan " + string3 + " : " + string2, d.toString());
        } else if (string3.endsWith("_TIME")) {
            Function function = this.addFunction(string3, 1);
            function.addGroup(this.addGroup("DARSHAN"));
            FunctionProfile functionProfile = new FunctionProfile(function);
            thread.addFunctionProfile(functionProfile);
            functionProfile.setInclusive(0, d);
            functionProfile.setExclusive(0, d);
            functionProfile.setNumCalls(1.0);
        } else {
            UserEvent userEvent = this.addUserEvent(string3);
            UserEventProfile userEventProfile = new UserEventProfile(userEvent);
            thread.addUserEventProfile(userEventProfile);
            userEventProfile.setNumSamples(1.0);
            userEventProfile.setMaxValue(d);
            userEventProfile.setMinValue(d);
            userEventProfile.setMeanValue(d);
            userEventProfile.setSumSquared(0.0);
            userEventProfile.updateMax();
        }
    }
}

