/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EBSTraceReader {
    private static String reader_version = "0.2";
    private DataSource dataSource;
    private Map<String, Map<String, Integer>> sampleMap = new HashMap<String, Map<String, Integer>>();
    private int node = -1;
    private int tid = -1;
    private static boolean showCallSites = false;

    public EBSTraceReader(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private void addSample(String string, String string2) {
        Map<String, Integer> map = this.sampleMap.get(string2);
        if (map != null) {
            Integer n = map.get(string);
            if (n != null) {
                map.put(string, new Integer(n + 1));
            } else {
                map.put(string, new Integer(1));
            }
        } else {
            map = new HashMap<String, Integer>();
            map.put(string, new Integer(1));
            this.sampleMap.put(string2, map);
        }
    }

    private void addIntermediateNodes(Thread thread, String string, int n, double d, Group group, Group group2) {
        String[] stringArray = string.split("=>");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        String string2 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + " => " + stringArray[i];
            Function function = this.dataSource.addFunction(string2);
            function.addGroup(group);
            function.addGroup(group2);
            FunctionProfile functionProfile = thread.getOrCreateFunctionProfile(function, this.dataSource.getNumberOfMetrics());
            if (functionProfile.getNumCalls() != 0.0) continue;
            functionProfile.setInclusive(n, functionProfile.getInclusive(n) + d);
        }
    }

    private void processMap() {
        Thread thread = this.dataSource.getThread(this.node, 0, this.tid);
        Group group = this.dataSource.addGroup("TAU_CALLPATH");
        Group group2 = this.dataSource.addGroup("TAU_SAMPLE");
        for (String string : this.sampleMap.keySet()) {
            Map<String, Integer> map = this.sampleMap.get(string);
            int n = 0;
            Object object = map.values().iterator();
            while (object.hasNext()) {
                int n2 = object.next();
                n += n2;
            }
            object = this.dataSource.getFunction(string = Utility.removeRuns((String)string));
            if (object == null) {
                System.err.println("Error: callpath not found in profile: \"" + string + "\"");
                continue;
            }
            FunctionProfile functionProfile = thread.getFunctionProfile((Function)object);
            FunctionProfile functionProfile2 = null;
            if (string.lastIndexOf("=>") != -1) {
                String string2 = string.substring(string.lastIndexOf("=>") + 2).trim();
                Function function = this.dataSource.getFunction(string2);
                if (function == null) {
                    System.err.println("Error: function not found in profile: " + string2);
                    continue;
                }
                functionProfile2 = thread.getFunctionProfile(function);
            }
            for (int i = 0; i < this.dataSource.getNumberOfMetrics(); ++i) {
                double d = functionProfile.getExclusive(i);
                double d2 = d / (double)n;
                functionProfile.setExclusive(i, 0.0);
                if (functionProfile2 != null) {
                    functionProfile2.setExclusive(i, 0.0);
                }
                for (String string3 : map.keySet()) {
                    int n3 = map.get(string3);
                    double d3 = d2 * (double)n3;
                    String string4 = string + " => " + string3;
                    Function function = this.dataSource.addFunction(string4);
                    function.addGroup(group);
                    function.addGroup(group2);
                    FunctionProfile functionProfile3 = thread.getOrCreateFunctionProfile(function, this.dataSource.getNumberOfMetrics());
                    functionProfile3.setInclusive(i, functionProfile3.getInclusive(i) + d3);
                    functionProfile3.setExclusive(i, functionProfile3.getExclusive(i) + d3);
                    functionProfile3.setNumCalls(functionProfile3.getNumCalls() + (double)n3);
                    this.addIntermediateNodes(thread, string4, i, d3, group, group2);
                    if (string4.lastIndexOf("=>") == -1) continue;
                    String string5 = UtilFncs.getRightMost(string4);
                    Function function2 = this.dataSource.addFunction(string5);
                    function2.addGroup(group2);
                    FunctionProfile functionProfile4 = thread.getOrCreateFunctionProfile(function2, this.dataSource.getNumberOfMetrics());
                    functionProfile4.setInclusive(i, functionProfile4.getInclusive(i) + d3);
                    functionProfile4.setExclusive(i, functionProfile4.getExclusive(i) + d3);
                    functionProfile4.setNumCalls(functionProfile4.getNumCalls() + (double)n3);
                }
            }
        }
    }

    private static String stripFileLine(String string) {
        try {
            int n = string.lastIndexOf(58);
            int n2 = string.lastIndexOf(58, n - 1);
            return "[INTERMEDIATE] " + string.substring(0, n2);
        }
        catch (Exception exception) {
            System.out.println("Location = " + string);
            exception.printStackTrace();
            return string;
        }
    }

    private static String stripPath(String string) {
        try {
            int n = string.lastIndexOf(58);
            int n2 = string.lastIndexOf(58, n - 1);
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, n);
            String string4 = string.substring(n + 1);
            String string5 = string3.substring(string3.lastIndexOf("/") + 1);
            return string2 + "[{" + string5 + "} {" + string4 + ",1}]";
        }
        catch (Exception exception) {
            System.out.println("Location = " + string);
            exception.printStackTrace();
            return string;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(EBSTraceReader.stripFileLine("foo:bar.cc:2060"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processEBSTrace(DataSource dataSource, File file) {
        try {
            this.sampleMap.clear();
            this.node = -1;
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            while (true) {
                String string2;
                Object object;
                if (string == null) {
                    this.processMap();
                    return;
                }
                if (string.startsWith("#")) {
                    if (string.startsWith("# Format version:") && !((String)(object = string.substring("# Format version:".length() + 1).trim())).equals(reader_version)) {
                        string2 = "Wrong EBS version, we are looking for " + reader_version + ", but found " + (String)object;
                        System.err.println(string2);
                        throw new RuntimeException(string2);
                    }
                    if (string.startsWith("# node:")) {
                        object = string.substring(8);
                        this.node = Integer.parseInt((String)object);
                        if (this.tid != -1) {
                            // empty if block
                        }
                    }
                    if (string.startsWith("# thread:")) {
                        object = string.substring(10);
                        this.tid = Integer.parseInt((String)object);
                        if (this.node == -1) {
                            // empty if block
                        }
                    }
                } else {
                    object = string.split("\\|");
                    string2 = object[4].trim();
                    String string3 = object[5].trim();
                    if (!string3.startsWith("??:")) {
                        try {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            String[] stringArray = string3.split("@");
                            int n = stringArray.length;
                            if (n > 1) {
                                --n;
                            }
                            for (int i = 0; i < n; ++i) {
                                if (showCallSites) {
                                    arrayList.add(stringArray[i]);
                                    continue;
                                }
                                if (i == 0) {
                                    arrayList.add(EBSTraceReader.stripPath(stringArray[i]));
                                    arrayList.add(EBSTraceReader.stripFileLine(stringArray[i]));
                                    continue;
                                }
                                arrayList.add(EBSTraceReader.stripFileLine(stringArray[i]));
                            }
                            Collections.reverse(arrayList);
                            String string4 = null;
                            for (String string5 : arrayList) {
                                if (string4 == null) {
                                    string4 = string5;
                                    continue;
                                }
                                string4 = string4 + " => " + string5;
                            }
                            this.addSample(string4, string2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            System.out.println(string);
                        }
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            String string;
            exception.printStackTrace();
            if (exception instanceof IOException) return;
            if (exception instanceof FileNotFoundException) return;
            if (exception == null) {
                string = null;
                throw new RuntimeException(string);
            }
            string = exception.toString();
            throw new RuntimeException(string);
        }
    }

    public static void processEBSTraces(DataSource dataSource, File file) {
        long l = System.currentTimeMillis();
        if (!file.isDirectory()) {
            return;
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("ebstrace.processed.");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        EBSTraceReader eBSTraceReader = new EBSTraceReader(dataSource);
        for (int i = 0; i < fileArray.length; ++i) {
            eBSTraceReader.processEBSTrace(dataSource, fileArray[i]);
        }
        l = System.currentTimeMillis() - l;
    }
}

