/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.GPTLFileFilter;
import edu.uoregon.tau.perfdmf.MultiFileFilter;
import edu.uoregon.tau.perfdmf.ProfileFileFilter;
import edu.uoregon.tau.perfdmf.RangeProfileFilter;
import edu.uoregon.tau.perfdmf.TimeSeriesFileFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileList {
    boolean useRange = false;
    String range = null;

    public FileList(String string) {
        this.range = string;
        if (string != null && string.trim().length() > 0) {
            this.useRange = true;
        }
    }

    public FileList() {
    }

    public List<File[]> helperFindProfilesPrefixMulti(String string, String string2) {
        ArrayList<File[]> arrayList = new ArrayList<File[]>();
        File file = new File(string);
        if (!file.isDirectory()) {
            return arrayList;
        }
        FilenameFilter filenameFilter = this.useRange ? new RangeProfileFilter(string2, this.range) : new ProfileFileFilter(string2);
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray.length == 0) {
            MultiFileFilter multiFileFilter = new MultiFileFilter();
            File[] fileArray2 = file.listFiles(multiFileFilter);
            for (int i = 0; i < fileArray2.length; ++i) {
                File[] fileArray3 = fileArray2[i].listFiles(filenameFilter);
                arrayList.add(fileArray3);
            }
        } else {
            arrayList.add(fileArray);
            return arrayList;
        }
        return arrayList;
    }

    public File[] helperFindProfilesPrefix(String string, String string2) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return new File[0];
        }
        FilenameFilter filenameFilter = this.useRange ? new RangeProfileFilter(string2, this.range) : new ProfileFileFilter(string2);
        File[] fileArray = file.listFiles(filenameFilter);
        return fileArray;
    }

    public List<File[]> helperFindTimeSeriesProfilesPrefix(String string, String string2) {
        ArrayList<File[]> arrayList = new ArrayList<File[]>();
        File file = new File(string);
        if (!file.isDirectory()) {
            return arrayList;
        }
        FilenameFilter filenameFilter = this.useRange ? new RangeProfileFilter(string2, this.range) : new ProfileFileFilter(string2);
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray.length == 0) {
            TimeSeriesFileFilter timeSeriesFileFilter = new TimeSeriesFileFilter();
            File[] fileArray2 = file.listFiles(timeSeriesFileFilter);
            List<File> list = Arrays.asList(fileArray2);
            Collections.sort(list);
            fileArray2 = list.toArray(fileArray2);
            for (int i = 0; i < fileArray2.length; ++i) {
                File[] fileArray3 = fileArray2[i].listFiles(filenameFilter);
                arrayList.add(fileArray3);
            }
        } else {
            arrayList.add(fileArray);
            return arrayList;
        }
        return arrayList;
    }

    public List<File[]> helperFindTimeSeriesProfiles(String string) {
        List<File[]> list = this.helperFindTimeSeriesProfilesPrefix(string, "profile");
        if (list.size() == 0) {
            list = this.helperFindTimeSeriesProfilesPrefix(string, "dump");
        }
        return list;
    }

    public List<File[]> helperFindProfiles(String string) {
        List<File[]> list = this.helperFindProfilesPrefixMulti(string, "profile");
        if (list.size() == 0) {
            list = this.helperFindProfilesPrefixMulti(string, "dump");
        }
        return list;
    }

    public List<File[]> helperFindGPTLProfiles(String string) {
        ArrayList<File[]> arrayList = new ArrayList<File[]>();
        File file = new File(string);
        if (!file.isDirectory()) {
            return arrayList;
        }
        String string2 = "";
        for (File file2 : file.listFiles()) {
            if (!file2.getName().endsWith("_stats")) continue;
            File[] fileArray = new File[]{file2};
            arrayList.add(fileArray);
            string2 = file2.getName().replace("_stats", "");
            break;
        }
        GPTLFileFilter gPTLFileFilter = new GPTLFileFilter(string2);
        File[] fileArray = file.listFiles(gPTLFileFilter);
        arrayList.add(fileArray);
        return arrayList;
    }

    public File[] helperFindSnapshots(String string) {
        return this.helperFindProfilesPrefix(string, "snapshot");
    }

    public static String getPathReverse(String string) {
        String string2 = System.getProperty("file.separator");
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            string3 = string4 + string2 + string3;
        }
        return string3;
    }
}

