/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Parameter;
import edu.uoregon.tau.perfdmf.SourceRegion;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Function
implements Serializable,
Comparable<Function> {
    private static final long serialVersionUID = 362090098221172924L;
    private String name;
    private String short_name;
    private String reversedName;
    private int id = -1;
    private List<Group> groups = new ArrayList<Group>();
    private boolean phase = false;
    private Function actualPhase;
    private Function parentPhase;
    private int databaseID = 0;
    boolean callpathFunction = false;
    boolean callpathFunctionSet = false;
    private FunctionProfile meanProfile;
    private FunctionProfile stddevProfile;
    private FunctionProfile totalProfile;
    private FunctionProfile minProfile;
    private FunctionProfile maxProfile;
    private FunctionProfile meanAllProfile;
    private FunctionProfile stddevAllProfile;
    private boolean colorFlag = false;
    private Color color = null;
    private Color specificColor = null;
    private SourceRegion sourceLink;

    public Function(String string, int n, int n2) {
        this.name = string;
        this.setID(n);
    }

    public int getID() {
        return this.id;
    }

    public int getDatabaseID() {
        return this.databaseID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.reversedName = null;
    }

    public String getCallpathNodeName() {
        if (!this.isCallPathFunction()) {
            return this.name;
        }
        String string = this.name;
        int n = string.lastIndexOf("=>");
        return string.substring(n + 3);
    }

    public String getReversedName() {
        if (this.reversedName == null) {
            if (!this.isCallPathFunction()) {
                this.reversedName = this.name;
            } else {
                String string = this.name;
                int n = string.lastIndexOf("=>");
                this.reversedName = "";
                while (n != -1) {
                    String string2 = string.substring(n + 3, string.length());
                    string2 = string2.trim();
                    this.reversedName = this.reversedName + string2;
                    if ((n = (string = string.substring(0, n)).lastIndexOf("=>")) == -1) continue;
                    this.reversedName = this.reversedName + " <= ";
                }
                this.reversedName = this.reversedName + " <= " + string;
            }
        }
        return this.reversedName.trim();
    }

    public String toString() {
        return this.name;
    }

    public SourceRegion getSourceLink() {
        if (this.sourceLink == null) {
            if (Function.isCallPathFunction(this.name)) {
                String string = this.name;
                SourceRegion sourceRegion = Function.getSourceLink(UtilFncs.getRightMost(string));
                int n = sourceRegion.getStartLine();
                while (n <= -1) {
                    sourceRegion = Function.getSourceLink(UtilFncs.getRightMost(string));
                    n = sourceRegion.getStartLine();
                    String string2 = string;
                    if (!(string = UtilFncs.getAllButRightMost(string)).equals(string2)) continue;
                    break;
                }
                this.sourceLink = sourceRegion;
            } else {
                this.sourceLink = Function.getSourceLink(this.name);
            }
        }
        return this.sourceLink;
    }

    public static SourceRegion getSourceLink(String string) {
        Comparable<File> comparable;
        String string2;
        int n;
        int n2;
        int n3;
        int n4;
        SourceRegion sourceRegion = new SourceRegion();
        sourceRegion.setShortName(string);
        if (string.indexOf("OpenMP location:") != -1) {
            n4 = string.indexOf("file:");
            n3 = string.indexOf("<");
            n2 = string.indexOf(",");
            n = string.indexOf(">");
            sourceRegion.setShortName(string.substring(0, n4));
            string2 = string.substring(n4 + 5, n3).trim();
            comparable = new File(string2);
            if (!comparable.exists() && string2.contains("/")) {
                string2 = string2.substring(string2.lastIndexOf("/") + 1);
            }
            sourceRegion.setFilename(string2);
            sourceRegion.setStartLine(Integer.parseInt(string.substring(n3 + 1, n2).trim()));
            sourceRegion.setEndLine(Integer.parseInt(string.substring(n2 + 1, n).trim()));
        }
        if (string.indexOf("file:") != -1 && string.indexOf("line:") != -1) {
            string = string.substring(string.lastIndexOf("["));
            n4 = string.indexOf("file:");
            n3 = string.indexOf("line:");
            String string3 = string.substring(n4 + 5, n3).trim();
            sourceRegion.setFilename(string3);
            n = string.indexOf("]", n3) != -1 ? Integer.parseInt(string.substring(n3 + 5, string.indexOf("]"))) : Integer.parseInt(string.substring(n3 + 5).trim());
            sourceRegion.setStartLine(n);
            sourceRegion.setEndLine(n);
            return sourceRegion;
        }
        if (Function.isCallPathFunction(string)) {
            string = string.substring(string.lastIndexOf("=>") + 2);
        }
        if (string.startsWith("!$omp")) {
            n4 = string.lastIndexOf(64);
            n3 = string.lastIndexOf(58);
            if (n4 < 0 || n3 < 0 || n3 < n4) {
                return sourceRegion;
            }
            String string4 = string.substring(n4 + 1, n3);
            String string5 = string.substring(n3 + 1);
            sourceRegion.setFilename(string4);
            int n5 = Integer.parseInt(string5);
            sourceRegion.setStartLine(n5);
            sourceRegion.setEndLine(n5);
            return sourceRegion;
        }
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        n3 = string.indexOf("[ <");
        while (n3 != -1) {
            n2 = string.indexOf("> = <", n3);
            String string6 = string.substring(n3 + 3, n2).trim();
            n3 = string.indexOf("<", n2);
            n2 = string.indexOf(">", n3);
            string2 = string.substring(n3 + 1, n2).trim();
            comparable = new Parameter(string6, string2, -1);
            arrayList.add((Parameter)comparable);
            n3 = string.indexOf(", <", n2);
        }
        sourceRegion.setParameters(arrayList);
        n2 = string.indexOf("[{");
        if (n2 == -1) {
            return sourceRegion;
        }
        n = string.indexOf("}", n2);
        if (n == -1) {
            return sourceRegion;
        }
        int n6 = string.indexOf("{", n + 1);
        sourceRegion.setShortName(string.substring(0, n2).trim());
        int n7 = string.indexOf(",", n + 1);
        int n8 = string.indexOf("}", n + 1);
        int n9 = string.indexOf("-", n8 + 1);
        int n10 = string.indexOf("{", n6 + 1);
        int n11 = string.indexOf(",", n7 + 1);
        int n12 = string.indexOf("}", n8 + 1);
        String string7 = string.substring(n2 + 2, n);
        File file = new File(string7);
        if (!file.exists()) {
            string7 = string7.substring(string7.lastIndexOf("/") + 1);
        }
        sourceRegion.setFilename(string7);
        if (n6 == -1) {
            return sourceRegion;
        }
        if (n7 > n8) {
            n7 = -1;
        }
        if (n9 > n12) {
            n9 = -1;
        }
        if (n9 == -1) {
            if (n7 == -1) {
                if (n8 != -1) {
                    int n13 = Integer.parseInt(string.substring(n6 + 1, n8));
                    sourceRegion.setStartLine(n13);
                    sourceRegion.setEndLine(n13);
                    return sourceRegion;
                }
                return sourceRegion;
            }
            String string8 = string.substring(n6 + 1, n7);
            int n14 = Integer.parseInt(string8);
            sourceRegion.setStartLine(n14);
            sourceRegion.setEndLine(n14);
            return sourceRegion;
        }
        if (n6 == -1 || n10 == -1 || n7 == -1 || n11 == -1 || n8 == -1 || n12 == -1) {
            return sourceRegion;
        }
        int n15 = Integer.parseInt(string.substring(n6 + 1, n7));
        int n16 = Integer.parseInt(string.substring(n7 + 1, n8));
        int n17 = Integer.parseInt(string.substring(n10 + 1, n11));
        int n18 = Integer.parseInt(string.substring(n11 + 1, n12));
        sourceRegion.setStartLine(n15);
        sourceRegion.setStartColumn(n16);
        sourceRegion.setEndLine(n17);
        sourceRegion.setEndColumn(n18);
        return sourceRegion;
    }

    public static boolean isCallPathFunction(String string) {
        return string.indexOf("=>") > 0;
    }

    public void addGroup(Group group) {
        if (this.isGroupMember(group)) {
            return;
        }
        this.groups.add(group);
    }

    public void removeGroup(Group group) {
        if (this.isGroupMember(group)) {
            this.groups.remove(group);
        }
    }

    public boolean isGroupMember(Group group) {
        return this.groups.contains(group);
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public String getGroupString() {
        String string = "";
        for (int i = 0; i < this.groups.size(); ++i) {
            Group group = this.groups.get(i);
            string = i == 0 ? group.getName() : string + " | " + group.getName();
        }
        return string;
    }

    public boolean isPhaseMember(Function function) {
        if (function == this) {
            return true;
        }
        if (function == null) {
            return true;
        }
        if (!this.isCallPathFunction()) {
            return false;
        }
        int n = this.name.indexOf("=>");
        String string = this.name.substring(0, n).trim();
        return string.compareTo(function.getName()) == 0;
    }

    public boolean isGroupMember(String string) {
        for (Group group : this.groups) {
            if (!group.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isCallPathFunction() {
        if (!this.callpathFunctionSet) {
            this.callpathFunction = Function.isCallPathFunction(this.name);
            this.callpathFunctionSet = true;
        }
        return this.callpathFunction;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        if (this.colorFlag) {
            return this.specificColor;
        }
        return this.color;
    }

    public void setColorFlag(boolean bl) {
        this.colorFlag = bl;
    }

    public boolean isColorFlagSet() {
        return this.colorFlag;
    }

    public void setSpecificColor(Color color) {
        this.specificColor = color;
    }

    public void setStddevProfile(FunctionProfile functionProfile) {
        this.stddevProfile = functionProfile;
    }

    public void setStddevAllProfile(FunctionProfile functionProfile) {
        this.stddevAllProfile = functionProfile;
    }

    public FunctionProfile getStddevProfile() {
        return this.stddevProfile;
    }

    public FunctionProfile getStddevAllProfile() {
        return this.stddevAllProfile;
    }

    public void setMeanProfile(FunctionProfile functionProfile) {
        this.meanProfile = functionProfile;
    }

    public FunctionProfile getMeanProfile() {
        return this.meanProfile;
    }

    public void setMeanAllProfile(FunctionProfile functionProfile) {
        this.meanAllProfile = functionProfile;
    }

    public FunctionProfile getMeanAllProfile() {
        return this.meanAllProfile;
    }

    public double getMeanInclusive(int n) {
        return this.meanProfile.getInclusive(n);
    }

    public double getMeanExclusive(int n) {
        return this.meanProfile.getExclusive(n);
    }

    public double getMeanInclusivePercent(int n) {
        return this.meanProfile.getInclusivePercent(n);
    }

    public double getMeanExclusivePercent(int n) {
        return this.meanProfile.getExclusivePercent(n);
    }

    public double getMeanNumCalls() {
        return this.meanProfile.getNumCalls();
    }

    public double getMeanNumSubr() {
        return this.meanProfile.getNumSubr();
    }

    public double getMeanInclusivePerCall(int n) {
        return this.meanProfile.getInclusivePerCall(n);
    }

    public double getTotalInclusive(int n) {
        return this.totalProfile.getInclusive(n);
    }

    public double getTotalExclusive(int n) {
        return this.totalProfile.getExclusive(n);
    }

    public double getTotalInclusivePercent(int n) {
        return this.totalProfile.getInclusivePercent(n);
    }

    public double getTotalExclusivePercent(int n) {
        return this.totalProfile.getExclusivePercent(n);
    }

    public double getTotalNumCalls() {
        return this.totalProfile.getNumCalls();
    }

    public double getTotalNumSubr() {
        return this.totalProfile.getNumSubr();
    }

    public double getTotalInclusivePerCall(int n) {
        return this.totalProfile.getInclusivePerCall(n);
    }

    public void setTotalProfile(FunctionProfile functionProfile) {
        this.totalProfile = functionProfile;
    }

    public FunctionProfile getTotalProfile() {
        return this.totalProfile;
    }

    public FunctionProfile getMinProfile() {
        return this.minProfile;
    }

    public void setMinProfile(FunctionProfile functionProfile) {
        this.minProfile = functionProfile;
    }

    public FunctionProfile getMaxProfile() {
        return this.maxProfile;
    }

    public void setMaxProfile(FunctionProfile functionProfile) {
        this.maxProfile = functionProfile;
    }

    @Override
    public int compareTo(Function function) {
        return this.getID() - function.getID();
    }

    public boolean isPhase() {
        return this.phase;
    }

    public void setPhase(boolean bl) {
        this.phase = bl;
    }

    public Function getActualPhase() {
        return this.actualPhase;
    }

    public void setActualPhase(Function function) {
        this.actualPhase = function;
    }

    public Function getParentPhase() {
        return this.parentPhase;
    }

    public void setParentPhase(Function function) {
        this.parentPhase = function;
    }

    public void setSourceRegion(SourceRegion sourceRegion) {
        this.sourceLink = sourceRegion;
        if (sourceRegion.getShortName() == null) {
            this.sourceLink = Function.getSourceLink(this.name);
        }
        if (this.short_name == null) {
            this.short_name = this.sourceLink.getShortName();
        }
    }

    public String getShortName() {
        return this.short_name;
    }

    public void setShortName(String string) {
        if (string == null) {
            System.out.println("null short name");
        }
        this.short_name = string;
    }

    public void setDatabaseID(int n) {
        this.databaseID = n;
    }

    public void setID(int n) {
        this.id = n;
    }
}

