/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.TrackerInputStream;
import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPTLDataSource
extends DataSource {
    private File file = null;
    private GlobalData globalData = null;
    private volatile int totalFiles = 0;
    private volatile int filesRead = 0;
    private volatile long totalBytes = 0L;
    private volatile TrackerInputStream tracker;
    private List<File[]> dirs;
    private boolean oneFile = false;
    private File globalFile = null;
    private boolean isPAPI = false;
    private List<String> dataColumns = new ArrayList<String>();
    private int currentProcess = 0;
    private File fileToMonitor;

    public GPTLDataSource(File file) {
        this.file = file;
        this.oneFile = true;
    }

    public GPTLDataSource(List<?> list) {
        if (list.size() > 0) {
            if (list.get(0) instanceof File[]) {
                this.dirs = list;
                File[] fileArray = (File[])list.get(0);
                if (fileArray.length > 0) {
                    this.fileToMonitor = fileArray[0];
                }
            } else {
                this.dirs = new ArrayList<File[]>();
                File[] fileArray = new File[]{(File)list.get(0)};
                this.dirs.add(fileArray);
                this.fileToMonitor = fileArray[0];
            }
        }
    }

    @Override
    public void cancelLoad() {
    }

    @Override
    public int getProgress() {
        if (this.oneFile) {
            if (this.totalBytes != 0L) {
                return (int)((float)this.tracker.byteCount() / (float)this.totalBytes * 100.0f);
            }
        } else if (this.totalFiles != 0) {
            return (int)((float)this.filesRead / (float)this.totalFiles * 100.0f);
        }
        return 0;
    }

    @Override
    public void load() throws FileNotFoundException, IOException {
        if (this.oneFile) {
            this.loadOneFile();
        } else {
            this.loadMultipleFiles();
        }
    }

    public void loadOneFile() throws FileNotFoundException, IOException {
        long l = System.currentTimeMillis();
        Node node = null;
        Context context = null;
        Thread thread = null;
        FileInputStream fileInputStream = new FileInputStream(this.file);
        this.tracker = new TrackerInputStream((InputStream)fileInputStream);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this.tracker);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.totalBytes = this.file.length();
        this.globalData = this.processGlobalSection(bufferedReader);
        List<ThreadData> list = this.processThreadData(bufferedReader);
        for (ThreadData threadData : list) {
            node = this.addNode(threadData.processid);
            context = node.addContext(0);
            thread = context.addThread(threadData.threadid);
            for (int i = 0; i < threadData.eventData.size(); ++i) {
                EventData eventData = threadData.eventData.get(i);
                this.createFunction(thread, eventData, false);
                if (i <= 0) continue;
                this.createFunction(thread, eventData, true);
            }
        }
        this.generateDerivedData();
        this.setGroupNamesPresent(true);
        l = System.currentTimeMillis() - l;
        fileInputStream.close();
    }

    public void loadMultipleFiles() throws FileNotFoundException, IOException {
        long l = System.currentTimeMillis();
        for (File[] object2 : this.dirs) {
            for (int i = 0; i < object2.length; ++i) {
                ++this.totalFiles;
                if (!object2[i].getName().endsWith("_stats")) continue;
                this.globalFile = object2[i];
            }
        }
        Object object3 = null;
        Object var4_4 = null;
        Thread thread = null;
        this.file = this.globalFile;
        FileInputStream fileInputStream = new FileInputStream(this.file);
        this.tracker = new TrackerInputStream((InputStream)fileInputStream);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this.tracker);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.totalBytes = this.file.length();
        this.globalData = this.processGlobalSection(bufferedReader);
        fileInputStream.close();
        for (File[] fileArray : this.dirs) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.file = fileArray[i];
                if (this.file.getName().endsWith("_stats")) continue;
                fileInputStream = new FileInputStream(this.file);
                this.tracker = new TrackerInputStream((InputStream)fileInputStream);
                inputStreamReader = new InputStreamReader((InputStream)this.tracker);
                bufferedReader = new BufferedReader(inputStreamReader);
                this.totalBytes = this.file.length();
                List<ThreadData> list = this.processThreadData(bufferedReader);
                for (ThreadData threadData : list) {
                    object3 = this.addNode(threadData.processid);
                    Context context = ((Node)object3).addContext(0);
                    thread = context.addThread(threadData.threadid);
                    for (int j = 0; j < threadData.eventData.size(); ++j) {
                        EventData eventData = threadData.eventData.get(j);
                        this.createFunction(thread, eventData, false);
                        if (eventData.callpathName.equals(eventData.name)) continue;
                        this.createFunction(thread, eventData, true);
                    }
                }
                fileInputStream.close();
            }
            this.setGroupNamesPresent(true);
            l = System.currentTimeMillis() - l;
        }
        this.generateDerivedData();
    }

    private void createFunction(Thread thread, EventData eventData, boolean bl) {
        Function function = null;
        FunctionProfile functionProfile = null;
        if (bl) {
            function = this.addFunction(eventData.callpathName);
            function.addGroup(this.addGroup("TAU_DEFAULT"));
            function.addGroup(this.addGroup("TAU_CALLPATH"));
        } else {
            function = this.addFunction(eventData.name);
            function.addGroup(this.addGroup("TAU_DEFAULT"));
        }
        functionProfile = new FunctionProfile(function, 3 + 2 * this.globalData.metrics.size());
        thread.addFunctionProfile(functionProfile);
        functionProfile.setNumCalls(eventData.calls);
        functionProfile.setNumSubr(eventData.children.size());
        Measurements measurements = eventData.inclusive;
        Measurements measurements2 = eventData.getExclusive();
        Metric metric = this.addMetric("WALL_CLOCK_TIME", thread);
        functionProfile.setInclusive(metric.getID(), measurements.wallclock * 1000000.0);
        functionProfile.setExclusive(metric.getID(), measurements2.wallclock * 1000000.0);
        metric = this.addMetric("WALL_CLOCK_TIME max", thread);
        functionProfile.setInclusive(metric.getID(), measurements.wallclockMax * 1000000.0);
        functionProfile.setExclusive(metric.getID(), measurements.wallclockMax * 1000000.0);
        metric = this.addMetric("WALL_CLOCK_TIME min", thread);
        functionProfile.setInclusive(metric.getID(), measurements.wallclockMin * 1000000.0);
        functionProfile.setExclusive(metric.getID(), measurements.wallclockMin * 1000000.0);
        for (int i = 0; i < this.globalData.metrics.size(); ++i) {
            String string = this.globalData.metrics.get(i);
            metric = this.addMetric(string, thread);
            functionProfile.setInclusive(metric.getID(), measurements.papi[i]);
            functionProfile.setExclusive(metric.getID(), measurements2.papi[i]);
            metric = this.addMetric(string + " e6/sec", thread);
            functionProfile.setInclusive(metric.getID(), measurements.papiE6OverSeconds[i]);
            functionProfile.setExclusive(metric.getID(), measurements2.papiE6OverSeconds[i]);
        }
    }

    private GlobalData processGlobalSection(BufferedReader bufferedReader) {
        GlobalData globalData = new GlobalData();
        String string = null;
        String string2 = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                if (string.trim().startsWith("***** GLOBAL STATISTICS ")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    globalData.numTasks = Integer.parseInt(string2);
                    continue;
                }
                if (string.trim().startsWith("name")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r()");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equalsIgnoreCase("name") || string2.equalsIgnoreCase("processes") || string2.equalsIgnoreCase("threads") || string2.equalsIgnoreCase("count") || string2.equalsIgnoreCase("walltotal") || string2.equalsIgnoreCase("wallmax") || string2.equalsIgnoreCase("wallmin") || string2.equalsIgnoreCase("proc") || string2.equalsIgnoreCase("thrd")) continue;
                        if (string2.endsWith("max")) {
                            globalData.metrics.add(string2.replaceAll("max", ""));
                            continue;
                        }
                        if (!string2.endsWith("min")) continue;
                    }
                    continue;
                }
                if (string.trim().length() != 0 || globalData.metrics.size() <= 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return globalData;
    }

    private List<ThreadData> processThreadData(BufferedReader bufferedReader) {
        ArrayList<ThreadData> arrayList = new ArrayList<ThreadData>();
        ThreadData threadData = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        try {
            boolean bl2 = false;
            boolean bl3 = false;
            Stack<Object> stack = new Stack<Object>();
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                if (string.trim().startsWith("************ PROCESS")) {
                    bl3 = false;
                    object = new StringTokenizer(string, " \t\n\r()");
                    string2 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    this.currentProcess = Integer.parseInt(string2, 10);
                    continue;
                }
                if (string.trim().startsWith("Stats for thread ")) {
                    bl3 = false;
                    threadData = new ThreadData();
                    threadData.processid = this.currentProcess;
                    this.dataColumns.clear();
                    bl2 = true;
                    object = new StringTokenizer(string, " \t\n\r:");
                    string2 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    threadData.threadid = Integer.parseInt(string2);
                    continue;
                }
                if (string.trim().startsWith("On")) {
                    bl3 = false;
                    bl2 = true;
                    this.isPAPI = false;
                    this.parseDataColumns(string);
                    continue;
                }
                if (string.trim().startsWith("Called")) {
                    bl3 = false;
                    bl2 = true;
                    this.isPAPI = true;
                    this.parseDataColumns(string);
                    continue;
                }
                if (string.trim().startsWith("Overhead sum")) {
                    bl3 = false;
                    bl2 = false;
                    continue;
                }
                if (string.trim().startsWith("Total calls")) {
                    bl3 = false;
                    bl2 = false;
                    while (!stack.isEmpty()) {
                        stack.pop();
                    }
                    arrayList.add(threadData);
                    continue;
                }
                if (string.trim().startsWith("Total recursive calls")) {
                    bl3 = false;
                    bl2 = false;
                    continue;
                }
                if (string.trim().startsWith("thread")) {
                    bl3 = false;
                    bl2 = false;
                    continue;
                }
                if (string.trim().startsWith("hashtable")) {
                    bl3 = false;
                    bl2 = false;
                    continue;
                }
                if (string.trim().length() == 0) {
                    if (!bl3 || bl2) {
                        bl3 = true;
                        continue;
                    }
                    break;
                }
                if (!bl2) {
                    bl3 = false;
                    continue;
                }
                if (!bl2) continue;
                bl3 = false;
                object = this.processEventLine(string);
                threadData.eventData.add((EventData)object);
                if (stack.empty()) {
                    stack.push(object);
                    continue;
                }
                EventData eventData = (EventData)stack.peek();
                if (((EventData)object).depth > eventData.depth) {
                    eventData.children.add(object);
                    ((EventData)object).callpathName = eventData.callpathName + " => " + ((EventData)object).callpathName;
                } else if (((EventData)object).depth == eventData.depth) {
                    stack.pop();
                    if (stack.empty()) {
                        eventData = null;
                    } else {
                        eventData = (EventData)stack.peek();
                        eventData.children.add(object);
                        ((EventData)object).callpathName = eventData.callpathName + " => " + ((EventData)object).callpathName;
                    }
                } else if (((EventData)object).depth < eventData.depth) {
                    while (((EventData)object).depth <= eventData.depth) {
                        stack.pop();
                        if (stack.empty()) {
                            eventData = null;
                            break;
                        }
                        eventData = (EventData)stack.peek();
                    }
                    if (eventData != null) {
                        eventData.children.add(object);
                        ((EventData)object).callpathName = eventData.callpathName + " => " + ((EventData)object).callpathName;
                    }
                }
                stack.push(object);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return arrayList;
    }

    private void parseDataColumns(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.dataColumns.add(string2);
        }
    }

    public static String rtrim(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && Character.isWhitespace(string.charAt(n)); --n) {
        }
        return string.substring(0, n + 1);
    }

    private EventData processEventLine(String string) {
        EventData eventData = new EventData();
        string = GPTLDataSource.rtrim(string);
        String string2 = string.substring(0, 60);
        eventData.name = string2.trim();
        if (eventData.name.startsWith("*")) {
            eventData.name = eventData.name.replaceFirst("\\*", "").trim();
            eventData.depth = string.length() - string.replaceFirst("\\*", "").trim().length();
        } else {
            eventData.depth = string.length() - string.trim().length();
        }
        eventData.callpathName = eventData.name;
        String string3 = string.substring(60, string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " \t\n\r()");
        int n = 0;
        for (String string4 : this.dataColumns) {
            if (n > 0) {
                --n;
                continue;
            }
            if (string4.equalsIgnoreCase("on")) {
                stringTokenizer.nextToken();
                continue;
            }
            if (string4.equalsIgnoreCase("called")) {
                eventData.calls = Integer.parseInt(stringTokenizer.nextToken());
                continue;
            }
            if (string4.equalsIgnoreCase("recurse")) {
                stringTokenizer.nextToken();
                continue;
            }
            if (string4.equalsIgnoreCase("wallclock")) {
                eventData.inclusive.wallclock = Double.parseDouble(stringTokenizer.nextToken());
                continue;
            }
            if (string4.equalsIgnoreCase("max")) {
                eventData.inclusive.wallclockMax = Double.parseDouble(stringTokenizer.nextToken());
                continue;
            }
            if (string4.equalsIgnoreCase("min")) {
                eventData.inclusive.wallclockMin = Double.parseDouble(stringTokenizer.nextToken());
                continue;
            }
            if (string4.equalsIgnoreCase("%")) {
                stringTokenizer.nextToken();
                n = 2;
                continue;
            }
            if (string4.equalsIgnoreCase("utr")) {
                eventData.inclusive.utrOverhead = Double.parseDouble(stringTokenizer.nextToken());
                n = 1;
                continue;
            }
            if (string4.equalsIgnoreCase("OH")) {
                eventData.inclusive.ohCycles = Double.parseDouble(stringTokenizer.nextToken());
                n = 1;
                continue;
            }
            eventData.inclusive.papi = new double[this.globalData.metrics.size()];
            eventData.inclusive.papiE6OverSeconds = new double[this.globalData.metrics.size()];
            for (int i = 0; i < this.globalData.metrics.size(); ++i) {
                eventData.inclusive.papi[i] = Double.parseDouble(stringTokenizer.nextToken());
                eventData.inclusive.papiE6OverSeconds[i] = Double.parseDouble(stringTokenizer.nextToken());
                n += 2;
            }
        }
        return eventData;
    }

    private class Measurements
    implements Cloneable {
        public double wallclock;
        public double wallclockMax;
        public double wallclockMin;
        public double utrOverhead;
        public double[] papi;
        public double[] papiE6OverSeconds;
        public double ohCycles;

        private Measurements() {
        }

        public Object clone() {
            Measurements measurements = new Measurements();
            measurements.wallclock = this.wallclock;
            measurements.wallclockMax = this.wallclockMax;
            measurements.wallclockMin = this.wallclockMin;
            measurements.utrOverhead = this.utrOverhead;
            measurements.ohCycles = this.ohCycles;
            measurements.papi = new double[((GPTLDataSource)GPTLDataSource.this).globalData.metrics.size()];
            measurements.papiE6OverSeconds = new double[((GPTLDataSource)GPTLDataSource.this).globalData.metrics.size()];
            for (int i = 0; i < ((GPTLDataSource)GPTLDataSource.this).globalData.metrics.size(); ++i) {
                measurements.papi[i] = this.papi[i];
                measurements.papiE6OverSeconds[i] = this.papiE6OverSeconds[i];
            }
            return measurements;
        }
    }

    private class EventData {
        public String name;
        public String callpathName;
        public int depth;
        public int calls;
        private List<EventData> children = new ArrayList<EventData>();
        public Measurements inclusive = new Measurements();

        private EventData() {
        }

        public Measurements getExclusive() {
            int n;
            Measurements measurements = (Measurements)this.inclusive.clone();
            for (n = 0; n < this.children.size(); ++n) {
                EventData eventData = this.children.get(n);
                measurements.wallclock -= eventData.inclusive.wallclock;
                measurements.wallclockMax -= eventData.inclusive.wallclockMax;
                measurements.wallclockMin -= eventData.inclusive.wallclockMin;
                measurements.utrOverhead -= eventData.inclusive.utrOverhead;
                measurements.ohCycles -= eventData.inclusive.ohCycles;
                for (int i = 0; i < ((GPTLDataSource)GPTLDataSource.this).globalData.metrics.size(); ++i) {
                    int n2 = i;
                    measurements.papi[n2] = measurements.papi[n2] - eventData.inclusive.papi[i];
                }
            }
            measurements.wallclock = measurements.wallclock < 0.0 ? 0.0 : measurements.wallclock;
            measurements.wallclockMax = measurements.wallclockMax < 0.0 ? 0.0 : measurements.wallclockMax;
            measurements.wallclockMin = measurements.wallclockMin < 0.0 ? 0.0 : measurements.wallclockMin;
            measurements.utrOverhead = measurements.utrOverhead < 0.0 ? 0.0 : measurements.utrOverhead;
            measurements.ohCycles = measurements.ohCycles < 0.0 ? 0.0 : measurements.ohCycles;
            for (n = 0; n < ((GPTLDataSource)GPTLDataSource.this).globalData.metrics.size(); ++n) {
                measurements.papi[n] = measurements.papi[n] < 0.0 ? 0.0 : measurements.papi[n];
                measurements.papiE6OverSeconds[n] = measurements.papi[n] / 1000000.0 / measurements.wallclock;
            }
            return measurements;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    private class ThreadData {
        public List<EventData> eventData = new ArrayList<EventData>();
        public int processid = 0;
        public int threadid = 0;

        private ThreadData() {
        }
    }

    private class GlobalData {
        public int numTasks = 0;
        public List<String> metrics = new ArrayList<String>();

        private GlobalData() {
        }
    }
}

