/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.HPCToolkitXMLHandler;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class HPCToolkitDataSource
extends DataSource {
    private File file;
    private HPCToolkitXMLHandler handler = new HPCToolkitXMLHandler(this);

    public HPCToolkitDataSource(File file) {
        this.file = file;
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        try {
            FunctionProfile functionProfile;
            Object object;
            Object object2;
            Object object3;
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setContentHandler(this.handler);
            xMLReader.setErrorHandler(this.handler);
            xMLReader.parse(new InputSource(new FileInputStream(this.file)));
            for (int i = 0; i < this.getNumberOfMetrics(); ++i) {
                object3 = this.getThread(0, 0, 0);
                object2 = this.getFunctionIterator();
                while (object2.hasNext()) {
                    FunctionProfile functionProfile2;
                    object = object2.next();
                    functionProfile = ((Thread)object3).getFunctionProfile((Function)object);
                    if (functionProfile == null || (functionProfile2 = this.getParent((Thread)object3, (Function)object)) == null) continue;
                    double d = functionProfile2.getExclusive(i) - functionProfile.getInclusive(i);
                    if (d < 0.0) {
                        d = 0.0;
                    }
                    functionProfile2.setExclusive(i, d);
                }
            }
            Thread thread = this.getThread(0, 0, 0);
            object3 = this.getFunctionIterator();
            while (object3.hasNext()) {
                object2 = (Function)object3.next();
                object = thread.getFunctionProfile((Function)object2);
                if (object == null || (functionProfile = this.getFlatFunctionProfile(thread, (Function)object2)) == null) continue;
                for (int i = 0; i < this.getNumberOfMetrics(); ++i) {
                    functionProfile.setExclusive(i, functionProfile.getExclusive(i) + ((FunctionProfile)object).getExclusive(i));
                    functionProfile.setInclusive(i, functionProfile.getInclusive(i) + ((FunctionProfile)object).getInclusive(i));
                }
            }
            this.setGroupNamesPresent(true);
            this.generateDerivedData();
        }
        catch (SAXException sAXException) {
            throw new DataSourceException(sAXException);
        }
    }

    private FunctionProfile getParent(Thread thread, Function function) {
        if (!function.isCallPathFunction()) {
            return null;
        }
        String string = function.getName();
        String string2 = string.substring(0, string.lastIndexOf("=>"));
        Function function2 = this.getFunction(string2);
        FunctionProfile functionProfile = thread.getFunctionProfile(function2);
        return functionProfile;
    }

    private FunctionProfile getFlatFunctionProfile(Thread thread, Function function) {
        if (!function.isCallPathFunction()) {
            return null;
        }
        String string = function.getName().substring(function.getName().lastIndexOf("=>") + 2).trim();
        Function function2 = this.addFunction(string);
        FunctionProfile functionProfile = thread.getFunctionProfile(function2);
        if (functionProfile == null) {
            functionProfile = new FunctionProfile(function2, this.getNumberOfMetrics());
            thread.addFunctionProfile(functionProfile);
        }
        return functionProfile;
    }

    public int getProgress() {
        return 0;
    }

    public void cancelLoad() {
    }
}

