/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.FileList;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.TauDataSource;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class TimeSeriesDataSource
extends DataSource {
    private List<File[]> dirlist;
    private boolean profileStatsPresent = false;
    private boolean groupCheck = false;
    int numSnapShots;

    public TimeSeriesDataSource(File file) {
        FileList fileList = new FileList();
        this.dirlist = fileList.helperFindTimeSeriesProfiles(System.getProperty("user.dir"));
        this.numSnapShots = this.dirlist.size();
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        int n = -1;
        for (File[] fileArray : this.dirlist) {
            System.out.println("loading snapshot " + ++n);
            int n2 = n;
            this.addMetric("Snapshot " + n);
            for (int i = 0; i < fileArray.length; ++i) {
                int n3;
                int n4;
                int[] nArray = TauDataSource.getNCT(fileArray[i].getName());
                int n5 = nArray[0];
                int n6 = nArray[1];
                int n7 = nArray[2];
                Node node = this.addNode(n5);
                Context context = node.addContext(n6);
                Thread thread = context.addThread(n7, this.numSnapShots);
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = bufferedReader.readLine();
                if (string == null) {
                    throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nLooking for 'templated_functions' line");
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
                String string2 = stringTokenizer.nextToken();
                try {
                    n4 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataSourceException(fileArray[i].getName() + ": Couldn't read number of functions, bad TAU Profile?");
                }
                string = bufferedReader.readLine();
                if (string == null) {
                    throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nLooking for '# Name Calls ...' line");
                }
                if (n == 0 && string.indexOf("SumExclSqr") != -1) {
                    this.profileStatsPresent = true;
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nOnly found " + (n3 - 2) + " of " + n4 + " Function Lines");
                    }
                    this.processFunctionLine(string, thread, n2);
                }
                string = bufferedReader.readLine();
                if (string == null) {
                    throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nLooking for 'aggregates' line");
                }
                stringTokenizer = new StringTokenizer(string, " \t\n\r");
                string2 = stringTokenizer.nextToken();
                n4 = Integer.parseInt(string2);
                for (n3 = 0; n3 < n4; ++n3) {
                    string = bufferedReader.readLine();
                }
                string = bufferedReader.readLine();
                if (string != null) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r");
                    string2 = stringTokenizer.nextToken();
                    n3 = Integer.parseInt(string2);
                    bufferedReader.readLine();
                    for (int j = 0; j < n3; ++j) {
                        if (j == 0) {
                            this.setUserEventsPresent(true);
                        }
                        if ((string = bufferedReader.readLine()) == null) {
                            throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nOnly found " + (j - 2) + " of " + n3 + " User Event Lines");
                        }
                        this.processUserEventLine(string, thread);
                    }
                }
                bufferedReader.close();
                inputStreamReader.close();
                fileInputStream.close();
            }
        }
        this.generateDerivedData();
    }

    public int getProgress() {
        return 0;
    }

    public void cancelLoad() {
    }

    private void processFunctionLine(String string, Thread thread, int n) throws DataSourceException {
        StringTokenizer stringTokenizer;
        String string2;
        Object object;
        String string3 = this.getGroupNames(string);
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n2;
        }
        if (n2 == 0) {
            throw new DataSourceException("Looking for function line, found '" + string + "' instead");
        }
        if (n2 == 2 || n2 == 4) {
            object = new StringTokenizer(string, "\"");
            string2 = ((StringTokenizer)object).nextToken();
            stringTokenizer = new StringTokenizer(((StringTokenizer)object).nextToken(), " \t\n\r");
        } else {
            int n3;
            int n4 = 0;
            for (n3 = 0; n4 < n2 - 2 && n3 < string.length(); ++n3) {
                if (string.charAt(n3) != '\"') continue;
                ++n4;
            }
            string2 = string.substring(1, n3 - 1);
            stringTokenizer = new StringTokenizer(string.substring(n3 + 1), " \t\n\r");
        }
        double d = Double.parseDouble(stringTokenizer.nextToken());
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        double d3 = Double.parseDouble(stringTokenizer.nextToken());
        double d4 = Double.parseDouble(stringTokenizer.nextToken());
        if (this.profileStatsPresent) {
            // empty if block
        }
        if (d4 < 0.0) {
            System.err.println("Warning, negative values found in profile, ignoring!");
            d4 = 0.0;
        }
        if (d3 < 0.0) {
            System.err.println("Warning, negative values found in profile, ignoring!");
            d3 = 0.0;
        }
        if (d != 0.0) {
            object = this.addFunction(string2, this.numSnapShots);
            FunctionProfile functionProfile = thread.getFunctionProfile((Function)object);
            if (functionProfile == null) {
                functionProfile = new FunctionProfile((Function)object, this.numSnapShots);
                thread.addFunctionProfile(functionProfile);
            }
            functionProfile.setExclusive(n, functionProfile.getExclusive(n) + d3);
            functionProfile.setInclusive(n, functionProfile.getInclusive(n) + d4);
            if (n == 0) {
                functionProfile.setNumCalls(functionProfile.getNumCalls() + d);
                functionProfile.setNumSubr(functionProfile.getNumSubr() + d2);
            }
            if (n == 0 && string3 != null) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "|");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string4 = stringTokenizer2.nextToken();
                    if (string4 == null) continue;
                    Group group = this.addGroup(string4.trim());
                    ((Function)object).addGroup(group);
                }
            }
        }
    }

    private String getGroupNames(String string) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '\"') continue;
            ++n3;
        }
        n2 = 0;
        for (n = 0; n2 < n3 - 2 && n < string.length(); ++n) {
            if (string.charAt(n) != '\"') continue;
            ++n2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), "\"");
        String string2 = stringTokenizer.nextToken();
        if (!this.groupCheck) {
            int n4 = string2.indexOf("GROUP=");
            if (n4 > 0) {
                this.setGroupNamesPresent(true);
            }
            this.groupCheck = true;
        }
        if (this.getGroupNamesPresent()) {
            try {
                string2 = stringTokenizer.nextToken();
                return string2;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        return null;
    }

    private void processUserEventLine(String string, Thread thread) {
        StringTokenizer stringTokenizer;
        String string2;
        Object object;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n;
        }
        if (n == 2) {
            object = new StringTokenizer(string, "\"");
            string2 = ((StringTokenizer)object).nextToken();
            stringTokenizer = new StringTokenizer(((StringTokenizer)object).nextToken(), " \t\n\r");
        } else {
            int n2;
            int n3 = 0;
            for (n2 = 0; n3 < n && n2 < string.length(); ++n2) {
                if (string.charAt(n2) != '\"') continue;
                ++n3;
            }
            string2 = string.substring(1, n2 - 1);
            stringTokenizer = new StringTokenizer(string.substring(n2 + 1), " \t\n\r");
        }
        double d = Double.parseDouble(stringTokenizer.nextToken());
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        double d3 = Double.parseDouble(stringTokenizer.nextToken());
        double d4 = Double.parseDouble(stringTokenizer.nextToken());
        double d5 = Double.parseDouble(stringTokenizer.nextToken());
        if (d != 0.0) {
            object = this.addUserEvent(string2);
            UserEventProfile userEventProfile = thread.getUserEventProfile((UserEvent)object);
            if (userEventProfile == null) {
                userEventProfile = new UserEventProfile((UserEvent)object);
                thread.addUserEventProfile(userEventProfile);
            }
            userEventProfile.setNumSamples(d);
            userEventProfile.setMaxValue(d2);
            userEventProfile.setMinValue(d3);
            userEventProfile.setMeanValue(d4);
            userEventProfile.setSumSquared(d5);
            userEventProfile.updateMax();
        }
    }
}

