/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
implements Serializable {
    private static final long serialVersionUID = 7198343642137106238L;
    private static List<String> fieldNames = null;
    protected List<String> fields = new ArrayList<String>();
    private DefaultMutableTreeNode node = null;
    private View parent = null;
    private Database database;
    private int viewID = 0;
    private String whereClause = "";
    private String joinClause = "";
    private String trialID = "";
    public static final String WILDCARD = "%";
    public static final String ANY = "or";
    public static final String ALL = "and";
    public static final String GTE = ">=";
    public static final String LTE = "<=";
    public static final String STRING_ENDS = "ends with";
    public static final String STRING_CONTAINS = "contains";
    public static final String STRING_EXACTLY = "is exactly";
    public static final String STRING_NOT = "does not contain";
    public static final String STRING_BEGINS = "beings with";
    public static final String NUMBER_EQUAL = "is equal to";
    public static final String NUMBER_NOT = "is not equal to";
    public static final String NUMBER_LESS = "is less than";
    public static final String NUMBER_RANGE = "is in the range";
    public static final String NUMBER_GREATER = "is greater than";
    public static final String DATE_IS = "is";
    public static final String DATE_RANGE = "is between";
    public static final String DATE_BEFORE = "is before";
    public static final String DATE_AFTER = "is after";

    public String getTrialID() {
        return this.trialID;
    }

    public void setTrialID(String string) {
        this.trialID = string;
    }

    public String getJoinClause() {
        if (this.trialID.length() > 0) {
            return "";
        }
        return this.joinClause;
    }

    public void setJoinClause(String string) {
        this.joinClause = string;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public View getParent() {
        return this.parent;
    }

    public void setParent(View view) {
        this.parent = view;
    }

    public View() {
    }

    public View(View view) {
        for (String string : view.fields) {
            this.fields.add(string);
        }
        this.node = view.node;
        this.parent = view.parent;
        this.database = view.database;
        this.viewID = view.viewID;
    }

    public static View VirtualView(View view) {
        View view2 = new View(view);
        view2.viewID = -2;
        view2.parent = view;
        view2.fields.set(fieldNames.indexOf("NAME"), "All Trials");
        view2.fields.set(fieldNames.indexOf("PARENT"), "");
        view2.fields.set(fieldNames.indexOf("ID"), "-1");
        view2.node = null;
        return view2;
    }

    public static Iterator<String> getFieldNames(DB dB) {
        String string = "TRIAL_VIEW";
        String string2 = "trial_view";
        if (dB.getSchemaVersion() > 0) {
            string = "TAUDB_VIEW";
            string2 = "taudb_view";
        }
        if (fieldNames == null) {
            fieldNames = new ArrayList<String>();
            try {
                ResultSet resultSet = null;
                DatabaseMetaData databaseMetaData = dB.getMetaData();
                resultSet = dB.getDBType().compareTo("oracle") == 0 ? databaseMetaData.getColumns(null, null, string, WILDCARD) : (dB.getDBType().compareTo("derby") == 0 ? databaseMetaData.getColumns(null, null, string, WILDCARD) : (dB.getDBType().compareTo("h2") == 0 ? databaseMetaData.getColumns(null, null, string, WILDCARD) : (dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, string, WILDCARD) : databaseMetaData.getColumns(null, null, string2, WILDCARD))));
                while (resultSet.next()) {
                    String string3 = resultSet.getString("COLUMN_NAME").toUpperCase();
                    fieldNames.add(string3);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                System.err.println("DATABASE EXCEPTION: " + sQLException.toString());
                sQLException.printStackTrace();
            }
        }
        return fieldNames.iterator();
    }

    public static boolean isTrialCol(String string) {
        for (String string2 : TAUdbTrial.TRIAL_COLUMNS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static Iterator<String> getFieldNames() {
        return fieldNames.iterator();
    }

    public static int getFieldCount() {
        return fieldNames.size();
    }

    public void addField(String string) {
        this.fields.add(string);
    }

    public String getField(String string) {
        int n = fieldNames.indexOf(string.toUpperCase());
        if (n == -1) {
            return new String("");
        }
        if (this.fields == null) {
            return "";
        }
        return this.fields.get(n);
    }

    public String getField(int n) {
        return this.fields.get(n);
    }

    public static String getFieldName(int n) {
        return fieldNames.get(n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (fieldNames == null) {
            fieldNames = (List)objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(fieldNames);
    }

    public String toString() {
        return this.getField("NAME");
    }

    public void setDMTN(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.node = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDMTN() {
        return this.node;
    }

    public static List<View> getViews(int n, DB dB) {
        ArrayList<View> arrayList = new ArrayList<View>();
        try {
            Iterator<String> iterator;
            String string = "trial_view";
            if (dB.getSchemaVersion() > 0) {
                string = "taudb_view";
            }
            if (!(iterator = View.getFieldNames(dB)).hasNext()) {
                throw new Exception("The Database is not modified to support views.");
            }
            StringBuilder stringBuilder = new StringBuilder("select ");
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                stringBuilder.append(iterator.next());
            }
            stringBuilder.append(" from " + string);
            if (n != -1) {
                if (n == 0) {
                    stringBuilder.append(" where parent is null");
                } else {
                    stringBuilder.append(" where parent = ");
                    stringBuilder.append(n);
                }
            }
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                View view = new View();
                view.setDatabase(dB.getDatabase());
                for (int i = 1; i <= View.getFieldCount(); ++i) {
                    view.addField(resultSet.getString(i));
                }
                arrayList.add(view);
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select views from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Trial> getTrialsForView(List<View> list, boolean bl, DB dB) {
        int n;
        StringBuilder stringBuilder;
        List<Trial> list2 = null;
        if (dB.getSchemaVersion() > 0) {
            list2 = View.getTrialsForTAUdbView(list, dB);
        } else {
            list2 = new ArrayList<Trial>();
            try {
                stringBuilder = new StringBuilder();
                stringBuilder.append(" inner join application a on e.application = a.id ");
                if (list.size() > 0) {
                    stringBuilder.append(" where ");
                    for (n = 0; n < list.size(); ++n) {
                        void object2;
                        Object object;
                        String string;
                        if (n > 0) {
                            stringBuilder.append(" AND ");
                        }
                        if ((string = ((View)(object = list.get(n))).getWhereClause(dB.getDBType())).trim().startsWith("where")) {
                            String string2 = string.substring(string.indexOf("where") + 5);
                        }
                        stringBuilder.append((String)object2);
                    }
                }
                list2 = Trial.getTrialList(dB, stringBuilder.toString(), bl);
            }
            catch (Exception exception) {
                String string = "ERROR: Couldn't select views from the database!";
                System.err.println(string);
                exception.printStackTrace();
            }
        }
        stringBuilder = new StringBuilder();
        n = 0;
        for (Trial trial : list2) {
            if (n != 0) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("(");
            }
            stringBuilder.append(trial.trialID);
            n = 1;
        }
        if (n != 0) {
            stringBuilder.append(")");
        }
        for (View view : list) {
            view.setTrialID(stringBuilder.toString());
        }
        return list2;
    }

    public static List<Trial> getTrialsForTAUdbView(List<View> list, DB dB) {
        return View.getTrialsForTAUdbView(list, dB, false);
    }

    public static List<Trial> getTrialsForTAUdbView(List<View> list, DB dB, boolean bl) {
        HashMap<Integer, View> hashMap = new HashMap<Integer, View>();
        if (list.size() == 0) {
            List<View> list2 = View.getViews(0, dB);
            if (list2.size() > 0) {
                list.add((View)list2.get(0));
            } else {
                return null;
            }
        }
        for (View view : list) {
            hashMap.put(view.getID(), view);
        }
        return View.getTrialsForTAUdbView(list, hashMap, dB, bl);
    }

    private static List<Trial> getTrialsForTAUdbView(List<View> list, HashMap<Integer, View> hashMap, DB dB) {
        return View.getTrialsForTAUdbView(list, hashMap, dB, false);
    }

    public static ResultSet getViewParameters(DB dB, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select conjoin, taudb_view, table_name, column_name, operator, value from taudb_view left outer join taudb_view_parameter on taudb_view.id = taudb_view_parameter.taudb_view where taudb_view.id in (");
        stringBuilder.append("?");
        stringBuilder.append(") order by taudb_view.id");
        try {
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
            int n2 = 1;
            preparedStatement.setInt(n2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            return resultSet;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    private static List<Trial> getTrialsForTAUdbView(List<View> list, HashMap<Integer, View> hashMap, DB dB, boolean bl) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select conjoin, taudb_view, table_name, column_name, operator, value from taudb_view left outer join taudb_view_parameter on taudb_view.id = taudb_view_parameter.taudb_view where taudb_view.id in (");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(",?");
                    continue;
                }
                stringBuilder.append("?");
            }
            stringBuilder.append(") order by taudb_view.id");
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
            int n = 1;
            for (View serializable2 : list) {
                preparedStatement.setInt(n, Integer.valueOf(serializable2.getField("ID")));
                ++n;
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            int n2 = 0;
            int n3 = 0;
            String string = " where ((";
            boolean bl2 = false;
            while (resultSet.next()) {
                int n4 = resultSet.getInt(2);
                String string2 = resultSet.getString(3);
                if (string2 == null) break;
                bl2 = true;
                String string3 = resultSet.getString(4);
                String string4 = resultSet.getString(5);
                String string5 = resultSet.getString(6);
                if (n2 > 0 && n2 != n4) {
                    string = ") and ((";
                } else if (n2 == n4) {
                    string = " " + resultSet.getString(1) + " (";
                }
                if (string2.equalsIgnoreCase("trial")) {
                    stringBuilder2.append(string + "t." + string3 + " " + string4 + " " + "'" + string5 + "'");
                } else {
                    stringBuilder3.append(" left outer join " + string2 + " t" + n3 + " on t.id = t" + n3 + ".trial and ");
                    stringBuilder3.append("t" + n3 + ".name = '" + string3 + "' ");
                    stringBuilder2.append(string + " t" + n3 + ".value " + string4 + " '" + string5 + "' ");
                }
                stringBuilder2.append(")");
                ++n3;
                n2 = n4;
                hashMap.get(n2).setWhereClause(stringBuilder2.toString());
                hashMap.get(n2).setJoinClause(stringBuilder3.toString());
            }
            if (bl2) {
                stringBuilder2.append(")");
            }
            preparedStatement.close();
            return Trial.getTrialList(dB, stringBuilder3.toString() + " " + stringBuilder2.toString(), bl);
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select views from the database!";
            System.err.println(string);
            exception.printStackTrace();
            return null;
        }
    }

    public int getID() {
        if (this.viewID == 0) {
            this.viewID = Integer.valueOf(this.getField("ID"));
        }
        return this.viewID;
    }

    public void setID(int n) {
        this.viewID = n;
    }

    public void setField(String string, String string2) {
        String string3 = string.toUpperCase();
        int n = fieldNames.indexOf(string3);
        this.setField(n, string2);
    }

    public void setField(int n, String string) {
        int[] nArray = this.database.getAppFieldTypes();
        this.fields.set(n, string);
    }

    public void rename(DB dB, String string) {
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("UPDATE " + dB.getSchemaPrefix() + "taudb_view SET name = ? WHERE id = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, this.getID());
            preparedStatement.executeUpdate();
            this.setField("NAME", string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public int saveView(DB dB) throws SQLException {
        int n;
        int n2;
        boolean bl = false;
        PreparedStatement preparedStatement = dB.prepareStatement("SELECT name FROM " + dB.getSchemaPrefix() + "taudb_view WHERE id = ?");
        preparedStatement.setInt(1, this.getID());
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("UPDATE " + dB.getSchemaPrefix() + "taudb_view SET ");
            for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                if (View.getFieldName(n2).equals("ID")) continue;
                stringBuffer.append(", " + View.getFieldName(n2) + " = ?");
            }
            stringBuffer.append(" WHERE id = ?");
        } else {
            stringBuffer.append("INSERT INTO " + dB.getSchemaPrefix() + "taudb_view (name");
            for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                if (View.getFieldName(n2).equals("ID")) continue;
                stringBuffer.append(", " + View.getFieldName(n2));
            }
            stringBuffer.append(") VALUES (?");
            for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                if (View.getFieldName(n2).equals("ID")) continue;
                stringBuffer.append(", ?");
            }
            stringBuffer.append(")");
        }
        preparedStatement = dB.prepareStatement(stringBuffer.toString());
        n2 = 1;
        for (n = 0; n < this.getNumFields(); ++n) {
            if (View.getFieldName(n).equals("ID")) continue;
            preparedStatement.setString(n2++, this.getField(n));
        }
        if (bl) {
            preparedStatement.setInt(n2++, this.getID());
        }
        preparedStatement.executeUpdate();
        preparedStatement.close();
        n = 0;
        if (bl) {
            n = this.getID();
        } else {
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM taudb_view" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'taudb_view'" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM taudb_view" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM taudb_view" : (dB.getDBType().compareTo("oracle") == 0 ? "SELECT " + dB.getSchemaPrefix() + "taudb_view_id_seq.currval FROM DUAL" : "select currval('taudb_view_id_seq');")))));
            n = Integer.parseInt(dB.getDataItem(string));
        }
        return n;
    }

    public static int createView(DB dB, String string, boolean bl, int n, List<ViewRule> list) throws SQLException {
        String string2 = ALL;
        if (!bl) {
            string2 = ANY;
        }
        int n2 = View.saveView(dB, string, string2, n);
        for (ViewRule viewRule : list) {
            View.saveViewRule(dB, n2, viewRule);
        }
        return n2;
    }

    public static int saveView(DB dB, String string, String string2, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO " + dB.getSchemaPrefix() + "taudb_view  (parent, name, conjoin) ");
        stringBuffer.append(" VALUES (?,?,?)");
        PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
        if (n >= 0) {
            preparedStatement.setInt(1, n);
        } else {
            preparedStatement.setNull(1, 4);
        }
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        String string3 = new String();
        string3 = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM taudb_view" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'taudb_view'" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM taudb_view" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM taudb_view" : (dB.getDBType().compareTo("oracle") == 0 ? "SELECT " + dB.getSchemaPrefix() + "taudb_view_id_seq.currval FROM DUAL" : "select currval('taudb_view_id_seq');")))));
        return Integer.parseInt(dB.getDataItem(string3));
    }

    public static void saveViewRule(DB dB, int n, ViewRule viewRule) throws SQLException {
        if (viewRule.getOperator().equals(NUMBER_RANGE)) {
            View.saveViewParameter(dB, n, viewRule.getTable_name(), viewRule.getColumn_name(), GTE, viewRule.getValue());
            View.saveViewParameter(dB, n, viewRule.getTable_name(), viewRule.getColumn_name(), LTE, viewRule.getValue2());
        } else {
            View.saveViewParameter(dB, n, viewRule.getTable_name(), viewRule.getColumn_name(), viewRule.getOperator(), viewRule.getValue());
        }
    }

    public static void saveViewParameter(DB dB, int n, String string, String string2, String string3, String string4) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO " + dB.getSchemaPrefix() + "taudb_view_parameter   (taudb_view, table_name, column_name, operator, value) ");
        stringBuffer.append(" VALUES (?,?,?,?,?)");
        PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        preparedStatement.setString(4, string3);
        preparedStatement.setString(5, string4);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public static void clearViewParameters(DB dB, int n) throws SQLException {
        PreparedStatement preparedStatement = dB.prepareStatement("DELETE FROM " + dB.getSchemaPrefix() + "taudb_view_parameter WHERE taudb_view = ?");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public static void deleteView(int n, DB dB) throws SQLException {
        ArrayList<Integer> arrayList = View.getAllChildern(n, dB);
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        preparedStatement = dB.prepareStatement("DELETE FROM " + dB.getSchemaPrefix() + "taudb_view WHERE id = ?");
        preparedStatement2 = dB.prepareStatement("DELETE FROM " + dB.getSchemaPrefix() + "taudb_view_parameter WHERE taudb_view = ?");
        preparedStatement.setInt(1, n);
        preparedStatement.addBatch();
        preparedStatement2.setInt(1, n);
        preparedStatement2.addBatch();
        for (Integer n2 : arrayList) {
            preparedStatement.setInt(1, n2);
            preparedStatement.addBatch();
            preparedStatement2.setInt(1, n2);
            preparedStatement2.addBatch();
        }
        preparedStatement2.executeBatch();
        preparedStatement.executeBatch();
    }

    public static ArrayList<Integer> getAllChildern(int n, DB dB) throws SQLException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        View.getAllChildern(n, dB, arrayList);
        return arrayList;
    }

    private static void getAllChildern(int n, DB dB, ArrayList<Integer> arrayList) throws SQLException {
        PreparedStatement preparedStatement = dB.prepareStatement(" SELECT id FROM " + dB.getSchemaPrefix() + "taudb_view WHERE parent = ?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            arrayList.add(n2);
            View.getAllChildern(n2, dB, arrayList);
        }
    }

    public int getNumFields() {
        return View.getFieldCount();
    }

    public String getWhereClause(String string) {
        if (this.trialID.length() > 0) {
            String string2 = " where t.id in " + this.trialID;
            return string2;
        }
        if (this.whereClause == null || this.whereClause.equals("")) {
            String string3 = this.getField("COLUMN_NAME");
            if (string3 == null || string3.length() == 0) {
                return this.whereClause;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (string.compareTo("db2") == 0) {
                stringBuilder.append(" cast (");
            }
            if (this.getField("TABLE_NAME").equalsIgnoreCase("Application")) {
                stringBuilder.append(" a.");
            } else if (this.getField("TABLE_NAME").equalsIgnoreCase("Experiment")) {
                stringBuilder.append(" e.");
            } else {
                stringBuilder.append(" t.");
            }
            stringBuilder.append(string3);
            if (string.compareTo("db2") == 0) {
                stringBuilder.append(" as varchar(256)) ");
            }
            stringBuilder.append(" " + this.getField("OPERATOR") + " '");
            stringBuilder.append(this.getField("VALUE"));
            stringBuilder.append("' ");
            this.setWhereClause(stringBuilder.toString());
        }
        return this.whereClause;
    }

    public void setWhereClause(String string) {
        this.whereClause = string;
    }

    public static class ViewRule {
        public static final String STRING = "read as a string";
        public static final String NUMBER = "read as a number";
        public static final String DATE = "read as a date";
        String table_name = "primary_metadata";
        String column_name = "";
        String operator = "";
        String value = "";
        String value2 = "";
        String type = "";

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getTable_name() {
            return this.table_name;
        }

        private void setTable_name(String string) {
            this.table_name = string;
        }

        public String getColumn_name() {
            return this.column_name;
        }

        public void setColumn_name(String string) {
            boolean bl = View.isTrialCol(string);
            if (bl) {
                this.setTable_name("trial");
            } else {
                this.setTable_name("primary_metadata");
            }
            this.column_name = string;
        }

        public String getOperator() {
            if (this.operator == View.STRING_BEGINS || this.operator == View.STRING_ENDS || this.operator == View.STRING_CONTAINS) {
                return "like";
            }
            if (this.operator == View.STRING_NOT) {
                return "not like";
            }
            if (this.operator == View.STRING_EXACTLY) {
                return "=";
            }
            if (this.operator == View.NUMBER_EQUAL) {
                return "=";
            }
            if (this.operator == View.NUMBER_NOT) {
                return "!=";
            }
            if (this.operator == View.NUMBER_GREATER) {
                return ">";
            }
            if (this.operator == View.NUMBER_LESS) {
                return "<";
            }
            if (this.operator == View.NUMBER_RANGE) {
                return View.NUMBER_RANGE;
            }
            return this.operator;
        }

        public void setOperator(String string) {
            this.operator = string;
        }

        public String getValue() {
            if (this.operator == View.STRING_BEGINS) {
                return this.value + View.WILDCARD;
            }
            if (this.operator == View.STRING_ENDS) {
                return View.WILDCARD + this.value;
            }
            if (this.operator == View.STRING_CONTAINS || this.operator == View.STRING_NOT) {
                return View.WILDCARD + this.value + View.WILDCARD;
            }
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue2() {
            return this.value2;
        }

        public void setValue2(String string) {
            this.value2 = string;
        }

        public static ViewRule createNumericViewRule(String string, String string2, NumericViewComparator numericViewComparator) {
            if (!ViewRule.isNumber(string2)) {
                throw new NumberFormatException();
            }
            ViewRule viewRule = new ViewRule();
            viewRule.setColumn_name(string);
            viewRule.setValue(string2);
            viewRule.setType(NUMBER);
            switch (numericViewComparator) {
                case NOT: {
                    viewRule.setOperator(View.NUMBER_NOT);
                    break;
                }
                case EQUAL: {
                    viewRule.setOperator(View.NUMBER_EQUAL);
                    break;
                }
                case GREATER: {
                    viewRule.setOperator(View.NUMBER_GREATER);
                    break;
                }
                case LESS: {
                    viewRule.setOperator(View.NUMBER_LESS);
                    break;
                }
            }
            return viewRule;
        }

        public static ViewRule createStringViewRule(String string, String string2, StringViewComparator stringViewComparator) {
            ViewRule viewRule = new ViewRule();
            viewRule.setColumn_name(string);
            viewRule.setValue(string2);
            viewRule.setType(STRING);
            switch (stringViewComparator) {
                case CONTAINS: {
                    viewRule.setOperator(View.STRING_CONTAINS);
                    break;
                }
                case ENDS: {
                    viewRule.setOperator(View.STRING_ENDS);
                    break;
                }
                case EXACTLY: {
                    viewRule.setOperator(View.STRING_EXACTLY);
                    break;
                }
                case NOT: {
                    viewRule.setOperator(View.STRING_NOT);
                    break;
                }
                case BEGINS: {
                    viewRule.setOperator(View.STRING_BEGINS);
                    break;
                }
            }
            return viewRule;
        }

        public static ViewRule createNumericRangeViewRule(String string, String string2, String string3) {
            if (!ViewRule.isNumber(string2) || !ViewRule.isNumber(string3)) {
                throw new NumberFormatException();
            }
            ViewRule viewRule = new ViewRule();
            viewRule.setColumn_name(string);
            viewRule.setValue(string2);
            viewRule.setValue2(string3);
            viewRule.setType(NUMBER);
            viewRule.setOperator(View.NUMBER_RANGE);
            return viewRule;
        }

        public static boolean isNumber(String string) {
            try {
                Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum NumericViewComparator {
            EQUAL,
            NOT,
            LESS,
            GREATER;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum StringViewComparator {
            ENDS,
            BEGINS,
            CONTAINS,
            EXACTLY,
            NOT;

        }
    }
}

