/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.database;

import edu.uoregon.tau.perfdmf.database.CustomSSLError;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class CustomX509KeyManager
implements X509KeyManager {
    private final KeyStore keyStore;
    private final String keyAlias;
    private char[] keyStorePassword;
    private static final Logger logger = Logger.getLogger(CustomX509KeyManager.class.getName());
    private static String desiredAlias = null;

    public CustomX509KeyManager(KeyStore keyStore, char[] cArray) {
        this.keyStore = keyStore;
        this.keyStorePassword = cArray;
        this.keyAlias = CustomX509KeyManager.getKeyAlias(this.keyStore);
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return new String[]{this.keyAlias};
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.keyAlias;
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        throw new UnsupportedOperationException("This KeyManager only supports client mode");
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        throw new UnsupportedOperationException("This KeyManager only supports client mode");
    }

    public X509Certificate[] getCertificateChain(String string) {
        try {
            Certificate[] certificateArray = this.keyStore.getCertificateChain(string);
            X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
            System.arraycopy(certificateArray, 0, x509CertificateArray, 0, certificateArray.length);
            return x509CertificateArray;
        }
        catch (KeyStoreException keyStoreException) {
            logger.log(Level.SEVERE, "Unable to retrieve certificate chain for client certificate", keyStoreException);
            return null;
        }
    }

    public PrivateKey getPrivateKey(String string) {
        try {
            return (PrivateKey)this.keyStore.getKey(string, this.keyStorePassword);
        }
        catch (KeyStoreException keyStoreException) {
            logger.log(Level.SEVERE, "Unable to retrieve private key for client certificate", keyStoreException);
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.log(Level.SEVERE, "Unable to retrieve private key for client certificate", noSuchAlgorithmException);
            return null;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            logger.log(Level.SEVERE, "Unable to retrieve private key for client certificate", unrecoverableKeyException);
            return null;
        }
    }

    private X509KeyManager getDefaultKeyManager(KeyStore keyStore, char[] cArray) {
        try {
            KeyManager[] keyManagerArray;
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, cArray);
            for (KeyManager keyManager : keyManagerArray = keyManagerFactory.getKeyManagers()) {
                if (!(keyManager instanceof X509TrustManager)) continue;
                return (X509KeyManager)keyManager;
            }
            throw new CustomSSLError("No X509KeyManager found");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CustomSSLError(noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new CustomSSLError(keyStoreException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new CustomSSLError(unrecoverableKeyException);
        }
    }

    private static String getKeyAlias(KeyStore keyStore) {
        String string = null;
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                if (!desiredAlias.equals(string2) || !keyStore.isKeyEntry(string2) || string != null) continue;
                string = string2;
                break;
            }
            if (string == null) {
                throw new CustomSSLError("Key store contains no keys, it is empty or contains only trusted certs");
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new CustomSSLError("Error reading key store to determine key alias", keyStoreException);
        }
        return string;
    }

    public static void setClientAlias(String string) {
        desiredAlias = string;
    }
}

