/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbCounter {
    private TAUdbSession session = null;
    private int id = 0;
    private TAUdbTrial trial = null;
    private String name = null;

    public TAUdbCounter() {
    }

    public TAUdbCounter(TAUdbSession tAUdbSession, int n, TAUdbTrial tAUdbTrial, String string) {
        this.session = tAUdbSession;
        this.id = n;
        this.trial = tAUdbTrial;
        this.name = string;
    }

    public TAUdbSession getSession() {
        return this.session;
    }

    public void setSession(TAUdbSession tAUdbSession) {
        this.session = tAUdbSession;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public TAUdbTrial getTrial() {
        return this.trial;
    }

    public void setTrial(TAUdbTrial tAUdbTrial) {
        this.trial = tAUdbTrial;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("name:" + this.name + ",");
        return stringBuilder.toString();
    }

    public static TAUdbCounter getCounter(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial, int n) {
        TAUdbCounter tAUdbCounter = null;
        String string = "select name from counter where id = ?;";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                tAUdbCounter = new TAUdbCounter(tAUdbSession, n, tAUdbTrial, string2);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return tAUdbCounter;
    }

    public static Map<Integer, TAUdbCounter> getCounters(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial) {
        if (tAUdbTrial.getCounters() != null && tAUdbTrial.getCounters().size() > 0) {
            return tAUdbTrial.getCounters();
        }
        HashMap<Integer, TAUdbCounter> hashMap = new HashMap<Integer, TAUdbCounter>();
        String string = "select id, name from counter where trial = ?;";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            preparedStatement.setInt(1, tAUdbTrial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                String string2 = resultSet.getString(2);
                TAUdbCounter tAUdbCounter = new TAUdbCounter(tAUdbSession, n, tAUdbTrial, string2);
                hashMap.put(n, tAUdbCounter);
            }
            resultSet.close();
            preparedStatement.close();
            tAUdbTrial.setCounters(hashMap);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        TAUdbTrial tAUdbTrial = TAUdbTrial.getTrial(tAUdbSession, 1, true);
        Map<Integer, TAUdbCounter> map = TAUdbCounter.getCounters(tAUdbSession, tAUdbTrial);
        for (Integer n : map.keySet()) {
            TAUdbCounter tAUdbCounter = map.get(n);
            System.out.println(tAUdbCounter.toString());
        }
        tAUdbSession.close();
    }
}

