/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDatabaseAPI;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbDataSource
extends DataSource {
    private TAUdbDatabaseAPI databaseAPI;

    public TAUdbDataSource(DatabaseAPI databaseAPI) {
        this.setMetrics(new Vector<Metric>());
        this.databaseAPI = new TAUdbDatabaseAPI(databaseAPI);
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public void cancelLoad() {
    }

    private Thread makeDerivedThread(int n) {
        int n2 = this.getNumberOfMetrics();
        Thread thread = null;
        switch (n) {
            case -1: {
                if (this.meanDataNoNull == null) {
                    this.meanDataNoNull = new Thread(-1, -1, -1, n2, this);
                }
                thread = this.meanDataNoNull;
                break;
            }
            case -2: {
                if (this.totalData == null) {
                    this.totalData = new Thread(-2, -2, -2, n2, this);
                }
                thread = this.totalData;
                break;
            }
            case -3: {
                if (this.stddevDataNoNull == null) {
                    this.stddevDataNoNull = new Thread(-3, -3, -3, n2, this);
                }
                thread = this.stddevDataNoNull;
                break;
            }
            case -4: {
                if (this.minData == null) {
                    this.minData = new Thread(-4, -4, -4, n2, this);
                }
                thread = this.minData;
                break;
            }
            case -5: {
                if (this.maxData == null) {
                    this.maxData = new Thread(-5, -5, -5, n2, this);
                }
                thread = this.maxData;
                break;
            }
            case -6: {
                if (this.meanDataAll == null) {
                    this.meanDataAll = new Thread(-6, -6, -6, n2, this);
                }
                thread = this.meanDataAll;
                break;
            }
            case -7: {
                if (this.stddevDataAll == null) {
                    this.stddevDataAll = new Thread(-7, -7, -7, n2, this);
                }
                thread = this.stddevDataAll;
            }
        }
        return thread;
    }

    private void fastGetIntervalEventData(int n, Map<Integer, Function> map, Map<Integer, Metric> map2) throws SQLException {
        int n2 = this.getNumberOfMetrics();
        DB dB = this.databaseAPI.getDb();
        String string = "select cp.id, v.metric, h.node_rank as node, h.context_rank as context, h.thread_rank as thread, v.inclusive_value as inclusive, v.exclusive_value as inclusive, tcd.calls, tcd.subroutines from " + dB.getSchemaPrefix() + "timer_value v " + "left outer join " + dB.getSchemaPrefix() + "timer_call_data tcd on v.timer_call_data = tcd.id " + "left outer join " + dB.getSchemaPrefix() + "timer_callpath cp on tcd.timer_callpath = cp.id " + "left outer join " + dB.getSchemaPrefix() + "timer t on cp.timer = t.id " + "left outer join " + dB.getSchemaPrefix() + "thread h on tcd.thread = h.id " + "where t.trial = " + n + " and h.trial = " + n;
        long l = System.currentTimeMillis();
        ResultSet resultSet = dB.executeQuery(string.toString());
        l = System.currentTimeMillis() - l;
        l = System.currentTimeMillis();
        while (resultSet.next()) {
            int n3 = resultSet.getInt(1);
            Function function = map.get(new Integer(n3));
            if (function == null) {
                System.err.println("Warning! Can't find timer_callpath id " + n3);
                continue;
            }
            int n4 = resultSet.getInt(3);
            int n5 = resultSet.getInt(4);
            int n6 = resultSet.getInt(5);
            Thread thread = null;
            thread = n4 >= 0 ? this.addThread(n4, n5, n6) : this.makeDerivedThread(n4);
            FunctionProfile functionProfile = thread.getFunctionProfile(function);
            if (functionProfile == null) {
                functionProfile = new FunctionProfile(function, n2);
                thread.addFunctionProfile(functionProfile);
            }
            int n7 = map2.get(new Integer(resultSet.getInt(2))).getID();
            double d = resultSet.getDouble(6);
            double d2 = resultSet.getDouble(7);
            double d3 = resultSet.getDouble(8);
            double d4 = resultSet.getDouble(9);
            functionProfile.setNumCalls(d3);
            functionProfile.setNumSubr(d4);
            functionProfile.setExclusive(n7, d2);
            functionProfile.setInclusive(n7, d);
        }
        l = System.currentTimeMillis() - l;
        this.derivedProvided = true;
        this.meanData = this.meanDataNoNull;
        this.stddevData = this.stddevDataNoNull;
        if (meanIncludeNulls) {
            this.meanData = this.meanDataAll;
            this.stddevData = this.stddevDataAll;
        }
        resultSet.close();
    }

    @Override
    public void load() throws SQLException {
        Serializable serializable;
        Map<Integer, Function> map;
        long l = System.currentTimeMillis();
        int n = this.databaseAPI.getTrial().getID();
        this.databaseAPI.getTrial().setDataSource(this);
        DB dB = this.databaseAPI.getDb();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id, name ");
        stringBuffer.append("FROM " + dB.getSchemaPrefix() + "metric ");
        stringBuffer.append("WHERE trial = ");
        stringBuffer.append(this.databaseAPI.getTrial().getID());
        stringBuffer.append(" ORDER BY id ");
        HashMap<Integer, Metric> hashMap = new HashMap<Integer, Metric>();
        ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
        int n2 = 0;
        while (resultSet.next()) {
            int n3 = resultSet.getInt(1);
            map = resultSet.getString(2);
            serializable = this.addMetricNoCheck((String)((Object)map));
            ((Metric)serializable).setDbMetricID(n3);
            hashMap.put(new Integer(n3), (Metric)serializable);
            ++n2;
        }
        resultSet.close();
        Map<Thread, Integer> map2 = TAUdbDatabaseAPI.getThreadsMap(n, this, this.databaseAPI.getDb(), true);
        map = new HashMap();
        map = this.databaseAPI.getIntervalEvents(this, n2);
        this.fastGetIntervalEventData(n, map, hashMap);
        this.databaseAPI.getAtomicEvents();
        this.databaseAPI.getAtomicEventData(this);
        serializable = this.databaseAPI.getTrial();
        this.databaseAPI.getTrial().loadXMLMetadata(dB, map);
        this.setMetaData(((Trial)serializable).getMetaData());
        this.databaseAPI.terminate();
        l = System.currentTimeMillis() - l;
        this.derivedProvided = true;
        this.generateDerivedData();
        this.aggregateMetaData();
    }
}

