/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbThread;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimerCallpath;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbSecondaryMetadata {
    private TAUdbSession session = null;
    private TAUdbTrial trial = null;
    private int id = 0;
    private TAUdbTimerCallpath timerCallpath = null;
    private TAUdbThread thread = null;
    private TAUdbSecondaryMetadata parent = null;
    private List<TAUdbSecondaryMetadata> children = null;
    private double timestamp = 0.0;
    private String name = null;
    private String value = null;
    private boolean isArray = false;

    public TAUdbSession getSession() {
        return this.session;
    }

    public void setSession(TAUdbSession tAUdbSession) {
        this.session = tAUdbSession;
    }

    public TAUdbTrial getTrial() {
        return this.trial;
    }

    public void setTrial(TAUdbTrial tAUdbTrial) {
        this.trial = tAUdbTrial;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public TAUdbTimerCallpath getTimerCallpath() {
        return this.timerCallpath;
    }

    public void setTimerCallpath(TAUdbTimerCallpath tAUdbTimerCallpath) {
        this.timerCallpath = tAUdbTimerCallpath;
    }

    public TAUdbThread getThread() {
        return this.thread;
    }

    public void setThread(TAUdbThread tAUdbThread) {
        this.thread = tAUdbThread;
    }

    public TAUdbSecondaryMetadata getParent() {
        return this.parent;
    }

    public void setParent(TAUdbSecondaryMetadata tAUdbSecondaryMetadata) {
        this.parent = tAUdbSecondaryMetadata;
    }

    public List<TAUdbSecondaryMetadata> getChildren() {
        return this.children;
    }

    public void setChildren(List<TAUdbSecondaryMetadata> list) {
        this.children = list;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(double d) {
        this.timestamp = d;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean bl) {
        this.isArray = bl;
    }

    public TAUdbSecondaryMetadata(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial, int n, TAUdbTimerCallpath tAUdbTimerCallpath, TAUdbThread tAUdbThread, TAUdbSecondaryMetadata tAUdbSecondaryMetadata, String string, String string2, boolean bl) {
        this.session = tAUdbSession;
        this.trial = tAUdbTrial;
        this.id = n;
        this.timerCallpath = tAUdbTimerCallpath;
        this.thread = tAUdbThread;
        this.parent = tAUdbSecondaryMetadata;
        this.children = new ArrayList<TAUdbSecondaryMetadata>();
        this.name = string;
        this.value = string2;
        this.isArray = bl;
    }

    public static Map<Integer, TAUdbSecondaryMetadata> getSecondaryMetadata(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial) {
        if (tAUdbTrial.getSecondaryMetadata() != null && tAUdbTrial.getSecondaryMetadata().size() > 0) {
            return tAUdbTrial.getSecondaryMetadata();
        }
        HashMap<Integer, TAUdbSecondaryMetadata> hashMap = new HashMap<Integer, TAUdbSecondaryMetadata>();
        String string = "select id, thread, timer_callpath, parent, name, value, is_array from secondary_metadata where trial = ?";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            preparedStatement.setInt(1, tAUdbTrial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                Integer n2 = resultSet.getInt(2);
                Integer n3 = resultSet.getInt(3);
                Integer n4 = resultSet.getInt(4);
                String string2 = resultSet.getString(5);
                String string3 = resultSet.getString(6);
                boolean bl = resultSet.getBoolean(7);
                TAUdbTimerCallpath tAUdbTimerCallpath = tAUdbTrial.getTimerCallpaths().get(n3);
                TAUdbThread tAUdbThread = tAUdbTrial.getThreads().get(n2);
                TAUdbSecondaryMetadata tAUdbSecondaryMetadata = null;
                if (n4 != null) {
                    tAUdbSecondaryMetadata = (TAUdbSecondaryMetadata)hashMap.get(n4);
                }
                TAUdbSecondaryMetadata tAUdbSecondaryMetadata2 = new TAUdbSecondaryMetadata(tAUdbSession, tAUdbTrial, n, tAUdbTimerCallpath, tAUdbThread, tAUdbSecondaryMetadata, string2, string3, bl);
                hashMap.put(n, tAUdbSecondaryMetadata2);
            }
            resultSet.close();
            preparedStatement.close();
            tAUdbTrial.setSecondaryMetadata(hashMap);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        TAUdbTrial tAUdbTrial = TAUdbTrial.getTrial(tAUdbSession, 1, true);
        Map<Integer, TAUdbSecondaryMetadata> map = TAUdbSecondaryMetadata.getSecondaryMetadata(tAUdbSession, tAUdbTrial);
        for (Integer n : map.keySet()) {
            System.out.println(map.get(n).toString());
        }
        tAUdbSession.close();
    }
}

