/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDataSourceType;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDatabaseAPI;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.io.File;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbSession {
    private Map<Integer, TAUdbDataSourceType> sources = null;
    private TAUdbDatabaseAPI api = null;
    private boolean connected = false;
    private TAUdbTrial currentTrial = null;
    private DB db;

    public TAUdbSession(String string, boolean bl) {
        this.api = new TAUdbDatabaseAPI();
        String string2 = System.getenv("HOME");
        String string3 = string2 + File.separator + ".ParaProf" + File.separator + "perfdmf.cfg." + string;
        try {
            this.api.initialize(string3, false);
            this.connected = true;
            this.sources = TAUdbDataSourceType.getDataSourceTypes(this);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public TAUdbSession(DB dB) {
        this.db = dB;
    }

    public void close() {
        if (this.api != null) {
            this.api.db().close();
        }
        this.connected = false;
    }

    public TAUdbTrial getCurrentTrial() {
        return this.currentTrial;
    }

    public void finalize() {
        if (this.connected) {
            System.err.println("Forgot to close the database connection!");
        }
        this.close();
    }

    public Map<Integer, TAUdbDataSourceType> getDataSources() {
        return this.sources;
    }

    public DB getDB() {
        if (this.api == null) {
            return this.db;
        }
        return this.api.db();
    }

    public static void main(String[] stringArray) {
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        System.out.print("Connected to: ");
        System.out.println(tAUdbSession.api.db().getConnectString());
        tAUdbSession.close();
    }
}

