/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbThread {
    private int id = 0;
    private TAUdbTrial trial = null;
    private TAUdbSession session = null;
    private int nodeRank = 0;
    private int contextRank = 0;
    private int threadRank = 0;
    private int threadIndex = 0;

    public TAUdbThread(TAUdbSession tAUdbSession, int n, TAUdbTrial tAUdbTrial, int n2, int n3, int n4, int n5) {
        this.id = n;
        this.trial = tAUdbTrial;
        this.session = tAUdbSession;
        this.nodeRank = n2;
        this.contextRank = n3;
        this.threadRank = n4;
        this.threadIndex = n5;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public TAUdbTrial getTrial() {
        return this.trial;
    }

    public void setTrial(TAUdbTrial tAUdbTrial) {
        this.trial = tAUdbTrial;
    }

    public TAUdbSession getSession() {
        return this.session;
    }

    public void setSession(TAUdbSession tAUdbSession) {
        this.session = tAUdbSession;
    }

    public int getNodeRank() {
        return this.nodeRank;
    }

    public void setNodeRank(int n) {
        this.nodeRank = n;
    }

    public int getContextRank() {
        return this.contextRank;
    }

    public void setContextRank(int n) {
        this.contextRank = n;
    }

    public int getThreadRank() {
        return this.threadRank;
    }

    public void setThreadRank(int n) {
        this.threadRank = n;
    }

    public int getThreadIndex() {
        return this.threadIndex;
    }

    public void setThreadIndex(int n) {
        this.threadIndex = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.nodeRank);
        stringBuilder.append(",");
        stringBuilder.append(this.contextRank);
        stringBuilder.append(",");
        stringBuilder.append(this.threadRank);
        stringBuilder.append(",");
        stringBuilder.append(this.threadIndex);
        return stringBuilder.toString();
    }

    public static Map<Integer, TAUdbThread> getThreads(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial, boolean bl) {
        if (bl) {
            if (tAUdbTrial.getDerivedThreads() != null && tAUdbTrial.getDerivedThreads().size() > 0) {
                return tAUdbTrial.getDerivedThreads();
            }
        } else if (tAUdbTrial.getThreads() != null && tAUdbTrial.getThreads().size() > 0) {
            return tAUdbTrial.getThreads();
        }
        HashMap<Integer, TAUdbThread> hashMap = new HashMap<Integer, TAUdbThread>();
        String string = "thread_index > -1";
        if (bl) {
            string = "thread_index < 0";
        }
        String string2 = "select id, node_rank, context_rank, thread_rank, thread_index from thread where trial = ? and " + string + " order by thread_index;";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string2);
            preparedStatement.setInt(1, tAUdbTrial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                int n2 = resultSet.getInt(2);
                int n3 = resultSet.getInt(3);
                int n4 = resultSet.getInt(4);
                int n5 = resultSet.getInt(5);
                TAUdbThread tAUdbThread = new TAUdbThread(tAUdbSession, n, tAUdbTrial, n2, n3, n4, n5);
                hashMap.put(n, tAUdbThread);
            }
            resultSet.close();
            preparedStatement.close();
            if (bl) {
                tAUdbTrial.setDerivedThreads(hashMap);
            } else {
                tAUdbTrial.setThreads(hashMap);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        TAUdbThread tAUdbThread;
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        TAUdbTrial tAUdbTrial = TAUdbTrial.getTrial(tAUdbSession, 1, false);
        Map<Integer, TAUdbThread> map = TAUdbThread.getThreads(tAUdbSession, tAUdbTrial, false);
        for (Integer n : map.keySet()) {
            tAUdbThread = map.get(n);
            System.out.println(tAUdbThread.toString());
        }
        map = TAUdbThread.getThreads(tAUdbSession, tAUdbTrial, true);
        for (Integer n : map.keySet()) {
            tAUdbThread = map.get(n);
            System.out.println(tAUdbThread.toString());
        }
        tAUdbSession.close();
    }
}

