/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbThread;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimerCallpath;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbTimerCall {
    private TAUdbSession session = null;
    private TAUdbTrial trial = null;
    private int id = 0;
    private TAUdbTimerCallpath timerCallpath = null;
    private TAUdbThread thread = null;
    private double calls = 0.0;
    private double subroutines = 0.0;
    private double timestamp = 0.0;

    public TAUdbTimerCall(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial, int n, TAUdbTimerCallpath tAUdbTimerCallpath, TAUdbThread tAUdbThread, double d, double d2, double d3) {
        this.session = tAUdbSession;
        this.trial = tAUdbTrial;
        this.id = n;
        this.timerCallpath = tAUdbTimerCallpath;
        this.thread = tAUdbThread;
        this.calls = d;
        this.subroutines = d2;
        this.timestamp = d3;
    }

    public TAUdbSession getSession() {
        return this.session;
    }

    public void setSession(TAUdbSession tAUdbSession) {
        this.session = tAUdbSession;
    }

    public TAUdbTrial getTrial() {
        return this.trial;
    }

    public void setTrial(TAUdbTrial tAUdbTrial) {
        this.trial = tAUdbTrial;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public TAUdbTimerCallpath getTimerCallpath() {
        return this.timerCallpath;
    }

    public void setTimerCallpath(TAUdbTimerCallpath tAUdbTimerCallpath) {
        this.timerCallpath = tAUdbTimerCallpath;
    }

    public TAUdbThread getThread() {
        return this.thread;
    }

    public void setThread(TAUdbThread tAUdbThread) {
        this.thread = tAUdbThread;
    }

    public double getCalls() {
        return this.calls;
    }

    public void setCalls(double d) {
        this.calls = d;
    }

    public double getSubroutines() {
        return this.subroutines;
    }

    public void setSubroutines(double d) {
        this.subroutines = d;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(double d) {
        this.timestamp = d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Callpath: " + this.timerCallpath);
        stringBuilder.append(" Thread: " + this.thread.getThreadRank());
        stringBuilder.append(" Calls: " + this.calls);
        stringBuilder.append(" Subroutines: " + this.subroutines);
        return stringBuilder.toString();
    }

    public static Map<Integer, TAUdbTimerCall> getTimerCalls(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial) {
        if (tAUdbTrial.getTimerCalls() != null && tAUdbTrial.getTimerCalls().size() > 0) {
            return tAUdbTrial.getTimerCalls();
        }
        HashMap<Integer, TAUdbTimerCall> hashMap = new HashMap<Integer, TAUdbTimerCall>();
        String string = "select tc.id, tc.timer_callpath, tc.thread, tc.calls, tc.subroutines, tc.timestamp from timer_call_data tc join thread t on tc.thread = t.id where t.trial = ?";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            preparedStatement.setInt(1, tAUdbTrial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                Integer n2 = resultSet.getInt(2);
                Integer n3 = resultSet.getInt(3);
                double d = resultSet.getDouble(4);
                double d2 = resultSet.getDouble(5);
                double d3 = resultSet.getDouble(6);
                TAUdbTimerCallpath tAUdbTimerCallpath = tAUdbTrial.getTimerCallpaths().get(n2);
                TAUdbThread tAUdbThread = tAUdbTrial.getThreads().get(n3);
                if (tAUdbThread == null) {
                    tAUdbThread = tAUdbTrial.getDerivedThreads().get(n3);
                }
                TAUdbTimerCall tAUdbTimerCall = new TAUdbTimerCall(tAUdbSession, tAUdbTrial, n, tAUdbTimerCallpath, tAUdbThread, d, d2, d3);
                hashMap.put(n, tAUdbTimerCall);
            }
            resultSet.close();
            preparedStatement.close();
            tAUdbTrial.setTimerCalls(hashMap);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        TAUdbTrial tAUdbTrial = TAUdbTrial.getTrial(tAUdbSession, 1, true);
        Map<Integer, TAUdbTimerCall> map = TAUdbTimerCall.getTimerCalls(tAUdbSession, tAUdbTrial);
        for (Integer n : map.keySet()) {
            System.out.println(map.get(n).toString());
        }
        tAUdbSession.close();
    }
}

