/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.taudb.TAUdbCounter;
import edu.uoregon.tau.perfdmf.taudb.TAUdbCounterValue;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDataSourceType;
import edu.uoregon.tau.perfdmf.taudb.TAUdbMetric;
import edu.uoregon.tau.perfdmf.taudb.TAUdbSecondaryMetadata;
import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbThread;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimer;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimerCall;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimerCallpath;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimerGroup;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimerValue;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbTrial
extends Trial {
    private static final long serialVersionUID = -8756722915938384030L;
    public static final String[] TRIAL_COLUMNS = new String[]{"name", "data_source", "node_count", "contexts_per_node", "threads_per_context", "total_threads"};
    private TAUdbSession session = null;
    private TAUdbDataSourceType dataSourceType = null;
    private int nodeCount = 0;
    private int contextsPerNode = 0;
    private int threadsPerContext = 0;
    private int totalThreads = 0;
    private Map<String, String> primaryMetadata;
    private Map<Integer, TAUdbSecondaryMetadata> secondaryMetadata;
    private Map<Integer, TAUdbTimer> timers;
    private Set<TAUdbTimerGroup> timerGroups;
    private Map<Integer, TAUdbTimerCallpath> timerCallpaths;
    private Map<Integer, TAUdbThread> threads;
    private Map<Integer, TAUdbTimerCall> timerCalls;
    private List<TAUdbTimerValue> timerValues;
    private Map<Integer, TAUdbThread> derivedThreads;
    private Map<Integer, TAUdbMetric> metrics;
    private Map<Integer, TAUdbCounter> counters;
    private List<TAUdbCounterValue> counterValues;

    public TAUdbTrial(TAUdbSession tAUdbSession, int n, String string, TAUdbDataSourceType tAUdbDataSourceType, int n2, int n3, int n4, int n5) {
        this.session = tAUdbSession;
        this.trialID = n;
        this.name = string;
        this.dataSourceType = tAUdbDataSourceType;
        this.nodeCount = n2;
        this.contextsPerNode = n3;
        this.threadsPerContext = n4;
        this.totalThreads = n5;
        this.loadPrimaryMetadata();
        this.timerGroups = new HashSet<TAUdbTimerGroup>();
    }

    public static TAUdbTrial getTrial(TAUdbSession tAUdbSession, int n, boolean bl) {
        TAUdbTrial tAUdbTrial = null;
        String string = "select id, name, data_source, node_count, contexts_per_node, threads_per_context, total_threads from trial ";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(2);
                Integer n2 = resultSet.getInt(3);
                TAUdbDataSourceType tAUdbDataSourceType = tAUdbSession.getDataSources().get(n2);
                int n3 = resultSet.getInt(4);
                int n4 = resultSet.getInt(5);
                int n5 = resultSet.getInt(6);
                int n6 = resultSet.getInt(7);
                tAUdbTrial = new TAUdbTrial(tAUdbSession, n, string2, tAUdbDataSourceType, n3, n4, n5, n6);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        if (tAUdbTrial != null & bl) {
            super.loadEverything();
        }
        return tAUdbTrial;
    }

    private void loadEverything() {
        this.timers = TAUdbTimer.getTimers(this.session, this);
        this.timerCallpaths = TAUdbTimerCallpath.getTimerCallpaths(this.session, this);
        this.threads = TAUdbThread.getThreads(this.session, this, false);
        this.derivedThreads = TAUdbThread.getThreads(this.session, this, true);
        this.timerCalls = TAUdbTimerCall.getTimerCalls(this.session, this);
        this.metrics = TAUdbMetric.getMetrics(this.session, this);
        this.timerValues = TAUdbTimerValue.getTimerValues(this.session, this);
        this.counters = TAUdbCounter.getCounters(this.session, this);
        this.counterValues = TAUdbCounterValue.getCounterValues(this.session, this);
    }

    public void addTimerGroup(TAUdbTimerGroup tAUdbTimerGroup) {
        this.timerGroups.add(tAUdbTimerGroup);
    }

    private void loadPrimaryMetadata() {
        this.primaryMetadata = new HashMap<String, String>();
        String string = "select name, value from primary_metadata where trial = ? order by name ";
        try {
            PreparedStatement preparedStatement = this.session.getDB().prepareStatement(string);
            preparedStatement.setInt(1, this.trialID);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                this.primaryMetadata.put(string2, string3);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public TAUdbDataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSource(TAUdbDataSourceType tAUdbDataSourceType) {
        this.dataSourceType = tAUdbDataSourceType;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setNodeCount(int n) {
        this.nodeCount = n;
    }

    public int getContextsPerNode() {
        return this.contextsPerNode;
    }

    public void setContextsPerNode(int n) {
        this.contextsPerNode = n;
    }

    public int getThreadsPerContext() {
        return this.threadsPerContext;
    }

    public void setThreadsPerContext(int n) {
        this.threadsPerContext = n;
    }

    public int getTotalThreads() {
        return this.totalThreads;
    }

    public void setTotalThreads(int n) {
        this.totalThreads = n;
    }

    public Map<Integer, TAUdbTimer> getTimers() {
        return this.timers;
    }

    public void setTimers(Map<Integer, TAUdbTimer> map) {
        this.timers = map;
    }

    public Set<TAUdbTimerGroup> getTimerGroups() {
        return this.timerGroups;
    }

    public void setTimerGroups(Set<TAUdbTimerGroup> set) {
        this.timerGroups = set;
    }

    public Map<Integer, TAUdbTimerCallpath> getTimerCallpaths() {
        return this.timerCallpaths;
    }

    public void setTimerCallpaths(Map<Integer, TAUdbTimerCallpath> map) {
        this.timerCallpaths = map;
    }

    public Map<Integer, TAUdbThread> getThreads() {
        return this.threads;
    }

    public void setThreads(Map<Integer, TAUdbThread> map) {
        this.threads = map;
    }

    public Map<Integer, TAUdbThread> getDerivedThreads() {
        return this.derivedThreads;
    }

    public void setDerivedThreads(Map<Integer, TAUdbThread> map) {
        this.derivedThreads = map;
    }

    public Map<Integer, TAUdbTimerCall> getTimerCalls() {
        return this.timerCalls;
    }

    public void setTimerCalls(Map<Integer, TAUdbTimerCall> map) {
        this.timerCalls = map;
    }

    public TAUdbSession getSession() {
        return this.session;
    }

    public void setSession(TAUdbSession tAUdbSession) {
        this.session = tAUdbSession;
    }

    public Map<String, String> getPrimaryMetadata() {
        return this.primaryMetadata;
    }

    public void setPrimaryMetadata(Map<String, String> map) {
        this.primaryMetadata = map;
    }

    public Map<Integer, TAUdbMetric> getTAUdbMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<Integer, TAUdbMetric> map) {
        this.metrics = map;
    }

    public List<TAUdbTimerValue> getTimerValues() {
        return this.timerValues;
    }

    public void setTimerValues(List<TAUdbTimerValue> list) {
        this.timerValues = list;
    }

    public Map<Integer, TAUdbCounter> getCounters() {
        return this.counters;
    }

    public void setCounters(Map<Integer, TAUdbCounter> map) {
        this.counters = map;
    }

    public List<TAUdbCounterValue> getCounterValues() {
        return this.counterValues;
    }

    public void setCounterValues(List<TAUdbCounterValue> list) {
        this.counterValues = list;
    }

    public Map<Integer, TAUdbSecondaryMetadata> getSecondaryMetadata() {
        return this.secondaryMetadata;
    }

    public void setSecondaryMetadata(Map<Integer, TAUdbSecondaryMetadata> map) {
        this.secondaryMetadata = map;
    }

    @Override
    public MetaDataMap getMetaData() {
        MetaDataMap metaDataMap = super.getMetaData();
        if (metaDataMap == null || metaDataMap.size() <= 0) {
            MetaDataMap metaDataMap2 = new MetaDataMap();
            if (this.primaryMetadata != null) {
                Set<Map.Entry<String, String>> set = this.primaryMetadata.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    metaDataMap2.put(entry.getKey(), entry.getValue());
                }
            }
            return metaDataMap2;
        }
        return super.getMetaData();
    }

    public static Map<Integer, TAUdbTrial> getTrials(TAUdbSession tAUdbSession) {
        HashMap<Integer, TAUdbTrial> hashMap = new HashMap<Integer, TAUdbTrial>();
        String string = "select id, name, data_source, node_count, contexts_per_node, threads_per_context, total_threads from trial ";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                String string2 = resultSet.getString(2);
                Integer n2 = resultSet.getInt(3);
                TAUdbDataSourceType tAUdbDataSourceType = tAUdbSession.getDataSources().get(n2);
                int n3 = resultSet.getInt(4);
                int n4 = resultSet.getInt(5);
                int n5 = resultSet.getInt(6);
                int n6 = resultSet.getInt(7);
                TAUdbTrial tAUdbTrial = new TAUdbTrial(tAUdbSession, n, string2, tAUdbDataSourceType, n3, n4, n5, n6);
                hashMap.put(n, tAUdbTrial);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        Map<Integer, TAUdbTrial> map = TAUdbTrial.getTrials(tAUdbSession);
        for (Integer n : map.keySet()) {
            TAUdbTrial tAUdbTrial = map.get(n);
            tAUdbTrial.loadEverything();
            System.out.println(tAUdbTrial.toString());
            System.out.println(tAUdbTrial.getDataSource().toString());
        }
        tAUdbSession.close();
    }

    @Override
    public int saveTrial(DB dB) {
        return TAUdbTrial.saveTrialTAUdb(dB, this.trialID, this.dataSource, this.name);
    }

    @Override
    public void rename(DB dB, String string) {
        String string2 = "UPDATE " + dB.getSchemaPrefix() + "trial SET name=? where id=?";
        try {
            PreparedStatement preparedStatement = dB.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, this.trialID);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.setName(string);
    }

    public static int saveTrialTAUdb(DB dB, int n, DataSource dataSource, String string) {
        if (dB.getSchemaVersion() < 1) {
            System.err.println("You can't save a TAUdbTrial to a PerfDMF database.");
            return -1;
        }
        boolean bl = TAUdbTrial.exists(dB, n);
        int n2 = 0;
        if (dataSource == null) {
            System.out.println("Given a null Datasource, must be loaded first, TAUdbTrial");
            return n;
        }
        if (bl) {
            System.out.println("Updates to TAUdb trials have not been implemented yet");
            return n;
        }
        try {
            int n3 = dataSource.getMaxNode();
            int n4 = dataSource.getMaxContextPerNode();
            int n5 = dataSource.getMaxThreadsPerContext();
            int n6 = dataSource.getFileType();
            int n7 = dataSource.getNumThreads();
            String string2 = "INSERT INTO " + dB.getSchemaPrefix() + "trial (name, data_source,  node_count, contexts_per_node, threads_per_context, total_threads)" + "VALUES (?,?,?,?,?,?" + ") ";
            PreparedStatement preparedStatement = dB.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n6);
            preparedStatement.setInt(3, n3);
            preparedStatement.setInt(4, n4);
            preparedStatement.setInt(5, n5);
            preparedStatement.setInt(6, n7);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string3 = new String();
            string3 = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'trial'" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "trial_id_seq.currval FROM dual" : "select currval('trial_id_seq');")))));
            n2 = Integer.parseInt(dB.getDataItem(string3));
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the trial.");
            sQLException.printStackTrace();
        }
        return n2;
    }

    private static boolean exists(DB dB, int n) {
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("SELECT name FROM " + dB.getSchemaPrefix() + "trial WHERE id = ?");
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while checking to see if the trial exists.");
            sQLException.printStackTrace();
        }
        return bl;
    }

    public static Vector<Trial> getTrialList(DB dB, boolean bl, String string) {
        try {
            Trial.getMetaData(dB);
            String string2 = "SELECT DISTINCT t.id, t.name, t.data_source, t.node_count, t.contexts_per_node, t.threads_per_context, t.total_threads FROM " + dB.getSchemaPrefix() + "trial t " + string + " order by t.id";
            Vector<Trial> vector = new Vector<Trial>();
            ResultSet resultSet = dB.executeQuery(string2.toString());
            TAUdbSession tAUdbSession = new TAUdbSession(dB);
            while (resultSet.next()) {
                int n = 1;
                n = 1;
                int n2 = resultSet.getInt(n++);
                String string3 = resultSet.getString(n++);
                int n3 = resultSet.getInt(n++);
                int n4 = resultSet.getInt(n++);
                int n5 = resultSet.getInt(n++);
                int n6 = resultSet.getInt(n++);
                int n7 = resultSet.getInt(n++);
                TAUdbTrial tAUdbTrial = new TAUdbTrial(tAUdbSession, n2, string3, null, n4, n5, n6, n7);
                tAUdbTrial.setDatabase(dB.getDatabase());
                tAUdbTrial.setField("data_source", String.valueOf(n3));
                tAUdbTrial.setField("node_count", String.valueOf(n4));
                tAUdbTrial.setField("contexts_per_node", String.valueOf(n5));
                tAUdbTrial.setField("threads_per_context", String.valueOf(n6));
                tAUdbTrial.setField("total_threads", String.valueOf(n7));
                if (bl) {
                    tAUdbTrial.loadXMLMetadata(dB);
                }
                vector.addElement(tAUdbTrial);
            }
            resultSet.close();
            Collections.sort(vector);
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void getTrialMetrics(DB dB) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id, name, derived ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "metric ");
        stringBuffer.append("where trial = ");
        stringBuffer.append(this.getID());
        stringBuffer.append(" order by id ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                TAUdbMetric tAUdbMetric = new TAUdbMetric(this.session, resultSet.getInt(1), this, resultSet.getString(2), resultSet.getBoolean(3));
                this.addMetric(tAUdbMetric);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void deleteMetric(DB dB, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        dB.setAutoCommit(false);
        try {
            preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_value WHERE metric = ?");
            preparedStatement.setInt(1, n2);
            preparedStatement.execute();
            preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "metric WHERE id = ?");
            preparedStatement.setInt(1, n2);
            preparedStatement.execute();
            dB.commit();
        }
        catch (SQLException sQLException) {
            dB.rollback();
        }
        dB.setAutoCommit(true);
    }

    private static PreparedStatement setTrialIDs(PreparedStatement preparedStatement, int[] nArray) throws SQLException {
        for (int i = 0; i < nArray.length; ++i) {
            preparedStatement.setInt(i + 1, nArray[i]);
        }
        return preparedStatement;
    }

    public static void deleteTrial(DB dB, int[] nArray) throws SQLException {
        for (int i = 0; i < nArray.length; ++i) {
            String string = " = " + nArray[i];
            String string2 = " WHERE id " + string;
            String string3 = " WHERE trial " + string;
            System.out.print("Deleting trial ID " + nArray[i]);
            long l = System.currentTimeMillis();
            dB.setAutoCommit(false);
            try {
                PreparedStatement preparedStatement = null;
                preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "primary_metadata" + string3);
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.getDBType().compareTo("postgresql") == 0 ? dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "time_range x using " + dB.getSchemaPrefix() + "secondary_metadata y where y.trial " + string + " and x.id = y.time_range ") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "time_range where id in (select time_range from " + dB.getSchemaPrefix() + "secondary_metadata " + string3 + ")");
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "secondary_metadata " + string3);
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.getDBType().compareTo("postgresql") == 0 ? dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "counter_value x using " + dB.getSchemaPrefix() + "counter y where y.trial " + string + " and x.counter = y.id ") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "counter_value WHERE counter in (SELECT id FROM " + dB.getSchemaPrefix() + "counter " + string3 + ")");
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.getDBType().compareTo("postgresql") == 0 ? dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_value tv using " + dB.getSchemaPrefix() + "timer_call_data tcd, " + dB.getSchemaPrefix() + "timer_callpath tcp, " + dB.getSchemaPrefix() + "timer t where t.trial " + string + " and tcp.timer = t.id and tcd.timer_callpath = tcp.id and tv.timer_call_data = tcd.id") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_value tv WHERE tv.timer_call_data IN (SELECT tcd.id FROM " + dB.getSchemaPrefix() + "timer_call_data tcd WHERE tcd.timer_callpath IN (SELECT tcp.id FROM " + dB.getSchemaPrefix() + "timer_callpath tcp WHERE tcp.timer IN (SELECT t.id FROM " + dB.getSchemaPrefix() + "timer t " + string3 + ")))");
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.getDBType().compareTo("postgresql") == 0 ? dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_call_data tcd using " + dB.getSchemaPrefix() + "timer_callpath tcp, " + dB.getSchemaPrefix() + "timer t where t.trial " + string + " and tcp.timer = t.id and tcd.timer_callpath = tcp.id ") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_call_data tcd WHERE tcd.timer_callpath IN (SELECT tcp.id FROM " + dB.getSchemaPrefix() + "timer_callpath tcp WHERE tcp.timer IN (SELECT t.id FROM " + dB.getSchemaPrefix() + "timer t " + string3 + "))");
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.getDBType().compareTo("postgresql") == 0 ? dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_callpath tcp using " + dB.getSchemaPrefix() + "timer t where t.trial " + string + " and tcp.timer = t.id ") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_callpath WHERE timer IN (SELECT id FROM " + dB.getSchemaPrefix() + "timer " + string3 + ")");
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.getDBType().compareTo("postgresql") == 0 ? dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_parameter tp using " + dB.getSchemaPrefix() + "timer t where t.trial " + string + " and tp.timer = t.id ") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_parameter WHERE timer IN (SELECT id FROM " + dB.getSchemaPrefix() + "timer " + string3 + ")");
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.getDBType().compareTo("postgresql") == 0 ? dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_group tg using " + dB.getSchemaPrefix() + "timer t where t.trial " + string + " and tg.timer = t.id ") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer_group WHERE timer IN (SELECT id FROM " + dB.getSchemaPrefix() + "timer " + string3 + ")");
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "counter " + string3);
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "thread " + string3);
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "timer " + string3);
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "metric " + string3);
                System.out.print(".");
                preparedStatement.execute();
                preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "trial " + string2);
                preparedStatement.execute();
                long l2 = System.currentTimeMillis();
                System.out.println("done. (" + (double)(l2 - l) / 1000.0 + " seconds)");
                dB.commit();
            }
            catch (SQLException sQLException) {
                dB.rollback();
            }
            dB.setAutoCommit(true);
        }
    }

    public void updatePrimaryMetadataField(String string, String string2) {
        TAUdbTrial.updatePrimaryMetadataField(this.getSession().getDB(), this.trialID, string, string2);
    }

    public static void updatePrimaryMetadataField(DB dB, int n, String string, String string2) {
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("update primary_metadata set value=? where trial=? and name=?;");
            preparedStatement.setString(1, string2);
            preparedStatement.setInt(2, n);
            preparedStatement.setString(3, string);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void addToPrimaryMetadataField(String string, String string2) {
        TAUdbTrial.addToPrimaryMetadataField(this.getSession().getDB(), this.trialID, string, string2);
    }

    public static void addToPrimaryMetadataField(DB dB, int n, String string, String string2) {
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "primary_metadata (trial, name, value) VALUES (?, ?, ?);");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void removeFromPrimaryMetadataField(String string) {
        TAUdbTrial.removeFromPrimaryMetadataField(this.getSession().getDB(), this.trialID, string);
    }

    public static void removeFromPrimaryMetadataField(DB dB, int n, String string) {
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("DELETE FROM " + dB.getSchemaPrefix() + "primary_metadata WHERE trial=? AND name=?;");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static void updateFields(DB dB, int n, String string, String string2) {
        String string3 = "update trial set " + string + "=? where ID=" + n;
        try {
            PreparedStatement preparedStatement = dB.prepareStatement(string3);
            preparedStatement.setString(1, string2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    @Override
    public void loadXMLMetadata(DB dB, Map<Integer, Function> map) {
        this.loadMetadata(dB, map);
    }

    public void loadMetadata(DB dB) {
        HashMap<Integer, Function> hashMap = new HashMap<Integer, Function>();
        this.loadMetadata(dB, hashMap);
    }

    public void loadMetadata(DB dB, Map<Integer, Function> map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        stringBuffer.append("<tau:metadata xmlns:tau=\"http://www.cs.uoregon.edu/research/tau\">");
        stringBuffer.append("<tau:CommonProfileAttributes>");
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("SELECT name, value FROM " + dB.getSchemaPrefix() + "primary_metadata WHERE trial = ?");
            preparedStatement.setInt(1, this.trialID);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                this.metaData.put(string, string2);
                stringBuffer.append("<tau:attribute><tau:name>");
                stringBuffer.append(string);
                stringBuffer.append("</tau:name><tau:value>");
                stringBuffer.append(string2);
                stringBuffer.append("</tau:value></tau:attribute>");
            }
            resultSet.close();
            stringBuffer.append("</tau:CommonProfileAttributes>");
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            boolean bl = false;
            preparedStatement = dB.prepareStatement("SELECT sm.name, sm.value, t.node_rank, t.context_rank, t.thread_rank, timer_callpath, iteration_start, time_start, parent FROM " + dB.getSchemaPrefix() + "secondary_metadata sm left outer join " + dB.getSchemaPrefix() + "thread t on sm.thread = t.id left outer join " + dB.getSchemaPrefix() + "time_range tr on sm.time_range = tr.id WHERE sm.trial = ? order by t.node_rank, t.context_rank, t.thread_rank");
            preparedStatement.setInt(1, this.trialID);
            resultSet = preparedStatement.executeQuery();
            Thread thread = null;
            while (resultSet.next()) {
                if (n != resultSet.getInt(3) || n2 != resultSet.getInt(4) || n3 != resultSet.getInt(5)) {
                    n = resultSet.getInt(3);
                    n2 = resultSet.getInt(4);
                    n3 = resultSet.getInt(5);
                    if (this.getDataSource() != null) {
                        thread = this.getDataSource().getThread(n, n2, n3);
                    }
                    if (bl) {
                        stringBuffer.append("</tau:ProfileAttributes>");
                    }
                    stringBuffer.append("<tau:ProfileAttributes context=\"" + n2 + "\" node=\"" + n + "\" thread=\"" + n3 + "\">");
                    bl = true;
                }
                MetaDataMap metaDataMap = this.uncommonMetaData;
                metaDataMap.getClass();
                MetaDataMap.MetaDataKey metaDataKey = new MetaDataMap.MetaDataKey(metaDataMap, resultSet.getString(1));
                Function function = map.get(resultSet.getInt(6));
                metaDataKey.timer_context = function == null ? "" : function.getName();
                metaDataKey.call_number = resultSet.getInt(7);
                metaDataKey.timestamp = resultSet.getLong(8);
                String string = resultSet.getString(2);
                this.uncommonMetaData.put(metaDataKey, (Object)string);
                if (thread != null) {
                    thread.getMetaData().put(metaDataKey, (Object)string);
                }
                stringBuffer.append("<tau:attribute><tau:name>");
                String string3 = metaDataKey.timer_context + " : " + metaDataKey.call_number + " : " + metaDataKey.timestamp + " : " + metaDataKey.name;
                stringBuffer.append(string3);
                stringBuffer.append("</tau:name><tau:timer_context>");
                stringBuffer.append(metaDataKey.timer_context);
                stringBuffer.append("</tau:timer_context><tau:call_number>");
                stringBuffer.append(metaDataKey.call_number);
                stringBuffer.append("</tau:call_number><tau:timestamp>");
                stringBuffer.append(metaDataKey.timestamp);
                stringBuffer.append("</tau:timestamp><tau:value>");
                stringBuffer.append(string);
                stringBuffer.append("</tau:value></tau:attribute>");
            }
            resultSet.close();
            if (bl) {
                stringBuffer.append("</tau:ProfileAttributes>");
            }
            stringBuffer.append("</tau:metadata>");
            this.setField("XML_METADATA", stringBuffer.toString());
            this.setXmlMetaDataLoaded(true);
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred loading metadata for trial object from TAUdb database.");
            sQLException.printStackTrace();
        }
    }
}

