/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerJTabbedPane;
import client.SAXTreeViewer;
import common.RMISortableIntervalEvent;
import common.RMIView;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalLocationProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import java.awt.Component;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.table.AbstractTableModel;

public class PerfExplorerTableModel
extends AbstractTableModel {
    private Application application = null;
    private Experiment experiment = null;
    private Trial trial = null;
    private Metric metric = null;
    private RMISortableIntervalEvent event = null;
    private IntervalLocationProfile ilp = null;
    private RMIView view = null;
    private int type = -1;
    private String[] columnNames = new String[]{"Field", "Value"};
    private int currentTrial = 0;
    private int dividerLocation = 200;

    public PerfExplorerTableModel(Object object) {
        if (object != null) {
            this.updateObject(object);
        }
    }

    public void updateObject(Object object) {
        JSplitPane jSplitPane = (JSplitPane)PerfExplorerJTabbedPane.getPane().getTab(0);
        if (jSplitPane.getBottomComponent() != null) {
            this.dividerLocation = jSplitPane.getDividerLocation();
        }
        jSplitPane.setBottomComponent(null);
        this.currentTrial = 0;
        if (object instanceof Application) {
            this.application = (Application)object;
            this.type = 0;
        } else if (object instanceof Experiment) {
            this.experiment = (Experiment)object;
            this.type = 1;
        } else if (object instanceof Trial) {
            this.trial = (Trial)object;
            this.type = 2;
        } else if (object instanceof Metric) {
            this.metric = (Metric)object;
            this.type = 3;
        } else if (object instanceof RMISortableIntervalEvent) {
            this.event = (RMISortableIntervalEvent)object;
            try {
                this.ilp = this.event.getMeanSummary();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.type = 4;
        } else if (object instanceof RMIView) {
            this.view = (RMIView)object;
            this.type = 5;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        switch (this.type) {
            case 0: {
                return this.application.getNumFields() + 2;
            }
            case 1: {
                return this.experiment.getNumFields() + 2;
            }
            case 2: {
                return this.trial.getNumFields() + 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return RMIView.getFieldCount();
            }
        }
        return 0;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValueAt(int n, int n2) {
        switch (this.type) {
            case 0: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Application ID";
                        }
                    }
                    if (this.application.getFieldName(n - 2) == null) return "";
                    return this.application.getFieldName(n - 2);
                }
                switch (n) {
                    case 0: {
                        return this.application.getName();
                    }
                    case 1: {
                        return new Integer(this.application.getID());
                    }
                }
                if (this.application.getField(n - 2) == null) return "";
                return this.application.getField(n - 2);
            }
            case 1: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Experiment ID";
                        }
                    }
                    if (this.experiment.getFieldName(n - 2) == null) return "";
                    return this.experiment.getFieldName(n - 2);
                }
                switch (n) {
                    case 0: {
                        return this.experiment.getName();
                    }
                    case 1: {
                        return new Integer(this.experiment.getID());
                    }
                }
                if (this.experiment.getField(n - 2) == null) return "";
                return this.experiment.getField(n - 2);
            }
            case 2: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Trial ID";
                        }
                    }
                    if (this.trial.getFieldName(n - 2) == null) return "";
                    return this.trial.getFieldName(n - 2);
                }
                switch (n) {
                    case 0: {
                        return this.trial.getName();
                    }
                    case 1: {
                        return new Integer(this.trial.getID());
                    }
                }
                if (this.trial.getField(n - 2) == null) return "";
                if (!this.trial.getFieldName(n - 2).equalsIgnoreCase("XML_METADATA") || this.trial.getID() == this.currentTrial) return this.trial.getField(n - 2);
                try {
                    SAXTreeViewer sAXTreeViewer = new SAXTreeViewer();
                    JSplitPane jSplitPane = (JSplitPane)PerfExplorerJTabbedPane.getPane().getTab(0);
                    JScrollPane jScrollPane = new JScrollPane((Component)sAXTreeViewer.getTreeTable(this.trial.getField(n - 2)));
                    JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                    jScrollBar.setUnitIncrement(35);
                    jSplitPane.setBottomComponent(jScrollPane);
                    jSplitPane.setDividerLocation(this.dividerLocation);
                    this.currentTrial = this.trial.getID();
                    return this.trial.getFieldName(n - 2);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    exception.printStackTrace();
                }
            }
            case 3: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Metric ID";
                        }
                        case 2: {
                            return "Trial ID";
                        }
                    }
                    return "";
                }
                switch (n) {
                    case 0: {
                        return this.metric.getName();
                    }
                    case 1: {
                        return new Integer(this.metric.getID());
                    }
                    case 2: {
                        return new Integer(this.metric.getTrialID());
                    }
                }
                return "";
            }
            case 4: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Interval Event ID";
                        }
                        case 2: {
                            return "Group Name";
                        }
                        case 3: {
                            return "Trial ID";
                        }
                        case 4: {
                            return "Number of Calls";
                        }
                        case 5: {
                            return "Number of Subroutines";
                        }
                        case 6: {
                            return "Exclusive";
                        }
                        case 7: {
                            return "Exclusive Percentage";
                        }
                        case 8: {
                            return "Inclusive";
                        }
                        case 9: {
                            return "Inclusive Percentage";
                        }
                        case 10: {
                            return "Inclusive Per Call";
                        }
                    }
                    return "";
                }
                DecimalFormat decimalFormat = new DecimalFormat("#,##0");
                DecimalFormat decimalFormat2 = new DecimalFormat("#,##0.00");
                FieldPosition fieldPosition = new FieldPosition(0);
                StringBuffer stringBuffer = new StringBuffer();
                switch (n) {
                    case 0: {
                        return this.event.getName();
                    }
                    case 1: {
                        return new Integer(this.event.getID());
                    }
                    case 2: {
                        return this.event.getGroup();
                    }
                    case 3: {
                        return new Integer(this.event.getTrialID());
                    }
                    case 4: {
                        decimalFormat.format(this.ilp.getNumCalls(), stringBuffer, fieldPosition);
                        return stringBuffer.toString();
                    }
                    case 5: {
                        decimalFormat.format(this.ilp.getNumSubroutines(), stringBuffer, fieldPosition);
                        return stringBuffer.toString();
                    }
                    case 6: {
                        decimalFormat2.format(this.ilp.getExclusive(this.event.metricIndex), stringBuffer, fieldPosition);
                        return stringBuffer.toString();
                    }
                    case 7: {
                        decimalFormat2.format(this.ilp.getExclusivePercentage(this.event.metricIndex), stringBuffer, fieldPosition);
                        stringBuffer.append("%");
                        return stringBuffer.toString();
                    }
                    case 8: {
                        decimalFormat2.format(this.ilp.getInclusive(this.event.metricIndex), stringBuffer, fieldPosition);
                        return stringBuffer.toString();
                    }
                    case 9: {
                        decimalFormat2.format(this.ilp.getInclusivePercentage(this.event.metricIndex), stringBuffer, fieldPosition);
                        stringBuffer.append("%");
                        return stringBuffer.toString();
                    }
                    case 10: {
                        decimalFormat2.format(this.ilp.getInclusivePerCall(this.event.metricIndex), stringBuffer, fieldPosition);
                        return stringBuffer.toString();
                    }
                }
                return "";
            }
            case 5: {
                if (n2 == 0) {
                    if (RMIView.getFieldName(n) == null) return "";
                    return RMIView.getFieldName(n);
                }
                if (this.view.getField(n) == null) return "";
                return this.view.getField(n);
            }
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

