/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.JTreeContentHandler;
import client.JTreeErrorHandler;
import client.JTreeLexicalHandler;
import client.TreePortionCellRenderer;
import client.XMLModel;
import edu.uoregon.tau.common.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.common.treetable.JTreeTable;
import java.awt.Component;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXTreeViewer
extends JFrame {
    private String vendorParserClass = "org.apache.xerces.parsers.SAXParser";
    private JTreeTable jTreeTable;
    AbstractTreeTableModel xmlModel;

    public SAXTreeViewer() {
        super("SAX Tree Viewer");
        this.setSize(600, 450);
    }

    public void init(String string) throws IOException, SAXException {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("XML String");
        this.buildTree(string);
        this.getContentPane().add((Component)new JScrollPane((Component)this.jTreeTable), "Center");
    }

    public JTreeTable getTreeTable(String string) throws IOException, SAXException {
        Object var2_2 = null;
        this.jTreeTable = this.buildTree(string);
        this.jTreeTable.expandAll(true);
        return this.jTreeTable;
    }

    public JTreeTable buildTree(String string) throws IOException, SAXException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader(this.vendorParserClass);
        JTreeContentHandler jTreeContentHandler = new JTreeContentHandler();
        JTreeErrorHandler jTreeErrorHandler = new JTreeErrorHandler();
        JTreeLexicalHandler jTreeLexicalHandler = new JTreeLexicalHandler(jTreeContentHandler);
        xMLReader.setContentHandler(jTreeContentHandler);
        xMLReader.setErrorHandler(jTreeErrorHandler);
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", jTreeLexicalHandler);
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        xMLReader.parse(inputSource);
        this.xmlModel = new XMLModel(jTreeContentHandler.getRoot());
        JTreeTable jTreeTable = new JTreeTable(this.xmlModel, true, false);
        jTreeTable.getTree().setCellRenderer(new TreePortionCellRenderer());
        return jTreeTable;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.out.println("Usage: java SAXTreeViewer [XML Document URI]");
                System.exit(0);
            }
            SAXTreeViewer sAXTreeViewer = new SAXTreeViewer();
            sAXTreeViewer.init(stringArray[0]);
            sAXTreeViewer.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

