/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import scalasca.cubex.cube.Cartesian;
import scalasca.cubex.cube.Cnode;
import scalasca.cubex.cube.CubeCalculationFlavour;
import scalasca.cubex.cube.ExclusiveMetric;
import scalasca.cubex.cube.InclusiveMetric;
import scalasca.cubex.cube.Location;
import scalasca.cubex.cube.LocationGroup;
import scalasca.cubex.cube.LocationGroupType;
import scalasca.cubex.cube.LocationType;
import scalasca.cubex.cube.Machine;
import scalasca.cubex.cube.Metric;
import scalasca.cubex.cube.MetricType;
import scalasca.cubex.cube.Node;
import scalasca.cubex.cube.Process;
import scalasca.cubex.cube.Region;
import scalasca.cubex.cube.SystemTreeNode;
import scalasca.cubex.cube.Thread;
import scalasca.cubex.cube.Vertex;
import scalasca.cubex.cube.cubeparser.CubeParser;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.BadCubeReportLayoutException;
import scalasca.cubex.cube.errors.BadSyntaxException;
import scalasca.cubex.cube.errors.NotEnumeratedCnodeException;
import scalasca.cubex.cube.errors.UnknownMetricTypeException;
import scalasca.cubex.cube.errors.UnknownValueTypeException;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.CubeFileFilter;
import scalasca.cubex.cube.services.ProgressReport;
import scalasca.cubex.cubexlayout.CubeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cube
extends ProgressReport {
    private boolean loading = false;
    private FileInputStream fis;
    private BufferedInputStream buffered_fis;
    private CubeLayout cube_tar_layout;
    protected String filename;
    protected String version;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected ArrayList<String> mirrors = new ArrayList();
    protected ArrayList<Metric> metv = new ArrayList();
    protected ArrayList<Metric> root_metv = new ArrayList();
    protected ArrayList<Region> regionv = new ArrayList();
    protected ArrayList<Cnode> cnodev = new ArrayList();
    protected ArrayList<Cnode> root_cnodev = new ArrayList();
    protected ArrayList<SystemTreeNode> stnv = new ArrayList();
    protected ArrayList<SystemTreeNode> root_stnv = new ArrayList();
    protected ArrayList<SystemTreeNode> non_root_stnv = new ArrayList();
    protected ArrayList<LocationGroup> lgv = new ArrayList();
    protected ArrayList<Location> locv = new ArrayList();
    protected ArrayList<Cartesian> cartv = new ArrayList();
    protected String metricsTreeTitle = "";
    protected String callTreeTitle = "";
    protected String systemTreeTitle = "";

    public void openCubeReport(String string) throws BadSyntaxException, BadCubeReportLayoutException, FileNotFoundException, IOException {
        try {
            this.progressContext.setNextStep(0.04);
            this.progressContext.setProgressMessage("Open report and get the achor file...");
            this.loading = true;
            this.filename = string;
            File file = new File(this.filename);
            this.progressContext.setAchievedStep();
            this.progressContext.setNextStep(0.22);
            this.progressContext.setProgressMessage("Parsing report structure...");
            this.cube_tar_layout = CubeLayout.getCubeLayout(file.getPath());
            this.progressContext.setAchievedStep();
            this.progressContext.setNextStep(0.04);
            this.progressContext.setProgressMessage("Parsing meta data of the report...");
            byte[] byArray = this.cube_tar_layout.getAnchorBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            CubeParser cubeParser = new CubeParser(this);
            xMLReader.setContentHandler(cubeParser);
            xMLReader.setErrorHandler(cubeParser);
            this.progressContext.setSubActor(cubeParser);
            xMLReader.parse(new InputSource(byteArrayInputStream));
            this.progressContext.setAchievedStep();
            this.progressContext.setProgressMessage("Load binary data...");
            this.loadData();
            this.cube_tar_layout = null;
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            this.loading = false;
        }
        catch (BadCubeReportLayoutException badCubeReportLayoutException) {
            throw badCubeReportLayoutException;
        }
        catch (SAXException sAXException) {
            throw new BadSyntaxException(sAXException.getMessage());
        }
    }

    public void set_version(String string) {
        this.version = string;
    }

    public String get_version() {
        return this.version;
    }

    public void def_attr(String string, String string2) {
        if (string != null) {
            this.attributes.put(string, string2);
        }
    }

    public String get_attr(String string) {
        if (string != null) {
            return this.attributes.get(string);
        }
        return null;
    }

    public void def_mirror(String string) {
        if (string != null) {
            this.mirrors.add(string);
        }
    }

    public Metric def_met(String string, String string2, String string3, String string4, String string5, String string6, MetricType metricType, Metric metric) throws UnknownMetricTypeException, UnknownValueTypeException, WrongNumberOfValueParametersException {
        int n = this.metv.size();
        Metric metric2 = this.def_met(n, metricType, metric);
        if (metric2 != null) {
            metric2.init(string, string2, string3, string4, string5, string6);
        }
        return metric2;
    }

    public Metric def_met(int n, String string, String string2, String string3, String string4, String string5, String string6, MetricType metricType, Metric metric) throws UnknownMetricTypeException, UnknownValueTypeException, WrongNumberOfValueParametersException {
        Metric metric2 = this.def_met(n, metricType, metric);
        if (metric2 != null) {
            metric2.init(string, string2, string3, string4, string5, string6);
        }
        return metric2;
    }

    public Metric def_met(int n, MetricType metricType, Metric metric) throws UnknownMetricTypeException, WrongNumberOfValueParametersException {
        Metric metric2 = null;
        if ((metricType == MetricType.INCLUSIVE || metricType == MetricType.EXCLUSIVE) && this.metv.size() <= n) {
            this.metv.ensureCapacity(n + 1);
            for (int i = this.metv.size(); i < n + 1; ++i) {
                this.metv.add(null);
            }
        }
        switch (metricType) {
            case INCLUSIVE: {
                metric2 = new InclusiveMetric(n, metric);
                this.metv.set(n, metric2);
                if (metric != null) break;
                this.root_metv.add(metric2);
                break;
            }
            case EXCLUSIVE: {
                metric2 = new ExclusiveMetric(n, metric);
                this.metv.set(n, metric2);
                if (metric != null) break;
                this.root_metv.add(metric2);
                break;
            }
            default: {
                throw new UnknownMetricTypeException(metricType);
            }
        }
        return metric2;
    }

    public Region def_region(String string, String string2, String string3, String string4, int n, int n2, String string5, String string6, String string7) {
        int n3 = this.regionv.size();
        return this.def_region(string, string2, string3, string4, n, n2, string5, string6, string7);
    }

    public Region def_region(int n, String string, String string2, String string3, String string4, int n2, int n3, String string5, String string6, String string7) {
        Region region = null;
        if (this.regionv.size() <= n) {
            this.regionv.ensureCapacity(n + 1);
            for (int i = this.regionv.size(); i < n + 1; ++i) {
                this.regionv.add(null);
            }
        }
        region = new Region(n, string, string2, string3, string4, n2, n3, string7, string5, string6);
        this.regionv.set(n, region);
        return region;
    }

    public Cnode def_cnode(int n, Cnode cnode) {
        int n2 = this.cnodev.size();
        return this.def_cnode(n2, n, cnode);
    }

    public Cnode def_cnode(int n, int n2, Cnode cnode) {
        if (this.cnodev.size() <= n) {
            this.cnodev.ensureCapacity(n + 1);
            for (int i = this.cnodev.size(); i < n + 1; ++i) {
                this.cnodev.add(null);
            }
        }
        Region region = this.regionv.get(n2);
        Cnode cnode2 = new Cnode(n, region, cnode);
        this.cnodev.set(n, cnode2);
        if (cnode == null) {
            this.root_cnodev.add(cnode2);
        }
        return cnode2;
    }

    public SystemTreeNode def_system_tree_node(String string, String string2, String string3, SystemTreeNode systemTreeNode) {
        int n = this.stnv.size();
        return this.def_system_tree_node(n, string, string2, string3, systemTreeNode);
    }

    public SystemTreeNode def_system_tree_node(int n, SystemTreeNode systemTreeNode) {
        if (this.stnv.size() <= n) {
            this.stnv.ensureCapacity(n + 1);
            for (int i = this.stnv.size(); i < n + 1; ++i) {
                this.stnv.add(null);
            }
        }
        SystemTreeNode systemTreeNode2 = new SystemTreeNode(n, systemTreeNode);
        this.stnv.set(n, systemTreeNode2);
        if (systemTreeNode == null) {
            this.root_stnv.add(systemTreeNode2);
        } else {
            this.non_root_stnv.add(systemTreeNode2);
        }
        return systemTreeNode2;
    }

    public SystemTreeNode def_system_tree_node(int n, String string, String string2, String string3, SystemTreeNode systemTreeNode) {
        SystemTreeNode systemTreeNode2 = this.def_system_tree_node(n, systemTreeNode);
        systemTreeNode2.init(string, string2, string3);
        return systemTreeNode2;
    }

    public SystemTreeNode def_machine(String string, String string2) {
        return new Machine(this.def_system_tree_node(string, string2, "machine", null));
    }

    public SystemTreeNode def_machine(int n) {
        return new Machine(this.def_system_tree_node(n, "noname machine", "", "machine", null));
    }

    public SystemTreeNode def_machine(int n, String string, String string2) {
        return new Machine(this.def_system_tree_node(n, string, string2, "machine", null));
    }

    public SystemTreeNode def_node(String string, String string2, SystemTreeNode systemTreeNode) {
        return new Node(this.def_system_tree_node(string, string2, "node", systemTreeNode), systemTreeNode);
    }

    public SystemTreeNode def_node(int n, SystemTreeNode systemTreeNode) {
        return new Node(this.def_system_tree_node(n, "noname node", "", "node", systemTreeNode), systemTreeNode);
    }

    public SystemTreeNode def_node(int n, String string, String string2, SystemTreeNode systemTreeNode) {
        return new Node(this.def_system_tree_node(n, string, string2, "node", systemTreeNode), systemTreeNode);
    }

    public LocationGroup def_location_group(long l, String string, LocationGroupType locationGroupType, SystemTreeNode systemTreeNode) {
        int n = this.lgv.size();
        LocationGroup locationGroup = this.def_location_group(n, systemTreeNode);
        locationGroup.init(l, string, locationGroupType);
        return locationGroup;
    }

    public LocationGroup def_location_group(int n, SystemTreeNode systemTreeNode) {
        if (this.lgv.size() <= n) {
            this.lgv.ensureCapacity(n + 1);
            for (int i = this.lgv.size(); i < n + 1; ++i) {
                this.lgv.add(null);
            }
        }
        LocationGroup locationGroup = new LocationGroup(n, systemTreeNode);
        this.lgv.set(n, locationGroup);
        return locationGroup;
    }

    public LocationGroup def_location_group(SystemTreeNode systemTreeNode) {
        int n = this.lgv.size();
        return this.def_location_group(n, systemTreeNode);
    }

    public LocationGroup def_location_group(int n, long l, String string, LocationGroupType locationGroupType, SystemTreeNode systemTreeNode) {
        LocationGroup locationGroup = this.def_location_group(n, systemTreeNode);
        locationGroup.init(l, string, locationGroupType);
        return locationGroup;
    }

    public LocationGroup def_proc(long l, String string, SystemTreeNode systemTreeNode) {
        return new Process(this.def_location_group(l, string, LocationGroupType.PROCESS, systemTreeNode), systemTreeNode);
    }

    public LocationGroup def_proc(int n, SystemTreeNode systemTreeNode) {
        return new Process(this.def_location_group(n, systemTreeNode), systemTreeNode);
    }

    public LocationGroup def_proc(int n, long l, String string, SystemTreeNode systemTreeNode) {
        return new Process(this.def_location_group(n, l, string, LocationGroupType.PROCESS, systemTreeNode), systemTreeNode);
    }

    public Location def_location(long l, String string, LocationType locationType, LocationGroup locationGroup) {
        int n = this.locv.size();
        return this.def_location(n, l, string, locationType, locationGroup);
    }

    public Location def_location(int n, LocationGroup locationGroup) {
        if (this.locv.size() <= n) {
            this.locv.ensureCapacity(n + 1);
            for (int i = this.locv.size(); i < n + 1; ++i) {
                this.locv.add(null);
            }
        }
        Location location = new Location(n, locationGroup);
        location.init(0L, "", LocationType.CPU_THREAD);
        this.locv.set(n, location);
        return location;
    }

    public Location def_location(LocationGroup locationGroup) {
        int n = this.locv.size();
        return this.def_location(n, locationGroup);
    }

    public Location def_location(int n, long l, String string, LocationType locationType, LocationGroup locationGroup) {
        Location location = this.def_thrd(n, locationGroup);
        location.init(l, string, locationType);
        return location;
    }

    public Location def_thrd(long l, String string, LocationGroup locationGroup) {
        return new Thread(this.def_location(l, string, LocationType.CPU_THREAD, locationGroup), locationGroup);
    }

    public Location def_thrd(int n, LocationGroup locationGroup) {
        return new Thread(this.def_location(n, locationGroup), locationGroup);
    }

    public Location def_thrd(int n, long l, String string, LocationGroup locationGroup) {
        return new Thread(this.def_location(n, l, string, LocationType.CPU_THREAD, locationGroup), locationGroup);
    }

    public Cartesian def_cart(int n, ArrayList<Integer> arrayList, ArrayList<Boolean> arrayList2) {
        Cartesian cartesian = new Cartesian(n, arrayList, arrayList2);
        this.cartv.add(cartesian);
        return cartesian;
    }

    public ArrayList<Metric> get_metv() {
        return this.metv;
    }

    public ArrayList<Metric> get_root_metv() {
        return this.root_metv;
    }

    public ArrayList<Region> get_regionv() {
        return this.regionv;
    }

    public ArrayList<Cnode> get_cnodev() {
        return this.cnodev;
    }

    public ArrayList<Cnode> get_root_cnodev() {
        return this.root_cnodev;
    }

    public ArrayList<SystemTreeNode> get_root_stnv() {
        return this.root_stnv;
    }

    public ArrayList<Machine> get_machv() {
        ArrayList<Machine> arrayList = new ArrayList<Machine>();
        for (SystemTreeNode systemTreeNode : this.stnv) {
            if (systemTreeNode.getSystemTreeNodeClass() != "machine") continue;
            arrayList.add((Machine)systemTreeNode);
        }
        return arrayList;
    }

    public ArrayList<Node> get_nodev() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (SystemTreeNode systemTreeNode : this.stnv) {
            if (systemTreeNode.getSystemTreeNodeClass() != "node") continue;
            arrayList.add((Node)systemTreeNode);
        }
        return arrayList;
    }

    public ArrayList<Process> get_procv() {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        for (LocationGroup locationGroup : this.lgv) {
            if (locationGroup.getType() != LocationGroupType.PROCESS) continue;
            arrayList.add((Process)locationGroup);
        }
        return arrayList;
    }

    public ArrayList<Thread> get_thrdv() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        for (Location location : this.locv) {
            if (location.getType() != LocationType.CPU_THREAD) continue;
            arrayList.add((Thread)location);
        }
        return arrayList;
    }

    public ArrayList<SystemTreeNode> get_stnv() {
        return this.stnv;
    }

    public ArrayList<LocationGroup> get_location_groupv() {
        return this.lgv;
    }

    public ArrayList<Location> get_locationv() {
        return this.locv;
    }

    public ArrayList<Cartesian> get_cartv() {
        return this.cartv;
    }

    public void set_metricstree_title(String string) {
        this.metricsTreeTitle = string;
    }

    public void set_calltree_title(String string) {
        this.callTreeTitle = string;
    }

    public void set_systemtree_title(String string) {
        this.systemTreeTitle = string;
    }

    public String get_metricstree_title() {
        return this.metricsTreeTitle;
    }

    public String get_calltree_title() {
        return this.callTreeTitle;
    }

    public String get_systemtree_title() {
        return this.systemTreeTitle;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void set_sev(Metric metric, Cnode cnode, Location location, String string) throws NotEnumeratedCnodeException {
        metric.set_sev(cnode, location, string);
    }

    public void set_sev(Metric metric, Cnode cnode, Thread thread, String string) throws NotEnumeratedCnodeException {
        metric.set_sev(cnode, thread, string);
    }

    public double get_sev(Metric metric, CubeCalculationFlavour cubeCalculationFlavour) throws NotEnumeratedCnodeException {
        Value value = this.get_sev_adv(metric, cubeCalculationFlavour);
        return value.getDouble();
    }

    public double get_sev(Metric metric, CubeCalculationFlavour cubeCalculationFlavour, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour2) throws NotEnumeratedCnodeException {
        Value value = this.get_sev_adv(metric, cubeCalculationFlavour, cnode, cubeCalculationFlavour2);
        return value.getDouble();
    }

    public double get_sev(Metric metric, CubeCalculationFlavour cubeCalculationFlavour, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour2, SystemTreeNode systemTreeNode, CubeCalculationFlavour cubeCalculationFlavour3) throws NotEnumeratedCnodeException {
        Value value = this.get_sev_adv(metric, cubeCalculationFlavour, cnode, cubeCalculationFlavour2, systemTreeNode, cubeCalculationFlavour3);
        return value.getDouble();
    }

    public double get_sev(Metric metric, CubeCalculationFlavour cubeCalculationFlavour, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour2, LocationGroup locationGroup, CubeCalculationFlavour cubeCalculationFlavour3) throws NotEnumeratedCnodeException {
        Value value = this.get_sev_adv(metric, cubeCalculationFlavour, cnode, cubeCalculationFlavour2, locationGroup, cubeCalculationFlavour3);
        return value.getDouble();
    }

    public double get_sev(Metric metric, CubeCalculationFlavour cubeCalculationFlavour, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour2, Location location, CubeCalculationFlavour cubeCalculationFlavour3) throws NotEnumeratedCnodeException {
        Value value = this.get_sev_adv(metric, cubeCalculationFlavour, cnode, cubeCalculationFlavour2, location, cubeCalculationFlavour3);
        return value.getDouble();
    }

    public Value get_sev_adv(Metric metric, CubeCalculationFlavour cubeCalculationFlavour) throws NotEnumeratedCnodeException {
        ArrayList<Cnode> arrayList = this.get_root_cnodev();
        Value value = null;
        for (Cnode object : arrayList) {
            if (value == null) {
                value = metric.get_sev(object, CubeCalculationFlavour.INCLUSIVE);
                continue;
            }
            value.addValue(metric.get_sev(object, CubeCalculationFlavour.INCLUSIVE));
        }
        if (cubeCalculationFlavour == CubeCalculationFlavour.EXCLUSIVE) {
            ArrayList<Vertex> arrayList2 = metric.getAllChildren();
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Vertex vertex = (Vertex)iterator.next();
                value.subtractValue(this.get_sev_adv((Metric)vertex, CubeCalculationFlavour.INCLUSIVE));
            }
        }
        return value;
    }

    public Value get_sev_adv(Metric metric, CubeCalculationFlavour cubeCalculationFlavour, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour2) throws NotEnumeratedCnodeException {
        Value value = null;
        value = metric.get_sev(cnode, cubeCalculationFlavour2);
        if (cubeCalculationFlavour == CubeCalculationFlavour.EXCLUSIVE) {
            ArrayList<Vertex> arrayList = metric.getAllChildren();
            for (Vertex vertex : arrayList) {
                value.subtractValue(this.get_sev_adv((Metric)vertex, CubeCalculationFlavour.INCLUSIVE, cnode, cubeCalculationFlavour2));
            }
        }
        return value;
    }

    public Value get_sev_adv(Metric metric, CubeCalculationFlavour cubeCalculationFlavour, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour2, SystemTreeNode systemTreeNode, CubeCalculationFlavour cubeCalculationFlavour3) throws NotEnumeratedCnodeException {
        Value value = null;
        value = metric.get_sev(cnode, cubeCalculationFlavour2, systemTreeNode, cubeCalculationFlavour3);
        if (cubeCalculationFlavour == CubeCalculationFlavour.EXCLUSIVE) {
            ArrayList<Vertex> arrayList = metric.getAllChildren();
            for (Vertex vertex : arrayList) {
                value.subtractValue(this.get_sev_adv((Metric)vertex, CubeCalculationFlavour.INCLUSIVE, cnode, cubeCalculationFlavour2, systemTreeNode, cubeCalculationFlavour3));
            }
        }
        return value;
    }

    public Value get_sev_adv(Metric metric, CubeCalculationFlavour cubeCalculationFlavour, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour2, LocationGroup locationGroup, CubeCalculationFlavour cubeCalculationFlavour3) throws NotEnumeratedCnodeException {
        Value value = null;
        value = metric.get_sev(cnode, cubeCalculationFlavour2, locationGroup, cubeCalculationFlavour3);
        if (cubeCalculationFlavour == CubeCalculationFlavour.EXCLUSIVE) {
            ArrayList<Vertex> arrayList = metric.getAllChildren();
            for (Vertex vertex : arrayList) {
                value.subtractValue(this.get_sev_adv((Metric)vertex, CubeCalculationFlavour.INCLUSIVE, cnode, cubeCalculationFlavour2, locationGroup, cubeCalculationFlavour3));
            }
        }
        return value;
    }

    public Value get_sev_adv(Metric metric, CubeCalculationFlavour cubeCalculationFlavour, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour2, Location location, CubeCalculationFlavour cubeCalculationFlavour3) throws NotEnumeratedCnodeException {
        Value value = null;
        value = metric.get_sev(cnode, cubeCalculationFlavour2, location, cubeCalculationFlavour3);
        if (cubeCalculationFlavour == CubeCalculationFlavour.EXCLUSIVE) {
            ArrayList<Vertex> arrayList = metric.getAllChildren();
            for (Vertex vertex : arrayList) {
                value.subtractValue(this.get_sev_adv((Metric)vertex, CubeCalculationFlavour.INCLUSIVE, cnode, cubeCalculationFlavour2, location, cubeCalculationFlavour3));
            }
        }
        return value;
    }

    public double get_sev(Metric metric, Cnode cnode, Location location) throws NotEnumeratedCnodeException {
        return this.get_sev(metric, cnode, CubeCalculationFlavour.EXCLUSIVE, location);
    }

    public double get_sev(Metric metric, Cnode cnode, Thread thread) throws NotEnumeratedCnodeException {
        return this.get_sev(metric, cnode, CubeCalculationFlavour.EXCLUSIVE, (Location)thread);
    }

    public double get_sev(Metric metric, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour, Location location) throws NotEnumeratedCnodeException {
        Value value = this.get_sev_adv(metric, cnode, cubeCalculationFlavour, location);
        return value.getDouble();
    }

    public double get_sev(Metric metric, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour, Thread thread) throws NotEnumeratedCnodeException {
        Value value = this.get_sev_adv(metric, cnode, cubeCalculationFlavour, (Location)thread);
        return value.getDouble();
    }

    public Value get_sev_adv(Metric metric, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour, Location location) throws NotEnumeratedCnodeException {
        return metric.get_sev(cnode, cubeCalculationFlavour, location, CubeCalculationFlavour.EXCLUSIVE);
    }

    public Value get_sev_adv(Metric metric, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour, Thread thread) throws NotEnumeratedCnodeException {
        return metric.get_sev(cnode, cubeCalculationFlavour, thread, CubeCalculationFlavour.EXCLUSIVE);
    }

    public Value get_sev_adv(Metric metric, Cnode cnode, Location location) throws NotEnumeratedCnodeException {
        return this.get_sev_adv(metric, cnode, CubeCalculationFlavour.EXCLUSIVE, location);
    }

    public Value get_sev_adv(Metric metric, Cnode cnode, Thread thread) throws NotEnumeratedCnodeException {
        return this.get_sev_adv(metric, cnode, CubeCalculationFlavour.EXCLUSIVE, (Location)thread);
    }

    private void loadData() throws BadCubeReportLayoutException {
        if (!(this.version.equalsIgnoreCase("4.0") || this.version.equalsIgnoreCase("4.1") || this.version.equalsIgnoreCase("4.2") || this.version.equalsIgnoreCase("4.3") || this.version.equalsIgnoreCase("4.4"))) {
            this.progressContext.setNextStep(0.3);
            return;
        }
        double d = 0.7 / (double)this.metv.size();
        for (Metric metric : this.metv) {
            this.progressContext.setNextStep(d);
            this.progressContext.setProgressMessage("Load data into CUBE for metric: " + metric.getDisplayName());
            metric.createEnumeration(this.root_cnodev);
            try {
                byte[] byArray = this.cube_tar_layout.getMetricIndexBytes(metric.getId());
                byte[] byArray2 = this.cube_tar_layout.getMetricDataBytes(metric.getId());
                this.progressContext.setSubActor(metric);
                if (byArray != null && byArray2 != null) {
                    metric.createDataMatrix(byArray, byArray2, this.cnodev.size(), this.locv.size());
                } else {
                    metric.createDataMatrix(this.cnodev.size(), this.locv.size());
                }
                this.progressContext.setAchievedStep();
                byArray = null;
                byArray2 = null;
            }
            catch (Exception exception) {
                throw new BadCubeReportLayoutException("Cannot load data for metric " + metric.getUniqName() + ". Error: " + exception.getMessage());
            }
        }
    }

    public void prepareForCube3() {
        for (Metric metric : this.metv) {
            metric.createEnumeration(this.root_cnodev);
            metric.createDataMatrix(this.cnodev.size(), this.locv.size());
        }
    }

    public static FileFilter getCubeFilesFilter() {
        return new CubeFileFilter();
    }
}

