/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube;

import scalasca.cubex.cube.LocationGroupType;
import scalasca.cubex.cube.NamedVertex;
import scalasca.cubex.cube.SystemTreeNode;
import scalasca.cubex.cube.errors.BadSyntaxException;

public class LocationGroup
extends NamedVertex {
    protected long rank = -1L;
    LocationGroupType type = LocationGroupType.PROCESS;

    public LocationGroup() {
        super("Process");
    }

    public LocationGroup(int n, SystemTreeNode systemTreeNode) {
        super(n, "Process", null);
        this.parent = systemTreeNode;
        ((SystemTreeNode)this.parent).addLocationGroup(this);
    }

    public LocationGroup(int n, long l, LocationGroupType locationGroupType, SystemTreeNode systemTreeNode) {
        super(n, "Process", null);
        this.parent = systemTreeNode;
        this.type = locationGroupType;
        ((SystemTreeNode)this.parent).addLocationGroup(this);
        this.rank = l;
    }

    public LocationGroup(int n, long l, String string, LocationGroupType locationGroupType, SystemTreeNode systemTreeNode) {
        super(n, string, null);
        this.parent = systemTreeNode;
        this.type = locationGroupType;
        ((SystemTreeNode)this.parent).addLocationGroup(this);
        this.rank = l;
    }

    public void init(long l, String string, LocationGroupType locationGroupType) {
        this.setName(string);
        this.rank = l;
        this.type = locationGroupType;
    }

    public long getRank() {
        return this.rank;
    }

    public String getName() {
        return super.getName() + " " + String.valueOf(this.rank);
    }

    public LocationGroupType getType() {
        return this.type;
    }

    public String getTypeAsString() {
        if (this.type == LocationGroupType.PROCESS) {
            return "process";
        }
        if (this.type == LocationGroupType.METRICS) {
            return "metrics";
        }
        return "not supported";
    }

    public static LocationGroupType getLocationGroupType(String string) throws BadSyntaxException {
        if (string.equals("process")) {
            return LocationGroupType.PROCESS;
        }
        if (string.equals("metrics")) {
            return LocationGroupType.METRICS;
        }
        throw new BadSyntaxException("Do not support location group type " + string);
    }
}

