/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.CubeDouble;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeHistogram
extends Value {
    protected int N;
    protected CubeDouble _service_exemplar = new CubeDouble();
    protected Vector<CubeDouble> values = new Vector();

    public CubeHistogram() {
        this.N = 0;
        this.values.clear();
    }

    public CubeHistogram(int n) {
        this.N = n;
        this.values.clear();
        for (int i = 0; i < this.N; ++i) {
            this.values.add(new CubeDouble());
        }
    }

    public CubeHistogram(Vector<CubeDouble> vector) {
        this.N = vector.size();
        this.values = vector;
    }

    @Override
    public String getName() {
        return "HISTOGRAM";
    }

    @Override
    public String toString() {
        String string = "(";
        for (CubeDouble cubeDouble : this.values) {
            string = string + String.valueOf(cubeDouble.getDouble()) + " ";
        }
        string = string + ")";
        return string;
    }

    @Override
    public int size() {
        return this.N * this._service_exemplar.size();
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        for (CubeDouble cubeDouble : this.values) {
            cubeDouble.correctEndianess(endianess, dataInputStream, dataOutputStream);
        }
    }

    @Override
    public Value clone() {
        return new CubeHistogram(this.N);
    }

    @Override
    public Value copy() {
        Vector<CubeDouble> vector = new Vector<CubeDouble>();
        for (CubeDouble cubeDouble : this.values) {
            vector.add(new CubeDouble(cubeDouble.getDouble()));
        }
        return new CubeHistogram(vector);
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        Vector<CubeDouble> vector = new Vector<CubeDouble>();
        for (CubeDouble cubeDouble : this.values) {
            double d = dataInputStream.readDouble();
            vector.add(new CubeDouble(d));
        }
        return new CubeHistogram(vector);
    }

    @Override
    public void setValue(String string) {
    }

    @Override
    public void setValue(byte by) {
    }

    @Override
    public void setValue(short s) {
    }

    @Override
    public void setValue(int n) {
    }

    @Override
    public void setValue(long l) {
    }

    @Override
    public void setValue(double d) {
    }

    @Override
    public double getDouble() {
        double d = 0.0;
        for (CubeDouble cubeDouble : this.values) {
            d += cubeDouble.getDouble();
        }
        return d;
    }

    public double getN() {
        return this.N;
    }

    @Override
    public void addValue(Value value) {
        CubeHistogram cubeHistogram = (CubeHistogram)value;
    }

    @Override
    public void subtractValue(Value value) {
        CubeHistogram cubeHistogram = (CubeHistogram)value;
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
        if (vector.size() < 1) {
            throw new WrongNumberOfValueParametersException(vector.size(), 1, "HISTOGRAM");
        }
        this.N = vector.get(0).intValue();
        this.values.clear();
        for (int i = 0; i < this.N; ++i) {
            this.values.add(new CubeDouble());
        }
    }
}

