/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeUint64
extends Value {
    protected BigInteger value;

    public CubeUint64() {
        this.value = BigInteger.valueOf(0L);
    }

    public CubeUint64(long l) {
        this.value = BigInteger.valueOf(l);
    }

    @Override
    public String getName() {
        return "UINT64";
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public int size() {
        return 8;
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        long l = dataInputStream.readLong();
        long l2 = endianess.applyOn(l);
        dataOutputStream.writeLong(l2);
    }

    @Override
    public Value clone() {
        return new CubeUint64();
    }

    @Override
    public Value copy() {
        return new CubeUint64(this.value.longValue());
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeUint64(dataInputStream.readLong());
    }

    @Override
    public void setValue(String string) {
        try {
            this.value = new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.value = new BigInteger(new Long((long)Double.valueOf(string).doubleValue()).toString());
        }
    }

    @Override
    public void setValue(byte by) {
        this.value = new BigInteger(Byte.toString(by));
    }

    @Override
    public void setValue(short s) {
        this.value = new BigInteger(Short.toString(s));
    }

    @Override
    public void setValue(int n) {
        this.value = new BigInteger(Integer.toString(n));
    }

    @Override
    public void setValue(long l) {
        this.value = new BigInteger(Long.toString(l));
    }

    @Override
    public void setValue(double d) {
        this.value = new BigInteger(Double.toString(d));
    }

    @Override
    public double getDouble() {
        return this.value.doubleValue();
    }

    @Override
    public void addValue(Value value) {
        CubeUint64 cubeUint64 = (CubeUint64)value;
        this.value = this.value.add(cubeUint64.value);
    }

    @Override
    public void subtractValue(Value value) {
        CubeUint64 cubeUint64 = (CubeUint64)value;
        this.value = this.value.subtract(cubeUint64.value);
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

