/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cubexlayout;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.xeustechnologies.jtar.TarInputStream;
import scalasca.cubex.cube.errors.BadCubeReportLayoutException;
import scalasca.cubex.cube.errors.MissingMetricInCubeReport;
import scalasca.cubex.cube.errors.MissingMiscInCubeReport;
import scalasca.cubex.cubexlayout.CubeLayout;
import scalasca.cubex.tarviewer.BTarEntry;
import scalasca.cubex.tarviewer.BTarInputStream;

public class CubeTarLayout
extends CubeLayout {
    public CubeTarLayout(String string) {
        super(string);
        try {
            BTarEntry bTarEntry;
            BTarInputStream bTarInputStream = new BTarInputStream(new FileInputStream(string));
            while ((bTarEntry = bTarInputStream.next()) != null) {
                HashMap<String, Long> hashMap;
                Serializable serializable;
                String string2;
                if (bTarEntry.getName().compareTo("anchor.xml") == 0) {
                    this.AnchorShift = bTarEntry.getOffset();
                    this.AnchorSize = bTarEntry.getSize();
                    continue;
                }
                if (bTarEntry.getName().endsWith(".data")) {
                    string2 = bTarEntry.getName().substring(0, bTarEntry.getName().indexOf(".data"));
                    serializable = new Long(string2);
                    hashMap = new HashMap<String, Long>();
                    hashMap.put("size", new Long(bTarEntry.getSize()));
                    hashMap.put("offset", new Long(bTarEntry.getOffset()));
                    this.metricDataPlaces.put(serializable, hashMap);
                    continue;
                }
                if (bTarEntry.getName().endsWith(".index")) {
                    string2 = bTarEntry.getName().substring(0, bTarEntry.getName().indexOf(".index"));
                    serializable = new Long(string2);
                    hashMap = new HashMap();
                    hashMap.put("size", new Long(bTarEntry.getSize()));
                    hashMap.put("offset", new Long(bTarEntry.getOffset()));
                    this.metricIndexPlaces.put(serializable, hashMap);
                    continue;
                }
                string2 = bTarEntry.getName();
                serializable = new HashMap<String, Long>();
                ((HashMap)serializable).put("size", new Long(bTarEntry.getSize()));
                ((HashMap)serializable).put("offset", new Long(bTarEntry.getOffset()));
                this.miscDataPlaces.put(string2, serializable);
            }
            if (this.AnchorSize == -1L && this.AnchorShift == -1L) {
                throw new BadCubeReportLayoutException("Not found anchor in cubex file " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public long getAnchorSize() {
        return this.AnchorSize;
    }

    public long getAnchorShift() {
        return this.AnchorShift;
    }

    public long getMetricDataSize(int n) throws MissingMetricInCubeReport {
        Map map = (Map)this.metricDataPlaces.get(new Long(n));
        if (map == null) {
            throw new MissingMetricInCubeReport("Missing " + n + ".data file in cube report");
        }
        return (Long)map.get("size");
    }

    public long getMetricDataShift(int n) throws MissingMetricInCubeReport {
        Map map = (Map)this.metricDataPlaces.get(new Long(n));
        if (map == null) {
            throw new MissingMetricInCubeReport("Missing " + n + ".data file in cube report");
        }
        return (Long)map.get("offset");
    }

    public long getMetricIndexSize(int n) throws MissingMetricInCubeReport {
        Map map = (Map)this.metricIndexPlaces.get(new Long(n));
        if (map == null) {
            throw new MissingMetricInCubeReport("Missing " + n + ".index file in cube report");
        }
        return (Long)map.get("size");
    }

    public long getMetricIndexShift(int n) throws MissingMetricInCubeReport {
        Map map = (Map)this.metricIndexPlaces.get(new Long(n));
        if (map == null) {
            throw new MissingMetricInCubeReport("Missing " + n + ".index file in cube report");
        }
        return (Long)map.get("offset");
    }

    public long getMiscDataSize(String string) throws MissingMiscInCubeReport {
        Map map = (Map)this.miscDataPlaces.get(string);
        if (map == null) {
            throw new MissingMiscInCubeReport("Missing " + string + " file in cube report");
        }
        return (Long)map.get("size");
    }

    public long getMiscDataShift(String string) throws MissingMiscInCubeReport {
        Map map = (Map)this.miscDataPlaces.get(string);
        if (map == null) {
            throw new MissingMiscInCubeReport("Missing " + string + " file in cube report");
        }
        return (Long)map.get("offset");
    }

    public void print() {
        Map map;
        System.out.println("Anchor size:      " + this.AnchorSize);
        System.out.println("Anchor offset:   " + this.AnchorShift);
        System.out.println("===== Data =====");
        for (Long l : this.metricDataPlaces.keySet()) {
            map = (Map)this.metricDataPlaces.get(l);
            System.out.println(l + ".data -> (" + map.get("size") + ", " + map.get("offset") + ")");
        }
        System.out.println("===== Indecies =====");
        for (Long l : this.metricIndexPlaces.keySet()) {
            map = (Map)this.metricIndexPlaces.get(l);
            System.out.println(l + ".index -> (" + map.get("size") + ", " + map.get("offset") + ")");
        }
    }

    static boolean testLayout(String string) {
        try {
            TarInputStream tarInputStream = new TarInputStream(new FileInputStream(string));
            return tarInputStream.getNextEntry().getHeader().magic.substring(0, "ustar".length()).equalsIgnoreCase("ustar");
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public byte[] getAnchorBytes() throws IOException {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(this.filename);
            fileInputStream.skip(this.AnchorShift);
            byte[] byArray = new byte[(int)this.AnchorSize];
            fileInputStream.read(byArray);
            fileInputStream.close();
            String string = new String(byArray, 0, 15);
            if (string.startsWith("<?xml")) {
                return byArray;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            byte[] byArray2 = new byte[0x800000];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + this.filename + " not found.");
            return new byte[0];
        }
    }

    public byte[] getMetricDataBytes(int n) throws IOException {
        File file = new File(this.filename);
        byte[] byArray = null;
        try {
            long l = this.getMetricDataSize(n);
            long l2 = this.getMetricDataShift(n);
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.skip(l2);
            byArray = new byte[(int)l];
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (MissingMetricInCubeReport missingMetricInCubeReport) {
            // empty catch block
        }
        return byArray;
    }

    public byte[] getMetricIndexBytes(int n) throws IOException {
        File file = new File(this.filename);
        byte[] byArray = null;
        try {
            long l = this.getMetricIndexSize(n);
            long l2 = this.getMetricIndexShift(n);
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.skip(l2);
            byArray = new byte[(int)l];
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (MissingMetricInCubeReport missingMetricInCubeReport) {
            // empty catch block
        }
        return byArray;
    }

    public byte[] getMiscDataBytes(String string) throws IOException, MissingMiscInCubeReport {
        File file = new File(this.filename);
        long l = this.getMiscDataSize(string);
        long l2 = this.getMiscDataShift(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.skip(l2);
        byte[] byArray = new byte[(int)l];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }
}

