#include <Profile/CuptiLayer.h>
#include <unistd.h>

using namespace std;

// CrayCC is stupid and doesn't support weak symbols
void * pomp_rd_table;
int POMP_MAX_ID = 0;

int main(int argc, char **argv)
{
    int c;
    bool listCounters = true, checkCounters = false;
    char* counter_list;

    while ((c = getopt(argc, argv, "hc:")) != -1) {
        switch (c) {
        case 'h':
            //printUsage()
            break;
        case 'c':
            checkCounters = true;
            listCounters = false;
            counter_list = optarg;
            break;
        case '?':
            if (optopt == 'c') {
                fprintf(stderr, "Error: Option -c require an argument.\n");
                //printUsage();
                exit(1);
            } else {
                fprintf(stderr, "Error: could not parse arguments.\n");
                //printUsage();
                exit(1);
            }
        default:
            exit(1);
        }
    }

    if (listCounters) {
        Tau_CuptiLayer_Initialize_Map();
        CuptiCounterEvent::printHeader();
        for (counter_map_it it = Tau_CuptiLayer_Counter_Map().begin(); it != Tau_CuptiLayer_Counter_Map().end(); it++) {
            it->second->print();
        }
    }

    if (checkCounters) {
        Tau_CuptiLayer_Initialize_Map();
        if (counter_list == NULL) {
            fprintf(stderr, "ERROR: counter list empty.\n");
            exit(1);
        }
        printf("conter list arg is: %s.\n", counter_list);
        //split counter list by ':' delimiter.
        string counter_list_str = string(counter_list);

        stringstream iss(counter_list_str);
        string item;
        vector<string> tags;
        while (std::getline(iss, item, ':')) {
            tags.push_back(item);
        }

        vector<string> tags_added;
        vector<string> tags_failed;
        vector<CuptiCounterEvent*> counters_added;

        for (vector<string>::iterator it = tags.begin(); it != tags.end(); it++) {
            //printf("size of available counters: %d.\n", Tau_CuptiLayer_Counter_Map.size());

            if (Tau_CuptiLayer_Counter_Map().count(*it) > 0) {
                CuptiCounterEvent *ev = Tau_CuptiLayer_Counter_Map().find(*it)->second;
                //ev->print();
                tags_added.push_back(*it);
                counters_added.push_back(ev);
            } else {
                tags_failed.push_back(*it);
            }
        }

        cout << "Counters successfully set:" << endl;
        for (vector<string>::iterator it = tags_added.begin(); it != tags_added.end(); it++) {
            cout << "\t * " << *it << endl;
        }
        cout << "Failed to set these counters:" << endl;
        for (vector<string>::iterator it = tags_failed.begin(); it != tags_failed.end(); it++) {
            cout << "\t * " << *it << endl;
        }

    }

    return 0;
}
