/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.common.VectorExport;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfexplorer.client.ChartGUI;
import edu.uoregon.tau.perfexplorer.client.CommunicationMatrix;
import edu.uoregon.tau.perfexplorer.client.DatabaseManagerWindow;
import edu.uoregon.tau.perfexplorer.client.DerivedMetricWindow;
import edu.uoregon.tau.perfexplorer.client.LoadTrialWindow;
import edu.uoregon.tau.perfexplorer.client.ParsingException;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerBoxChart;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChart;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerCube;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerExpression;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerHistogramChart;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerProbabilityPlot;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerVariation;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerViews;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerWekaLauncher;
import edu.uoregon.tau.perfexplorer.common.AnalysisType;
import edu.uoregon.tau.perfexplorer.common.Console;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import edu.uoregon.tau.perfexplorer.common.ScriptThread;
import edu.uoregon.tau.perfexplorer.common.TransformationType;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jfree.data.general.SeriesException;

public class PerfExplorerActionListener
implements ActionListener {
    public static final String PARSE_EXPRESSION = "Parse Expression File";
    public static final String REPARSE_EXPRESSION = "Re-Parse Expression File";
    public static final String DATABASE_CONFIGURATION = "Database Configuration";
    public static final String LOADSCRIPT = "Load Analysis Script";
    public static final String RERUNSCRIPT = "Re-run Analysis Script";
    public static final String SAVE_MAIN = "Save Main Window As Vector Image";
    public static final String CONSOLE = "Open New Console Window";
    public static final String QUIT = "Quit PerfExplorer";
    public static final String QUIT_SERVER = "Quit PerfExplorer (Shutdown Server)";
    public static final String LOOK_AND_FEEL = "Set Look and Feel: ";
    public static final String ABOUT = "About PerfExplorer";
    public static final String LOAD_PROFILE = "Load Profile Data";
    public static final String SEARCH = "Search for help on...";
    public static final String CLUSTERING_METHOD = "Select Clustering Method";
    public static final String DIMENSION_REDUCTION = "Select Dimension Reduction";
    public static final String NORMALIZATION = "Select Normalization Method";
    public static final String NUM_CLUSTERS = "Set Maximum Number of Clusters";
    public static final String DO_CLUSTERING = "Do Clustering";
    public static final String DO_INC_CLUSTERING = "Do Inclusive Clustering";
    public static final String DO_CORRELATION_ANALYSIS = "Do Correlation Analysis";
    public static final String DO_INC_CORRELATION_ANALYSIS = "Do Inclusive Correlation Analysis";
    public static final String DO_CORRELATION_CUBE = "Do 3D Correlation Cube";
    public static final String DO_VARIATION_ANALYSIS = "Show Data Summary";
    public static final String DO_LAUNCH_WEKA = "Launch Weka With This Dataset";
    public static final String SET_GROUPNAME = "Set Group Name";
    public static final String SET_PROBLEM_SIZE = "Set Problem Size (Scaling)";
    public static final String SET_METRICNAME = "Set Metric of Interest";
    public static final String SET_TIMESTEPS = "Set Total Number of Timesteps";
    public static final String SET_EVENTNAME = "Set Event of Interest";
    public static final String TIMESTEPS_CHART = "Timesteps Per Second";
    public static final String TOTAL_TIME_CHART = "Total Execution Time";
    public static final String EFFICIENCY_CHART = "Relative Efficiency";
    public static final String EFFICIENCY_EVENTS_CHART = "Relative Efficiency by Event";
    public static final String EFFICIENCY_ONE_EVENT_CHART = "Relative Efficiency for One Event";
    public static final String SPEEDUP_CHART = "Relative Speedup";
    public static final String SPEEDUP_EVENTS_CHART = "Relative Speedup by Event";
    public static final String SPEEDUP_ONE_EVENT_CHART = "Relative Speedup for One Event";
    public static final String COMMUNICATION_CHART = "Group % of Total Runtime";
    public static final String FRACTION_CHART = "Runtime Breakdown";
    public static final String CORRELATION_CHART = "Correlate Events with Total Runtime";
    public static final String STACKED_BAR_CHART = "Stacked Bar Chart";
    public static final String ALIGNED_STACKED_BAR_CHART = "Aligned Stacked Bar Chart";
    public static final String EFFICIENCY_PHASE_CHART = "Relative Efficiency per Phase";
    public static final String SPEEDUP_PHASE_CHART = "Relative Speedup per Phase";
    public static final String FRACTION_PHASE_CHART = "Phase Fraction of Total Runtime";
    public static final String CREATE_NEW_VIEW = "Create New View";
    public static final String CREATE_NEW_SUB_VIEW = "Create New Sub-View";
    public static final String DELETE_CURRENT_VIEW = "Delete Selected View";
    public static final String DO_IQR_BOXCHART = "Create BoxChart";
    public static final String DO_HISTOGRAM = "Create Histograms";
    public static final String DO_PROBABILITY_PLOT = "Create Normal Probability Plot";
    public static final String DO_CHARTS = "Open Scalability Chart Tool";
    public static final String DO_COMMUNICATION_MATRIX = "Show Communication Matrix";
    private PerfExplorerClient mainFrame;
    private String scriptName = null;
    private String scriptDir = null;
    private String expressionFilename;

    public PerfExplorerActionListener(PerfExplorerClient perfExplorerClient) {
        this.mainFrame = perfExplorerClient;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals(QUIT)) {
                    System.exit(0);
                } else if (string.equals(QUIT_SERVER)) {
                    System.exit(0);
                } else if (string.startsWith(LOOK_AND_FEEL)) {
                    UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
                    for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
                        if (!string.endsWith(lookAndFeelInfoArray[i].getName())) continue;
                        try {
                            PerfExplorerClient perfExplorerClient = PerfExplorerClient.getMainFrame();
                            UIManager.setLookAndFeel(lookAndFeelInfoArray[i].getClassName());
                            Frame[] frameArray = Frame.getFrames();
                            for (int j = 0; j < frameArray.length; ++j) {
                                Component[] componentArray = perfExplorerClient.getComponents();
                                for (int k = 0; k < componentArray.length; ++k) {
                                    this.updateAll((Container)componentArray[k]);
                                }
                                frameArray[j].repaint();
                            }
                            continue;
                        }
                        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                            PerfExplorerOutput.println(unsupportedLookAndFeelException.getMessage());
                        }
                    }
                } else if (string.equals(DATABASE_CONFIGURATION)) {
                    this.databaseConfiguration();
                } else if (string.equals(PARSE_EXPRESSION)) {
                    this.parseExpression();
                } else if (string.equals(REPARSE_EXPRESSION)) {
                    this.reparseExpression();
                } else if (string.equals(LOAD_PROFILE)) {
                    this.loadProfile();
                } else if (string.equals(LOADSCRIPT)) {
                    this.loadScript();
                } else if (string.equals(RERUNSCRIPT)) {
                    this.runScript();
                } else if (string.equals(SAVE_MAIN)) {
                    this.saveMain();
                } else if (string.equals(CONSOLE)) {
                    new Console();
                } else if (string.equals(ABOUT)) {
                    this.createAboutWindow();
                } else if (string.equals(SEARCH)) {
                    this.createHelpWindow();
                } else if (string.equals(CLUSTERING_METHOD)) {
                    this.createMethodWindow();
                } else if (string.equals(DIMENSION_REDUCTION)) {
                    this.createDimensionWindow();
                } else if (string.equals(NORMALIZATION)) {
                    this.createNormalizationWindow();
                } else if (string.equals(NUM_CLUSTERS)) {
                    this.createClusterSizeWindow();
                } else if (string.equals(DO_CLUSTERING)) {
                    if (this.validAnalysisSelection()) {
                        PerfExplorerModel.getModel().setClusterValueType("exclusive");
                        this.createDoClusteringWindow();
                    }
                } else if (string.equals(DO_INC_CLUSTERING)) {
                    if (this.validAnalysisSelection()) {
                        this.createDoClusteringWindow();
                        PerfExplorerModel.getModel().setClusterValueType("inclusive");
                    }
                } else if (string.equals(DO_CORRELATION_ANALYSIS)) {
                    if (this.validCorrelationSelection()) {
                        PerfExplorerModel.getModel().setClusterValueType("exclusive");
                        this.createDoCorrelationWindow();
                    }
                } else if (string.equals(DO_INC_CORRELATION_ANALYSIS)) {
                    if (this.validCorrelationSelection()) {
                        PerfExplorerModel.getModel().setClusterValueType("inclusive");
                        this.createDoCorrelationWindow();
                    }
                } else if (string.equals(DO_CORRELATION_CUBE)) {
                    if (this.valid3DSelection()) {
                        PerfExplorerCube.doCorrelationCube();
                    }
                } else if (string.equals(DO_LAUNCH_WEKA)) {
                    if (this.valid3DSelection()) {
                        PerfExplorerWekaLauncher.launch();
                    }
                } else if (string.equals(DO_IQR_BOXCHART)) {
                    if (this.valid3DSelection()) {
                        PerfExplorerBoxChart.doIQRBoxChart();
                    }
                } else if (string.equals(DO_HISTOGRAM)) {
                    if (this.validDistributionSelection()) {
                        PerfExplorerHistogramChart.doHistogram();
                    }
                } else if (string.equals(DO_VARIATION_ANALYSIS)) {
                    if (this.valid3DSelection()) {
                        PerfExplorerVariation.doVariationAnalysis();
                    }
                } else if (string.equals(DO_PROBABILITY_PLOT)) {
                    if (this.validDistributionSelection()) {
                        PerfExplorerProbabilityPlot.doProbabilityPlot();
                    }
                } else if (string.equals(DO_COMMUNICATION_MATRIX)) {
                    if (this.validCommunicationMatrixSelection()) {
                        CommunicationMatrix communicationMatrix = new CommunicationMatrix();
                        communicationMatrix.doCommunicationMatrix();
                    }
                } else if (string.equals(DO_CHARTS)) {
                    this.createChartDialogBox();
                } else if (string.equals(SET_PROBLEM_SIZE)) {
                    this.checkAndSetProblemSize(true);
                } else if (string.equals(SET_GROUPNAME)) {
                    this.checkAndSetGroupName(true);
                } else if (string.equals(SET_METRICNAME)) {
                    this.checkAndSetMetricName(true);
                } else if (string.equals(SET_EVENTNAME)) {
                    this.checkAndSetEventName(true);
                } else if (string.equals(SET_TIMESTEPS)) {
                    this.checkAndSetTimesteps(true);
                } else if (string.equals(TIMESTEPS_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetTimesteps(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doTimestepsChart();
                    }
                } else if (string.equals(TOTAL_TIME_CHART)) {
                    if (this.checkAndSetMetricName(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doTotalTimeChart();
                    }
                } else if (string.equals(EFFICIENCY_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doEfficiencyChart();
                    }
                } else if (string.equals(EFFICIENCY_EVENTS_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doEfficiencyEventsChart();
                    }
                } else if (string.equals(EFFICIENCY_ONE_EVENT_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetEventName(false) && this.checkAndSetProblemSize(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doEfficiencyOneEventChart();
                    }
                } else if (string.equals(SPEEDUP_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doSpeedupChart();
                    }
                } else if (string.equals(SPEEDUP_EVENTS_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doSpeedupEventsChart();
                    }
                } else if (string.equals(STACKED_BAR_CHART)) {
                    if (this.checkAndSetMetricName(false)) {
                        PerfExplorerChart.doStackedBarChart();
                    }
                } else if (string.equals(ALIGNED_STACKED_BAR_CHART)) {
                    if (this.checkAndSetMetricName(false)) {
                        PerfExplorerChart.doAlignedStackedBarChart();
                    }
                } else if (string.equals(SPEEDUP_ONE_EVENT_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetEventName(false) && this.checkAndSetProblemSize(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doSpeedupOneEventChart();
                    }
                } else if (string.equals(COMMUNICATION_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetGroupName(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doCommunicationChart();
                    }
                } else if (string.equals(FRACTION_CHART)) {
                    if (this.checkAndSetMetricName(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doFractionChart();
                    }
                } else if (string.equals(CORRELATION_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doCorrelationChart();
                    }
                } else if (string.equals(EFFICIENCY_PHASE_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doEfficiencyPhasesChart();
                    }
                } else if (string.equals(SPEEDUP_PHASE_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doSpeedupPhasesChart();
                    }
                } else if (string.equals(FRACTION_PHASE_CHART)) {
                    if (this.checkAndSetMetricName(false)) {
                        ChartGUI.checkScaling();
                        PerfExplorerChart.doFractionPhasesChart();
                    }
                } else if (string.equals(CREATE_NEW_VIEW)) {
                    int n = 0;
                    PerfExplorerViews.createNewView(this.mainFrame, n);
                } else if (string.equals(CREATE_NEW_SUB_VIEW)) {
                    PerfExplorerViews.createNewSubView(this.mainFrame);
                } else if (string.equals(DELETE_CURRENT_VIEW)) {
                    PerfExplorerViews.deleteCurrentView(this.mainFrame);
                } else {
                    System.out.println("unknown event! " + string);
                }
            }
        }
        catch (SeriesException seriesException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Two or more trials in this selection have the same total number of threads of execution, and an error occurred.\n");
            stringBuilder.append("To create a scalability chart, please ensure the trials selected have different numbers of threads.\n");
            stringBuilder.append("To create a different parametric chart, please use the custom chart interface.");
            JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), stringBuilder.toString(), "Selection Warning", 0);
        }
        catch (Exception exception) {
            System.err.println("actionPerformed Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void createChartDialogBox() {
        System.out.println("Opening Dialog Box to create charts");
        ChartGUI.getInstance(true);
    }

    private void updateAll(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JComponent jComponent;
            if (componentArray[i] instanceof Container) {
                this.updateAll((Container)componentArray[i]);
            }
            if (componentArray[i] instanceof JComponent) {
                jComponent = (JComponent)componentArray[i];
                jComponent.updateUI();
            }
            if (!(componentArray[i] instanceof JTree)) continue;
            jComponent = (JTree)componentArray[i];
            ((JTree)jComponent).updateUI();
        }
        container.repaint();
    }

    public static String getVersionString() {
        return new String("Fri Oct  5 16:48:27 PDT 2018");
    }

    public void createAboutWindow() {
        long l = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\njava.home : " + System.getProperty("java.home"));
        stringBuilder.append("\njava.vendor : " + System.getProperty("java.vendor"));
        stringBuilder.append("\njava.vendor.url : " + System.getProperty("java.vendor.url"));
        stringBuilder.append("\njava.version : " + System.getProperty("java.version"));
        stringBuilder.append("\nos.arch : " + System.getProperty("os.arch"));
        stringBuilder.append("\nos.name : " + System.getProperty("os.name"));
        stringBuilder.append("\nos.version : " + System.getProperty("os.version"));
        stringBuilder.append("\nuser.dir : " + System.getProperty("user.dir"));
        stringBuilder.append("\nuser.home : " + System.getProperty("user.home"));
        stringBuilder.append("\nuser.name : " + System.getProperty("user.name"));
        stringBuilder.append("\nuser.country : " + System.getProperty("user.country"));
        stringBuilder.append("\nuser.timezone : " + System.getProperty("user.timezone"));
        stringBuilder.append("\nuser.language : " + System.getProperty("user.language"));
        String string = new String("PerfExplorer 2.0\n" + PerfExplorerActionListener.getVersionString() + "\nJVM Heap Size: " + l + "kb\n" + stringBuilder.toString());
        ImageIcon imageIcon = PerfExplorerActionListener.createImageIcon(Utility.getResource((String)"tau-large.png"));
        JOptionPane.showMessageDialog(this.mainFrame, string, ABOUT, 1, imageIcon);
    }

    public void databaseConfiguration() {
        new DatabaseManagerWindow(PerfExplorerClient.getMainFrame()).setVisible(true);
    }

    public void deriveMetric() {
        Object object;
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        Application application = null;
        Experiment experiment = null;
        Trial trial = null;
        Object object2 = perfExplorerModel.getCurrentSelection();
        if (object2 instanceof Application) {
            application = (Application)object2;
        } else if (object2 instanceof Experiment) {
            experiment = (Experiment)object2;
            object = perfExplorerConnection.getApplicationList();
            while (object.hasNext() && (application = object.next()).getID() != experiment.getApplicationID()) {
            }
        } else if (object2 instanceof Trial) {
            trial = (Trial)object2;
            object = perfExplorerConnection.getApplicationList();
            while (object.hasNext() && (application = (Application)object.next()).getID() != trial.getApplicationID()) {
            }
            ListIterator<Experiment> listIterator = perfExplorerConnection.getExperimentList(trial.getApplicationID());
            while (listIterator.hasNext() && (experiment = listIterator.next()).getID() != trial.getExperimentID()) {
            }
        }
        if (application != null) {
            object = new DerivedMetricWindow(PerfExplorerClient.getMainFrame(), application, experiment, trial);
            ((Window)object).setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select an Application, Experiment or Trial.", "Selection Error", 0);
        }
    }

    protected static ImageIcon createImageIcon(URL uRL) {
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + uRL);
        return null;
    }

    public void createHelpWindow() {
        ImageIcon imageIcon = PerfExplorerActionListener.createImageIcon(Utility.getResource((String)"tau-large.png"));
        JOptionPane.showMessageDialog(this.mainFrame, "Internal help not implemented.\nFor the most up-to-date documentation, please see\n<html><a href='http://www.cs.uoregon.edu/research/tau/'>http://www.cs.uoregon.edu/research/tau/</a></html>", "PerfExplorer Help", 1, imageIcon);
    }

    public void createMethodWindow() {
        Object[] objectArray = AnalysisType.getClusterMethods();
        AnalysisType analysisType = (AnalysisType)JOptionPane.showInputDialog(this.mainFrame, "Select a cluster method:", "Cluster Method", -1, null, objectArray, PerfExplorerModel.getModel().getClusterMethod());
        PerfExplorerModel.getModel().setClusterMethod(analysisType);
    }

    public void createDimensionWindow() {
        String string;
        Object[] objectArray = TransformationType.getDimensionReductions();
        Object object = JOptionPane.showInputDialog(this.mainFrame, "Select a dimension reduction method:", "Dimension Reduction", -1, null, objectArray, TransformationType.NONE);
        TransformationType transformationType = (TransformationType)object;
        PerfExplorerModel.getModel().setDimensionReduction(transformationType);
        if (transformationType != TransformationType.NONE && transformationType != null && PerfExplorerModel.getModel().getDimensionReduction().equals(transformationType) && (string = JOptionPane.showInputDialog(this.mainFrame, "Only select events with exclusive time % greater than X:\n(where 0 <= X < 100)", "Minimum Percentage", -1)) != null && !string.equals("")) {
            PerfExplorerModel.getModel().setXPercent(string);
        }
    }

    public void createNormalizationWindow() {
        Object[] objectArray = TransformationType.getNormalizations();
        TransformationType transformationType = (TransformationType)JOptionPane.showInputDialog(this.mainFrame, "Select a normalization method:", "Normalization", -1, null, objectArray, TransformationType.NONE);
        PerfExplorerModel.getModel().setNormalization(transformationType);
    }

    public void createClusterSizeWindow() {
        String string = new Integer(PerfExplorerModel.getModel().getNumberOfClusters()).toString();
        String string2 = JOptionPane.showInputDialog(this.mainFrame, "Enter the max number of clusters (<= " + string + "):", "Max Clusters", -1);
        if (string2 != null && !string2.equals("")) {
            PerfExplorerModel.getModel().setNumberOfClusters(string2);
        }
    }

    public void createDoClusteringWindow() {
        int n;
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        String string = null;
        if (object instanceof Application) {
            int n2 = this.getConfirmation(perfExplorerModel);
            if (n2 == 1) {
                Application application = (Application)object;
                PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
                ListIterator<Experiment> listIterator = perfExplorerConnection.getExperimentList(application.getID());
                Experiment experiment = null;
                boolean bl = false;
                while (listIterator.hasNext() && !bl) {
                    experiment = listIterator.next();
                    perfExplorerModel.setCurrentSelection(experiment);
                    ListIterator<Trial> listIterator2 = perfExplorerConnection.getTrialList(experiment.getID(), false);
                    Trial trial = null;
                    block1: while (listIterator2.hasNext() && !bl) {
                        trial = listIterator2.next();
                        perfExplorerModel.setCurrentSelection(trial);
                        List list = trial.getMetrics();
                        for (int i = 0; i < list.size(); ++i) {
                            Object e = list.get(i);
                            perfExplorerModel.setCurrentSelection(e);
                            RMIPerfExplorerModel rMIPerfExplorerModel = perfExplorerModel.copy();
                            string = perfExplorerConnection.requestAnalysis(rMIPerfExplorerModel, true);
                            if (string.endsWith("Request accepted.")) continue;
                            JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", 0);
                            bl = true;
                            continue block1;
                        }
                    }
                    perfExplorerModel.setCurrentSelection(experiment);
                }
                perfExplorerModel.setCurrentSelection(application);
                if (string.endsWith("Request accepted.")) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", -1);
                }
            }
        } else if (object instanceof Experiment) {
            int n3 = this.getConfirmation(perfExplorerModel);
            if (n3 == 1) {
                Experiment experiment = (Experiment)object;
                PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
                ListIterator<Trial> listIterator = perfExplorerConnection.getTrialList(experiment.getID(), false);
                Trial trial = null;
                boolean bl = false;
                block3: while (listIterator.hasNext() && !bl) {
                    trial = listIterator.next();
                    perfExplorerModel.setCurrentSelection(trial);
                    List list = trial.getMetrics();
                    for (int i = 0; i < list.size(); ++i) {
                        Object e = list.get(i);
                        perfExplorerModel.setCurrentSelection(e);
                        RMIPerfExplorerModel rMIPerfExplorerModel = perfExplorerModel.copy();
                        string = perfExplorerConnection.requestAnalysis(rMIPerfExplorerModel, true);
                        if (string.endsWith("Request accepted.")) continue;
                        JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", 0);
                        bl = true;
                        continue block3;
                    }
                }
                if (string.endsWith("Request accepted.")) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", -1);
                }
                perfExplorerModel.setCurrentSelection(experiment);
            }
        } else if (object instanceof Trial) {
            int n4 = this.getConfirmation(perfExplorerModel);
            if (n4 == 1) {
                PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
                RMIPerfExplorerModel rMIPerfExplorerModel = perfExplorerModel.copy();
                string = perfExplorerConnection.requestAnalysis(rMIPerfExplorerModel, true);
                Trial trial = (Trial)object;
                List list = trial.getMetrics();
                for (int i = 0; i < list.size(); ++i) {
                    rMIPerfExplorerModel = perfExplorerModel.copy();
                    Object e = list.get(i);
                    rMIPerfExplorerModel.setCurrentSelection(e);
                    string = perfExplorerConnection.requestAnalysis(rMIPerfExplorerModel, true);
                    if (string.endsWith("Request accepted.")) continue;
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", 0);
                    break;
                }
                if (string.endsWith("Request accepted.")) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", -1);
                }
            }
        } else if (object instanceof Metric && (n = this.getConfirmation(perfExplorerModel)) == 1) {
            PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
            string = perfExplorerConnection.requestAnalysis(PerfExplorerModel.getModel(), true);
            if (string.endsWith("Request accepted.")) {
                JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", -1);
            } else {
                JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", 0);
            }
        }
    }

    public void createDoCorrelationWindow() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        String string = null;
        if (object instanceof Trial || object instanceof Metric) {
            RMIPerfExplorerModel rMIPerfExplorerModel = perfExplorerModel.copy();
            rMIPerfExplorerModel.setClusterMethod(AnalysisType.CORRELATION_ANALYSIS);
            int n = this.getConfirmation(rMIPerfExplorerModel);
            if (n == 1) {
                PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
                string = perfExplorerConnection.requestAnalysis(rMIPerfExplorerModel, true);
                if (string.endsWith("Request accepted.")) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", -1);
                } else {
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", 0);
                }
            }
        }
    }

    private int getConfirmation(RMIPerfExplorerModel rMIPerfExplorerModel) {
        Object[] objectArray = new Object[]{"No, not yet", "Yes, do analysis"};
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Analysis method: " + rMIPerfExplorerModel.getClusterMethod());
        stringBuilder.append("\nDimension Reduction: " + rMIPerfExplorerModel.getDimensionReduction());
        if (rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT)) {
            stringBuilder.append("\n\t\t Minimum percentage: " + rMIPerfExplorerModel.getXPercent());
        }
        stringBuilder.append("\nNormalization: " + rMIPerfExplorerModel.getNormalization());
        if (!rMIPerfExplorerModel.getClusterMethod().equals(AnalysisType.CORRELATION_ANALYSIS)) {
            stringBuilder.append("\nMax Clusters: " + rMIPerfExplorerModel.getNumberOfClusters());
        }
        stringBuilder.append("\nTrial: " + rMIPerfExplorerModel.toString());
        stringBuilder.append("\n\nPerform " + rMIPerfExplorerModel.getClusterMethod() + " with the these options?");
        int n = JOptionPane.showOptionDialog(this.mainFrame, stringBuilder.toString(), "Confirm Analysis", 0, -1, null, objectArray, objectArray[1]);
        return n;
    }

    private boolean validCorrelationSelection() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (!(object instanceof Trial) && !(object instanceof Metric)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select a Trial or Metric.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean validAnalysisSelection() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (!(object instanceof Experiment || object instanceof Trial || object instanceof Application || object instanceof Metric)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select an Application, Experiment, Trial or Metric.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean validSelection(PerfExplorerModel perfExplorerModel) {
        Object object = perfExplorerModel.getCurrentSelection();
        if (!(object instanceof Experiment) && !(object instanceof View)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select one or more Experiments or one View.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean valid3DSelection() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (object == null || !(object instanceof Metric)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select a Metric.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean validDistributionSelection() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (object == null || !(object instanceof Metric) && !(object instanceof RMISortableIntervalEvent)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select an Metrics or one or more Events.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean validCommunicationMatrixSelection() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (object == null || !(object instanceof Trial)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select one Trial.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean checkAndSetMetricName(boolean bl) {
        PerfExplorerConnection perfExplorerConnection;
        List<String> list;
        Object[] objectArray;
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        if (!this.validSelection(perfExplorerModel)) {
            return false;
        }
        String string = perfExplorerModel.getMetricName();
        if ((bl || string == null) && (objectArray = (list = (perfExplorerConnection = PerfExplorerConnection.getConnection()).getPotentialMetrics(perfExplorerModel)).toArray()).length > 0) {
            string = objectArray.length == 1 ? (String)objectArray[0] : (String)JOptionPane.showInputDialog(this.mainFrame, "Please enter the metric of interest", "Metric of interest", -1, null, objectArray, objectArray[0]);
            perfExplorerModel.setMetricName(string);
        }
        return bl || string != null;
    }

    private boolean checkAndSetGroupName(boolean bl) {
        PerfExplorerConnection perfExplorerConnection;
        List<String> list;
        Object[] objectArray;
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        String string = perfExplorerModel.getGroupName();
        if ((bl || string == null) && (objectArray = (list = (perfExplorerConnection = PerfExplorerConnection.getConnection()).getPotentialGroups(perfExplorerModel)).toArray()).length > 0) {
            string = objectArray.length == 1 ? (String)objectArray[0] : (String)JOptionPane.showInputDialog(this.mainFrame, "Please enter the group of interest", "Group of interest", -1, null, objectArray, objectArray[0]);
            perfExplorerModel.setGroupName(string);
        }
        return bl || string != null;
    }

    private boolean checkAndSetEventName(boolean bl) {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        String string = perfExplorerModel.getEventName();
        if (bl || string == null) {
            PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
            List<String> list = perfExplorerConnection.getPotentialEvents(perfExplorerModel);
            List<String> list2 = perfExplorerConnection.getPotentialCallPathEvents(perfExplorerModel);
            for (String string2 : list2) {
                list.add(string2);
            }
            Object[] objectArray = list.toArray();
            if (objectArray.length > 0) {
                string = objectArray.length == 1 ? (String)objectArray[0] : (String)JOptionPane.showInputDialog(this.mainFrame, "Please enter the event of interest", "Event of interest", -1, null, objectArray, objectArray[0]);
                perfExplorerModel.setEventName(string);
            }
        }
        return bl || string != null;
    }

    private boolean checkAndSetTimesteps(boolean bl) {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        String string = perfExplorerModel.getTotalTimesteps();
        if (bl || string == null) {
            string = JOptionPane.showInputDialog(this.mainFrame, "Please enter the total number of timesteps for the experiment", "Total Timesteps", -1);
            perfExplorerModel.setTotalTimesteps(string);
        }
        return bl || string != null;
    }

    private boolean checkAndSetProblemSize(boolean bl) {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Boolean bl2 = perfExplorerModel.getConstantProblem();
        if (bl || bl2 == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("The problem size remains constant. (strong scaling)");
            arrayList.add("The problem size increases as the processor count increases. (weak scaling)");
            Object[] objectArray = arrayList.toArray();
            String string = (String)JOptionPane.showInputDialog(this.mainFrame, "Please select the problem scaling:", "Problem Scaling", -1, null, objectArray, objectArray[0]);
            if (string != null) {
                perfExplorerModel.setConstantProblem(string.startsWith("The problem size remains"));
                bl2 = perfExplorerModel.getConstantProblem();
            }
        }
        return bl || bl2 != null;
    }

    public static int setSession(String string) {
        try {
            PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
            List<String> list = perfExplorerConnection.getConfigNames();
            int n = 0;
            for (String string2 : list) {
                if (string2.equals(string)) {
                    perfExplorerConnection.setConnectionIndex(n);
                    return n;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private boolean loadProfile() {
        Application application = new Application();
        Experiment experiment = new Experiment();
        try {
            application.setName("New Application");
            application.setID(application.saveApplication(PerfExplorerServer.getServer().getDB()));
            PerfExplorerModel.getModel().setCurrentSelection(application);
            experiment.setApplicationID(application.getID());
            experiment.setName("New Experiment");
            experiment.setID(experiment.saveExperiment(PerfExplorerServer.getServer().getDB()));
            PerfExplorerModel.getModel().setCurrentSelection(experiment);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        LoadTrialWindow loadTrialWindow = new LoadTrialWindow(this.mainFrame, this, application, experiment, true, true);
        loadTrialWindow.setVisible(true);
        return true;
    }

    private boolean loadScript() {
        JFileChooser jFileChooser = null;
        jFileChooser = this.scriptDir == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.scriptDir);
        int n = jFileChooser.showOpenDialog(this.mainFrame);
        if (n == 0) {
            this.scriptName = jFileChooser.getSelectedFile().getAbsolutePath();
            this.scriptDir = jFileChooser.getSelectedFile().getParent();
            this.runScript();
            return true;
        }
        return false;
    }

    private boolean parseExpression() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (object == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select an Application, Experiment or Trial.", "Selection Error", 0);
            return false;
        }
        JFileChooser jFileChooser = null;
        jFileChooser = this.scriptDir == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.scriptDir);
        int n = jFileChooser.showOpenDialog(this.mainFrame);
        if (n == 0) {
            this.expressionFilename = jFileChooser.getSelectedFile().getAbsolutePath();
            this.scriptDir = jFileChooser.getSelectedFile().getParent();
            this.reparseExpression();
            return true;
        }
        return false;
    }

    public boolean reparseExpression() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Application application = perfExplorerModel.getApplication();
        Experiment experiment = perfExplorerModel.getExperiment();
        Trial trial = perfExplorerModel.getTrial();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (application != null) {
            string = application.getName();
        }
        if (experiment != null) {
            string2 = experiment.getName();
        }
        if (trial != null) {
            string3 = trial.getName();
        }
        if (this.expressionFilename == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please load an expression file first.", "Expression File Not Found", 0);
            return false;
        }
        if (string != null) {
            try {
                String string4 = new PerfExplorerExpression().getScriptFromFile(string, string2, string3, this.expressionFilename);
                new ScriptThread(string4, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this.mainFrame, "", "Script File Not Found", 0);
            }
            catch (ParsingException parsingException) {
                JOptionPane.showMessageDialog(this.mainFrame, "", "Unable to Parse Expression", 0);
            }
            return true;
        }
        JOptionPane.showMessageDialog(this.mainFrame, "Please select an Application, Experiment or Trial.", "Selection Error", 0);
        return false;
    }

    public boolean runScript() {
        if (this.scriptName == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please load a script first.", "Script File Not Found", 0);
            return false;
        }
        new ScriptThread(this.scriptName);
        return true;
    }

    public void saveMain() {
        try {
            VectorExport.promptForVectorExport((ImageExport)this.mainFrame, (String)"PerfExplorer");
        }
        catch (Exception exception) {
            System.out.println("File Export Failed!");
        }
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String string) {
        this.scriptName = string;
    }

    public void handleDelete(Object object) {
        try {
            DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession();
            if (object instanceof Application) {
                Application application = (Application)object;
                if (databaseAPI != null) {
                    databaseAPI.deleteApplication(application.getID());
                }
            } else if (object instanceof Experiment) {
                Experiment experiment = (Experiment)object;
                if (databaseAPI != null) {
                    databaseAPI.deleteExperiment(experiment.getID());
                }
            } else if (object instanceof Trial) {
                Trial trial = (Trial)object;
                if (databaseAPI != null) {
                    databaseAPI.deleteTrial(trial.getID());
                }
            }
        }
        catch (Exception exception) {
            System.out.print(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

