/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering.weka;

import edu.uoregon.tau.perfexplorer.clustering.ClassifierInterface;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaNaiveBayesClassifier
implements ClassifierInterface {
    protected Instances trainingData = null;
    protected Classifier classifier = null;
    protected List<double[]> distributions = new ArrayList<double[]>();

    protected WekaNaiveBayesClassifier(RawDataInterface rawDataInterface) {
        this.trainingData = (Instances)rawDataInterface.getData();
        this.trainingData.setClassIndex(this.trainingData.numAttributes() - 1);
        this.trainingData.setClass(this.trainingData.attribute(this.trainingData.numAttributes() - 1));
    }

    @Override
    public List<String> classifyInstances(RawDataInterface rawDataInterface) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Instances instances = (Instances)rawDataInterface.getData();
        instances.setClassIndex(this.trainingData.numAttributes() - 1);
        try {
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                double d = this.classifier.classifyInstance(instance);
                double[] dArray = this.classifier.distributionForInstance(instance);
                this.distributions.add(dArray);
                arrayList.add(Double.toString(d));
            }
        }
        catch (Exception exception) {
            System.err.println("Error performing classification");
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(0);
        }
        return arrayList;
    }

    @Override
    public void buildClassifier() {
        try {
            this.classifier = Classifier.forName((String)"weka.classifiers.bayes.NaiveBayes", null);
            this.classifier.buildClassifier(this.trainingData);
        }
        catch (Exception exception) {
            System.err.println("Error building classifier");
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    @Override
    public String evaluate(RawDataInterface rawDataInterface) {
        Instances instances = (Instances)rawDataInterface.getData();
        Evaluation evaluation = null;
        try {
            evaluation = new Evaluation(this.trainingData);
            evaluation.evaluateModel(this.classifier, instances, new Object[0]);
        }
        catch (Exception exception) {
            System.err.println("Error evaluating classifier");
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(0);
        }
        return evaluation.toSummaryString("\nResults\n=======\n", false);
    }

    @Override
    public List<double[]> getDistributions() {
        return this.distributions;
    }
}

