/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering.weka;

import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaRawData
implements RawDataInterface,
Serializable {
    private static final long serialVersionUID = 2898797823766558128L;
    private Instances instances = null;
    private int vectors = 0;
    private int dimensions = 0;
    private double maximum = 0.0;
    private boolean normalize = false;
    private double[][] ranges = null;

    WekaRawData(String string, List<String> list, int n, int n2, List<String> list2) {
        Object object;
        String string2;
        this.vectors = n;
        this.dimensions = n2;
        FastVector fastVector = new FastVector(list.size());
        for (int i = 0; i < list.size(); ++i) {
            string2 = list.get(i);
            fastVector.addElement((Object)new Attribute(string2));
        }
        Attribute attribute = null;
        if (list2 != null) {
            string2 = "class";
            object = new FastVector(list2.size());
            for (String string3 : list2) {
                object.addElement((Object)string3);
            }
            attribute = new Attribute(string2, object);
            fastVector.addElement((Object)attribute);
        }
        this.instances = new Instances(string, fastVector, n);
        if (list2 != null) {
            this.instances.setClass(attribute);
            for (int i = 0; i < n; ++i) {
                object = new Instance(fastVector.size());
                object.setDataset(this.instances);
                for (int j = 0; j < n2; ++j) {
                    object.setValue(j, 0.0);
                }
                this.instances.add((Instance)object);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                object = new double[n2];
                for (int j = 0; j < n2; ++j) {
                    object[j] = (FastVector)0.0;
                }
                this.instances.add(new Instance(1.0, (double[])object));
            }
        }
    }

    WekaRawData(Instances instances) {
        this.instances = instances;
        this.vectors = instances.numInstances();
        if (this.vectors > 0) {
            this.dimensions = instances.instance(0).numAttributes();
        }
    }

    @Override
    public void addValue(int n, int n2, double d) {
        Instance instance = this.instances.instance(n);
        instance.setValue(n2, d);
        if (this.maximum < d) {
            this.maximum = d;
        }
    }

    @Override
    public double getValue(int n, int n2) {
        if (this.normalize) {
            double d = this.instances.instance(n).value(n2);
            d -= this.ranges[n2][0];
            return d /= this.ranges[n2][1];
        }
        return this.instances.instance(n).value(n2);
    }

    @Override
    public double getManhattanDistance(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            d += Math.abs(this.instances.instance(n).value(i) - this.instances.instance(n2).value(i));
        }
        return d;
    }

    @Override
    public double getCartesianDistance(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            double d2 = Math.abs(this.instances.instance(n).value(i) - this.instances.instance(n2).value(i));
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    @Override
    public Object getData() {
        return this.instances;
    }

    @Override
    public List<String> getEventNames() {
        Enumeration enumeration = this.instances.enumerateAttributes();
        ArrayList<String> arrayList = new ArrayList<String>(this.instances.numDistinctValues(0));
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            arrayList.add(attribute.name());
        }
        return arrayList;
    }

    @Override
    public int numVectors() {
        return this.vectors;
    }

    @Override
    public int numDimensions() {
        return this.dimensions;
    }

    @Override
    public String getName() {
        return this.instances.relationName();
    }

    @Override
    public double getMaximum() {
        return this.maximum;
    }

    @Override
    public double[] getVector(int n) {
        double[] dArray = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            dArray[i] = this.instances.instance(n).value(i);
        }
        return dArray;
    }

    @Override
    public double getCorrelation(int n, int n2) {
        int n3;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n3 = 0; n3 < this.vectors; ++n3) {
            d2 += this.instances.instance(n3).value(n);
            d3 += this.instances.instance(n3).value(n2);
        }
        d2 /= (double)this.vectors;
        d3 /= (double)this.vectors;
        for (n3 = 0; n3 < this.vectors; ++n3) {
            d4 += (this.instances.instance(n3).value(n) - d2) * (this.instances.instance(n3).value(n) - d2);
            d5 += (this.instances.instance(n3).value(n2) - d3) * (this.instances.instance(n3).value(n2) - d3);
        }
        d4 /= (double)(this.vectors - 1);
        d4 = Math.sqrt(d4);
        d5 /= (double)(this.vectors - 1);
        d5 = Math.sqrt(d5);
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < this.vectors; ++i) {
            d6 = (this.instances.instance(i).value(n) - d2) / d4;
            d7 = (this.instances.instance(i).value(n2) - d3) / d5;
            d += d6 * d7;
        }
        return d /= (double)(this.vectors - 1);
    }

    @Override
    public void addMainValue(int n, int n2, double d) {
    }

    @Override
    public double getMainValue(int n) {
        return 0.0;
    }

    @Override
    public String getMainEventName() {
        String string = new String("");
        return string;
    }

    @Override
    public void addValue(int n, int n2, String string) {
        Instance instance = this.instances.instance(n);
        instance.setValue(n2, string);
    }
}

