/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfexplorer.cqos.WekaClassifierWrapper;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.TrialMetadata;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQoSClassifierOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -3400888131847759109L;
    public static final String SUPPORT_VECTOR_MACHINE = "weka.classifiers.functions.SMO";
    public static final String NAIVE_BAYES = "weka.classifiers.bayes.NaiveBayes";
    public static final String MULTILAYER_PERCEPTRON = "weka.classifiers.functions.MultilayerPerceptron";
    public static final String LINEAR_REGRESSION = "weka.classifiers.functions.LinearRegression";
    public static final String J48 = "weka.classifiers.trees.J48";
    public static final String ALTERNATING_DECISION_TREE = "weka.classifiers.trees.ADTree";
    public static final String RANDOM_TREE = "weka.classifiers.trees.RandomTree";
    private String metric = "Time";
    private Set<String> metadataFields = null;
    private String classLabel = null;
    private WekaClassifierWrapper wrapper = null;
    private String classifierType = "weka.classifiers.functions.MultilayerPerceptron";
    private int trainingSize = 0;
    protected List<Map<String, String>> trainingData = null;
    private Map<String, Set<String>> validation = new HashMap<String, Set<String>>();

    public CQoSClassifierOperation(List<PerformanceResult> list, String string, Set<String> set, String string2) {
        super(list);
        this.metric = string;
        this.metadataFields = set;
        this.classLabel = string2;
        this.getUniqueTuples();
    }

    private CQoSClassifierOperation(String string) {
        this.wrapper = WekaClassifierWrapper.readClassifier(string);
    }

    /*
     * WARNING - void declaration
     */
    private void getUniqueTuples() {
        try {
            HashMap hashMap;
            Object object322;
            HashMap hashMap2 = new HashMap();
            System.out.println("Finding unique tuples...");
            int n = 1;
            int n2 = 0;
            for (Object object322 : this.inputs) {
                boolean bl = false;
                boolean bl2 = false;
                System.out.print("\rProcessing " + n + " of " + this.inputs.size() + " (" + n * 100 / this.inputs.size() + "% done, " + n2 + " discarded)");
                ++n;
                Hashtable<String, String> object5 = new Hashtable<String, String>();
                hashMap = new TrialMetadata((PerformanceResult)object322);
                Hashtable<String, String> hashtable = ((TrialMetadata)((Object)hashMap)).getCommonAttributes();
                if (this.metadataFields != null) {
                    for (String string : this.metadataFields) {
                        if (string.equals(this.classLabel)) continue;
                        String string2 = hashtable.get(string);
                        if (string2 == null) {
                            bl = true;
                            continue;
                        }
                        String string3 = hashtable.get(string);
                        if (string.endsWith("_success") && string3.trim().equals("0")) {
                            bl2 = true;
                            continue;
                        }
                        object5.put(string, hashtable.get(string));
                    }
                } else {
                    for (String string : hashtable.keySet()) {
                        if (string.equals(this.classLabel)) continue;
                        object5.put(string, hashtable.get(string));
                    }
                }
                if (bl || bl2) {
                    ++n2;
                    continue;
                }
                if (!object322.getMetrics().contains(this.metric)) {
                    PerformanceResult performanceResult = (PerformanceResult)hashMap2.get(object5);
                    String string = (String)object5.get("success");
                    if (string != null && !string.equals("1")) continue;
                    if (performanceResult == null) {
                        hashMap2.put(object5, object322);
                        continue;
                    }
                    TrialMetadata trialMetadata = new TrialMetadata(performanceResult);
                    if (!(Double.parseDouble(hashtable.get(this.metric)) < Double.parseDouble(trialMetadata.getCommonAttributes().get(this.metric)))) continue;
                    hashMap2.put(object5, object322);
                    continue;
                }
                PerformanceResult performanceResult = (PerformanceResult)hashMap2.get(object5);
                if (performanceResult == null) {
                    hashMap2.put(object5, object322);
                    continue;
                }
                if (!(object322.getInclusive(0, object322.getMainEvent(), this.metric) < performanceResult.getInclusive(0, performanceResult.getMainEvent(), this.metric))) continue;
                hashMap2.put(object5, object322);
            }
            System.out.println("Done.");
            this.trainingData = new ArrayList<Map<String, String>>();
            FileWriter fileWriter = new FileWriter("/tmp/data.csv");
            object322 = new BufferedWriter(fileWriter);
            String string = new String();
            for (String string4 : this.metadataFields) {
                string = string + string4 + ", ";
            }
            string = string + "time";
            ((Writer)object322).write(string);
            ((BufferedWriter)object322).newLine();
            System.out.println("Processing unique tuples...");
            n = 1;
            for (Hashtable hashtable : hashMap2.keySet()) {
                System.out.print("\rProcessing " + n + " of " + hashMap2.keySet().size() + " (" + n * 100 / hashMap2.keySet().size() + "% done)");
                ++n;
                hashMap = new HashMap();
                string = new String();
                if (this.metadataFields != null) {
                    for (String string5 : this.metadataFields) {
                        void var12_44;
                        hashMap.put(string5, hashtable.get(string5));
                        Set<String> set = this.validation.get(string5);
                        if (set == null) {
                            HashSet hashSet = new HashSet();
                            this.validation.put(string5, hashSet);
                        }
                        var12_44.add(hashtable.get(string5));
                        if (string5.equals(this.classLabel)) {
                            string = string + new TrialMetadata((PerformanceResult)hashMap2.get(hashtable)).getCommonAttributes().get(this.classLabel) + ", ";
                            continue;
                        }
                        string = string + (String)hashtable.get(string5) + ", ";
                    }
                } else {
                    for (String string6 : hashtable.keySet()) {
                        hashMap.put(string6, hashtable.get(string6));
                    }
                }
                PerformanceResult performanceResult = (PerformanceResult)hashMap2.get(hashtable);
                string = string + performanceResult.getInclusive(0, performanceResult.getMainEvent(), this.metric);
                ((Writer)object322).write(string);
                ((BufferedWriter)object322).newLine();
                hashMap.put(this.classLabel, new TrialMetadata((PerformanceResult)hashMap2.get(hashtable)).getCommonAttributes().get(this.classLabel));
                this.trainingData.add(hashMap);
            }
            System.out.println("Done.");
            ((BufferedWriter)object322).close();
            for (String string7 : this.validation.keySet()) {
                System.out.print(string7 + ": ");
                for (String string8 : this.validation.get(string7)) {
                    System.out.print(string8 + ", ");
                }
                System.out.println("");
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    @Override
    public List<PerformanceResult> processData() {
        this.trainingSize = this.trainingData.size();
        System.out.println("Total instances for training: " + this.trainingSize);
        System.out.println("Using keys: " + this.metadataFields.toString());
        try {
            this.wrapper = new WekaClassifierWrapper(this.trainingData, this.classLabel);
            this.wrapper.setClassifierType(this.classifierType);
            this.wrapper.buildClassifier();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        return null;
    }

    public String getClass(Map<String, String> map) {
        return this.wrapper.getClass(map);
    }

    public double getConfidence() {
        return this.wrapper.getConfidence();
    }

    public void writeClassifier(String string) {
        WekaClassifierWrapper.writeClassifier(string, this.wrapper);
    }

    public static CQoSClassifierOperation readClassifier(String string) {
        return new CQoSClassifierOperation(string);
    }

    public String getClassifierType() {
        return this.classifierType;
    }

    public void setClassifierType(String string) {
        this.classifierType = string;
    }

    public String crossValidateModel() {
        return this.wrapper.crossValidateModel(3);
    }
}

