/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeriveMetricOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = 8570470654069226204L;
    public static final String ADD = "+";
    public static final String SUBTRACT = "-";
    public static final String MULTIPLY = "*";
    public static final String DIVIDE = "/";
    private String firstMetric = null;
    private String secondMetric = null;
    private float multFactor = 1.0f;
    private float addFactor = 0.0f;
    private String operation = "+";
    private String newName = null;

    public DeriveMetricOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public DeriveMetricOperation(Trial trial) {
        super(trial);
    }

    public DeriveMetricOperation(List<PerformanceResult> list) {
        super(list);
    }

    public DeriveMetricOperation(PerformanceResult performanceResult, String string, String string2, String string3, float f, float f2) {
        super(performanceResult);
        this.firstMetric = string;
        this.secondMetric = string2;
        this.multFactor = f;
        this.addFactor = f2;
        this.operation = string3;
        this.newName = "(" + string + string3 + string2 + ")";
        if (!(string.equals("CALLS") || string.equals("SUBROUTINES") || string2.equals("CALLS") || string2.equals("SUBROUTINES"))) {
            if (!performanceResult.getMetrics().contains(string)) {
                System.err.println("\n\n *** ERROR: Trial does not have a metric named: " + string + " ***\n\n");
            }
            if (!performanceResult.getMetrics().contains(string2)) {
                System.err.println("\n\n *** ERROR: Trial does not have a metric named: " + string2 + " ***\n\n");
            }
        }
    }

    public DeriveMetricOperation(PerformanceResult performanceResult, String string, String string2, String string3) {
        super(performanceResult);
        this.firstMetric = string;
        this.secondMetric = string2;
        this.operation = string3;
        this.newName = "(" + string + string3 + string2 + ")";
        if (!(string.equals("CALLS") || string.equals("SUBROUTINES") || string2.equals("CALLS") || string2.equals("SUBROUTINES"))) {
            if (!performanceResult.getMetrics().contains(string)) {
                System.err.println("\n\n *** ERROR: Trial does not have a metric named: " + string + " ***\n\n");
            }
            if (!performanceResult.getMetrics().contains(string2)) {
                System.err.println("\n\n *** ERROR: Trial does not have a metric named: " + string2 + " ***\n\n");
            }
        }
    }

    @Override
    public List<PerformanceResult> processData() {
        for (PerformanceResult performanceResult : this.inputs) {
            DefaultResult defaultResult = new DefaultResult(performanceResult, false);
            for (String string : performanceResult.getEvents()) {
                for (Integer n : performanceResult.getThreads()) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    if (this.firstMetric.equals("CALLS")) {
                        d4 = performanceResult.getCalls(n, string);
                        d3 = performanceResult.getCalls(n, string);
                    } else if (this.firstMetric.equals("SUBROUTINES")) {
                        d4 = performanceResult.getSubroutines(n, string);
                        d3 = performanceResult.getSubroutines(n, string);
                    } else {
                        d4 = performanceResult.getInclusive(n, string, this.firstMetric);
                        d3 = performanceResult.getExclusive(n, string, this.firstMetric);
                    }
                    if (this.secondMetric.equals("CALLS")) {
                        d2 = performanceResult.getCalls(n, string);
                        d = performanceResult.getCalls(n, string);
                    } else if (this.secondMetric.equals("SUBROUTINES")) {
                        d2 = performanceResult.getSubroutines(n, string);
                        d = performanceResult.getSubroutines(n, string);
                    } else {
                        d2 = performanceResult.getInclusive(n, string, this.secondMetric);
                        d = performanceResult.getExclusive(n, string, this.secondMetric);
                    }
                    if (this.operation.equals(ADD)) {
                        d5 = d4 + d2;
                        d6 = d3 + d;
                    } else if (this.operation.equals(SUBTRACT)) {
                        d5 = d4 - d2;
                        d6 = d3 - d;
                    } else if (this.operation.equals(MULTIPLY)) {
                        d5 = d4 * d2;
                        d6 = d3 * d;
                    } else if (this.operation.equals(DIVIDE)) {
                        d5 = d2 == 0.0 ? 0.0 : d4 / d2;
                        d6 = d == 0.0 ? 0.0 : d3 / d;
                    }
                    d5 = d5 * (double)this.multFactor + (double)this.addFactor;
                    d6 = d6 * (double)this.multFactor + (double)this.addFactor;
                    defaultResult.putInclusive(n, string, this.newName, d5);
                    defaultResult.putExclusive(n, string, this.newName, d6);
                    defaultResult.putCalls(n, string, performanceResult.getCalls(n, string));
                    defaultResult.putSubroutines(n, string, performanceResult.getSubroutines(n, string));
                }
            }
            this.outputs.add(defaultResult);
        }
        return this.outputs;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String string) {
        this.newName = string;
    }

    public boolean exists() {
        return ((PerformanceResult)this.inputs.get(0)).getMetrics().contains(this.newName);
    }
}

