/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.clustering.PrincipalComponentsAnalysisInterface;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.AnalysisFactory;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.ClusterOutputResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCAOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -7122252507773375487L;
    private String metric = null;
    private int type = 1;
    private int maxComponents = -1;

    public PCAOperation(PerformanceResult performanceResult, String string, int n) {
        super(performanceResult);
        this.metric = string;
        this.type = n;
    }

    public PCAOperation(Trial trial) {
        super(trial);
    }

    public PCAOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        PerfExplorerServer.getServer();
        for (PerformanceResult performanceResult : this.inputs) {
            ArrayList<String> arrayList = new ArrayList<String>(performanceResult.getEvents());
            RawDataInterface rawDataInterface = AnalysisFactory.createRawData("Cluster Test", arrayList, performanceResult.getThreads().size(), arrayList.size(), null);
            for (Integer n : performanceResult.getThreads()) {
                int n2 = 0;
                for (String string : arrayList) {
                    rawDataInterface.addValue((int)n, n2++, performanceResult.getDataPoint(n, string, this.metric, this.type));
                    if (!string.equals(performanceResult.getMainEvent())) continue;
                    rawDataInterface.addMainValue(n, n2 - 1, performanceResult.getDataPoint(n, string, this.metric, this.type));
                }
            }
            PrincipalComponentsAnalysisInterface principalComponentsAnalysisInterface = AnalysisFactory.createPCAEngine(rawDataInterface);
            principalComponentsAnalysisInterface.setMaxComponents(this.maxComponents);
            try {
                principalComponentsAnalysisInterface.doPCA();
            }
            catch (Exception exception) {
                System.err.println("failure to perform PCA.");
                System.exit(0);
            }
            ClusterOutputResult serializable2 = new ClusterOutputResult(principalComponentsAnalysisInterface.getResults(), this.metric, this.type);
            this.outputs.add(serializable2);
        }
        return this.outputs;
    }

    public int getMaxComponents() {
        return this.maxComponents;
    }

    public void setMaxComponents(int n) {
        this.maxComponents = n;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String string) {
        this.metric = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }
}

