/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.ScalabilityResult;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalabilityOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = 2643250836211731594L;
    private ScalabilityResult.Measure measure = ScalabilityResult.Measure.SPEEDUP;
    private ScalabilityResult.Scaling scaling = ScalabilityResult.Scaling.STRONG;

    public ScalabilityResult.Measure getMeasure() {
        return this.measure;
    }

    public void setMeasure(ScalabilityResult.Measure measure) {
        this.measure = measure;
    }

    public ScalabilityResult.Scaling getScaling() {
        return this.scaling;
    }

    public void setScaling(ScalabilityResult.Scaling scaling) {
        this.scaling = scaling;
    }

    public ScalabilityOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public ScalabilityOperation(Trial trial) {
        super(trial);
    }

    public ScalabilityOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        PerformanceResult performanceResult = (PerformanceResult)this.inputs.get(0);
        Set<Integer> set = performanceResult.getThreads();
        set.addAll(performanceResult.getThreads());
        Set<String> set2 = performanceResult.getEvents();
        set2.addAll(performanceResult.getEvents());
        Set<String> set3 = performanceResult.getMetrics();
        set3.addAll(performanceResult.getMetrics());
        for (PerformanceResult performanceResult2 : this.inputs) {
            String string2;
            PerformanceResult performanceResult3 = performanceResult2;
            if (performanceResult == performanceResult3) continue;
            ScalabilityResult scalabilityResult = new ScalabilityResult(performanceResult2, false);
            double d = performanceResult3.getOriginalThreads() / performanceResult.getOriginalThreads();
            scalabilityResult.setIdealRatio(d);
            for (String string2 : set2) {
                for (String string3 : set3) {
                    scalabilityResult.putExclusive(0, string2, string3, performanceResult.getExclusive(0, string2, string3) / performanceResult3.getExclusive(0, string2, string3));
                    scalabilityResult.putInclusive(0, string2, string3, performanceResult.getInclusive(0, string2, string3) / performanceResult3.getInclusive(0, string2, string3));
                }
                scalabilityResult.putCalls(0, string2, performanceResult.getCalls(0, string2) / performanceResult3.getCalls(0, string2));
                scalabilityResult.putSubroutines(0, string2, performanceResult.getSubroutines(0, string2) / performanceResult3.getSubroutines(0, string2));
            }
            Integer n = 0;
            string2 = performanceResult.getMainEvent();
            String string4 = performanceResult.getTimeMetric();
            scalabilityResult.setActualRatio(performanceResult.getInclusive(n, string2, string4) / performanceResult3.getInclusive(n, string2, string4));
            scalabilityResult.setMainEvent(string2);
            scalabilityResult.setTimeMetric(string4);
            this.outputs.add(scalabilityResult);
        }
        return this.outputs;
    }

    public PerformanceResult getBaseline() {
        return (PerformanceResult)this.inputs.get(0);
    }

    public PerformanceResult getComparison() {
        return (PerformanceResult)this.inputs.get(1);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ScalabilityOperation.toString() not yet supported.");
        return stringBuilder.toString();
    }
}

