/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectRanksByEventsOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -8592649905701916890L;
    private List<String> events;
    private boolean exclude;

    public SelectRanksByEventsOperation(PerformanceResult performanceResult, List<String> list, boolean bl) {
        super(performanceResult);
        this.exclude = bl;
        this.events = list;
    }

    public SelectRanksByEventsOperation(Trial trial) {
        super(trial);
    }

    public SelectRanksByEventsOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        this.outputs = new ArrayList();
        for (PerformanceResult performanceResult : this.inputs) {
            DefaultResult defaultResult = new DefaultResult(performanceResult, false);
            this.outputs.add(defaultResult);
            for (Integer n : performanceResult.getThreads()) {
                boolean bl = false;
                for (String string : this.events) {
                    Double d = performanceResult.getCalls(n, string);
                    if (this.exclude && d > 0.0) {
                        bl = true;
                        break;
                    }
                    if (this.exclude || d != 0.0) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                for (String string : performanceResult.getEvents()) {
                    for (String string2 : performanceResult.getMetrics()) {
                        defaultResult.putExclusive(n, string, string2, performanceResult.getExclusive(n, string, string2));
                        defaultResult.putInclusive(n, string, string2, performanceResult.getInclusive(n, string, string2));
                    }
                    defaultResult.putCalls(n, string, performanceResult.getCalls(n, string));
                    defaultResult.putSubroutines(n, string, performanceResult.getSubroutines(n, string));
                }
                defaultResult.updateEventMap();
            }
        }
        return this.outputs;
    }
}

